/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Difference;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IStateDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.PowersetDeterminizer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IOpWithDelayedDeadEndRemoval;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.senwa.DifferenceSenwa;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IDeterminizeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISenwaStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.IRunningTaskStackReceiver;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.TaskCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.lib.results.UnprovabilityReason;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.SubtaskIterationIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.taskidentifier.TaskIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngineResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.ITraceCheckStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AbstractCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.ICegarNwaWorkerThread;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IPostconditionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.IPreconditionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.NwaCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.ParallelNwaCegarLoop;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PathProgramCache;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryRefinement;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TraceAbstractionUtils;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TransferBetweenMainAndWorker;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.WorkerThreadResult;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.ErrorGeneralizationEngine;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.DeterministicInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.NondeterministicInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IpTcStrategyModuleAcceleratedTraceCheck;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.StrategyFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TaCheckAndRefinementPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TraceAbstractionRefinementEngine;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;

public class CegarNwaWorkerThread<L extends IIcfgTransition<?>, A extends IAutomaton<L, IPredicate>>
implements ICegarNwaWorkerThread<L, A> {
    private final ILogger mLogger;
    private final TAPreferences mPref;
    private final AbstractCegarLoop.CegarLoopResultBuilder mResultBuilder;
    private final IUltimateServiceProvider mServices;
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final PredicateFactory mPredicateFactory;
    private final PredicateFactoryForInterpolantAutomata mPredicateFactoryInterpolantAutomata;
    private int mIteration;
    private final ErrorGeneralizationEngine<L> mErrorGeneralizationEngine;
    private IRefinementEngineResult<L, NestedWordAutomaton<L, IPredicate>> mRefinementResult = null;
    private NestedWordAutomaton<L, IPredicate> mInterpolAutomaton = null;
    private IRun<L, ?> mCounterexample = null;
    private final TaCheckAndRefinementPreferences<L> mTaCheckAndRefinementPrefs;
    private final PredicateFactoryRefinement mStateFactoryForRefinement;
    private final boolean mComputeHoareAnnotation;
    private IcfgLocation mCurrentErrorLoc;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    protected static final boolean REMOVE_DEAD_ENDS = true;
    private final ParallelNwaCegarLoop<L, A> mMainThread;
    private final INestedWordAutomaton<L, IPredicate> mAbstraction;
    private StrategyFactory<L> mStrategyFactory;
    private WorkerThreadResult<L, A> mThreadResult = null;
    private final BlockingQueue<WorkerThreadResult<L, A>> mBlockingQueueForResults;
    private final BlockingQueue<IRun<L, ?>> mWorkerTaskQueue;
    private final TransferBetweenMainAndWorker<L, IPredicate> mNwaCexTransferrer;
    private final PathProgramCache<L> mProgramCache;

    public CegarNwaWorkerThread(ILogger iLogger, TAPreferences tAPreferences, int n, AbstractCegarLoop.CegarLoopResultBuilder cegarLoopResultBuilder, IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, TaCheckAndRefinementPreferences<L> taCheckAndRefinementPreferences, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, PredicateFactoryRefinement predicateFactoryRefinement, boolean bl, ParallelNwaCegarLoop<L, A> parallelNwaCegarLoop, BlockingQueue<WorkerThreadResult<L, A>> blockingQueue, BlockingQueue<IRun<L, ?>> blockingQueue2, TransferBetweenMainAndWorker<L, IPredicate> transferBetweenMainAndWorker) throws InterruptedException {
        this.mLogger = iLogger;
        this.mPref = tAPreferences;
        this.mIteration = n;
        this.mResultBuilder = cegarLoopResultBuilder;
        this.mErrorGeneralizationEngine = new ErrorGeneralizationEngine(iUltimateServiceProvider);
        this.mServices = iUltimateServiceProvider;
        this.mCfgSmtToolkit = cfgSmtToolkit;
        this.mTaCheckAndRefinementPrefs = taCheckAndRefinementPreferences;
        this.mPredicateFactory = predicateFactory;
        this.mPredicateFactoryInterpolantAutomata = predicateFactoryForInterpolantAutomata;
        this.mStateFactoryForRefinement = predicateFactoryRefinement;
        this.mComputeHoareAnnotation = bl;
        this.mSimplificationTechnique = tAPreferences.getSimplificationTechnique();
        this.mMainThread = parallelNwaCegarLoop;
        this.mBlockingQueueForResults = blockingQueue;
        this.mWorkerTaskQueue = blockingQueue2;
        this.mNwaCexTransferrer = transferBetweenMainAndWorker;
        this.mAbstraction = (INestedWordAutomaton)this.getAbstraction();
        this.mProgramCache = new PathProgramCache(this.mLogger);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = (thread, throwable) -> {
            this.mThreadResult = new WorkerThreadResult(null, null, null, false, null, false, NwaCegarLoop.AutomatonType.ERROR, null, this.mCounterexample, null, true);
            try {
                this.mBlockingQueueForResults.put(this.mThreadResult);
            }
            catch (InterruptedException interruptedException) {
                throw new AssertionError((Object)("Worker Thread failed due to " + String.valueOf(interruptedException)));
            }
            this.mMainThread.reportFailedContinuesWorkerThread();
        };
        Thread.currentThread().setUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.mLogger.info((Object)("WorkerThread: " + String.valueOf(Thread.currentThread()) + " is Waiting for a Task"));
                ++this.mIteration;
                IRun<L, ?> iRun = this.mWorkerTaskQueue.take();
                this.mProgramCache.copyProgramCache(this.mMainThread.getCurrentProgramCache());
                this.mCounterexample = this.mNwaCexTransferrer.transferRun((NestedRun)iRun, TransferBetweenMainAndWorker.Mode.MAIN2WORKER);
                this.mProgramCache.setPathProgramCount(this.mCounterexample.getWord(), this.mProgramCache.getPathProgramCount(iRun.getWord()) - 1);
                List list = this.mCounterexample.getWord().asList();
                this.mCurrentErrorLoc = ((IIcfgTransition)this.mCounterexample.getSymbol(this.mCounterexample.getLength() - 2)).getTarget();
                int n = list.hashCode();
                this.mLogger.info((Object)("Starting Thread: " + Thread.currentThread().getId() + "# for Trace Check: " + n));
                Thread.currentThread().setName("Worker for " + n);
                try {
                    List<?> list2 = this.getControlConfigurationsFromCounterexample(this.mCounterexample);
                    Counterexample counterexample = new Counterexample(this.mCounterexample.getWord(), list2);
                    TraceAbstractionRefinementEngine.ITARefinementStrategy<L> iTARefinementStrategy = this.setUpStrategy(counterexample);
                    Pair<Script.LBool, IProgramExecution<L, Term>> pair = this.isCounterexampleFeasible(iTARefinementStrategy);
                    AbstractCegarLoop.AutomatonType automatonType = this.processFeasibilityCheckResult(iTARefinementStrategy, (Script.LBool)pair.getFirst(), (IProgramExecution)pair.getSecond(), this.mCurrentErrorLoc);
                    this.constructRefinementAutomaton(automatonType);
                    this.mThreadResult = this.refineAbstractionInternally();
                }
                catch (AutomataLibraryException | ToolchainCanceledException | SMTLIBException throwable) {
                    throw new AssertionError((Object)("WorkerThread Failed: " + String.valueOf(throwable)));
                }
                this.mLogger.info((Object)("Done with Thread: " + Thread.currentThread().getId() + "#"));
                this.mBlockingQueueForResults.put(this.mThreadResult);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    protected List<?> getControlConfigurationsFromCounterexample(IRun<L, ?> iRun) {
        return this.getIcfgLocationsFromRun(iRun);
    }

    private List<IcfgLocation> getIcfgLocationsFromRun(IRun<L, ?> iRun) {
        return iRun.getStateSequence().stream().map(object -> ((ISLPredicate)object).getProgramPoint()).collect(Collectors.toList());
    }

    private TraceAbstractionRefinementEngine.ITARefinementStrategy<L> setUpStrategy(Counterexample<L> counterexample) {
        this.mStrategyFactory = new StrategyFactory<L>(this.mLogger, this.mPref, this.mTaCheckAndRefinementPrefs, this.mCfgSmtToolkit, this.mPredicateFactory, this.mPredicateFactoryInterpolantAutomata, this.mMainThread.mTransitionClazz, this.mProgramCache);
        TraceAbstractionRefinementEngine.ITARefinementStrategy<L> iTARefinementStrategy = this.mStrategyFactory.constructStrategy(this.getServices(), counterexample, (IAutomaton<L, IPredicate>)this.mAbstraction, (TaskIdentifier)new SubtaskIterationIdentifier(this.mMainThread.mTaskIdentifier, this.mIteration), (IEmptyStackStateFactory<IPredicate>)this.mPredicateFactoryInterpolantAutomata, this.getPreconditionProvider(), this.getPostconditionProvider(), this.mPref.getRefinementStrategy());
        return iTARefinementStrategy;
    }

    private INwaOutgoingLetterAndTransitionProvider<L, IPredicate> getAbstraction() {
        INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton = this.mMainThread.getAbstraction();
        INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider = this.mNwaCexTransferrer.transferAutomaton((INwaOutgoingLetterAndTransitionProvider<L, IPredicate>)iNestedWordAutomaton, (IEmptyStackStateFactory<IPredicate>)this.mPredicateFactoryInterpolantAutomata, TransferBetweenMainAndWorker.Mode.MAIN2WORKER);
        return iNwaOutgoingLetterAndTransitionProvider;
    }

    private IPreconditionProvider getPreconditionProvider() {
        return IPreconditionProvider.constructDefaultPreconditionProvider();
    }

    private IPostconditionProvider getPostconditionProvider() {
        return IPostconditionProvider.constructDefaultPostconditionProvider();
    }

    protected Pair<Script.LBool, IProgramExecution<L, Term>> isCounterexampleFeasible(TraceAbstractionRefinementEngine.ITARefinementStrategy<L> iTARefinementStrategy) {
        if (this.mPref.hasLimitPathProgramCount() && this.mPref.getLimitPathProgramCount() < this.mStrategyFactory.getPathProgramCache().getPathProgramCount(this.mCounterexample.getWord())) {
            String string = "bailout by path program count limit in iteration " + this.mIteration;
            throw new TaskCanceledException(TaskCanceledException.UserDefinedLimit.PATH_PROGRAM_ATTEMPTS, this.getClass(), string);
        }
        Script.LBool lBool = new TraceAbstractionRefinementEngine(this.getServices(), this.mLogger, iTARefinementStrategy);
        this.mRefinementResult = lBool.getResult();
        lBool = this.mRefinementResult.getCounterexampleFeasibility();
        Object object = null;
        if (lBool != Script.LBool.UNSAT) {
            this.mLogger.info("Counterexample %s feasible", new Object[]{lBool == Script.LBool.SAT ? "is" : "might be"});
            object = this.mRefinementResult.providesIcfgProgramExecution() ? this.mRefinementResult.getIcfgProgramExecution() : TraceCheckUtils.computeSomeIcfgProgramExecutionWithoutValues((Word)this.mCounterexample.getWord());
            ((IcfgProgramExecution)object).setOriginCfgScript(this.mCfgSmtToolkit.getManagedScript());
        }
        return new Pair((Object)lBool, object);
    }

    private AbstractCegarLoop.AutomatonType processFeasibilityCheckResult(TraceAbstractionRefinementEngine.ITARefinementStrategy<L> iTARefinementStrategy, Script.LBool lBool, IProgramExecution<L, Term> iProgramExecution, IcfgLocation icfgLocation) {
        AbstractCegarLoop.Result result;
        if (lBool == Script.LBool.SAT) {
            this.mResultBuilder.addResultForProgramExecution(AbstractCegarLoop.Result.UNSAFE, iProgramExecution, null, null);
            if (this.mPref.stopAfterFirstViolation()) {
                this.mResultBuilder.addResultForAllRemaining(AbstractCegarLoop.Result.UNKNOWN);
            }
            return AbstractCegarLoop.AutomatonType.ERROR;
        }
        if (lBool != Script.LBool.UNKNOWN) {
            return AbstractCegarLoop.AutomatonType.INTERPOLANT;
        }
        if (iProgramExecution != null) {
            UnprovabilityReason unprovabilityReason;
            ITraceCheckStrategyModule<L, ?>[] iTraceCheckStrategyModuleArray = iTARefinementStrategy.getTraceCheckModules();
            int n = iTraceCheckStrategyModuleArray.length;
            int n2 = 0;
            while (n2 < n) {
                unprovabilityReason = iTraceCheckStrategyModuleArray[n2];
                if (unprovabilityReason instanceof IpTcStrategyModuleAcceleratedTraceCheck) {
                    throw new AssertionError((Object)"TraceCheck Unknown, dont return result. Might be just this Strategy that fails");
                }
                ++n2;
            }
            unprovabilityReason = new UnprovabilityReason("unable to decide satisfiability of path constraint");
            result = AbstractCegarLoop.Result.UNKNOWN;
            this.mResultBuilder.addResultForProgramExecution(result, iProgramExecution, null, unprovabilityReason);
        }
        result = AbstractCegarLoop.Result.TIMEOUT;
        this.mResultBuilder.addResult(icfgLocation, result, null, null, null);
        if (this.mPref.stopAfterFirstViolation()) {
            this.mResultBuilder.addResultForAllRemaining(result);
        }
        return AbstractCegarLoop.AutomatonType.UNKNOWN;
    }

    private void constructRefinementAutomaton(AbstractCegarLoop.AutomatonType automatonType) throws AutomataOperationCanceledException {
        switch (automatonType) {
            case ERROR: 
            case UNKNOWN: {
                this.mLogger.info("Excluding counterexample to continue analysis with %s automaton", new Object[]{automatonType});
                this.mErrorGeneralizationEngine.constructErrorAutomaton(this.mCounterexample, this.mPredicateFactory, this.mRefinementResult.getPredicateUnifier(), this.mCfgSmtToolkit, this.mSimplificationTechnique, this.mCfgSmtToolkit.getSymbolTable(), this.mPredicateFactoryInterpolantAutomata, this.mAbstraction, this.mIteration);
                this.mInterpolAutomaton = null;
                break;
            }
            case INTERPOLANT: {
                this.mInterpolAutomaton = (NestedWordAutomaton)this.mRefinementResult.getInfeasibilityProof();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown automaton type: " + String.valueOf((Object)automatonType));
            }
        }
    }

    protected IUltimateServiceProvider getServices() {
        return this.mServices;
    }

    private WorkerThreadResult<L, A> refineAbstractionInternally() throws AutomataLibraryException {
        INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider;
        NestedWordAutomaton<L, IPredicate> nestedWordAutomaton;
        TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement;
        boolean bl;
        boolean bl2;
        NwaCegarLoop.AutomatonType automatonType;
        this.mStateFactoryForRefinement.setIteration(this.mIteration);
        IPredicateUnifier iPredicateUnifier = this.mRefinementResult.getPredicateUnifier();
        IHoareTripleChecker iHoareTripleChecker = this.getHoareTripleChecker();
        if (this.mErrorGeneralizationEngine.hasAutomatonInIteration(this.mIteration)) {
            this.mErrorGeneralizationEngine.startDifference();
            automatonType = NwaCegarLoop.AutomatonType.ERROR;
            bl2 = true;
            bl = false;
            interpolantAutomatonEnhancement = this.mErrorGeneralizationEngine.getEnhancementMode();
            nestedWordAutomaton = this.mErrorGeneralizationEngine.getResultBeforeEnhancement();
            iNwaOutgoingLetterAndTransitionProvider = this.mErrorGeneralizationEngine.getResultAfterEnhancement();
        } else {
            automatonType = NwaCegarLoop.AutomatonType.FLOYD_HOARE;
            bl2 = false;
            bl = !this.mComputeHoareAnnotation;
            nestedWordAutomaton = this.mInterpolAutomaton;
            interpolantAutomatonEnhancement = this.mPref.interpolantAutomatonEnhancement();
            iNwaOutgoingLetterAndTransitionProvider = this.enhanceInterpolantAutomaton(interpolantAutomatonEnhancement, iPredicateUnifier, iHoareTripleChecker, nestedWordAutomaton);
        }
        this.mLogger.info((Object)"Difference in Worker for Generalization");
        this.computeAutomataDifference(this.mAbstraction, iNwaOutgoingLetterAndTransitionProvider, (INwaOutgoingLetterAndTransitionProvider<L, IPredicate>)nestedWordAutomaton, iPredicateUnifier, bl, iHoareTripleChecker, interpolantAutomatonEnhancement, bl2, automatonType);
        WorkerThreadResult workerThreadResult = new WorkerThreadResult(this.mNwaCexTransferrer.transferAutomaton(iNwaOutgoingLetterAndTransitionProvider, (IEmptyStackStateFactory<IPredicate>)this.mPredicateFactoryInterpolantAutomata, TransferBetweenMainAndWorker.Mode.WORKER2MAIN), this.mNwaCexTransferrer.transferAutomaton((INwaOutgoingLetterAndTransitionProvider<L, IPredicate>)nestedWordAutomaton, (IEmptyStackStateFactory<IPredicate>)this.mPredicateFactoryInterpolantAutomata, TransferBetweenMainAndWorker.Mode.WORKER2MAIN), iPredicateUnifier, bl, interpolantAutomatonEnhancement, bl2, automatonType, this.mCfgSmtToolkit.getManagedScript(), this.mNwaCexTransferrer.transferRun((NestedRun)this.mCounterexample, TransferBetweenMainAndWorker.Mode.WORKER2MAIN), this.mPredicateFactory, false);
        return workerThreadResult;
    }

    private IOpWithDelayedDeadEndRemoval<L, IPredicate> computeAutomataDifference(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider2, IPredicateUnifier iPredicateUnifier, boolean bl, IHoareTripleChecker iHoareTripleChecker, TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement, boolean bl2, NwaCegarLoop.AutomatonType automatonType) throws AutomataLibraryException, AssertionError {
        if (interpolantAutomatonEnhancement == TAPreferences.InterpolantAutomatonEnhancement.NONE) {
            return null;
        }
        try {
            Object object;
            this.mLogger.debug((Object)"WORKER: Start constructing difference for enhancing interpolant automaton in worker");
            PowersetDeterminizer powersetDeterminizer = new PowersetDeterminizer(iNwaOutgoingLetterAndTransitionProvider, true, (IDeterminizeStateFactory)this.mPredicateFactoryInterpolantAutomata);
            try {
                try {
                    object = this.mPref.differenceSenwa() ? new DifferenceSenwa(new AutomataLibraryServices(this.getServices()), (ISenwaStateFactory)this.mStateFactoryForRefinement, iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, (IStateDeterminizer)powersetDeterminizer, false) : new Difference(new AutomataLibraryServices(this.getServices()), (ISinkStateFactory)this.mStateFactoryForRefinement, iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, (IStateDeterminizer)powersetDeterminizer, bl);
                }
                catch (AutomataOperationCanceledException | ToolchainCanceledException throwable) {
                    RunningTaskInfo runningTaskInfo = this.executeDifferenceTimeoutActions(iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2, automatonType);
                    ((IRunningTaskStackReceiver)throwable).addRunningTaskInfo(runningTaskInfo);
                    throw throwable;
                }
            }
            finally {
                assert (iNwaOutgoingLetterAndTransitionProvider instanceof AbstractInterpolantAutomaton) : "if enhancement is used, we need AbstractInterpolantAutomaton";
                ((AbstractInterpolantAutomaton)iNwaOutgoingLetterAndTransitionProvider).switchToReadonlyMode();
            }
            object.removeDeadEnds();
            DifferenceSenwa differenceSenwa = object;
            return differenceSenwa;
        }
        finally {
            this.mLogger.info((Object)iPredicateUnifier.collectPredicateUnifierStatistics());
            this.mLogger.info((Object)iHoareTripleChecker.getStatistics());
            this.mLogger.info((Object)iHoareTripleChecker);
            this.mLogger.debug((Object)"WORKER: Finished constructing difference");
        }
    }

    private RunningTaskInfo executeDifferenceTimeoutActions(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider2, NwaCegarLoop.AutomatonType automatonType) throws AutomataLibraryException {
        RunningTaskInfo runningTaskInfo = this.getDifferenceTimeoutRunningTaskInfo(iNestedWordAutomaton, iNwaOutgoingLetterAndTransitionProvider, iNwaOutgoingLetterAndTransitionProvider2, automatonType);
        return runningTaskInfo;
    }

    private RunningTaskInfo getDifferenceTimeoutRunningTaskInfo(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider2, NwaCegarLoop.AutomatonType automatonType) {
        String string = "WORKER: constructing difference of abstraction (" + iNestedWordAutomaton.size() + "states) and " + String.valueOf((Object)automatonType) + " automaton (currently " + iNwaOutgoingLetterAndTransitionProvider.size() + " states, " + iNwaOutgoingLetterAndTransitionProvider2.size() + " states before enhancement)";
        return new RunningTaskInfo(this.getClass(), string);
    }

    protected final IHoareTripleChecker getHoareTripleChecker() {
        IHoareTripleChecker iHoareTripleChecker = this.mRefinementResult.getHoareTripleChecker();
        if (iHoareTripleChecker != null) {
            return iHoareTripleChecker;
        }
        HoareTripleCheckerCache hoareTripleCheckerCache = TraceAbstractionUtils.extractHoareTriplesfromAutomaton((NestedWordAutomaton)this.mRefinementResult.getInfeasibilityProof());
        return HoareTripleCheckerUtils.constructEfficientHoareTripleCheckerWithCaching((IUltimateServiceProvider)this.getServices(), (HoareTripleCheckerUtils.HoareTripleChecks)this.mPref.getHoareTripleChecks(), (CfgSmtToolkit)this.mCfgSmtToolkit, (IPredicateUnifier)this.mRefinementResult.getPredicateUnifier(), (HoareTripleCheckerCache)hoareTripleCheckerCache);
    }

    protected INwaOutgoingLetterAndTransitionProvider<L, IPredicate> enhanceInterpolantAutomaton(TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement, IPredicateUnifier iPredicateUnifier, IHoareTripleChecker iHoareTripleChecker, NestedWordAutomaton<L, IPredicate> nestedWordAutomaton) {
        Object object;
        if (interpolantAutomatonEnhancement == TAPreferences.InterpolantAutomatonEnhancement.NONE) {
            object = nestedWordAutomaton;
        } else {
            AbstractInterpolantAutomaton<L> abstractInterpolantAutomaton = this.constructInterpolantAutomatonForOnDemandEnhancement(nestedWordAutomaton, iPredicateUnifier, iHoareTripleChecker, interpolantAutomatonEnhancement);
            object = abstractInterpolantAutomaton;
        }
        return object;
    }

    protected AbstractInterpolantAutomaton<L> constructInterpolantAutomatonForOnDemandEnhancement(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, IPredicateUnifier iPredicateUnifier, IHoareTripleChecker iHoareTripleChecker, TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement) {
        return switch (interpolantAutomatonEnhancement) {
            case TAPreferences.InterpolantAutomatonEnhancement.NONE -> throw new IllegalArgumentException("In setting NONE we will not do any enhancement");
            case TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION, TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION_CONSERVATIVE, TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION_CANNIBALIZE -> this.constructInterpolantAutomatonForOnDemandEnhancementPredicateAbstraction(nestedWordAutomaton, iPredicateUnifier, iHoareTripleChecker, interpolantAutomatonEnhancement);
            case TAPreferences.InterpolantAutomatonEnhancement.EAGER, TAPreferences.InterpolantAutomatonEnhancement.EAGER_CONSERVATIVE, TAPreferences.InterpolantAutomatonEnhancement.NO_SECOND_CHANCE -> this.constructInterpolantAutomatonForOnDemandEnhancementEager(nestedWordAutomaton, iPredicateUnifier, iHoareTripleChecker, interpolantAutomatonEnhancement);
            default -> throw new UnsupportedOperationException("unknown " + String.valueOf((Object)interpolantAutomatonEnhancement));
        };
    }

    private NondeterministicInterpolantAutomaton<L> constructInterpolantAutomatonForOnDemandEnhancementEager(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, IPredicateUnifier iPredicateUnifier, IHoareTripleChecker iHoareTripleChecker, TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement) {
        boolean bl = interpolantAutomatonEnhancement == TAPreferences.InterpolantAutomatonEnhancement.EAGER_CONSERVATIVE;
        boolean bl2 = interpolantAutomatonEnhancement != TAPreferences.InterpolantAutomatonEnhancement.NO_SECOND_CHANCE;
        return new NondeterministicInterpolantAutomaton<L>(this.getServices(), this.mCfgSmtToolkit, iHoareTripleChecker, nestedWordAutomaton, iPredicateUnifier, bl, bl2);
    }

    private DeterministicInterpolantAutomaton<L> constructInterpolantAutomatonForOnDemandEnhancementPredicateAbstraction(NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, IPredicateUnifier iPredicateUnifier, IHoareTripleChecker iHoareTripleChecker, TAPreferences.InterpolantAutomatonEnhancement interpolantAutomatonEnhancement) {
        boolean bl = interpolantAutomatonEnhancement == TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION_CONSERVATIVE;
        boolean bl2 = interpolantAutomatonEnhancement == TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION_CANNIBALIZE;
        return new DeterministicInterpolantAutomaton<L>(this.getServices(), this.mCfgSmtToolkit, iHoareTripleChecker, nestedWordAutomaton, iPredicateUnifier, bl, bl2);
    }
}

