/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.IncrementalImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.predicates.IterativePredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.DefaultTransFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.NestedFormulas;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckSpWp;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.PredicateFactoryForInterpolantAutomata;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.IErrorAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.PredicateUnificationMechanism;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PosetUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;

class DangerAutomatonBuilder<L extends IIcfgTransition<?>>
implements IErrorAutomatonBuilder<L> {
    private static final boolean UNIFY_PREDICATES = true;
    private final IUltimateServiceProvider mServices;
    private NestedWordAutomaton<L, IPredicate> mResult;
    private final IPredicate mErrorPrecondition;
    private final Set<IPredicate> mPredicates;
    private final ILogger mLogger;
    private final CfgSmtToolkit mCsTookit;
    private PredicateTransformer<Term, IPredicate, TransFormula> mPt;
    final ConstructionCache<Pair<IPredicate, L>, Term> mPreInternalCc;
    final ConstructionCache<Triple<IPredicate, L, IPredicate>, Script.LBool> mIntersectionWithPreInternalCc;
    private final boolean USE_DISJUNCTIONS = false;
    private IPredicateUnifier mPredicateUnifier;
    Set<HashRelation<L, IPredicate>> constrainersCache = new HashSet<HashRelation<L, IPredicate>>();

    public DangerAutomatonBuilder(IUltimateServiceProvider iUltimateServiceProvider, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, NestedWord<L> nestedWord) {
        if (!NestedWordAutomataUtils.isFiniteAutomaton(iNestedWordAutomaton)) {
            throw new IllegalArgumentException("Calls and returns are not yet supported.");
        }
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mCsTookit = cfgSmtToolkit;
        this.mPredicateUnifier = iPredicateUnifier;
        PredicateUnificationMechanism predicateUnificationMechanism = new PredicateUnificationMechanism(iPredicateUnifier, true);
        TracePredicates tracePredicates = this.constructPredicates(this.mLogger, predicateFactory, predicateUnificationMechanism, cfgSmtToolkit, simplificationTechnique, iIcfgSymbolTable, nestedWord, iPredicateUnifier);
        this.mErrorPrecondition = tracePredicates.getPrecondition();
        this.mPredicates = DangerAutomatonBuilder.collectPredicates(tracePredicates);
        this.mLogger.info((Object)("Constructing danger automaton with " + this.mPredicates.size() + " predicates."));
        this.mPt = new PredicateTransformer(cfgSmtToolkit.getManagedScript(), (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, cfgSmtToolkit.getManagedScript()));
        IncrementalHoareTripleChecker incrementalHoareTripleChecker = new IncrementalHoareTripleChecker(this.mCsTookit, false);
        NestedWordAutomaton<L, IPredicate> nestedWordAutomaton = pair -> {
            Term term = (Term)this.mPt.weakestPrecondition((IAbstractPredicate)predicateFactory.not((IPredicate)pair.getFirst()), (ITransitionRelation)((IIcfgTransition)pair.getSecond()).getTransformula());
            Term term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)cfgSmtToolkit.getManagedScript(), (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term);
            Term term3 = SmtUtils.not((Script)cfgSmtToolkit.getManagedScript().getScript(), (Term)term2);
            return term3;
        };
        this.mPreInternalCc = new ConstructionCache((ConstructionCache.IValueConstruction)nestedWordAutomaton);
        nestedWordAutomaton = triple -> {
            IncrementalPlicationChecker.Validity validity = incrementalHoareTripleChecker.checkInternal((IPredicate)triple.getFirst(), (IInternalAction)triple.getSecond(), predicateFactory.not((IPredicate)triple.getThird()));
            incrementalHoareTripleChecker.releaseLock();
            return IncrementalPlicationChecker.convertValidity2Lbool((IncrementalPlicationChecker.Validity)validity);
        };
        this.mIntersectionWithPreInternalCc = new ConstructionCache((ConstructionCache.IValueConstruction)nestedWordAutomaton);
        nestedWordAutomaton = this.constructDangerAutomaton(new AutomataLibraryServices(iUltimateServiceProvider), this.mLogger, predicateFactory, predicateUnificationMechanism, cfgSmtToolkit, predicateFactoryForInterpolantAutomata, iNestedWordAutomaton, this.mPredicates, true);
        this.mResult = nestedWordAutomaton;
    }

    @Override
    public IErrorAutomatonBuilder.ErrorAutomatonType getType() {
        return IErrorAutomatonBuilder.ErrorAutomatonType.DANGER_AUTOMATON;
    }

    @Override
    public NestedWordAutomaton<L, IPredicate> getResultBeforeEnhancement() {
        return this.mResult;
    }

    @Override
    public INwaOutgoingLetterAndTransitionProvider<L, IPredicate> getResultAfterEnhancement() {
        return this.mResult;
    }

    @Override
    public IPredicate getErrorPrecondition() {
        return this.mErrorPrecondition;
    }

    @Override
    public TAPreferences.InterpolantAutomatonEnhancement getEnhancementMode() {
        return TAPreferences.InterpolantAutomatonEnhancement.NONE;
    }

    private NestedWordAutomaton<L, IPredicate> constructDangerAutomaton(AutomataLibraryServices automataLibraryServices, ILogger iLogger, PredicateFactory predicateFactory, PredicateUnificationMechanism predicateUnificationMechanism, CfgSmtToolkit cfgSmtToolkit, PredicateFactoryForInterpolantAutomata predicateFactoryForInterpolantAutomata, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, Set<IPredicate> set, boolean bl) {
        IPredicate iPredicate3;
        HashRelation hashRelation = new HashRelation();
        ConstructionCache.IValueConstruction iValueConstruction = pair -> predicateFactory.or((Collection)pair.getSecond());
        ConstructionCache constructionCache = new ConstructionCache(iValueConstruction);
        iValueConstruction = new IncrementalImplicationChecker(this.mServices, cfgSmtToolkit.getManagedScript());
        Object object = arg_0 -> this.lambda$3(predicateFactory, cfgSmtToolkit, (IncrementalImplicationChecker)iValueConstruction, set, arg_0);
        ConstructionCache constructionCache2 = new ConstructionCache((ConstructionCache.IValueConstruction)object);
        object = new ArrayDeque();
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(automataLibraryServices, NestedWordAutomataUtils.getVpAlphabet(iNestedWordAutomaton), (IEmptyStackStateFactory)predicateFactoryForInterpolantAutomata);
        IPredicate iPredicate2 = predicateUnificationMechanism.getTruePredicate();
        for (IPredicate iPredicate3 : iNestedWordAutomaton.getFinalStates()) {
            nestedWordAutomaton.addState(false, true, (Object)((IPredicate)constructionCache.getOrConstruct((Object)new Pair((Object)iPredicate3, Collections.singleton(iPredicate2)))));
            hashRelation.addPair((Object)iPredicate3, (Object)iPredicate2);
            object.add(iPredicate3);
        }
        iPredicate3 = new PredicateTransformer(cfgSmtToolkit.getManagedScript(), (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, cfgSmtToolkit.getManagedScript()));
        while (!object.isEmpty()) {
            IPredicate iPredicate4 = (IPredicate)object.poll();
            for (IncomingInternalTransition incomingInternalTransition : iNestedWordAutomaton.internalPredecessors((Object)iPredicate4)) {
                Set set2;
                IPredicate iPredicate5 = (IPredicate)incomingInternalTransition.getPred();
                Set<Object> set3 = this.getCoveredPredicates(iLogger, predicateFactory, cfgSmtToolkit, iNestedWordAutomaton, (HashRelation<IPredicate, IPredicate>)hashRelation, (ConstructionCache<Pair<IPredicate, Set<IPredicate>>, IPredicate>)constructionCache, set, (PredicateTransformer<Term, IPredicate, TransFormula>)iPredicate3, (IncrementalImplicationChecker)iValueConstruction, iPredicate5, constructionCache2);
                if (set3.isEmpty()) continue;
                if (bl && (set2 = PosetUtils.filterMaximalElements(set3, (IPartialComparator)this.mPredicateUnifier.getCoverageRelation().getPartialComparator()).collect(Collectors.toSet())).size() < set3.size()) {
                    set3 = set2;
                }
                set2 = hashRelation.getImage((Object)iPredicate5);
                boolean bl2 = false;
                for (IPredicate iPredicate6 : set3) {
                    if (set2.contains(iPredicate6)) continue;
                    bl2 = true;
                    IPredicate iPredicate7 = (IPredicate)constructionCache.getOrConstruct((Object)new Pair((Object)iPredicate5, Collections.singleton(iPredicate6)));
                    boolean bl3 = iNestedWordAutomaton.isInitial((Object)iPredicate5);
                    boolean bl4 = iNestedWordAutomaton.isFinal((Object)iPredicate5);
                    nestedWordAutomaton.addState(bl3, bl4, (Object)iPredicate7);
                    hashRelation.addPair((Object)iPredicate5, (Object)iPredicate6);
                }
                if (bl2) {
                    object.add(iPredicate5);
                }
                for (IPredicate iPredicate6 : set3) {
                    for (IPredicate iPredicate7 : iNestedWordAutomaton.internalSuccessors((Object)iPredicate5)) {
                        for (IPredicate iPredicate8 : hashRelation.getImage((Object)((IPredicate)iPredicate7.getSucc()))) {
                            Script.LBool lBool = (Script.LBool)this.mIntersectionWithPreInternalCc.getOrConstruct((Object)new Triple((Object)iPredicate6, (Object)((IIcfgTransition)iPredicate7.getLetter()), (Object)iPredicate8));
                            if (lBool != Script.LBool.SAT) continue;
                            nestedWordAutomaton.addInternalTransition((Object)((IPredicate)constructionCache.getOrConstruct((Object)new Pair((Object)iPredicate5, Collections.singleton(iPredicate6)))), (Object)((IIcfgTransition)iPredicate7.getLetter()), (Object)((IPredicate)constructionCache.getOrConstruct((Object)new Pair((Object)((IPredicate)iPredicate7.getSucc()), Collections.singleton(iPredicate8)))));
                        }
                    }
                }
            }
        }
        return nestedWordAutomaton;
    }

    private Set<IPredicate> getCoveredPredicates(ILogger iLogger, PredicateFactory predicateFactory, CfgSmtToolkit cfgSmtToolkit, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, HashRelation<IPredicate, IPredicate> hashRelation, ConstructionCache<Pair<IPredicate, Set<IPredicate>>, IPredicate> constructionCache, Set<IPredicate> set, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, IncrementalImplicationChecker incrementalImplicationChecker, IPredicate iPredicate, ConstructionCache<HashRelation<L, IPredicate>, Set<IPredicate>> constructionCache2) {
        HashRelation hashRelation2 = new HashRelation();
        for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors((Object)iPredicate)) {
            for (IPredicate iPredicate2 : hashRelation.getImage((Object)((IPredicate)outgoingInternalTransition.getSucc()))) {
                hashRelation2.addPair((Object)((IIcfgTransition)outgoingInternalTransition.getLetter()), (Object)iPredicate2);
            }
        }
        return (Set)constructionCache2.getOrConstruct((Object)hashRelation2);
    }

    private IPredicate getNewState(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, HashRelation<IPredicate, IPredicate> hashRelation, ConstructionCache<Pair<IPredicate, Set<IPredicate>>, IPredicate> constructionCache, Queue<IPredicate> queue, NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, IPredicate iPredicate, Set<IPredicate> set) {
        Set set2 = hashRelation.getImage((Object)iPredicate);
        if (set.equals(set2)) {
            return (IPredicate)constructionCache.getOrConstruct((Object)new Pair((Object)iPredicate, (Object)set2));
        }
        if (!queue.contains(iPredicate)) {
            queue.add(iPredicate);
        }
        IPredicate iPredicate2 = (IPredicate)constructionCache.getOrConstruct((Object)new Pair((Object)iPredicate, set));
        boolean bl = iNestedWordAutomaton.isInitial((Object)iPredicate);
        boolean bl2 = iNestedWordAutomaton.isFinal((Object)iPredicate);
        nestedWordAutomaton.addState(bl, bl2, (Object)iPredicate2);
        if (!set2.isEmpty()) {
            IPredicate iPredicate3 = (IPredicate)constructionCache.getOrConstruct((Object)new Pair((Object)iPredicate, (Object)set2));
            assert (nestedWordAutomaton.contains((Object)iPredicate3));
            this.copyAllIncomingTransitions(iPredicate3, iPredicate2, nestedWordAutomaton);
            nestedWordAutomaton.removeState((Object)iPredicate3);
        }
        for (IPredicate iPredicate3 : set) {
            hashRelation.addPair((Object)iPredicate, (Object)iPredicate3);
        }
        return iPredicate2;
    }

    private void addOutgoingTransitionsToContributingStates(ILogger iLogger, PredicateFactory predicateFactory, CfgSmtToolkit cfgSmtToolkit, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, HashRelation<IPredicate, IPredicate> hashRelation, ConstructionCache<Pair<IPredicate, Set<IPredicate>>, IPredicate> constructionCache, NestedWordAutomaton<L, IPredicate> nestedWordAutomaton, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, IPredicate iPredicate, IPredicate iPredicate2) {
        for (OutgoingInternalTransition outgoingInternalTransition : iNestedWordAutomaton.internalSuccessors((Object)iPredicate)) {
            IPredicate iPredicate3 = this.getSuccessorDisjunction(hashRelation, constructionCache, (IOutgoingTransitionlet<L, IPredicate>)outgoingInternalTransition);
            if (iPredicate3 == null) continue;
            assert (nestedWordAutomaton.getStates().contains(iPredicate3));
            Script.LBool lBool = (Script.LBool)this.mIntersectionWithPreInternalCc.getOrConstruct((Object)new Triple((Object)iPredicate2, (Object)((IIcfgTransition)outgoingInternalTransition.getLetter()), (Object)iPredicate3));
            if (lBool == Script.LBool.UNSAT) continue;
            nestedWordAutomaton.addInternalTransition((Object)iPredicate2, (Object)((IIcfgTransition)outgoingInternalTransition.getLetter()), (Object)iPredicate3);
        }
    }

    private Script.LBool checkIntersectionWithPre(ILogger iLogger, PredicateFactory predicateFactory, CfgSmtToolkit cfgSmtToolkit, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, IPredicate iPredicate, OutgoingInternalTransition<L, IPredicate> outgoingInternalTransition, IPredicate iPredicate2) {
        Term term = (Term)this.mPreInternalCc.getOrConstruct((Object)new Pair((Object)iPredicate2, (Object)((IIcfgTransition)outgoingInternalTransition.getLetter())));
        Term term2 = SmtUtils.and((Script)cfgSmtToolkit.getManagedScript().getScript(), Arrays.asList(term, iPredicate.getFormula()));
        return SmtUtils.checkSatTerm((Script)cfgSmtToolkit.getManagedScript().getScript(), (Term)term2);
    }

    private IPredicate getSuccessorDisjunction(HashRelation<IPredicate, IPredicate> hashRelation, ConstructionCache<Pair<IPredicate, Set<IPredicate>>, IPredicate> constructionCache, IOutgoingTransitionlet<L, IPredicate> iOutgoingTransitionlet) {
        IPredicate iPredicate = (IPredicate)iOutgoingTransitionlet.getSucc();
        Set set = hashRelation.getImage((Object)iPredicate);
        if (set.isEmpty()) {
            return null;
        }
        return (IPredicate)constructionCache.getOrConstruct((Object)new Pair((Object)iPredicate, (Object)set));
    }

    private TracePredicates constructPredicates(ILogger iLogger, PredicateFactory predicateFactory, PredicateUnificationMechanism predicateUnificationMechanism, CfgSmtToolkit cfgSmtToolkit, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, NestedWord<L> nestedWord, IPredicateUnifier iPredicateUnifier) throws AssertionError {
        IterativePredicateTransformer iterativePredicateTransformer = new IterativePredicateTransformer((BasicPredicateFactory)predicateFactory, cfgSmtToolkit.getManagedScript(), cfgSmtToolkit.getModifiableGlobalsTable(), this.mServices, nestedWord, null, predicateUnificationMechanism.getTruePredicate(), null, predicateUnificationMechanism.getTruePredicate(), simplificationTechnique, iIcfgSymbolTable);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IterativePredicateTransformer.QuantifierEliminationPostprocessor quantifierEliminationPostprocessor = new IterativePredicateTransformer.QuantifierEliminationPostprocessor(this.mServices, cfgSmtToolkit.getManagedScript(), (BasicPredicateFactory)predicateFactory, simplificationTechnique);
        arrayList.add(quantifierEliminationPostprocessor);
        arrayList.add(new TraceCheckSpWp.UnifyPostprocessor(iPredicateUnifier));
        DefaultTransFormulas defaultTransFormulas = new DefaultTransFormulas(nestedWord, null, null, Collections.emptySortedMap(), cfgSmtToolkit.getOldVarsAssignmentCache(), false);
        try {
            return iterativePredicateTransformer.computePreSequence((NestedFormulas)defaultTransFormulas, arrayList, false);
        }
        catch (IterativePredicateTransformer.TraceInterpolationException traceInterpolationException) {
            throw new AssertionError((Object)("failed to compute sequence " + String.valueOf((Object)traceInterpolationException)));
        }
    }

    private static Set<IPredicate> collectPredicates(TracePredicates tracePredicates) {
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>(tracePredicates.getPredicates());
        hashSet.add(tracePredicates.getPostcondition());
        hashSet.add(tracePredicates.getPrecondition());
        return hashSet;
    }

    private void copyAllIncomingTransitions(IPredicate iPredicate, IPredicate iPredicate2, NestedWordAutomaton<L, IPredicate> nestedWordAutomaton) {
        for (IncomingInternalTransition incomingInternalTransition : nestedWordAutomaton.internalPredecessors((Object)iPredicate)) {
            nestedWordAutomaton.addInternalTransition((Object)((IPredicate)incomingInternalTransition.getPred()), (Object)((IIcfgTransition)incomingInternalTransition.getLetter()), (Object)iPredicate2);
        }
    }

    private /* synthetic */ Set lambda$3(PredicateFactory predicateFactory, CfgSmtToolkit cfgSmtToolkit, IncrementalImplicationChecker incrementalImplicationChecker, Set set, HashRelation hashRelation) {
        Map.Entry entry2;
        HashSet<Term> hashSet = new HashSet<Term>();
        for (Map.Entry entry2 : hashRelation.getSetOfPairs()) {
            Term term = (Term)this.mPreInternalCc.getOrConstruct((Object)new Pair((Object)((IPredicate)entry2.getValue()), (Object)((IIcfgTransition)entry2.getKey())));
            hashSet.add(term);
        }
        entry2 = predicateFactory.newPredicate(SmtUtils.or((Script)cfgSmtToolkit.getManagedScript().getScript(), hashSet));
        HashSet hashSet2 = new HashSet();
        try {
            for (Term term : set) {
                IncrementalPlicationChecker.Validity validity;
                if (hashSet2.contains(term) || (validity = incrementalImplicationChecker.checkImplication((IPredicate)term, (IPredicate)entry2)) != IncrementalPlicationChecker.Validity.VALID) continue;
                hashSet2.addAll(this.mPredicateUnifier.getCoverageRelation().getCoveredPredicates((IPredicate)term));
            }
        }
        finally {
            incrementalImplicationChecker.releaseLock();
        }
        return hashSet2;
    }
}

