/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction;

import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.ErrorAutomatonStatisticsGenerator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ErrorTraceContainer<L>
implements Iterable<ErrorTrace<L>> {
    private final List<ErrorTrace<L>> mTraces = new LinkedList<ErrorTrace<L>>();

    public void addTrace(IRun<L, ?> iRun, IPredicate iPredicate) {
        this.mTraces.add(new ErrorTrace<L>(iRun, iPredicate));
    }

    public void addTrace(IRun<L, ?> iRun) {
        this.addTrace(iRun, null);
    }

    public void addPrecondition(IPredicate iPredicate) {
        if (iPredicate != null) {
            this.mTraces.get((int)(this.mTraces.size() - 1)).mPrecondition = iPredicate;
        }
    }

    public void addEnhancementType(ErrorAutomatonStatisticsGenerator.EnhancementType enhancementType) {
        this.mTraces.get((int)(this.mTraces.size() - 1)).mEnhancement = enhancementType;
    }

    public boolean isEmpty() {
        return this.mTraces.isEmpty();
    }

    public int size() {
        return this.mTraces.size();
    }

    @Override
    public Iterator<ErrorTrace<L>> iterator() {
        return this.mTraces.iterator();
    }

    public static final class ErrorTrace<L> {
        private final IRun<L, ?> mTrace;
        private IPredicate mPrecondition;
        private ErrorAutomatonStatisticsGenerator.EnhancementType mEnhancement;

        public ErrorTrace(IRun<L, ?> iRun, IPredicate iPredicate) {
            this.mTrace = iRun;
            this.mPrecondition = iPredicate;
            this.mEnhancement = ErrorAutomatonStatisticsGenerator.EnhancementType.UNKNOWN;
        }

        public ErrorTrace(IRun<L, ?> iRun) {
            this(iRun, null);
        }

        public IRun<L, ?> getTrace() {
            return this.mTrace;
        }

        public IPredicate getPrecondition() {
            return this.mPrecondition;
        }

        public ErrorAutomatonStatisticsGenerator.EnhancementType getEnhancement() {
            return this.mEnhancement;
        }
    }
}

