/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RcfgVariableProvider<STATE extends IAbstractState<STATE>>
implements IVariableProvider<STATE, IcfgEdge> {
    private final CfgSmtToolkit mCfgSmt;
    private final IIcfgSymbolTable mSymbolTable;
    private final ILogger mLogger;

    public RcfgVariableProvider(CfgSmtToolkit cfgSmtToolkit, IUltimateServiceProvider iUltimateServiceProvider) {
        this(cfgSmtToolkit, iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID));
    }

    public RcfgVariableProvider(CfgSmtToolkit cfgSmtToolkit, ILogger iLogger) {
        assert (cfgSmtToolkit != null);
        assert (iLogger != null);
        this.mCfgSmt = cfgSmtToolkit;
        this.mSymbolTable = cfgSmtToolkit.getSymbolTable();
        this.mLogger = iLogger;
    }

    public STATE defineInitialVariables(IcfgEdge icfgEdge, STATE STATE) {
        assert (icfgEdge != null) : "edge is null";
        assert (STATE != null) : "state is null";
        Set<IProgramVarOrConst> set = this.getPreVariables(icfgEdge);
        if (set.isEmpty()) {
            return STATE;
        }
        return (STATE)STATE.addVariables(set);
    }

    public STATE defineVariablesAfter(IcfgEdge icfgEdge, STATE STATE, STATE STATE2) {
        Summary summary;
        assert (icfgEdge != null);
        assert (STATE != null);
        if (icfgEdge instanceof IIcfgCallTransition) {
            return this.defineVariablesAfterCall(icfgEdge, STATE);
        }
        if (icfgEdge instanceof IIcfgReturnTransition) {
            String string = icfgEdge.getPrecedingProcedure();
            String string2 = icfgEdge.getSucceedingProcedure();
            return this.defineVariablesAfterReturn(STATE, STATE2, string, string2);
        }
        if (icfgEdge instanceof Summary && (summary = (Summary)icfgEdge).calledProcedureHasImplementation()) {
            String string = summary.getCallStatement().getMethodName();
            String string3 = icfgEdge.getSucceedingProcedure();
            return this.defineVariablesAfterReturn(STATE, STATE2, string, string3);
        }
        return STATE;
    }

    public STATE createValidPostOpStateAfterLeaving(IcfgEdge icfgEdge, STATE STATE, STATE STATE2) {
        Set<IProgramVarOrConst> set = this.getPreVariables(icfgEdge);
        STATE STATE3 = AbsIntUtil.synchronizeVariables(STATE, set);
        return this.defineVariablesAfter(icfgEdge, STATE3, STATE2);
    }

    public STATE createValidPostOpStateBeforeLeaving(IcfgEdge icfgEdge, STATE STATE) {
        Set<IProgramVarOrConst> set = this.getPreVariables(icfgEdge);
        return AbsIntUtil.synchronizeVariables(STATE, set);
    }

    private STATE defineVariablesAfterReturn(STATE STATE, STATE STATE2, String string, String string2) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        if (string != null) {
            hashSet.addAll(this.getMaskedGlobalsVariables(string));
            hashSet.addAll(this.getOldVars());
        }
        if (string2 != null) {
            hashSet.addAll(this.getLocalVariables(string2));
        }
        Object object = STATE;
        object = this.removeLocals(object, string);
        if (hashSet.isEmpty()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)new StringBuilder().append("   ").append(" No vars needed from old scope"));
            }
            return object;
        }
        Object object2 = STATE2;
        assert (object2 != null) : "There is no abstract state before the call that corresponds to this return";
        HashSet<IProgramVarOrConst> hashSet2 = new HashSet<IProgramVarOrConst>();
        for (IProgramVarOrConst iProgramVarOrConst : object2.getVariables()) {
            if (hashSet.contains(iProgramVarOrConst)) continue;
            hashSet2.add(iProgramVarOrConst);
        }
        if (!hashSet2.isEmpty()) {
            object2 = object2.removeVariables(hashSet2);
        }
        object = object.patch(object2);
        return object;
    }

    private STATE defineVariablesAfterCall(IcfgEdge icfgEdge, STATE STATE) {
        String string = icfgEdge.getPrecedingProcedure();
        String string2 = icfgEdge.getSucceedingProcedure();
        Object object = this.removeLocals(STATE, string);
        Set<IProgramVarOrConst> set = this.getMaskedGlobalsVariables(string2);
        if (!set.isEmpty()) {
            object = object.removeVariables(set);
        }
        object = this.applyLocals(object, string2, arg_0 -> object.addVariables(arg_0));
        return object;
    }

    private STATE removeLocals(STATE STATE, String string) {
        return (STATE)this.applyLocals(STATE, string, arg_0 -> STATE.removeVariables(arg_0));
    }

    private STATE applyLocals(STATE STATE, String string, Function<Set<IProgramVarOrConst>, STATE> function) {
        if (string == null) {
            return STATE;
        }
        Set<IProgramVarOrConst> set = this.getLocalVariables(string);
        if (set.isEmpty()) {
            return STATE;
        }
        return (STATE)((IAbstractState)function.apply(set));
    }

    private Set<IProgramVarOrConst> getMaskedGlobalsVariables(String string) {
        assert (string != null);
        Set<IProgramVarOrConst> set = this.getGlobalScopeVarAndConsts();
        Set<IProgramVarOrConst> set2 = this.getLocalVariables(string);
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        for (IProgramVarOrConst iProgramVarOrConst : set2) {
            if (!set.contains(iProgramVarOrConst)) continue;
            hashSet.add(iProgramVarOrConst);
        }
        return hashSet;
    }

    private Set<IProgramVarOrConst> getPreVariables(IcfgEdge icfgEdge) {
        Set<IProgramVarOrConst> set = this.getGlobalScopeVarAndConsts();
        String string = icfgEdge.getPrecedingProcedure();
        if (string != null) {
            set.addAll(this.getLocalVariables(string));
        }
        return set;
    }

    private Set<IProgramVarOrConst> getGlobalScopeVarAndConsts() {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        for (IProgramNonOldVar iProgramNonOldVar : this.mSymbolTable.getGlobals()) {
            hashSet.add((IProgramVarOrConst)iProgramNonOldVar);
            hashSet.add((IProgramVarOrConst)iProgramNonOldVar.getOldVar());
        }
        hashSet.addAll(this.mSymbolTable.getConstants());
        return hashSet;
    }

    private Set<IProgramVarOrConst> getOldVars() {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        for (IProgramNonOldVar iProgramNonOldVar : this.mSymbolTable.getGlobals()) {
            hashSet.add((IProgramVarOrConst)iProgramNonOldVar.getOldVar());
        }
        return hashSet;
    }

    private Set<IProgramVarOrConst> getLocalVariables(String string) {
        assert (string != null);
        Set<IProgramVarOrConst> set = this.mSymbolTable.getLocals(string).stream().map(iLocalProgramVar -> iLocalProgramVar).collect(Collectors.toSet());
        return set;
    }

    public IVariableProvider<STATE, IcfgEdge> createNewVariableProvider(CfgSmtToolkit cfgSmtToolkit) {
        return new RcfgVariableProvider<STATE>(cfgSmtToolkit, this.mLogger);
    }

    public Set<IProgramVarOrConst> getRequiredVars(IcfgEdge icfgEdge) {
        HashSet<IProgramVarOrConst> hashSet = new HashSet<IProgramVarOrConst>();
        if (icfgEdge instanceof IInternalAction) {
            RcfgVariableProvider.addTfVars(icfgEdge.getTransformula(), hashSet);
        } else if (icfgEdge instanceof ICallAction) {
            ICallAction iCallAction = (ICallAction)icfgEdge;
            RcfgVariableProvider.addTfVars(iCallAction.getLocalVarsAssignment(), hashSet);
            RcfgVariableProvider.addTfVars(this.mCfgSmt.getOldVarsAssignmentCache().getOldVarsAssignment(iCallAction.getSucceedingProcedure()), hashSet);
        } else if (icfgEdge instanceof IReturnAction) {
            IReturnAction iReturnAction = (IReturnAction)icfgEdge;
            RcfgVariableProvider.addTfVars(iReturnAction.getAssignmentOfReturn(), hashSet);
        } else {
            throw new UnsupportedOperationException();
        }
        return hashSet;
    }

    private static void addTfVars(UnmodifiableTransFormula unmodifiableTransFormula, Set<IProgramVarOrConst> set) {
        unmodifiableTransFormula.getNonTheoryConsts().forEach(iProgramConst -> {
            boolean bl = set.add((IProgramVarOrConst)iProgramConst);
        });
        unmodifiableTransFormula.getInVars().entrySet().stream().forEach(entry -> {
            boolean bl = set.add((IProgramVarOrConst)entry.getKey());
        });
        unmodifiableTransFormula.getOutVars().entrySet().stream().forEach(entry -> {
            boolean bl = set.add((IProgramVarOrConst)entry.getKey());
        });
    }
}

