/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public enum BoolValue {
    BOT,
    FALSE,
    TRUE,
    TOP;


    public static BoolValue get(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public BoolValue union(BoolValue boolValue) {
        return BoolValue.values()[this.ordinal() | boolValue.ordinal()];
    }

    public BoolValue intersect(BoolValue boolValue) {
        return BoolValue.values()[this.ordinal() & boolValue.ordinal()];
    }

    public boolean isSubsetEqual(BoolValue boolValue) {
        return this == BOT || boolValue == TOP || this == boolValue;
    }

    public BoolValue and(BoolValue boolValue) {
        if (this == BOT || boolValue == BOT) {
            return BOT;
        }
        int n = this.ordinal();
        int n2 = boolValue.ordinal();
        int n3 = n & n2 | (n | n2) & 1;
        return BoolValue.values()[n3];
    }

    public BoolValue or(BoolValue boolValue) {
        if (this == BOT || boolValue == BOT) {
            return BOT;
        }
        int n = this.ordinal();
        int n2 = boolValue.ordinal();
        int n3 = (n | n2) & 2 | n & n2;
        return BoolValue.values()[n3];
    }

    public BoolValue not() {
        switch (this) {
            case BOT: {
                return BOT;
            }
            case FALSE: {
                return TRUE;
            }
            case TRUE: {
                return FALSE;
            }
        }
        return TOP;
    }

    public Term getTerm(Script script, Sort sort, Term term) {
        switch (this) {
            case BOT: {
                return script.term("false", new Term[0]);
            }
            case FALSE: {
                return script.term("not", new Term[]{term});
            }
            case TRUE: {
                return term;
            }
        }
        return script.term("true", new Term[0]);
    }
}

