/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqBottomConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqDisjunctiveConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.VPDomainHelpers;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosureComparator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosureComparator;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EqConstraintFactory<NODE extends IEqNodeIdentifier<NODE>> {
    private final EqConstraint<NODE> mBottomConstraint;
    private final EqConstraint<NODE> mEmptyConstraint;
    private final EqDisjunctiveConstraint<NODE> mEmptyDisjunctiveConstraint;
    private final AbstractNodeAndFunctionFactory<NODE, Term> mEqNodeAndFunctionFactory;
    private final IUltimateServiceProvider mServices;
    private int mConstraintIdCounter;
    private final WeqCcManager<NODE> mWeqCcManager;
    private final ManagedScript mMgdScript;
    private final boolean mIsDebugMode;
    private final ILogger mLogger;
    private final BenchmarkWithCounters mBenchmark;
    private final Set<IProgramConst> mNonTheoryLiterals;

    public EqConstraintFactory(AbstractNodeAndFunctionFactory<NODE, Term> abstractNodeAndFunctionFactory, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, WeqSettings weqSettings, boolean bl, Set<IProgramConst> set) {
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mMgdScript = managedScript;
        this.mNonTheoryLiterals = set;
        Set set2 = set.stream().map(iProgramConst -> abstractNodeAndFunctionFactory.getOrConstructNode(iProgramConst.getTerm())).collect(Collectors.toSet());
        this.mWeqCcManager = new WeqCcManager<NODE>(this.mLogger, new WeqCongruenceClosureComparator(), new CongruenceClosureComparator(), this.mMgdScript, abstractNodeAndFunctionFactory, weqSettings, bl, set2);
        this.mBottomConstraint = new EqBottomConstraint(this);
        this.mBottomConstraint.freezeIfNecessary();
        this.mEmptyConstraint = new EqConstraint<NODE>(1, this.mWeqCcManager.getEmptyWeqCc(true), this);
        this.mEmptyConstraint.freezeIfNecessary();
        this.mEmptyDisjunctiveConstraint = new EqDisjunctiveConstraint<NODE>(Collections.singleton(this.mEmptyConstraint), this);
        this.mConstraintIdCounter = 2;
        this.mServices = iUltimateServiceProvider;
        this.mIsDebugMode = false;
        if (this.mIsDebugMode) {
            this.mBenchmark = new BenchmarkWithCounters();
            this.mBenchmark.registerCountersAndWatches(BmNames.getNames());
        } else {
            this.mBenchmark = null;
        }
        this.mEqNodeAndFunctionFactory = abstractNodeAndFunctionFactory;
    }

    public EqConstraint<NODE> getEmptyConstraint(boolean bl) {
        if (bl) {
            return new EqConstraint<NODE>(this.mConstraintIdCounter++, this.mWeqCcManager.getEmptyWeqCc(true), this);
        }
        return this.mEmptyConstraint;
    }

    public EqConstraint<NODE> getBottomConstraint() {
        return this.mBottomConstraint;
    }

    public EqConstraint<NODE> unfreeze(EqConstraint<NODE> eqConstraint) {
        assert (eqConstraint.isFrozen());
        this.debugStart(BmNames.UNFREEZE);
        if (eqConstraint.isBottom()) {
            this.debugEnd(BmNames.UNFREEZE);
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mWeqCcManager.copyWeqCc(eqConstraint.getWeqCc(), false);
        EqConstraint<NODE> eqConstraint2 = new EqConstraint<NODE>(this.mConstraintIdCounter++, weqCongruenceClosure, this);
        this.debugEnd(BmNames.UNFREEZE);
        return eqConstraint2;
    }

    private void debugStart(BmNames bmNames) {
        if (this.mIsDebugMode) {
            this.mBenchmark.incrementCounter(bmNames.name());
            this.mBenchmark.unpauseWatch(bmNames.name());
        }
    }

    private void debugEnd(BmNames bmNames) {
        if (this.mIsDebugMode) {
            this.mBenchmark.pauseWatch(bmNames.name());
        }
    }

    public EqConstraint<NODE> getEqConstraint(WeqCongruenceClosure<NODE> weqCongruenceClosure, boolean bl) {
        if (weqCongruenceClosure.isInconsistent(this.mWeqCcManager.getSettings().closeAllEqConstraints())) {
            return this.getBottomConstraint();
        }
        assert (bl != weqCongruenceClosure.isFrozen());
        EqConstraint<NODE> eqConstraint = new EqConstraint<NODE>(this.mConstraintIdCounter++, weqCongruenceClosure, this);
        if (!bl) {
            eqConstraint.superficialFreeze();
        }
        return eqConstraint;
    }

    public EqDisjunctiveConstraint<NODE> getDisjunctiveConstraint(Collection<EqConstraint<NODE>> collection) {
        assert (!collection.stream().filter(eqConstraint -> eqConstraint == null).findAny().isPresent());
        if (collection.stream().filter(eqConstraint -> eqConstraint.isTop()).findAny().isPresent()) {
            return this.getEmptyDisjunctiveConstraint(false);
        }
        Collection collection2 = collection.stream().filter(eqConstraint -> !(eqConstraint instanceof EqBottomConstraint)).collect(Collectors.toSet());
        return new EqDisjunctiveConstraint(collection2, this);
    }

    public EqConstraint<NODE> conjoin(EqConstraint<NODE> eqConstraint, EqConstraint<NODE> eqConstraint2, boolean bl) {
        this.debugStart(BmNames.CONJOIN);
        if (eqConstraint.isBottom()) {
            this.debugEnd(BmNames.CONJOIN);
            return eqConstraint;
        }
        if (eqConstraint2.isBottom() && !bl) {
            this.debugEnd(BmNames.CONJOIN);
            return eqConstraint2;
        }
        if (eqConstraint.isTop() && !bl) {
            this.debugEnd(BmNames.CONJOIN);
            return eqConstraint2;
        }
        if (eqConstraint2.isTop()) {
            this.debugEnd(BmNames.CONJOIN);
            return eqConstraint;
        }
        EqConstraint<NODE> eqConstraint3 = eqConstraint;
        if (!bl) {
            if (this.mWeqCcManager.getSettings().closeAllEqConstraints()) {
                eqConstraint3 = this.closeIfNecessary(eqConstraint);
            }
            eqConstraint3.freezeIfNecessary();
        }
        assert (bl != eqConstraint3.isFrozen());
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mWeqCcManager.meet(eqConstraint3.getWeqCc(), eqConstraint2.getWeqCc(), bl);
        assert (bl != weqCongruenceClosure.isFrozen());
        if (bl) {
            this.debugEnd(BmNames.CONJOIN);
            return eqConstraint3;
        }
        EqConstraint<NODE> eqConstraint4 = this.getEqConstraint(weqCongruenceClosure, false);
        this.debugEnd(BmNames.CONJOIN);
        return eqConstraint4;
    }

    public EqConstraint<NODE> closeIfNecessary(EqConstraint<NODE> eqConstraint) {
        if (eqConstraint.isBottom()) {
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure = eqConstraint.getWeqCc();
        if (weqCongruenceClosure.isClosed()) {
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure2 = this.mWeqCcManager.closeIfNecessary(eqConstraint.getWeqCc());
        return this.getEqConstraint(weqCongruenceClosure2, true);
    }

    public EqDisjunctiveConstraint<NODE> conjoinDisjunctiveConstraints(List<EqDisjunctiveConstraint<NODE>> list2) {
        this.debugStart(BmNames.CONJOIN_DISJUNCTIVE);
        List list3 = list2.stream().map(eqDisjunctiveConstraint -> eqDisjunctiveConstraint.getConstraints()).collect(Collectors.toList());
        List list4 = CrossProducts.crossProductOfSets(list3);
        List<EqConstraint<NODE>> list5 = list4.stream().map(list -> (EqConstraint)list.stream().reduce((eqConstraint, eqConstraint2) -> this.conjoin((EqConstraint<NODE>)eqConstraint, (EqConstraint<NODE>)eqConstraint2, false)).get()).collect(Collectors.toList());
        this.debugEnd(BmNames.CONJOIN_DISJUNCTIVE);
        return this.getDisjunctiveConstraint(list5);
    }

    public EqConstraint<NODE> addWeakEquivalence(NODE NODE, NODE NODE2, NODE NODE3, EqConstraint<NODE> eqConstraint, boolean bl) {
        assert (VPDomainHelpers.haveSameType(NODE, NODE2));
        this.debugStart(BmNames.ADD_WEAK_EQUALITY);
        if (bl) {
            assert (!eqConstraint.isFrozen());
            this.mWeqCcManager.reportWeakEquivalence(eqConstraint.getWeqCc(), NODE, NODE2, NODE3, true);
            this.debugEnd(BmNames.ADD_WEAK_EQUALITY);
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mWeqCcManager.reportWeakEquivalence(eqConstraint.getWeqCc(), NODE, NODE2, NODE3, false);
        EqConstraint<NODE> eqConstraint2 = this.getEqConstraint(weqCongruenceClosure, false);
        this.debugEnd(BmNames.ADD_WEAK_EQUALITY);
        return eqConstraint2;
    }

    public EqDisjunctiveConstraint<NODE> disjoinDisjunctiveConstraints(EqDisjunctiveConstraint<NODE> eqDisjunctiveConstraint, EqDisjunctiveConstraint<NODE> eqDisjunctiveConstraint2) {
        this.debugStart(BmNames.DISJOIN_DISJUNCTIVE);
        HashSet<EqConstraint<NODE>> hashSet = new HashSet<EqConstraint<NODE>>(eqDisjunctiveConstraint.getConstraints());
        hashSet.addAll(eqDisjunctiveConstraint2.getConstraints());
        EqDisjunctiveConstraint<NODE> eqDisjunctiveConstraint3 = this.getDisjunctiveConstraint(hashSet);
        this.debugEnd(BmNames.DISJOIN_DISJUNCTIVE);
        return eqDisjunctiveConstraint3;
    }

    public EqDisjunctiveConstraint<NODE> disjoinDisjunctiveConstraints(List<EqDisjunctiveConstraint<NODE>> list) {
        EqDisjunctiveConstraint<NODE> eqDisjunctiveConstraint2;
        this.debugStart(BmNames.DISJOIN_DISJUNCTIVE);
        HashSet<EqConstraint<NODE>> hashSet = new HashSet<EqConstraint<NODE>>();
        for (EqDisjunctiveConstraint<NODE> eqDisjunctiveConstraint2 : list) {
            hashSet.addAll(eqDisjunctiveConstraint2.getConstraints());
        }
        eqDisjunctiveConstraint2 = this.getDisjunctiveConstraint(hashSet);
        this.debugEnd(BmNames.DISJOIN_DISJUNCTIVE);
        return eqDisjunctiveConstraint2;
    }

    public EqConstraint<NODE> disjoin(EqConstraint<NODE> eqConstraint, EqConstraint<NODE> eqConstraint2) {
        this.debugStart(BmNames.DISJOIN);
        ArrayList<EqConstraint<NODE>> arrayList = new ArrayList<EqConstraint<NODE>>();
        arrayList.add(eqConstraint);
        arrayList.add(eqConstraint2);
        EqConstraint<NODE> eqConstraint3 = this.getDisjunctiveConstraint(arrayList).flatten();
        this.debugEnd(BmNames.DISJOIN);
        return eqConstraint3;
    }

    public EqConstraint<NODE> addEquality(NODE NODE, NODE NODE2, EqConstraint<NODE> eqConstraint, boolean bl) {
        this.debugStart(BmNames.ADD_EQUALITY);
        if (eqConstraint.isBottom()) {
            this.debugEnd(BmNames.ADD_EQUALITY);
            return eqConstraint;
        }
        if (eqConstraint.areEqual(NODE, NODE2, false)) {
            this.debugEnd(BmNames.ADD_EQUALITY);
            return eqConstraint;
        }
        if (eqConstraint.areUnequal(NODE, NODE2, false) && !bl) {
            this.debugEnd(BmNames.ADD_EQUALITY);
            return this.getBottomConstraint();
        }
        if (bl) {
            this.mWeqCcManager.reportEquality(eqConstraint.getWeqCc(), NODE, NODE2, true);
            this.debugEnd(BmNames.ADD_EQUALITY);
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mWeqCcManager.reportEquality(eqConstraint.getWeqCc(), NODE, NODE2, false);
        EqConstraint<NODE> eqConstraint2 = this.getEqConstraint(weqCongruenceClosure, false);
        this.debugEnd(BmNames.ADD_EQUALITY);
        return eqConstraint2;
    }

    public EqConstraint<NODE> addDisequality(NODE NODE, NODE NODE2, EqConstraint<NODE> eqConstraint, boolean bl) {
        assert (bl != eqConstraint.isFrozen());
        this.debugStart(BmNames.ADD_DISEQUALITY);
        if (eqConstraint.isBottom()) {
            this.debugEnd(BmNames.ADD_DISEQUALITY);
            return eqConstraint;
        }
        if (eqConstraint.areUnequal(NODE, NODE2, false)) {
            this.debugEnd(BmNames.ADD_DISEQUALITY);
            return eqConstraint;
        }
        if (eqConstraint.areEqual(NODE, NODE2, false) && !bl) {
            this.debugEnd(BmNames.ADD_DISEQUALITY);
            return this.getBottomConstraint();
        }
        if (bl) {
            this.mWeqCcManager.reportDisequality(eqConstraint.getWeqCc(), NODE, NODE2, true);
            this.debugEnd(BmNames.ADD_DISEQUALITY);
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mWeqCcManager.reportDisequality(eqConstraint.getWeqCc(), NODE, NODE2, false);
        EqConstraint<NODE> eqConstraint2 = this.getEqConstraint(weqCongruenceClosure, false);
        this.debugEnd(BmNames.ADD_DISEQUALITY);
        return eqConstraint2;
    }

    public EqDisjunctiveConstraint<NODE> renameVariables(EqDisjunctiveConstraint<NODE> eqDisjunctiveConstraint, Map<Term, Term> map) {
        this.debugStart(BmNames.RENAME_VARIABLES_DISJUNCTIVE);
        ArrayList<EqConstraint<NODE>> arrayList = new ArrayList<EqConstraint<NODE>>();
        for (EqConstraint<NODE> object2 : eqDisjunctiveConstraint.getConstraints()) {
            EqConstraint<NODE> eqConstraint = this.renameVariables(object2, map, false);
            arrayList.add(eqConstraint);
        }
        EqDisjunctiveConstraint<NODE> eqDisjunctiveConstraint2 = this.getDisjunctiveConstraint(arrayList);
        this.debugEnd(BmNames.RENAME_VARIABLES_DISJUNCTIVE);
        return eqDisjunctiveConstraint2;
    }

    private EqConstraint<NODE> renameVariables(EqConstraint<NODE> eqConstraint, Map<Term, Term> map, boolean bl) {
        this.debugStart(BmNames.RENAME_VARIABLES);
        if (bl) {
            this.mWeqCcManager.renameVariables(eqConstraint.getWeqCc(), map, true);
            this.debugEnd(BmNames.RENAME_VARIABLES);
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure = this.mWeqCcManager.renameVariables(eqConstraint.getWeqCc(), map, false);
        EqConstraint<NODE> eqConstraint2 = this.getEqConstraint(weqCongruenceClosure, false);
        this.debugEnd(BmNames.RENAME_VARIABLES);
        return eqConstraint2;
    }

    public EqConstraint<NODE> projectExistentially(Collection<Term> collection, EqConstraint<NODE> eqConstraint, boolean bl) {
        assert (eqConstraint.isFrozen());
        assert (eqConstraint.sanityCheck());
        this.debugStart(BmNames.PROJECTAWAY);
        if (eqConstraint.isBottom()) {
            this.debugEnd(BmNames.PROJECTAWAY);
            return eqConstraint;
        }
        if (this.mIsDebugMode) {
            this.mLogger.debug((Object)("project variables " + String.valueOf(collection) + " from " + eqConstraint.hashCode()));
        }
        if (bl) {
            for (Term term : collection) {
                if (!this.getEqNodeAndFunctionFactory().hasNode(term)) continue;
                if (eqConstraint.isInconsistent()) {
                    this.postProjectHelper(eqConstraint, collection, eqConstraint);
                    return eqConstraint;
                }
                NODE NODE = this.getEqNodeAndFunctionFactory().getExistingNode(term);
                this.mWeqCcManager.projectAway(eqConstraint.getWeqCc(), NODE);
            }
            this.postProjectHelper(eqConstraint, collection, eqConstraint);
            return eqConstraint;
        }
        WeqCongruenceClosure<NODE> weqCongruenceClosure = eqConstraint.getWeqCc();
        for (Term term : collection) {
            if (!this.getEqNodeAndFunctionFactory().hasNode(term)) continue;
            if (weqCongruenceClosure.isInconsistent(false)) {
                this.postProjectHelper(eqConstraint, collection, this.getBottomConstraint());
                return this.getBottomConstraint();
            }
            NODE NODE = this.getEqNodeAndFunctionFactory().getExistingNode(term);
            if ((weqCongruenceClosure = this.mWeqCcManager.projectAway(weqCongruenceClosure, NODE)).isInconsistent(false)) {
                this.postProjectHelper(eqConstraint, collection, this.getBottomConstraint());
                return this.getBottomConstraint();
            }
            assert (weqCongruenceClosure.sanityCheck());
        }
        EqConstraint<NODE> eqConstraint2 = this.getEqConstraint(weqCongruenceClosure, false);
        this.postProjectHelper(eqConstraint, collection, eqConstraint2);
        return eqConstraint2;
    }

    private void postProjectHelper(EqConstraint<NODE> eqConstraint, Collection<Term> collection, EqConstraint<NODE> eqConstraint2) {
        assert (VPDomainHelpers.constraintFreeOfVars(collection, eqConstraint2, this.getMgdScript().getScript())) : "resulting constraint still has at least one of the to-be-projected vars";
        if (this.mIsDebugMode) {
            this.mLogger.debug((Object)("projected variables " + String.valueOf(collection) + " from " + eqConstraint.hashCode() + " result: " + String.valueOf(eqConstraint2)));
        }
        this.debugEnd(BmNames.PROJECTAWAY);
    }

    public AbstractNodeAndFunctionFactory<NODE, Term> getEqNodeAndFunctionFactory() {
        return this.mEqNodeAndFunctionFactory;
    }

    public ManagedScript getMgdScript() {
        return this.mMgdScript;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public WeqCcManager<NODE> getWeqCcManager() {
        return this.mWeqCcManager;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public boolean isDebugMode() {
        return this.mIsDebugMode;
    }

    public Set<IProgramConst> getNonTheoryLiterals() {
        return this.mNonTheoryLiterals;
    }

    public EqDisjunctiveConstraint<NODE> getEmptyDisjunctiveConstraint(boolean bl) {
        if (bl) {
            return this.getDisjunctiveConstraint(Collections.singleton(this.getEmptyConstraint(true)));
        }
        return this.mEmptyDisjunctiveConstraint;
    }

    public BenchmarkWithCounters getBenchmark() {
        return this.mBenchmark;
    }

    public WeqSettings getWeqSettings() {
        return this.mWeqCcManager.getSettings();
    }

    public EqDisjunctiveConstraint<NODE> closeIfNecessary(EqDisjunctiveConstraint<NODE> eqDisjunctiveConstraint) {
        ArrayList<EqConstraint<NODE>> arrayList = new ArrayList<EqConstraint<NODE>>();
        for (EqConstraint<NODE> eqConstraint : eqDisjunctiveConstraint.getConstraints()) {
            arrayList.add(this.closeIfNecessary(eqConstraint));
        }
        return this.getDisjunctiveConstraint(arrayList);
    }

    private static enum BmNames {
        PROJECTAWAY,
        UNFREEZE,
        ADD_EQUALITY,
        ADD_DISEQUALITY,
        ADD_WEAK_EQUALITY,
        CONJOIN,
        CONJOIN_DISJUNCTIVE,
        DISJOIN,
        DISJOIN_DISJUNCTIVE,
        RENAME_VARIABLES,
        RENAME_VARIABLES_DISJUNCTIVE;


        static String[] getNames() {
            String[] stringArray = new String[BmNames.values().length];
            int n = 0;
            while (n < BmNames.values().length) {
                stringArray[n] = BmNames.values()[n].name();
                ++n;
            }
            return stringArray;
        }
    }
}

