/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.ITerm2ExpressionSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.LocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramFunction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.DeclarableFunctionSymbol;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class Boogie2SmtSymbolTable
implements IIcfgSymbolTable,
IBoogieSymbolTableVariableProvider,
ITerm2ExpressionSymbolTable {
    public static final String ID_BUILTIN = "builtin";
    public static final String ID_SMTDEFINED = "smtdefined";
    private static final String ID_INDICES = "indices";
    private static final String ID_CONST_ARRAY = "const_array";
    private static final String ID_STRUCTPOS = "structpos";
    private final BoogieDeclarations mBoogieDeclarations;
    private final ManagedScript mScript;
    private final TypeSortTranslator mTypeSortTranslator;
    private final Map<String, ProgramNonOldVar> mGlobals = new HashMap<String, ProgramNonOldVar>();
    private final Map<String, ProgramOldVar> mOldGlobals = new HashMap<String, ProgramOldVar>();
    private final Map<String, Map<String, IProgramVar>> mSpecificationInParam = new HashMap<String, Map<String, IProgramVar>>();
    private final Map<String, Map<String, IProgramVar>> mSpecificationOutParam = new HashMap<String, Map<String, IProgramVar>>();
    private final Map<String, Map<String, IProgramVar>> mImplementationInParam = new HashMap<String, Map<String, IProgramVar>>();
    private final Map<String, Map<String, IProgramVar>> mImplementationOutParam = new HashMap<String, Map<String, IProgramVar>>();
    private final Map<String, List<ILocalProgramVar>> mProc2InParams = new HashMap<String, List<ILocalProgramVar>>();
    private final Map<String, List<ILocalProgramVar>> mProc2OutParams = new HashMap<String, List<ILocalProgramVar>>();
    private final Map<String, Map<String, LocalProgramVar>> mImplementationLocals = new HashMap<String, Map<String, LocalProgramVar>>();
    private final Map<String, ProgramConst> mConstants = new HashMap<String, ProgramConst>();
    private final Map<TermVariable, IProgramVar> mSmtVar2ProgramVar = new HashMap<TermVariable, IProgramVar>();
    private final Map<IProgramVar, DeclarationInformation> mProgramVar2DeclarationInformation = new HashMap<IProgramVar, DeclarationInformation>();
    private final Map<IProgramVar, BoogieASTNode> mProgramVar2AstNode = new HashMap<IProgramVar, BoogieASTNode>();
    private final Map<ApplicationTerm, ProgramConst> mSmtConst2ProgramConst = new HashMap<ApplicationTerm, ProgramConst>();
    private final Map<String, String> mBoogieFunction2SmtFunction = new HashMap<String, String>();
    private final NestedMap2<String, IBoogieType, String> mSmtFunction2BoogieFunction = new NestedMap2();
    private final Map<String, Map<String, Expression[]>> mBoogieFunction2Attributes = new HashMap<String, Map<String, Expression[]>>();
    private final DefaultIcfgSymbolTable mIcfgSymbolTable = new DefaultIcfgSymbolTable();

    public Boogie2SmtSymbolTable(BoogieDeclarations boogieDeclarations, ManagedScript managedScript, TypeSortTranslator typeSortTranslator) {
        this.mScript = managedScript;
        this.mTypeSortTranslator = typeSortTranslator;
        this.mBoogieDeclarations = boogieDeclarations;
        this.mScript.lock((Object)this);
        this.mScript.echo((Object)this, new QuotedObject("Start declaration of constants"));
        for (ConstDeclaration object : this.mBoogieDeclarations.getConstDeclarations()) {
            this.declareConstants(object);
        }
        this.mScript.echo((Object)this, new QuotedObject("Finished declaration of constants"));
        this.mScript.echo((Object)this, new QuotedObject("Start declaration of functions"));
        for (FunctionDeclaration functionDeclaration : this.mBoogieDeclarations.getFunctionDeclarations()) {
            this.declareFunction(functionDeclaration);
        }
        this.mScript.echo((Object)this, new QuotedObject("Finished declaration of functions"));
        this.mScript.echo((Object)this, new QuotedObject("Start declaration of global variables"));
        for (VariableDeclaration variableDeclaration : this.mBoogieDeclarations.getGlobalVarDeclarations()) {
            this.declareGlobalVariables(variableDeclaration);
        }
        this.mScript.echo((Object)this, new QuotedObject("Finished declaration global variables"));
        this.mScript.echo((Object)this, new QuotedObject("Start declaration of local variables"));
        for (String string : this.mBoogieDeclarations.getProcSpecification().keySet()) {
            Procedure procedure = this.mBoogieDeclarations.getProcSpecification().get(string);
            Procedure procedure2 = this.mBoogieDeclarations.getProcImplementation().get(string);
            if (procedure2 == null) {
                this.declareSpec(procedure);
                continue;
            }
            this.declareSpecImpl(procedure, procedure2);
        }
        this.mScript.echo((Object)this, new QuotedObject("Finished declaration local variables"));
        this.mScript.unlock((Object)this);
    }

    private static <T extends IProgramVar> void putNew(String string, String string2, T t, Map<String, Map<String, T>> map) {
        Map<String, T> map2 = map.get(string);
        if (map2 == null) {
            map2 = new HashMap<String, T>();
            map.put(string, map2);
        }
        IProgramVar iProgramVar = (IProgramVar)map2.put(string2, t);
        assert (iProgramVar == null) : "variable already contained";
    }

    private static <VALUE> void putNew(String string, VALUE VALUE, Map<String, VALUE> map) {
        VALUE VALUE2 = map.put(string, VALUE);
        assert (VALUE2 == null) : "variable already contained";
    }

    private static <T extends IProgramVar> T get(String string, String string2, Map<String, Map<String, T>> map) {
        Map<String, T> map2 = map.get(string2);
        if (map2 == null) {
            return null;
        }
        return (T)((IProgramVar)map2.get(string));
    }

    public static boolean isSpecification(Procedure procedure) {
        return procedure.getSpecification() != null;
    }

    public static boolean isImplementation(Procedure procedure) {
        return procedure.getBody() != null;
    }

    @Override
    public IProgramVar getBoogieVar(String string, DeclarationInformation declarationInformation, boolean bl) {
        DeclarationInformation.StorageClass storageClass = declarationInformation.getStorageClass();
        String string2 = declarationInformation.getProcedure();
        return switch (storageClass) {
            case DeclarationInformation.StorageClass.GLOBAL -> {
                if (bl) {
                    yield this.mOldGlobals.get(string);
                }
                yield this.mGlobals.get(string);
            }
            case DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM -> Boogie2SmtSymbolTable.get(string, string2, this.mImplementationInParam);
            case DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM -> Boogie2SmtSymbolTable.get(string, string2, this.mImplementationOutParam);
            case DeclarationInformation.StorageClass.LOCAL -> Boogie2SmtSymbolTable.get(string, string2, this.mImplementationLocals);
            case DeclarationInformation.StorageClass.QUANTIFIED, DeclarationInformation.StorageClass.IMPLEMENTATION, DeclarationInformation.StorageClass.PROC_FUNC -> throw new AssertionError((Object)("inappropriate decl info " + String.valueOf(declarationInformation)));
            default -> throw new MatchException(null, null);
        };
    }

    @Override
    public IProgramVar getBoogieVar(String string, String string2, boolean bl) {
        if (bl) {
            return Boogie2SmtSymbolTable.get(string, string2, this.mImplementationInParam);
        }
        return Boogie2SmtSymbolTable.get(string, string2, this.mImplementationOutParam);
    }

    @Override
    public IProgramVar getProgramVar(TermVariable termVariable) {
        return this.mIcfgSymbolTable.getProgramVar(termVariable);
    }

    @Override
    public DeclarationInformation getDeclarationInformation(IProgramVar iProgramVar) {
        return this.mProgramVar2DeclarationInformation.get(iProgramVar);
    }

    public BoogieASTNode getAstNode(IProgramVar iProgramVar) {
        return this.mProgramVar2AstNode.get(iProgramVar);
    }

    private void declareConstants(ConstDeclaration constDeclaration) {
        Object object;
        VarList varList = constDeclaration.getVarList();
        Map<String, Expression[]> map = Boogie2SmtSymbolTable.extractAttributes((Declaration)constDeclaration);
        if (map != null && (object = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(map, ID_BUILTIN)) != null) {
            if (varList.getIdentifiers().length > 1) {
                throw new IllegalArgumentException("if builtin identifier is used we support only one constant per const declaration");
            }
            String string = varList.getIdentifiers()[0];
            String[] stringArray = Boogie2SmtSymbolTable.checkForIndices(map);
            ApplicationTerm applicationTerm = (ApplicationTerm)this.mScript.term((Object)this, (String)object, stringArray, null, new Term[0]);
            ProgramConst programConst = new ProgramConst(string, applicationTerm, true);
            ProgramConst programConst2 = this.mConstants.put(string, programConst);
            assert (programConst2 == null) : "constant already contained";
            this.mSmtConst2ProgramConst.put(applicationTerm, programConst);
            this.mIcfgSymbolTable.add(programConst);
            return;
        }
        object = new Sort[]{};
        IBoogieType iBoogieType = varList.getType().getBoogieType();
        Sort sort = this.mTypeSortTranslator.getSort(iBoogieType, (BoogieASTNode)varList);
        String[] stringArray = varList.getIdentifiers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            this.mScript.declareFun((Object)this, string, object, sort);
            ApplicationTerm applicationTerm = (ApplicationTerm)this.mScript.term((Object)this, string, new Term[0]);
            ProgramConst programConst = new ProgramConst(string, applicationTerm, false);
            ProgramConst programConst3 = this.mConstants.put(string, programConst);
            assert (programConst3 == null) : "constant already contained";
            this.mSmtConst2ProgramConst.put(applicationTerm, programConst);
            this.mIcfgSymbolTable.add(programConst);
            ++n2;
        }
    }

    @Override
    public ProgramConst getBoogieConst(String string) {
        return this.mConstants.get(string);
    }

    @Override
    public ProgramFunction getProgramFun(FunctionSymbol functionSymbol) {
        return (ProgramFunction)this.mIcfgSymbolTable.getProgramFun(functionSymbol);
    }

    public Map<String, Expression[]> getAttributes(String string) {
        Map<String, Expression[]> map = this.mBoogieFunction2Attributes.get(string);
        if (map == null) {
            throw new AssertionError((Object)("Undeclared function: " + string));
        }
        return Collections.unmodifiableMap(map);
    }

    private void declareFunction(FunctionDeclaration functionDeclaration) {
        String string;
        Sort sort;
        int n;
        VarList varList;
        Map<String, Expression[]> map = Boogie2SmtSymbolTable.extractAttributes((Declaration)functionDeclaration);
        String string2 = functionDeclaration.getIdentifier();
        this.mBoogieFunction2Attributes.put(string2, map);
        boolean bl = Boogie2SmtSymbolTable.checkForAttributeWithoutValue(map, ID_CONST_ARRAY);
        String string3 = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(map, ID_BUILTIN);
        String string4 = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(map, ID_SMTDEFINED);
        int n2 = 0;
        VarList varList2 = functionDeclaration.getInParams();
        int n3 = ((VarList[])varList2).length;
        int n4 = 0;
        while (n4 < n3) {
            varList = varList2[n4];
            n = varList.getIdentifiers().length;
            n2 += n == 0 ? 1 : n;
            ++n4;
        }
        varList = new Sort[n2];
        String[] stringArray = new String[n2];
        n3 = 0;
        FunctionSymbol functionSymbol = functionDeclaration.getInParams();
        int n5 = ((VarList[])functionSymbol).length;
        n = 0;
        while (n < n5) {
            varList2 = functionSymbol[n];
            int n6 = varList2.getIdentifiers().length;
            if (n6 == 0) {
                n6 = 1;
            }
            IBoogieType iBoogieType = varList2.getType().getBoogieType();
            sort = this.mTypeSortTranslator.getSort(iBoogieType, (BoogieASTNode)functionDeclaration);
            int n7 = 0;
            while (n7 < n6) {
                varList[n3] = sort;
                stringArray[n3] = n7 < varList2.getIdentifiers().length ? varList2.getIdentifiers()[n7] : null;
                ++n3;
                ++n7;
            }
            ++n;
        }
        varList2 = functionDeclaration.getOutParam().getType().getBoogieType();
        Sort sort2 = this.mTypeSortTranslator.getSort((IBoogieType)varList2, (BoogieASTNode)functionDeclaration);
        if (bl) {
            Sort sort3;
            int n8;
            string = Boogie2SMT.quoteId(string2);
            String string5 = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(map, ID_STRUCTPOS);
            int n9 = n8 = string5 == null ? 0 : Integer.parseInt(string5);
            if (string5 == null && stringArray.length > 1) {
                throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("Internal problem with expanding const-array function: " + string2);
            }
            if (!(varList2 instanceof BoogieArrayType) || ((BoogieArrayType)varList2).getValueType() != functionDeclaration.getInParams()[n8].getType().getBoogieType()) {
                throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("Type mismatch in const-array function: " + string2);
            }
            TermVariable[] termVariableArray = new TermVariable[stringArray.length];
            int n10 = 0;
            while (n10 < termVariableArray.length) {
                termVariableArray[n10] = this.mScript.getScript().variable(stringArray[n10], (Sort)varList[n10]);
                ++n10;
            }
            ArrayDeque<Sort> arrayDeque = new ArrayDeque<Sort>();
            sort = sort2;
            while (sort != varList[n8]) {
                arrayDeque.addLast(sort);
                assert (sort.getName().equals("Array"));
                sort = sort.getArguments()[1];
            }
            assert (arrayDeque.size() >= 1);
            TermVariable termVariable = termVariableArray[n8];
            while (!arrayDeque.isEmpty()) {
                sort3 = (Sort)arrayDeque.removeLast();
                termVariable = this.mScript.getScript().term("const", null, sort3, new Term[]{termVariable});
            }
            sort3 = DeclarableFunctionSymbol.createFromScriptDefineFun((String)string, (TermVariable[])termVariableArray, (Sort)sort2, (Term)termVariable);
            sort3.defineOrDeclare(this.mScript.getScript());
        } else if (string3 == null) {
            string = Boogie2SMT.quoteId(string2);
            DeclarableFunctionSymbol declarableFunctionSymbol = DeclarableFunctionSymbol.createFromString((Script)this.mScript.getScript(), (String)string, (String)string4, (String[])stringArray, (Sort[])varList, (Sort)sort2);
            declarableFunctionSymbol.defineOrDeclare(this.mScript.getScript());
            functionSymbol = this.mScript.getScript().getFunctionSymbol(string);
            ProgramFunction programFunction = new ProgramFunction(functionSymbol);
            this.mIcfgSymbolTable.addFun(programFunction);
        } else {
            string = string3;
            if (string4 != null) {
                throw new ISmtDeclarable.IllegalSmtDeclarableUsageException(string2 + " has smtdefined and builtin attributes");
            }
        }
        this.mBoogieFunction2SmtFunction.put(string2, string);
        this.mSmtFunction2BoogieFunction.put((Object)string, (Object)varList2, (Object)string2);
    }

    public static boolean checkForAttributeWithoutValue(Map<String, Expression[]> map, String string) {
        Expression[] expressionArray = map.get(string);
        if (expressionArray == null) {
            return false;
        }
        if (expressionArray.length == 0) {
            return true;
        }
        throw new IllegalArgumentException("Attribute has an argument: " + string);
    }

    public static String checkForAttributeDefinedIdentifier(Map<String, Expression[]> map, String string) {
        Expression[] expressionArray = map.get(string);
        if (expressionArray == null) {
            return null;
        }
        if (expressionArray.length == 1 && expressionArray[0] instanceof StringLiteral) {
            StringLiteral stringLiteral = (StringLiteral)expressionArray[0];
            return stringLiteral.getValue();
        }
        throw new IllegalArgumentException("Attribute has more than one argument or argument is not String: " + string);
    }

    public static String[] checkForIndices(Map<String, Expression[]> map) {
        Expression[] expressionArray = map.get(ID_INDICES);
        if (expressionArray == null) {
            return null;
        }
        String[] stringArray = new String[expressionArray.length];
        int n = 0;
        while (n < expressionArray.length) {
            if (!(expressionArray[n] instanceof IntegerLiteral)) {
                throw new IllegalArgumentException("no single value attribute");
            }
            stringArray[n] = ((IntegerLiteral)expressionArray[n]).getValue();
            ++n;
        }
        return stringArray;
    }

    public static Map<String, Expression[]> extractAttributes(Declaration declaration) {
        HashMap<String, Expression[]> hashMap = new HashMap<String, Expression[]>();
        Attribute[] attributeArray = declaration.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            if (attribute instanceof NamedAttribute) {
                NamedAttribute namedAttribute = (NamedAttribute)attribute;
                hashMap.put(namedAttribute.getName(), ((NamedAttribute)attribute).getValues());
            }
            ++n2;
        }
        return hashMap;
    }

    @Override
    public String translateToBoogieFunction(String string, IBoogieType iBoogieType) {
        return (String)this.mSmtFunction2BoogieFunction.get((Object)string, (Object)iBoogieType);
    }

    public Map<String, String> getBoogieFunction2SmtFunction() {
        return Collections.unmodifiableMap(this.mBoogieFunction2SmtFunction);
    }

    private void declareGlobalVariables(VariableDeclaration variableDeclaration) {
        VarList[] varListArray = variableDeclaration.getVariables();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray[n2];
            String[] stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray[n4];
                IBoogieType iBoogieType = varList.getType().getBoogieType();
                ProgramNonOldVar programNonOldVar = this.constructGlobalBoogieVar(string, iBoogieType, varList);
                Boogie2SmtSymbolTable.putNew(string, programNonOldVar, this.mGlobals);
                ProgramOldVar programOldVar = programNonOldVar.getOldVar();
                Boogie2SmtSymbolTable.putNew(string, programOldVar, this.mOldGlobals);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public Set<IProgramNonOldVar> getGlobals() {
        return this.mIcfgSymbolTable.getGlobals();
    }

    public Map<String, IProgramNonOldVar> getGlobalsMap() {
        return Collections.unmodifiableMap(this.mGlobals);
    }

    public Map<String, IProgramVar> getOldVars() {
        return Collections.unmodifiableMap(this.mOldGlobals);
    }

    @Override
    public Set<ILocalProgramVar> getLocals(String string) {
        return this.mIcfgSymbolTable.getLocals(string);
    }

    @Override
    public Set<IProgramConst> getConstants() {
        return this.mIcfgSymbolTable.getConstants();
    }

    public Map<String, ProgramConst> getConstsMap() {
        return Collections.unmodifiableMap(this.mConstants);
    }

    private void declareSpecImpl(Procedure procedure, Procedure procedure2) {
        DeclarationInformation declarationInformation;
        DeclarationInformation declarationInformation2;
        String string = procedure.getIdentifier();
        assert (string.equals(procedure2.getIdentifier()));
        if (procedure == procedure2) {
            declarationInformation2 = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string);
            declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, string);
        } else {
            assert (Boogie2SmtSymbolTable.isSpecAndImpl(procedure, procedure2));
            declarationInformation2 = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string);
            declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, string);
        }
        this.declareParams(string, procedure.getInParams(), procedure2.getInParams(), this.mSpecificationInParam, this.mImplementationInParam, declarationInformation2, this.mProc2InParams);
        this.declareParams(string, procedure.getOutParams(), procedure2.getOutParams(), this.mSpecificationOutParam, this.mImplementationOutParam, declarationInformation, this.mProc2OutParams);
        this.declareLocals(procedure2);
    }

    private static boolean isSpecAndImpl(Procedure procedure, Procedure procedure2) {
        return Boogie2SmtSymbolTable.isSpecification(procedure) && !Boogie2SmtSymbolTable.isImplementation(procedure) && Boogie2SmtSymbolTable.isImplementation(procedure2) && !Boogie2SmtSymbolTable.isSpecification(procedure2);
    }

    private void declareSpec(Procedure procedure) {
        assert (Boogie2SmtSymbolTable.isSpecification(procedure)) : "no specification";
        assert (!Boogie2SmtSymbolTable.isImplementation(procedure)) : "is implementation";
        String string = procedure.getIdentifier();
        this.declareParams(string, procedure.getInParams(), this.mSpecificationInParam, new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, string), this.mProc2InParams);
        this.declareParams(string, procedure.getOutParams(), this.mSpecificationOutParam, new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, string), this.mProc2OutParams);
    }

    private void declareParams(String string, VarList[] varListArray, VarList[] varListArray2, Map<String, Map<String, IProgramVar>> map, Map<String, Map<String, IProgramVar>> map2, DeclarationInformation declarationInformation, Map<String, List<ILocalProgramVar>> map3) {
        if (varListArray.length != varListArray2.length) {
            throw new IllegalArgumentException("specification and implementation have different param length");
        }
        ArrayList<LocalProgramVar> arrayList = new ArrayList<LocalProgramVar>();
        List list = map3.put(string, Collections.unmodifiableList(arrayList));
        if (list != null) {
            throw new AssertionError((Object)("params for procedure " + string + " already added"));
        }
        int n = 0;
        while (n < varListArray.length) {
            String[] stringArray;
            IBoogieType iBoogieType;
            IBoogieType iBoogieType2 = varListArray[n].getType().getBoogieType();
            if (!iBoogieType2.equals(iBoogieType = varListArray2[n].getType().getBoogieType())) {
                throw new IllegalArgumentException("specification and implementation have different types");
            }
            String[] stringArray2 = varListArray[n].getIdentifiers();
            if (stringArray2.length != (stringArray = varListArray2[n].getIdentifiers()).length) {
                throw new IllegalArgumentException("specification and implementation have different param length");
            }
            int n2 = 0;
            while (n2 < stringArray2.length) {
                LocalProgramVar localProgramVar = this.constructLocalProgramVar(stringArray[n2], string, iBoogieType, varListArray2[n], declarationInformation);
                Boogie2SmtSymbolTable.putNew(string, stringArray[n2], localProgramVar, map2);
                Boogie2SmtSymbolTable.putNew(string, stringArray2[n2], localProgramVar, map);
                arrayList.add(localProgramVar);
                ++n2;
            }
            ++n;
        }
    }

    private void declareParams(String string, VarList[] varListArray, Map<String, Map<String, IProgramVar>> map, DeclarationInformation declarationInformation, Map<String, List<ILocalProgramVar>> map2) {
        ArrayList<LocalProgramVar> arrayList = new ArrayList<LocalProgramVar>();
        List list = map2.put(string, Collections.unmodifiableList(arrayList));
        if (list != null) {
            throw new AssertionError((Object)("params for procedure " + string + " already added"));
        }
        VarList[] varListArray2 = varListArray;
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] stringArray;
            VarList varList = varListArray2[n2];
            IBoogieType iBoogieType = varList.getType().getBoogieType();
            String[] stringArray2 = stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string2 = stringArray2[n4];
                LocalProgramVar localProgramVar = this.constructLocalProgramVar(string2, string, iBoogieType, varList, declarationInformation);
                Boogie2SmtSymbolTable.putNew(string, string2, localProgramVar, map);
                arrayList.add(localProgramVar);
                ++n4;
            }
            ++n2;
        }
    }

    public void declareLocals(Procedure procedure) {
        if (procedure.getBody() != null) {
            DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, procedure.getIdentifier());
            VariableDeclaration[] variableDeclarationArray = procedure.getBody().getLocalVars();
            int n = variableDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableDeclaration variableDeclaration = variableDeclarationArray[n2];
                VarList[] varListArray = variableDeclaration.getVariables();
                int n3 = varListArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    VarList varList = varListArray[n4];
                    String[] stringArray = varList.getIdentifiers();
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String string = stringArray[n6];
                        IBoogieType iBoogieType = varList.getType().getBoogieType();
                        LocalProgramVar localProgramVar = this.constructLocalProgramVar(string, procedure.getIdentifier(), iBoogieType, varList, declarationInformation);
                        Boogie2SmtSymbolTable.putNew(procedure.getIdentifier(), string, localProgramVar, this.mImplementationLocals);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public LocalProgramVar constructLocalProgramVar(String string, String string2, IBoogieType iBoogieType, VarList varList, DeclarationInformation declarationInformation) {
        Sort sort = this.mTypeSortTranslator.getSort(iBoogieType, (BoogieASTNode)varList);
        String string3 = ProgramVarUtils.buildBoogieVarName(string, string2, false, false);
        TermVariable termVariable = this.mScript.variable(string3, sort);
        ApplicationTerm applicationTerm = ProgramVarUtils.constructDefaultConstant(this.mScript, this, sort, string3);
        ApplicationTerm applicationTerm2 = ProgramVarUtils.constructPrimedConstant(this.mScript, this, sort, string3);
        LocalProgramVar localProgramVar = new LocalProgramVar(string, string2, termVariable, applicationTerm, applicationTerm2);
        this.mSmtVar2ProgramVar.put(termVariable, localProgramVar);
        this.mProgramVar2DeclarationInformation.put(localProgramVar, declarationInformation);
        this.mProgramVar2AstNode.put(localProgramVar, (BoogieASTNode)varList);
        this.mIcfgSymbolTable.add(localProgramVar);
        return localProgramVar;
    }

    private ProgramNonOldVar constructGlobalBoogieVar(String string, IBoogieType iBoogieType, VarList varList) {
        Sort sort = this.mTypeSortTranslator.getSort(iBoogieType, (BoogieASTNode)varList);
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null);
        ProgramNonOldVar programNonOldVar = ProgramVarUtils.constructGlobalProgramVarPair(string, sort, this.mScript, this);
        this.mSmtVar2ProgramVar.put(programNonOldVar.getTermVariable(), programNonOldVar);
        this.mProgramVar2DeclarationInformation.put(programNonOldVar, declarationInformation);
        this.mProgramVar2AstNode.put(programNonOldVar, (BoogieASTNode)varList);
        ProgramOldVar programOldVar = programNonOldVar.getOldVar();
        this.mSmtVar2ProgramVar.put(programOldVar.getTermVariable(), programOldVar);
        this.mProgramVar2DeclarationInformation.put(programOldVar, declarationInformation);
        this.mProgramVar2AstNode.put(programOldVar, (BoogieASTNode)varList);
        this.mIcfgSymbolTable.add(programNonOldVar);
        return programNonOldVar;
    }

    public HashRelation<String, IProgramNonOldVar> constructProc2ModifiableGlobalsMapping() {
        HashRelation hashRelation = new HashRelation();
        for (Map.Entry<String, Set<String>> object2 : this.mBoogieDeclarations.getModifiedVars().entrySet()) {
            for (String string : object2.getValue()) {
                IProgramNonOldVar iProgramNonOldVar = this.getGlobalsMap().get(string);
                hashRelation.addPair((Object)object2.getKey(), (Object)iProgramNonOldVar);
            }
        }
        HashSet<String> hashSet = new HashSet<String>(this.mSpecificationInParam.keySet());
        hashSet.addAll(this.mImplementationInParam.keySet());
        return hashRelation;
    }

    @Override
    public ILocation getLocation(IProgramVar iProgramVar) {
        BoogieASTNode boogieASTNode = this.getAstNode(iProgramVar);
        assert (boogieASTNode != null) : "There is no AstNode for the IProgramVar " + String.valueOf(iProgramVar);
        ILocation iLocation = boogieASTNode.getLocation();
        return iLocation;
    }

    public Map<String, List<ILocalProgramVar>> getProc2InParams() {
        return Collections.unmodifiableMap(this.mProc2InParams);
    }

    public Map<String, List<ILocalProgramVar>> getProc2OutParams() {
        return Collections.unmodifiableMap(this.mProc2OutParams);
    }

    @Override
    public Set<ApplicationTerm> computeAllDefaultConstants() {
        LinkedHashSet<ApplicationTerm> linkedHashSet = new LinkedHashSet<ApplicationTerm>();
        Function<IProgramVar, ApplicationTerm> function = IProgramVar::getDefaultConstant;
        Boogie2SmtSymbolTable.getAll(this.mSpecificationInParam, function).forEachOrdered(linkedHashSet::add);
        Boogie2SmtSymbolTable.getAll(this.mSpecificationOutParam, function).forEachOrdered(linkedHashSet::add);
        Boogie2SmtSymbolTable.getAll(this.mImplementationInParam, function).forEachOrdered(linkedHashSet::add);
        Boogie2SmtSymbolTable.getAll(this.mImplementationOutParam, function).forEachOrdered(linkedHashSet::add);
        this.mImplementationLocals.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).map(entry -> (ApplicationTerm)function.apply((IProgramVar)entry.getValue())).forEachOrdered(linkedHashSet::add);
        this.mProc2InParams.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(function::apply).forEachOrdered(linkedHashSet::add);
        this.mProc2OutParams.entrySet().stream().flatMap(entry -> ((List)entry.getValue()).stream()).map(function::apply).forEachOrdered(linkedHashSet::add);
        this.mGlobals.entrySet().stream().map(entry -> (ApplicationTerm)function.apply((IProgramVar)entry.getValue())).forEachOrdered(linkedHashSet::add);
        this.mOldGlobals.entrySet().stream().map(entry -> (ApplicationTerm)function.apply((IProgramVar)entry.getValue())).forEachOrdered(linkedHashSet::add);
        return linkedHashSet;
    }

    private static <V, T, K1, K2> Stream<T> getAll(Map<K1, Map<K2, V>> map, Function<V, T> function) {
        return map.entrySet().stream().flatMap(entry -> ((Map)entry.getValue()).entrySet().stream()).map(entry -> function.apply(entry.getValue()));
    }
}

