/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.OldVarsAssignmentCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class DebuggingHoareTripleChecker
implements IHoareTripleChecker {
    private static final String PREFIX = DebuggingHoareTripleChecker.class.getSimpleName() + "_";
    private static final String ANNOT_NAMED = ":named";
    private static final String ID_PRECONDITION = PREFIX + "precond";
    private static final String ID_PRECONDITION_NON_MOD_GLOBAL_EQUALITY = PREFIX + "precondNonModGlobalEquality";
    private static final String ID_TRANSITION_MODIFIABLE_GLOBAL_EQUALITY = PREFIX + "modifiableVarEquality";
    private static final String ID_LOCAL_VARS_ASSIGNMENT = PREFIX + "localVarsAssignment";
    private static final String ID_HIERACHICAL_PRECONDITION = PREFIX + "hierarchicalPrecondition";
    private static final String ID_NEGATED_POSTCONDITION = PREFIX + "notPostcond";
    private static final String MSG_START_EDGE_CHECK = PREFIX + "Start";
    private static final String MSG_END_EDGE_CHECK = PREFIX + "End";
    private static final boolean SIMPLIFY_IF_ASSERTION_FAILS = true;
    private final ManagedScript mManagedScript;
    private final ModifiableGlobalsTable mModifiableGlobalVariableManager;
    private final OldVarsAssignmentCache mOldVarsAssignmentCache;
    private ScopedHashMap<IProgramVar, Term> mHierConstants;
    private final Deque<Assertion> mAssertions;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private IncrementalPlicationChecker.Validity mExpected;
    private boolean mIsLastOk;
    private final boolean mGenerateUnsatCore;

    public DebuggingHoareTripleChecker(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, CfgSmtToolkit cfgSmtToolkit, IncrementalPlicationChecker.Validity validity) {
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mManagedScript = cfgSmtToolkit.getManagedScript();
        this.mModifiableGlobalVariableManager = cfgSmtToolkit.getModifiableGlobalsTable();
        this.mOldVarsAssignmentCache = cfgSmtToolkit.getOldVarsAssignmentCache();
        this.mAssertions = new ArrayDeque<Assertion>();
        this.mExpected = validity;
        Object object = this.mManagedScript.getScript().getOption(":produce-unsat-cores");
        this.mGenerateUnsatCore = Boolean.parseBoolean(object.toString());
    }

    @Override
    public HoareTripleCheckerStatisticsGenerator getStatistics() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support getEdgeCheckerBenchmark()");
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        return this.checkValidity(this.mExpected, iInternalAction, iPredicate, iPredicate2, null, () -> this.assertAction(iInternalAction), () -> this.assertPrecondition(iPredicate), () -> this.assertPostcondInternal(iPredicate2));
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        return this.checkValidity(this.mExpected, iCallAction, iPredicate, iPredicate2, null, () -> this.assertAction(iCallAction), () -> this.assertPrecondition(iPredicate), () -> this.assertPostcondCall(iPredicate2));
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        return this.checkValidity(this.mExpected, iReturnAction, iPredicate, iPredicate3, iPredicate2, () -> this.assertAction(iReturnAction), () -> this.assertPrecondition(iPredicate), () -> this.assertHierPred(iPredicate2), () -> this.assertPostcondReturn(iPredicate3));
    }

    public boolean isLastOk() {
        return this.mIsLastOk;
    }

    public void setExpected(IncrementalPlicationChecker.Validity validity) {
        this.mExpected = validity;
    }

    public void releaseLock() {
        this.clearAssertionStack();
    }

    @SafeVarargs
    private final IncrementalPlicationChecker.Validity checkValidity(IncrementalPlicationChecker.Validity validity, IAction iAction, IPredicate iPredicate, IPredicate iPredicate2, IPredicate iPredicate3, Supplier<Script.LBool> ... supplierArray) {
        Script.LBool lBool;
        Supplier<Script.LBool>[] supplierArray2 = supplierArray;
        int n = supplierArray.length;
        int n2 = 0;
        while (n2 < n) {
            lBool = supplierArray2[n2];
            Script.LBool lBool2 = (Script.LBool)lBool.get();
            if (lBool2 == Script.LBool.UNSAT) {
                return this.checkValidity(validity, IncrementalPlicationChecker.Validity.VALID, iAction, iPredicate, iPredicate2, iPredicate3);
            }
            ++n2;
        }
        lBool = this.mManagedScript.checkSat((Object)this);
        return this.checkValidity(validity, IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)lBool), iAction, iPredicate, iPredicate2, iPredicate3);
    }

    private IncrementalPlicationChecker.Validity checkValidity(IncrementalPlicationChecker.Validity validity, IncrementalPlicationChecker.Validity validity2, IAction iAction, IPredicate iPredicate, IPredicate iPredicate2, IPredicate iPredicate3) {
        if (validity == IncrementalPlicationChecker.Validity.NOT_CHECKED || validity == validity2) {
            this.mIsLastOk = true;
            this.clearAssertionStack();
            return validity2;
        }
        if (validity2 == IncrementalPlicationChecker.Validity.UNKNOWN) {
            this.mIsLastOk = true;
            this.logUnsoundness(iAction, iPredicate, iPredicate2, iPredicate3, validity, validity2);
            this.clearAssertionStack();
            return validity2;
        }
        this.mIsLastOk = false;
        this.logUnsoundness(iAction, iPredicate, iPredicate2, iPredicate3, validity, validity2);
        this.clearAssertionStack();
        return validity2;
    }

    /*
     * Unable to fully structure code
     */
    private void logUnsoundness(IAction var1_1, IPredicate var2_2, IPredicate var3_3, IPredicate var4_4, IncrementalPlicationChecker.Validity var5_5, IncrementalPlicationChecker.Validity var6_6) {
        if (var6_6 == IncrementalPlicationChecker.Validity.UNKNOWN) ** GOTO lbl6
        if (var5_5 == IncrementalPlicationChecker.Validity.UNKNOWN) {
lbl6:
            // 2 sources

            var7_7 = (Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, warn(java.lang.Object ), (Ljava/lang/Object;)V)((ILogger)this.mLogger);
        } else {
            var7_7 = (Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, fatal(java.lang.Object ), (Ljava/lang/Object;)V)((ILogger)this.mLogger);
        }
        if (var6_6 == IncrementalPlicationChecker.Validity.UNKNOWN) {
            var7_7.accept("Soundness check inconclusive for the following hoare triple");
        } else {
            var7_7.accept("Soundness check failed for the following hoare triple");
        }
        var7_7.accept("Expected: " + String.valueOf(var5_5) + " Actual: " + String.valueOf(var6_6));
        var10_8 = this.mManagedScript.getScript();
        var7_7.accept("Solver was " + String.valueOf(var10_8.getInfo(":name")) + " in version " + String.valueOf(var10_8.getInfo(":version")));
        var11_9 = this.getActionStrings();
        var7_7.accept("--");
        var7_7.accept("Pre:       {" + DebuggingHoareTripleChecker.toString(var2_2) + "}");
        if (var4_4 != null) {
            var7_7.accept("PreHier:   {" + DebuggingHoareTripleChecker.toString(var4_4) + "}");
        }
        var7_7.accept("Action:    " + String.valueOf(var1_1));
        var11_9.stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$12(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).forEachOrdered((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, accept(T ), (Ljava/lang/String;)V)(var7_7));
        var7_7.accept("Post:      {" + DebuggingHoareTripleChecker.toString(var3_3) + "}");
        if (this.mGenerateUnsatCore) {
            if (var6_6 == IncrementalPlicationChecker.Validity.VALID) {
                var7_7.accept("--");
                var13_10 = this.mManagedScript.getUnsatCore((Object)this);
                var7_7.accept("Unsat core");
                var17_12 = var13_10;
                var16_14 = var13_10.length;
                var15_16 = 0;
                while (var15_16 < var16_14) {
                    var14_18 = var17_12[var15_16];
                    var7_7.accept(var14_18.toStringDirect());
                    ++var15_16;
                }
            } else if (var6_6 == IncrementalPlicationChecker.Validity.INVALID) {
                var7_7.accept("--");
                var7_7.accept("Model of prestate for invars");
                var13_11 = this.getAction().getTransformula();
                var14_19 = SmtUtils.extractApplicationTerms((String)"select", (Term)var13_11.getClosedFormula(), (boolean)false);
                for (Map.Entry<IProgramVar, TermVariable> var15_17 : var13_11.getInVars().entrySet()) {
                    var17_13 = var15_17.getKey();
                    var18_20 = var17_13.getTermVariable();
                    var19_21 = UnmodifiableTransFormula.getConstantForInVar(var17_13);
                    this.logUnsoundnessStateVar(var7_7, var14_19, var18_20, var19_21);
                }
                var7_7.accept("Model of poststate for outvars");
                for (Map.Entry<IProgramVar, TermVariable> var15_17 : var13_11.getOutVars().entrySet()) {
                    var17_13 = var15_17.getKey();
                    var18_20 = var17_13.getTermVariable();
                    var19_21 = UnmodifiableTransFormula.getConstantForOutVar(var17_13, var13_11.getInVars(), var13_11.getOutVars());
                    this.logUnsoundnessStateVar(var7_7, var14_19, var18_20, var19_21);
                }
            }
        } else {
            var7_7.accept("unsat core / model generation is disabled, enable it to get more details");
        }
        this.clearAssertionStack();
        var7_7.accept("--");
        var7_7.accept("Simplified triple ");
        var7_7.accept("Pre:       {" + this.toStringSimplified(var2_2) + "}");
        if (var4_4 != null) {
            var7_7.accept("PreHier:   {" + this.toStringSimplified(var4_4) + "}");
        }
        var7_7.accept("Action:    " + String.valueOf(var1_1));
        var11_9.stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$14(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).forEachOrdered((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, accept(T ), (Ljava/lang/String;)V)(var7_7));
        var7_7.accept("Post:      {" + this.toStringSimplified(var3_3) + "}");
    }

    private void logUnsoundnessStateVar(Consumer<Object> consumer, Set<ApplicationTerm> set, TermVariable termVariable, Term term) {
        if (SmtUtils.isSortForWhichWeCanGetValues((Sort)termVariable.getSort())) {
            Map map = this.mManagedScript.getValue((Object)this, new Term[]{term});
            consumer.accept(String.valueOf(term) + " = " + ((Term)map.get(term)).toStringDirect());
        } else if (SmtSortUtils.isArraySort((Sort)termVariable.getSort())) {
            set.stream().filter(applicationTerm -> applicationTerm.getParameters()[0] == term).forEachOrdered(applicationTerm -> {
                Map map = this.mManagedScript.getValue((Object)this, new Term[]{applicationTerm});
                consumer.accept(applicationTerm.toStringDirect() + "=" + ((Term)map.get(applicationTerm)).toStringDirect());
            });
        } else {
            consumer.accept(String.valueOf(term) + " = ?");
        }
    }

    private static String toString(IPredicate iPredicate) {
        return iPredicate.hashCode() + "#" + iPredicate.getClosedFormula().toStringDirect();
    }

    private List<String> getActionStrings() {
        return this.mAssertions.stream().filter(assertion -> assertion.getOrigin() instanceof IAction).map(assertion -> assertion.getTerm().toStringDirect()).collect(Collectors.toList());
    }

    private String toStringSimplified(IPredicate iPredicate) {
        Term term = iPredicate.getFormula();
        String string = iPredicate.hashCode() + "#";
        if (term instanceof QuantifiedFormula) {
            return string + PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)term).toStringDirect();
        }
        return string + SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)iPredicate.getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA).toStringDirect();
    }

    private void clearAssertionStack() {
        if (this.mAssertions.isEmpty()) {
            return;
        }
        Iterator<Assertion> iterator = this.mAssertions.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            this.mManagedScript.pop((Object)this, 1);
        }
        this.mHierConstants = null;
        this.mManagedScript.echo((Object)this, new QuotedObject(MSG_END_EDGE_CHECK));
        this.mManagedScript.unlock((Object)this);
    }

    private Script.LBool assertAction(IAction iAction) {
        if (this.mManagedScript.isLocked()) {
            this.mManagedScript.requestLockRelease();
        }
        this.mManagedScript.lock((Object)this);
        this.mManagedScript.echo((Object)this, new QuotedObject(MSG_START_EDGE_CHECK));
        Supplier<Term> supplier = () -> {
            if (iAction instanceof IInternalAction) {
                return iAction.getTransformula().getClosedFormula();
            }
            if (iAction instanceof ICallAction) {
                return ((ICallAction)iAction).getLocalVarsAssignment().getClosedFormula();
            }
            if (iAction instanceof IReturnAction) {
                return ((IReturnAction)iAction).getAssignmentOfReturn().getClosedFormula();
            }
            throw new AssertionError((Object)"unknown action");
        };
        Script.LBool lBool = this.pushAssertion(iAction, supplier);
        if (iAction instanceof IReturnAction) {
            IReturnAction iReturnAction = (IReturnAction)iAction;
            String string = iReturnAction.getPrecedingProcedure();
            UnmodifiableTransFormula unmodifiableTransFormula = this.mOldVarsAssignmentCache.getOldVarsAssignment(string);
            Supplier<Term> supplier2 = () -> {
                this.mHierConstants = new ScopedHashMap();
                Term term = unmodifiableTransFormula.getFormula();
                term = this.renameVarsToHierConstants(unmodifiableTransFormula.getInVars(), term);
                term = this.renameVarsToDefaultConstants(unmodifiableTransFormula.getOutVars(), term);
                assert (term.getFreeVars().length == 0);
                return this.mManagedScript.annotate((Object)this, term, new Annotation[]{new Annotation(ANNOT_NAMED, (Object)ID_TRANSITION_MODIFIABLE_GLOBAL_EQUALITY)});
            };
            lBool = this.pushAssertion(iAction, supplier2);
            Supplier<Term> supplier3 = () -> {
                Set<IProgramVar> set = unmodifiableTransFormula.getInVars().keySet();
                UnmodifiableTransFormula unmodifiableTransFormula2 = iReturnAction.getLocalVarsAssignmentOfCall();
                Term term = unmodifiableTransFormula2.getFormula();
                term = this.renameNonModifiableGlobalsToDefaultConstants(unmodifiableTransFormula2.getInVars(), set, term);
                term = this.renameVarsToHierConstants(unmodifiableTransFormula2.getInVars(), term);
                term = this.renameVarsToDefaultConstants(unmodifiableTransFormula2.getOutVars(), term);
                term = this.renameAuxVarsToCorrespondingConstants(unmodifiableTransFormula2.getAuxVars(), term);
                assert (term.getFreeVars().length == 0);
                return this.mManagedScript.annotate((Object)this, term, new Annotation[]{new Annotation(ANNOT_NAMED, (Object)ID_LOCAL_VARS_ASSIGNMENT)});
            };
            lBool = this.pushAssertion(iAction, supplier3);
        }
        return lBool;
    }

    private Script.LBool assertPrecondition(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Script.LBool lBool = this.pushAssertion(iPredicate, () -> this.mManagedScript.annotate((Object)this, iPredicate.getClosedFormula(), new Annotation[]{new Annotation(ANNOT_NAMED, (Object)ID_PRECONDITION)}));
        String string = this.getPrecedingProcedure();
        Set<IProgramNonOldVar> set = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string);
        Collection<Term> collection = DebuggingHoareTripleChecker.constructNonModOldVarsEquality(iPredicate.getVars(), set, this.mManagedScript, this);
        if (!collection.isEmpty()) {
            lBool = this.pushAssertion(iPredicate, () -> this.mManagedScript.annotate((Object)this, SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])collection.toArray(new Term[collection.size()])), new Annotation[]{new Annotation(ANNOT_NAMED, (Object)ID_PRECONDITION_NON_MOD_GLOBAL_EQUALITY)}));
        }
        return lBool;
    }

    private Script.LBool assertHierPred(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Supplier<Term> supplier = () -> {
            this.mHierConstants.beginScope();
            Term term = iPredicate.getFormula();
            String string = this.getPrecedingProcedure();
            Set<IProgramNonOldVar> set = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string);
            term = this.renameNonModifiableNonOldGlobalsToDefaultConstants(iPredicate.getVars(), set, term);
            String string2 = this.getSucceedingProcedure();
            Set<IProgramNonOldVar> set2 = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string2);
            term = DebuggingHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(iPredicate.getVars(), set2, term, this.mManagedScript, this);
            term = this.renameVarsToHierConstants(iPredicate.getVars(), term);
            assert (term.getFreeVars().length == 0);
            Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_HIERACHICAL_PRECONDITION);
            return this.mManagedScript.annotate((Object)this, term, new Annotation[]{annotation});
        };
        return this.pushAssertion(iPredicate, supplier);
    }

    private Script.LBool assertPostcondInternal(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Supplier<Term> supplier = () -> {
            Term term = DebuggingHoareTripleChecker.constructPostcondFormula(iPredicate, this.getInternalAction(), this.mModifiableGlobalVariableManager, this.mManagedScript, this);
            assert (term.getFreeVars().length == 0);
            Term term2 = this.mManagedScript.term((Object)this, "not", new Term[]{term});
            Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
            return this.mManagedScript.annotate((Object)this, term2, new Annotation[]{annotation});
        };
        return this.pushAssertion(iPredicate, supplier);
    }

    private Script.LBool assertPostcondCall(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Supplier<Term> supplier = () -> {
            Set<IProgramVar> set = iPredicate.getVars();
            Term term = this.renameGlobalsAndOldVarsToNonOldDefaultConstants(set, iPredicate.getFormula());
            term = DebuggingHoareTripleChecker.renameVarsToPrimedConstants(set, term, this.mManagedScript, this);
            term = DebuggingHoareTripleChecker.renameVarsToDefaultConstants(iPredicate.getVars(), term, this.mManagedScript, this);
            assert (term.getFreeVars().length == 0);
            Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
            return this.mManagedScript.annotate((Object)this, this.mManagedScript.term((Object)this, "not", new Term[]{term}), new Annotation[]{annotation});
        };
        return this.pushAssertion(iPredicate, supplier);
    }

    private Script.LBool assertPostcondReturn(IPredicate iPredicate) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Supplier<Term> supplier = () -> {
            this.mHierConstants.beginScope();
            Set<IProgramVar> set = this.getAssignmentOfReturn().getOutVars().keySet();
            Term term = DebuggingHoareTripleChecker.renameVarsToPrimedConstants(set, iPredicate.getFormula(), this.mManagedScript, this);
            String string = this.getPrecedingProcedure();
            Set<IProgramNonOldVar> set2 = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string);
            term = DebuggingHoareTripleChecker.renameVarsToDefaultConstants(set2, term, this.mManagedScript, this);
            term = this.renameNonModifiableNonOldGlobalsToDefaultConstants(iPredicate.getVars(), set2, term);
            String string2 = this.getSucceedingProcedure();
            Set<IProgramNonOldVar> set3 = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(string2);
            term = DebuggingHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(iPredicate.getVars(), set3, term, this.mManagedScript, this);
            term = this.renameVarsToHierConstants(iPredicate.getVars(), term);
            assert (term.getFreeVars().length == 0);
            Annotation annotation = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
            return this.mManagedScript.annotate((Object)this, this.mManagedScript.term((Object)this, "not", new Term[]{term}), new Annotation[]{annotation});
        };
        return this.pushAssertion(iPredicate, supplier);
    }

    private static Collection<Term> constructNonModOldVarsEquality(Set<IProgramVar> set, Set<IProgramNonOldVar> set2, ManagedScript managedScript, Object object) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IProgramVar iProgramVar : set) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!(iProgramVar instanceof IProgramOldVar) || set2.contains(iProgramNonOldVar = ((IProgramOldVar)iProgramVar).getNonOldVar())) continue;
            arrayList.add(DebuggingHoareTripleChecker.oldVarsEquality((IProgramOldVar)iProgramVar, managedScript, object));
        }
        return arrayList;
    }

    private static Term oldVarsEquality(IProgramOldVar iProgramOldVar, ManagedScript managedScript, Object object) {
        assert (iProgramOldVar.isOldvar());
        IProgramNonOldVar iProgramNonOldVar = iProgramOldVar.getNonOldVar();
        Term term = managedScript.term(object, "=", new Term[]{iProgramOldVar.getDefaultConstant(), iProgramNonOldVar.getDefaultConstant()});
        return term;
    }

    private Script.LBool pushAssertion(Object object, Supplier<Term> supplier) {
        this.mManagedScript.push((Object)this, 1);
        Term term = supplier.get();
        Script.LBool lBool = this.mManagedScript.assertTerm((Object)this, term);
        this.mAssertions.push(new Assertion(term, object, lBool));
        return lBool;
    }

    private static Term constructPostcondFormula(IPredicate iPredicate, IInternalAction iInternalAction, ModifiableGlobalsTable modifiableGlobalsTable, ManagedScript managedScript, Object object) {
        Set<IProgramVar> set = iInternalAction.getTransformula().getAssignedVars();
        Term term = DebuggingHoareTripleChecker.renameVarsToPrimedConstants(set, iPredicate.getFormula(), managedScript, object);
        String string = iInternalAction.getSucceedingProcedure();
        Set<IProgramNonOldVar> set2 = modifiableGlobalsTable.getModifiedBoogieVars(string);
        term = DebuggingHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(iPredicate.getVars(), set2, term, managedScript, object);
        term = DebuggingHoareTripleChecker.renameVarsToDefaultConstants(iPredicate.getVars(), term, managedScript, object);
        return term;
    }

    private static Term renameVarsToDefaultConstants(Set<? extends IProgramVar> set, Term term, ManagedScript managedScript, Object object) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(termVariableArray2.getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return managedScript.let(object, termVariableArray, termArray, term);
    }

    private Term renameVarsToDefaultConstants(Map<IProgramVar, TermVariable> map, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (Map.Entry<IProgramVar, TermVariable> termVariableArray2 : map.entrySet()) {
            arrayList.add(termVariableArray2.getValue());
            arrayList2.add(termVariableArray2.getKey().getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private static Term renameVarsToPrimedConstants(Set<IProgramVar> set, Term term, ManagedScript managedScript, Object object) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(termVariableArray2.getPrimedConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return managedScript.let(object, termVariableArray, termArray, term);
    }

    private Term renameVarsToHierConstants(Set<IProgramVar> set, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (IProgramVar termVariableArray2 : set) {
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(this.getOrConstructHierConstant(termVariableArray2));
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private Term renameVarsToHierConstants(Map<IProgramVar, TermVariable> map, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (Map.Entry<IProgramVar, TermVariable> termVariableArray2 : map.entrySet()) {
            arrayList.add(termVariableArray2.getValue());
            arrayList2.add(this.getOrConstructHierConstant(termVariableArray2.getKey()));
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private Term renameAuxVarsToCorrespondingConstants(Set<TermVariable> set, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        for (TermVariable termVariableArray2 : set) {
            arrayList.add(termVariableArray2);
            Term term2 = this.mManagedScript.term((Object)this, ProgramVarUtils.generateConstantIdentifierForAuxVar(termVariableArray2), new Term[0]);
            arrayList2.add(term2);
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private Term getOrConstructHierConstant(IProgramVar iProgramVar) {
        Term term = (Term)this.mHierConstants.get((Object)iProgramVar);
        if (term == null) {
            String string = "c_" + iProgramVar.getTermVariable().getName() + "_Hier";
            Sort sort = iProgramVar.getTermVariable().getSort();
            this.mManagedScript.declareFun((Object)this, string, new Sort[0], sort);
            term = this.mManagedScript.term((Object)this, string, new Term[0]);
            this.mHierConstants.put((Object)iProgramVar, (Object)term);
        }
        return term;
    }

    private Term renameNonModifiableNonOldGlobalsToDefaultConstants(Set<IProgramVar> set, Set<IProgramNonOldVar> set2, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            if (!termVariableArray2.isGlobal() || !(termVariableArray2 instanceof IProgramNonOldVar) || set2.contains(termVariableArray2)) continue;
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(termVariableArray2.getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private static Term renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(Set<IProgramVar> set, Set<IProgramNonOldVar> set2, Term term, ManagedScript managedScript, Object object) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!(termVariableArray2 instanceof IProgramOldVar) || set2.contains(iProgramNonOldVar = ((IProgramOldVar)termVariableArray2).getNonOldVar())) continue;
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(iProgramNonOldVar.getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return managedScript.let(object, termVariableArray, termArray, term);
    }

    private Term renameNonModifiableGlobalsToDefaultConstants(Map<IProgramVar, TermVariable> map, Set<IProgramVar> set, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (Map.Entry<IProgramVar, TermVariable> termVariableArray2 : map.entrySet()) {
            IProgramVar iProgramVar = termVariableArray2.getKey();
            if (iProgramVar.isGlobal()) {
                if (iProgramVar.isOldvar()) {
                    assert (!set.contains(iProgramVar));
                    continue;
                }
                if (set.contains(iProgramVar)) continue;
                arrayList.add(termVariableArray2.getValue());
                arrayList2.add(iProgramVar.getDefaultConstant());
                continue;
            }
            assert (!set.contains(iProgramVar));
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private Term renameGlobalsAndOldVarsToNonOldDefaultConstants(Set<IProgramVar> set, Term term) {
        ArrayList<TermVariable> arrayList = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> arrayList2 = new ArrayList<ApplicationTerm>();
        for (IProgramVar termVariableArray2 : set) {
            if (!termVariableArray2.isGlobal()) continue;
            if (termVariableArray2.isOldvar()) {
                arrayList.add(termVariableArray2.getTermVariable());
                IProgramNonOldVar iProgramNonOldVar = ((IProgramOldVar)termVariableArray2).getNonOldVar();
                arrayList2.add(iProgramNonOldVar.getDefaultConstant());
                continue;
            }
            arrayList.add(termVariableArray2.getTermVariable());
            arrayList2.add(termVariableArray2.getDefaultConstant());
        }
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        Term[] termArray = arrayList2.toArray(new Term[arrayList2.size()]);
        return this.mManagedScript.let((Object)this, termVariableArray, termArray, term);
    }

    private IAction getAction() {
        Optional<Assertion> optional = this.mAssertions.stream().filter(assertion -> assertion.getOrigin() instanceof IAction).findFirst();
        if (optional.isPresent()) {
            return (IAction)optional.get().getOrigin();
        }
        throw new AssertionError((Object)"No action");
    }

    private IInternalAction getInternalAction() {
        IAction iAction = this.getAction();
        if (iAction instanceof IInternalAction) {
            return (IInternalAction)iAction;
        }
        throw new AssertionError((Object)"No internal action");
    }

    private String getSucceedingProcedure() {
        return this.getAction().getSucceedingProcedure();
    }

    private String getPrecedingProcedure() {
        return this.getAction().getPrecedingProcedure();
    }

    private UnmodifiableTransFormula getAssignmentOfReturn() {
        IAction iAction = this.getAction();
        if (iAction instanceof IReturnAction) {
            return ((IReturnAction)iAction).getAssignmentOfReturn();
        }
        throw new AssertionError((Object)"No return action");
    }

    private static /* synthetic */ String lambda$12(String string) {
        return "ActionStr: " + string;
    }

    private static /* synthetic */ String lambda$14(String string) {
        return "ActionStr: " + string;
    }

    private static final class Assertion {
        private final Term mTerm;
        private final Object mOrigin;
        private final Script.LBool mResult;

        public Assertion(Term term, Object object, Script.LBool lBool) {
            this.mTerm = term;
            this.mOrigin = object;
            this.mResult = lBool;
        }

        public Term getTerm() {
            return this.mTerm;
        }

        public Object getOrigin() {
            return this.mOrigin;
        }

        public Script.LBool getResult() {
            return this.mResult;
        }
    }
}

