/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TermDomainOperationProvider
implements IDomainSpecificOperationProvider<Term, IPredicate, TransFormula> {
    protected final ManagedScript mMgdScript;
    protected final IUltimateServiceProvider mServices;

    public TermDomainOperationProvider(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this.mServices = iUltimateServiceProvider;
        this.mMgdScript = managedScript;
    }

    @Override
    public Term getConstraint(IPredicate iPredicate) {
        return iPredicate.getFormula();
    }

    @Override
    public boolean isConstraintUnsatisfiable(Term term) {
        return SmtUtils.isFalseLiteral((Term)term);
    }

    @Override
    public boolean isConstraintValid(Term term) {
        return SmtUtils.isTrueLiteral((Term)term);
    }

    @Override
    public Term getConstraintFromTransitionRelation(TransFormula transFormula) {
        return transFormula.getFormula();
    }

    @Override
    public Term renameVariables(Map<Term, Term> map, Term term) {
        Term term2 = Substitution.apply((ManagedScript)this.mMgdScript, map, (Term)term);
        return term2;
    }

    @Override
    public Term constructConjunction(List<Term> list) {
        return SmtUtils.and((Script)this.mMgdScript.getScript(), list);
    }

    @Override
    public Term constructDisjunction(List<Term> list) {
        return SmtUtils.or((Script)this.mMgdScript.getScript(), list);
    }

    @Override
    public Term constructNegation(Term term) {
        return SmtUtils.not((Script)this.mMgdScript.getScript(), (Term)term);
    }

    @Override
    public Term projectExistentially(Set<TermVariable> set, Term term) {
        return this.constructQuantifiedFormula(0, set, term);
    }

    @Override
    public Term projectUniversally(Set<TermVariable> set, Term term) {
        return this.constructQuantifiedFormula(1, set, term);
    }

    private Term constructQuantifiedFormula(int n, Set<TermVariable> set, Term term) {
        Term term2 = SmtUtils.quantifier((Script)this.mMgdScript.getScript(), (int)n, set, (Term)term);
        return PartialQuantifierElimination.eliminateLight((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (Term)term2);
    }
}

