/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation;

import de.uni_freiburg.informatik.ultimate.automata.IRun;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheckCraig;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;

public class Interpolator<LETTER extends IIcfgTransition<?>> {
    private final IPredicateUnifier mPredicateUnifier;
    private final PredicateTransformer<Term, IPredicate, TransFormula> mPredTransformer;
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private final ITraceCheckPreferences mPrefs;
    private IPredicate[] mInterpolants;
    private Script.LBool mTraceCheckResult;

    public Interpolator(IPredicateUnifier iPredicateUnifier, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, ILogger iLogger, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, ITraceCheckPreferences iTraceCheckPreferences) {
        this.mPredicateUnifier = iPredicateUnifier;
        this.mPredTransformer = predicateTransformer;
        this.mScript = managedScript;
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
        this.mPrefs = iTraceCheckPreferences;
    }

    public void generateInterpolants(InterpolationMethod interpolationMethod, IRun<LETTER, IPredicate> iRun) {
        switch (interpolationMethod) {
            case POST: {
                this.mInterpolants = this.generateInterpolantsPost(iRun);
                return;
            }
            case CRAIG_NESTED: {
                this.mInterpolants = this.generateInterpolantsCraigNested(iRun);
                return;
            }
        }
        throw new UnsupportedOperationException();
    }

    private IPredicate[] generateInterpolantsPost(IRun<LETTER, IPredicate> iRun) {
        this.mTraceCheckResult = Script.LBool.UNSAT;
        List list = iRun.getWord().asList();
        IPredicate[] iPredicateArray = new IPredicate[list.size() + 1];
        iPredicateArray[0] = this.mPredicateUnifier.getTruePredicate();
        iPredicateArray[list.size()] = this.mPredicateUnifier.getFalsePredicate();
        int n = 1;
        while (n <= list.size()) {
            iPredicateArray[n] = this.mPredicateUnifier.getOrConstructPredicate((Term)this.mPredTransformer.strongestPostcondition((IAbstractPredicate)iPredicateArray[n - 1], (ITransitionRelation)((IIcfgTransition)list.get(n - 1)).getTransformula()));
            ++n;
        }
        return Arrays.copyOfRange(iPredicateArray, 1, list.size());
    }

    private IPredicate[] generateInterpolantsCraigNested(IRun<LETTER, IPredicate> iRun) {
        List list = iRun.getWord().asList();
        NestedWord nestedWord = TraceCheckUtils.toNestedWord((List)list);
        TreeMap treeMap = new TreeMap();
        IPredicate iPredicate = this.mPredicateUnifier.getTruePredicate();
        IPredicate iPredicate2 = this.mPredicateUnifier.getFalsePredicate();
        Counterexample counterexample = new Counterexample((Word)nestedWord, iRun.getStateSequence());
        InterpolatingTraceCheckCraig interpolatingTraceCheckCraig = new InterpolatingTraceCheckCraig(iPredicate, iPredicate2, treeMap, counterexample, this.mServices, this.mPrefs.getCfgSmtToolkit(), this.mScript, (PredicateFactory)this.mPredicateUnifier.getPredicateFactory(), this.mPredicateUnifier, this.mPrefs.getAssertCodeBlockOrder(), this.mPrefs.computeCounterexample(), this.mPrefs.collectInterpolantStatistics(), InterpolationTechnique.Craig_NestedInterpolation, true, this.mPrefs.getSimplificationTechnique(), false);
        this.mTraceCheckResult = interpolatingTraceCheckCraig.isCorrect();
        if (this.mTraceCheckResult == Script.LBool.UNSAT) {
            return interpolatingTraceCheckCraig.getInterpolants();
        }
        return new IPredicate[0];
    }

    public Script.LBool getTraceCheckResult() {
        return this.mTraceCheckResult;
    }

    public IPredicate[] getInterpolants() {
        return this.mInterpolants;
    }

    public static enum InterpolationMethod {
        POST,
        BINARY,
        CRAIG_NESTED,
        CRAIG_TREE;

    }
}

