/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopdetector;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopdetector.CycleFinder;
import de.uni_freiburg.informatik.ultimate.lib.acceleratedinterpolation.loopdetector.ILoopdetector;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Loopdetector<LOC extends IcfgLocation, LETTER extends IIcfgTransition<?>>
implements ILoopdetector<LOC, LETTER> {
    private final List<LETTER> mTrace;
    private final List<LOC> mTraceLocations;
    private final ILogger mLogger;
    private Map<LOC, Set<List<LETTER>>> mLoops;
    private Map<LOC, Set<List<UnmodifiableTransFormula>>> mLoopsAsTf;
    private final Map<LOC, Set<List<LETTER>>> mNestedLoops;
    private final Map<LOC, Set<List<UnmodifiableTransFormula>>> mNestedLoopsAsTf;
    private final Map<LOC, LETTER> mLoopExitTransitions;
    private final Map<LOC, Pair<Integer, Integer>> mLoopSize;
    private final int mDelay;
    private final Map<LOC, LOC> mNestingRelation;
    private final CycleFinder<LOC> mCycleFinder;

    public Loopdetector(List<LETTER> list, ILogger iLogger) {
        this(list, iLogger, 1);
    }

    public Loopdetector(List<LETTER> list, ILogger iLogger, int n) {
        this.mLogger = iLogger;
        this.mTrace = new ArrayList<LETTER>(list);
        this.mCycleFinder = new CycleFinder();
        this.mTraceLocations = this.mCycleFinder.statementsToLocations(this.mTrace);
        this.mLoops = new HashMap<LOC, Set<List<LETTER>>>();
        this.mLoopsAsTf = new HashMap<LOC, Set<List<UnmodifiableTransFormula>>>();
        this.mNestedLoops = new HashMap<LOC, Set<List<LETTER>>>();
        this.mNestedLoopsAsTf = new HashMap<LOC, Set<List<UnmodifiableTransFormula>>>();
        this.mLoopExitTransitions = new HashMap<LOC, LETTER>();
        this.mLoopSize = new HashMap<LOC, Pair<Integer, Integer>>();
        this.mDelay = n;
        this.mNestingRelation = new HashMap<LOC, LOC>();
        this.mLogger.debug((Object)"Loopdetector: created.");
        this.mLogger.debug((Object)"Loopdetector: Searching for Loops");
        this.findLoopPaths();
        if (!this.mLoops.isEmpty()) {
            this.checkDelay();
        }
    }

    private void findLoopPaths() {
        Collection<Integer> collection;
        Object object;
        Map<LOC, List<Integer>> map = this.mCycleFinder.getCyclesInTrace(this.mTraceLocations);
        map = this.findOverarchingLoop(map);
        Set<LOC> set = this.getNestedCycles(map);
        Map<LOC, List<Integer>> map2 = new HashMap<LOC, List<Integer>>(map);
        map2 = this.filterProcedures(map2);
        for (Map.Entry<LOC, List<Integer>> entry : map2.entrySet()) {
            object = (Pair<Map<LOC, Set<List<LETTER>>>, Map<LOC, Set<List<UnmodifiableTransFormula>>>>)entry.getKey();
            collection = entry.getValue();
            int n = map2.get(object).get(map2.get(object).size() - 1);
            this.mLoopExitTransitions.put(object, (IIcfgTransition)this.mTrace.get(n));
            this.mLoopSize.put(object, (Pair<Integer, Integer>)new Pair((Object)((Integer)collection.get(0)), (Object)((Integer)collection.get(collection.size() - 1))));
        }
        for (IcfgLocation icfgLocation : set) {
            object = this.cyclePaths(map2);
            collection = (Set)((Map)object.getFirst()).get(icfgLocation);
            this.mNestedLoops.put((LOC)icfgLocation, (Set<List<LETTER>>)collection);
            this.mNestedLoopsAsTf.put(icfgLocation, (Set)((Map)object.getSecond()).get(icfgLocation));
            map2.remove(icfgLocation);
        }
        Pair<Map<LOC, Set<List<LETTER>>>, Map<LOC, Set<List<UnmodifiableTransFormula>>>> pair = this.cyclePaths(map2);
        this.mLoops = (Map)pair.getFirst();
        this.mLoopsAsTf = (Map)pair.getSecond();
        this.mLogger.debug((Object)"Found Loops");
        if (this.mLogger.isDebugEnabled()) {
            for (Map.Entry entry : this.mLoops.entrySet()) {
                this.mLogger.debug((Object)("Loops for " + ((IcfgLocation)entry.getKey()).toString() + " " + ((Set)entry.getValue()).toString()));
            }
        }
        if (!this.mNestingRelation.isEmpty()) {
            this.mLogger.debug((Object)"Found Nested Loops");
        }
    }

    private Map<LOC, List<Integer>> findOverarchingLoop(Map<LOC, List<Integer>> map) {
        HashMap<LOC, List<Integer>> hashMap = new HashMap<LOC, List<Integer>>(map);
        for (Map.Entry<LOC, List<Integer>> entry : map.entrySet()) {
            IcfgLocation icfgLocation = (IcfgLocation)entry.getKey();
            if (!hashMap.containsKey(icfgLocation)) continue;
            int n = entry.getValue().get(0);
            int n2 = entry.getValue().get(entry.getValue().size() - 1);
            for (Map.Entry<LOC, List<Integer>> entry2 : map.entrySet()) {
                IcfgLocation icfgLocation2 = (IcfgLocation)entry2.getKey();
                if (icfgLocation == icfgLocation2 || !hashMap.containsKey(icfgLocation2)) continue;
                int n3 = entry2.getValue().get(0);
                int n4 = entry2.getValue().get(entry2.getValue().size() - 1);
                if (n >= n3 || n2 >= n4) continue;
                hashMap.remove(icfgLocation2);
            }
        }
        return hashMap;
    }

    private Map<LOC, List<Integer>> filterProcedures(Map<LOC, List<Integer>> map) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<LOC, List<Integer>> entry : map.entrySet()) {
            IcfgLocation icfgLocation = (IcfgLocation)entry.getKey();
            ArrayList arrayList = new ArrayList(entry.getValue());
            ArrayList arrayList2 = new ArrayList(arrayList);
            int n = 0;
            while (n < arrayList.size() - 1) {
                Pair pair = new Pair((Object)((Integer)arrayList.get(n)), (Object)((Integer)arrayList.get(n + 1)));
                int n2 = (Integer)pair.getFirst();
                while (n2 <= (Integer)pair.getSecond()) {
                    IIcfgTransition iIcfgTransition = (IIcfgTransition)this.mTrace.get(n2);
                    if (iIcfgTransition instanceof ICallAction) {
                        IIcfgCallTransition iIcfgCallTransition = (IIcfgCallTransition)iIcfgTransition;
                        if (iIcfgCallTransition.getSucceedingProcedure().equals(iIcfgCallTransition.getPrecedingProcedure())) {
                            this.mLogger.debug((Object)"Found Recursive call!");
                            arrayList2.remove(pair.getSecond());
                        }
                        boolean bl = false;
                        int n3 = n2 - 1;
                        while (n3 < (Integer)pair.getSecond()) {
                            IIcfgReturnTransition iIcfgReturnTransition;
                            if (this.mTrace.get(n3) instanceof IReturnAction && iIcfgCallTransition == (iIcfgReturnTransition = (IIcfgReturnTransition)this.mTrace.get(n3)).getCorrespondingCall()) {
                                bl = true;
                            }
                            ++n3;
                        }
                        if (!bl) {
                            arrayList2.remove(pair.getSecond());
                        }
                    }
                    if (iIcfgTransition instanceof IReturnAction) {
                        boolean bl = false;
                        IIcfgReturnTransition iIcfgReturnTransition = (IIcfgReturnTransition)iIcfgTransition;
                        IIcfgCallTransition iIcfgCallTransition = iIcfgReturnTransition.getCorrespondingCall();
                        int n4 = n2 - 1;
                        while (n4 > (Integer)pair.getFirst()) {
                            if (this.mTrace.get(n4) == iIcfgCallTransition) {
                                bl = true;
                            }
                            --n4;
                        }
                        if (!bl) {
                            arrayList2.remove(pair.getSecond());
                        }
                    }
                    ++n2;
                }
                ++n;
            }
            if (arrayList2.size() <= 1) continue;
            hashMap.put(icfgLocation, arrayList2);
        }
        return hashMap;
    }

    private void checkDelay() {
        HashMap<LOC, Set<List<LETTER>>> hashMap = new HashMap<LOC, Set<List<LETTER>>>(this.mLoops);
        for (Map.Entry entry : hashMap.entrySet()) {
            Pair<Integer, Integer> pair2;
            Integer n = Integer.MAX_VALUE;
            for (Pair<Integer, Integer> pair2 : (Set)entry.getValue()) {
                if (pair2.size() >= n) continue;
                n = pair2.size();
            }
            pair2 = this.mLoopSize.get(entry.getKey());
            int n2 = (Integer)pair2.getSecond() - (Integer)pair2.getFirst();
            int n3 = n * this.mDelay;
            if (n3 <= n2) continue;
            this.mLoops.remove(entry.getKey());
            this.mLoopSize.remove(entry.getKey());
            this.mLoopExitTransitions.remove(entry.getKey());
        }
    }

    private Pair<Map<LOC, Set<List<LETTER>>>, Map<LOC, Set<List<UnmodifiableTransFormula>>>> cyclePaths(Map<LOC, List<Integer>> map) {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        for (Map.Entry<LOC, List<Integer>> entry : map.entrySet()) {
            HashSet<ArrayList<LETTER>> hashSet = new HashSet<ArrayList<LETTER>>();
            HashSet hashSet2 = new HashSet();
            IcfgLocation icfgLocation = (IcfgLocation)entry.getKey();
            int n = 1;
            while (n < entry.getValue().size()) {
                ArrayList<LETTER> arrayList = new ArrayList<LETTER>(this.mTrace.subList(entry.getValue().get(n - 1), entry.getValue().get(n)));
                hashSet.add(arrayList);
                ArrayList<UnmodifiableTransFormula> arrayList2 = new ArrayList<UnmodifiableTransFormula>();
                for (IIcfgTransition iIcfgTransition : arrayList) {
                    arrayList2.add(iIcfgTransition.getTransformula());
                }
                hashSet2.add(arrayList2);
                ++n;
            }
            hashMap.put(icfgLocation, hashSet);
            hashMap2.put(icfgLocation, hashSet2);
        }
        return new Pair(hashMap, hashMap2);
    }

    private Set<LOC> getNestedCycles(Map<LOC, List<Integer>> map) {
        IcfgLocation icfgLocation;
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        HashMap hashMap = new HashMap();
        for (Map.Entry<LOC, List<Integer>> entry : map.entrySet()) {
            icfgLocation = (IcfgLocation)entry.getKey();
            IcfgLocation icfgLocation2 = entry.getValue();
            int n = 0;
            while (n < icfgLocation2.size() - 1) {
                int n2 = icfgLocation2.get(n);
                int n3 = (Integer)icfgLocation2.get(n + 1);
                for (Map.Entry<LOC, List<Integer>> entry2 : map.entrySet()) {
                    HashSet<IcfgLocation> hashSet2;
                    int n4;
                    int n5;
                    IcfgLocation icfgLocation3 = (IcfgLocation)entry2.getKey();
                    List<Integer> list = entry2.getValue();
                    if (icfgLocation == icfgLocation3) continue;
                    int n6 = 0;
                    while (n6 < list.size() - 1) {
                        n5 = list.get(n6);
                        n4 = list.get(n6 + 1);
                        if (n2 < n5 && n3 > n4) {
                            hashSet.add(icfgLocation3);
                            this.mNestingRelation.put(icfgLocation, icfgLocation3);
                        } else if (!(n5 >= n2 && n4 >= n3 || n5 <= n2 && n4 <= n3)) {
                            if (!hashMap.containsKey(icfgLocation)) {
                                HashSet<IcfgLocation> hashSet3 = new HashSet<IcfgLocation>();
                                hashSet3.add(icfgLocation3);
                                hashMap.put(icfgLocation, hashSet3);
                                break;
                            }
                            HashSet<IcfgLocation> hashSet4 = new HashSet<IcfgLocation>((Collection)hashMap.get(icfgLocation));
                            hashSet4.add(icfgLocation3);
                            hashMap.put(icfgLocation, hashSet4);
                            break;
                        }
                        ++n6;
                    }
                    n6 = entry.getValue().get(0);
                    n5 = entry.getValue().get(entry.getValue().size() - 1);
                    n4 = entry2.getValue().get(0);
                    int hashSet4 = entry2.getValue().get(entry2.getValue().size() - 1);
                    if (n6 < n4 && hashSet4 < n5) continue;
                    if (!hashMap.containsKey(icfgLocation)) {
                        hashSet2 = new HashSet<IcfgLocation>();
                        hashSet2.add(icfgLocation3);
                        hashMap.put(icfgLocation, hashSet2);
                        continue;
                    }
                    hashSet2 = new HashSet((Collection)hashMap.get(icfgLocation));
                    hashSet2.add(icfgLocation3);
                    hashMap.put(icfgLocation, hashSet2);
                }
                ++n;
            }
        }
        for (Map.Entry<Object, List<Integer>> entry : hashMap.entrySet()) {
            icfgLocation = (IcfgLocation)entry.getKey();
            for (IcfgLocation icfgLocation2 : (Set)((Object)entry.getValue())) {
                if (!this.mNestingRelation.containsKey(icfgLocation) || this.mNestingRelation.get(icfgLocation) != icfgLocation2) continue;
                this.mNestingRelation.remove(icfgLocation);
            }
        }
        return hashSet;
    }

    @Override
    public Map<LOC, Set<List<LETTER>>> getLoops() {
        return this.mLoops;
    }

    @Override
    public Map<LOC, Set<List<UnmodifiableTransFormula>>> getLoopsTf() {
        return this.mLoopsAsTf;
    }

    @Override
    public Map<LOC, Set<List<UnmodifiableTransFormula>>> getNestedLoopsTf() {
        return this.mNestedLoopsAsTf;
    }

    @Override
    public Map<LOC, LOC> getNestingRelation() {
        return this.mNestingRelation;
    }

    @Override
    public Map<LOC, LETTER> getLoopExitTransitions() {
        return this.mLoopExitTransitions;
    }

    @Override
    public Map<LOC, Pair<Integer, Integer>> getLoopSize() {
        return this.mLoopSize;
    }

    public List<LETTER> getTrace() {
        return this.mTrace;
    }

    public List<LOC> getTraceLocations() {
        return this.mTraceLocations;
    }

    @Override
    public Map<LOC, Set<List<LETTER>>> getNestedLoops() {
        return this.mNestedLoops;
    }
}

