/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.EqualityProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ITheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SharedTermEvaluator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ArrayTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCBaseTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCParentInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTermPairHash;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CompareTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CongruencePath;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ModelBuilder;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.ReverseTrigger;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.EQAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ArrayQueue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.ScopedArrayList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CClosure
implements ITheory {
    final Clausifier mClausifier;
    final Map<Term, CCTerm> mAnonTerms = new HashMap<Term, CCTerm>();
    final ScopedArrayList<CCTerm> mAllTerms = new ScopedArrayList();
    final CCTermPairHash mPairHash = new CCTermPairHash();
    final ArrayQueue<Literal> mPendingLits = new ArrayQueue();
    ArrayQueue<Literal> mRecheckOnBacktrackLits = new ArrayQueue();
    ArrayQueue<SymmetricPair<CCAppTerm>> mRecheckOnBacktrackCongs = new ArrayQueue();
    final ScopedHashMap<Object, CCBaseTerm> mSymbolicTerms = new ScopedHashMap();
    final ArrayList<Integer> mNumFunctionPositionsStack = new ArrayList();
    int mNumFunctionPositions;
    final ArrayDeque<UndoInfo> mUndoStack = new ArrayDeque();
    final ArrayDeque<Integer> mDecideLevelToUndoStackSize = new ArrayDeque();
    final ArrayDeque<SymmetricPair<CCAppTerm>> mPendingCongruences = new ArrayDeque();
    private long mInvertEdgeTime;
    private long mEqTime;
    private long mCcTime;
    private long mSetRepTime;
    private long mCcCount;
    private long mMergeCount;

    public CClosure(Clausifier clausifier) {
        this.mClausifier = clausifier;
    }

    public DPLLEngine getEngine() {
        return this.mClausifier.getEngine();
    }

    public LogProxy getLogger() {
        return this.mClausifier.getLogger();
    }

    public boolean isProofGenerationEnabled() {
        return this.getEngine().isProofGenerationEnabled();
    }

    public CCTerm createAnonTerm(Term term) {
        CCBaseTerm cCBaseTerm = new CCBaseTerm(false, this.mNumFunctionPositions, term);
        this.mAllTerms.add(cCBaseTerm);
        this.mAnonTerms.put(term, cCBaseTerm);
        return cCBaseTerm;
    }

    /*
     * Unable to fully structure code
     */
    private int getMergeStackDepth(CCTerm var1_1, CCTerm var2_2) {
        if (!CClosure.$assertionsDisabled && var1_1.getRepresentative() != var2_2.getRepresentative()) {
            throw new AssertionError((Object)"terms were never merged");
        }
        if (var1_1 == var2_2) {
            return -1;
        }
        var3_3 = 0;
        var4_4 = 0;
        var5_5 = var1_1;
        while (var5_5 != var5_5.mRep) {
            ++var3_3;
            var5_5 = var5_5.mRep;
        }
        var5_5 = var2_2;
        while (var5_5 != var5_5.mRep) {
            ++var4_4;
            var5_5 = var5_5.mRep;
        }
        while (var3_3 > var4_4) {
            if (var1_1.mRep == var2_2) {
                return var1_1.mMergeTime;
            }
            var1_1 = var1_1.mRep;
            --var3_3;
        }
        if (CClosure.$assertionsDisabled || var1_1 != var2_2) ** GOTO lbl29
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            if (var2_2.mRep == var1_1) {
                return var2_2.mMergeTime;
            }
            var2_2 = var2_2.mRep;
            --var4_4;
lbl29:
            // 2 sources

            ** while (var4_4 > var3_3)
        }
lbl30:
        // 1 sources

        if (!CClosure.$assertionsDisabled && var1_1 == var2_2) {
            throw new AssertionError();
        }
        if (!CClosure.$assertionsDisabled && var4_4 != var3_3) {
            throw new AssertionError();
        }
        while (true) {
            if (!CClosure.$assertionsDisabled && var1_1 == var2_2) {
                throw new AssertionError();
            }
            if (!CClosure.$assertionsDisabled && var1_1 == var1_1.mRep) {
                throw new AssertionError();
            }
            if (!CClosure.$assertionsDisabled && var2_2 == var2_2.mRep) {
                throw new AssertionError();
            }
            if (var1_1.mRep == var2_2.mRep) {
                return Math.max(var1_1.mMergeTime, var2_2.mMergeTime);
            }
            var1_1 = var1_1.mRep;
            var2_2 = var2_2.mRep;
        }
    }

    private CCAppTerm findCongruentAppTerm(CCTerm cCTerm, CCTerm cCTerm2) {
        CCParentInfo cCParentInfo = cCTerm2.getRepresentative().mCCPars.getInfo(cCTerm.mParentPosition);
        int n = Integer.MAX_VALUE;
        CCAppTerm cCAppTerm = null;
        for (CCAppTerm.Parent parent : cCParentInfo.mCCParents) {
            int n2;
            CCAppTerm cCAppTerm2 = parent.getData();
            CCTerm cCTerm3 = cCAppTerm2.getFunc();
            CCTerm cCTerm4 = cCAppTerm2.getArg();
            assert (cCTerm4.getRepresentative() == cCTerm2.getRepresentative());
            if (cCTerm3.getRepresentative() != cCTerm.getRepresentative() || cCTerm3 == cCTerm && cCTerm4 == cCTerm2 || (n2 = Math.max(this.getMergeStackDepth(cCTerm3, cCTerm), this.getMergeStackDepth(cCTerm4, cCTerm2))) >= n) continue;
            n = n2;
            cCAppTerm = cCAppTerm2;
        }
        return cCAppTerm;
    }

    public CCAppTerm createAppTerm(boolean bl, CCTerm cCTerm, CCTerm cCTerm2, SourceAnnotation sourceAnnotation) {
        Object object;
        SimpleListable simpleListable;
        Object object2;
        SimpleListable simpleListable2;
        assert (cCTerm.mIsFunc);
        CCParentInfo cCParentInfo = cCTerm2.mRepStar.mCCPars.getExistingParentInfo(cCTerm.mParentPosition);
        if (cCParentInfo != null) {
            simpleListable2 = cCParentInfo.mCCParents;
            assert (((SimpleList)simpleListable2).wellformed());
            object2 = ((SimpleList)simpleListable2).iterator();
            while (object2.hasNext()) {
                simpleListable = object2.next();
                object = simpleListable.getData();
                if (((CCAppTerm)object).mFunc != cCTerm || ((CCAppTerm)object).mArg != cCTerm2) continue;
                return object;
            }
        }
        simpleListable2 = new CCAppTerm(bl, bl ? cCTerm.mParentPosition + 1 : 0, cCTerm, cCTerm2, this, sourceAnnotation.isFromQuantTheory());
        if (!bl && ((CCTerm)simpleListable2).getAge() > 0) {
            this.getLogger().debug("Create new AppTerm %s of age %d", simpleListable2, ((CCTerm)simpleListable2).getAge());
        }
        this.mAllTerms.add((CCTerm)simpleListable2);
        ((CCAppTerm)simpleListable2).addParentInfo(this);
        simpleListable = this.findCongruentAppTerm(cCTerm, cCTerm2);
        this.getLogger().debug("createAppTerm %s congruent: %s", simpleListable2, simpleListable);
        if (simpleListable != null) {
            this.mRecheckOnBacktrackCongs.add(new SymmetricPair<CCAppTerm.Parent>((CCAppTerm.Parent)simpleListable2, (CCAppTerm.Parent)simpleListable));
            this.addPendingCongruence((CCAppTerm)simpleListable2, (CCAppTerm)simpleListable);
        }
        if (!bl) {
            object2 = simpleListable2;
            while (object2 instanceof CCAppTerm) {
                object = (CCAppTerm)object2;
                CCTerm simpleListable3 = ((CCAppTerm)object).getArg();
                int n = ((CCAppTerm)object).getFunc().mParentPosition;
                CCParentInfo cCParentInfo2 = simpleListable3.getRepresentative().mCCPars.getInfo(n);
                if (cCParentInfo2 != null) {
                    for (ReverseTrigger reverseTrigger : cCParentInfo2.mReverseTriggers) {
                        reverseTrigger.activate((CCAppTerm)simpleListable2, true);
                    }
                }
                object2 = ((CCAppTerm)object).getFunc();
            }
            object = ((CCTerm)object2).mCCPars.getInfo(0);
            if (object != null) {
                for (ReverseTrigger reverseTrigger : ((CCParentInfo)object).mReverseTriggers) {
                    reverseTrigger.activate((CCAppTerm)simpleListable2, true);
                }
            }
        }
        return simpleListable2;
    }

    public CCTerm getFuncTerm(FunctionSymbol functionSymbol) {
        CCBaseTerm cCBaseTerm = (CCBaseTerm)this.mSymbolicTerms.get((Object)functionSymbol);
        if (cCBaseTerm == null) {
            cCBaseTerm = new CCBaseTerm(functionSymbol.getParameterSorts().length > 0, this.mNumFunctionPositions, functionSymbol);
            this.mAllTerms.add(cCBaseTerm);
            this.mNumFunctionPositions += functionSymbol.getParameterSorts().length;
            this.mSymbolicTerms.put((Object)functionSymbol, (Object)cCBaseTerm);
        }
        return cCBaseTerm;
    }

    public Collection<CCTerm> getArgTermsForFunc(FunctionSymbol functionSymbol, int n) {
        assert (functionSymbol.getParameterSorts().length > n);
        ArrayList<CCTerm> arrayList = new ArrayList<CCTerm>();
        List<CCTerm> list = new ArrayList<CCTerm>();
        list.add(this.getFuncTerm(functionSymbol));
        int n2 = 0;
        while (n2 <= n) {
            list = CClosure.getApplications(list);
            ++n2;
        }
        for (CCTerm cCTerm : list) {
            assert (cCTerm instanceof CCAppTerm);
            arrayList.add(((CCAppTerm)cCTerm).getArg());
        }
        return arrayList;
    }

    public List<CCTerm> getAllFuncApps(FunctionSymbol functionSymbol) {
        List<CCTerm> list = Collections.singletonList(this.getFuncTerm(functionSymbol));
        int n = 0;
        while (n < functionSymbol.getParameterSorts().length) {
            list = CClosure.getApplications(list);
            ++n;
        }
        return list;
    }

    static List<CCTerm> getApplications(List<CCTerm> list) {
        ArrayList<CCTerm> arrayList = new ArrayList<CCTerm>();
        for (CCTerm cCTerm : list) {
            CCParentInfo cCParentInfo = cCTerm.getRepresentative().mCCPars.getInfo(0);
            if (cCParentInfo == null) continue;
            for (CCAppTerm.Parent parent : cCParentInfo.mCCParents) {
                arrayList.add(parent.getData());
            }
        }
        return arrayList;
    }

    public List<CCTerm> getAllFuncAppsForArg(FunctionSymbol functionSymbol, CCTerm cCTerm, int n) {
        CCTerm cCTerm2 = this.getFuncTerm(functionSymbol);
        int n2 = cCTerm2.mParentPosition + n;
        CCParentInfo cCParentInfo = cCTerm.getRepresentative().mCCPars.getInfo(n2);
        List<CCTerm> list = new ArrayList<CCTerm>();
        if (cCParentInfo != null) {
            for (CCAppTerm.Parent parent : cCParentInfo.mCCParents) {
                if (parent.isMarked()) continue;
                list.add(parent.getData());
            }
            int n3 = n + 1;
            while (n3 < functionSymbol.getParameterSorts().length) {
                list = CClosure.getApplications(list);
                ++n3;
            }
        }
        return list;
    }

    public void insertCompareTrigger(CCTerm cCTerm, CCTerm cCTerm2, CompareTrigger compareTrigger) {
        Object object;
        assert (cCTerm.getRepresentative() != cCTerm2.getRepresentative());
        assert (!compareTrigger.inList());
        while (true) {
            if (cCTerm.mMergeTime > cCTerm2.mMergeTime) {
                object = cCTerm;
                cCTerm = cCTerm2;
                cCTerm2 = object;
            }
            if (cCTerm.mRep == cCTerm) {
                assert (cCTerm2.mRep == cCTerm2);
                object = this.mPairHash.getInfo(cCTerm, cCTerm2);
                if (object == null) {
                    object = new CCTermPairHash.Info(cCTerm, cCTerm2);
                    this.mPairHash.add(object);
                }
                break;
            }
            assert (cCTerm.mRep != cCTerm2);
            boolean bl = false;
            for (CCTermPairHash.Info.Entry entry : cCTerm.mPairInfos) {
                CCTermPairHash.Info info = entry.getInfo();
                if (entry.mOther != cCTerm2) continue;
                info.mCompareTriggers.prependIntoJoined(compareTrigger, false);
                bl = true;
                break;
            }
            if (!bl) {
                CCTermPairHash.Info info = new CCTermPairHash.Info(cCTerm, cCTerm2);
                info.mRhsEntry.unlink();
                info.mCompareTriggers.prependIntoJoined(compareTrigger, false);
            }
            cCTerm = cCTerm.mRep;
        }
        ((CCTermPairHash.Info)object).mCompareTriggers.prependIntoJoined(compareTrigger, true);
    }

    public void removeCompareTrigger(CompareTrigger compareTrigger) {
        Object object;
        CCTerm cCTerm = compareTrigger.getLhs();
        CCTerm cCTerm2 = compareTrigger.getRhs();
        if (!this.mAllTerms.contains(cCTerm) || !this.mAllTerms.contains(cCTerm2)) {
            return;
        }
        while (true) {
            if (cCTerm.mMergeTime > cCTerm2.mMergeTime) {
                object = cCTerm;
                cCTerm = cCTerm2;
                cCTerm2 = object;
            }
            if (cCTerm.mRep == cCTerm) {
                assert (cCTerm2.mRep == cCTerm2);
                object = this.mPairHash.getInfo(cCTerm, cCTerm2);
                assert (object != null);
                break;
            }
            assert (cCTerm.mRep != cCTerm2);
            boolean bl = false;
            for (CCTermPairHash.Info.Entry entry : cCTerm.mPairInfos) {
                CCTermPairHash.Info info = entry.getInfo();
                if (entry.mOther != cCTerm2) continue;
                info.mCompareTriggers.undoPrependIntoJoined(compareTrigger, false);
                bl = true;
                break;
            }
            assert (bl);
            cCTerm = cCTerm.mRep;
        }
        ((CCTermPairHash.Info)object).mCompareTriggers.undoPrependIntoJoined(compareTrigger, true);
    }

    public void insertReverseTrigger(FunctionSymbol functionSymbol, CCTerm cCTerm, int n, ReverseTrigger reverseTrigger) {
        CCParentInfo cCParentInfo;
        CCTerm cCTerm2 = this.getFuncTerm(functionSymbol);
        int n2 = cCTerm2.mParentPosition + n;
        while (cCTerm != cCTerm.mRep) {
            cCParentInfo = cCTerm.mCCPars.createInfo(n2);
            cCParentInfo.mReverseTriggers.prependIntoJoined(reverseTrigger, false);
            cCTerm = cCTerm.mRep;
        }
        cCParentInfo = cCTerm.mCCPars.createInfo(n2);
        cCParentInfo.mReverseTriggers.prependIntoJoined(reverseTrigger, true);
    }

    public void insertReverseTrigger(FunctionSymbol functionSymbol, ReverseTrigger reverseTrigger) {
        CCTerm cCTerm = this.getFuncTerm(functionSymbol);
        CCParentInfo cCParentInfo = cCTerm.mCCPars.createInfo(0);
        cCParentInfo.mReverseTriggers.append(reverseTrigger);
    }

    /*
     * Unable to fully structure code
     */
    public void removeReverseTrigger(ReverseTrigger var1_1) {
        var2_2 = this.getFuncTerm(var1_1.getFunctionSymbol());
        if (var1_1.getArgPosition() < 0) {
            if (!CClosure.$assertionsDisabled && var2_2 != var2_2.mRep) {
                throw new AssertionError();
            }
            var3_3 = var2_2;
            var4_4 = 0;
        } else {
            var3_3 = var1_1.getArgument();
            var4_4 = var2_2.mParentPosition + var1_1.getArgPosition();
        }
        if (this.mAllTerms.contains(var3_3)) ** GOTO lbl15
        return;
lbl-1000:
        // 1 sources

        {
            var5_5 = var3_3.mCCPars.createInfo(var4_4);
            var5_5.mReverseTriggers.undoPrependIntoJoined(var1_1, false);
            var3_3 = var3_3.mRep;
lbl15:
            // 2 sources

            ** while (var3_3 != var3_3.mRep)
        }
lbl16:
        // 1 sources

        var5_5 = var3_3.mCCPars.createInfo(var4_4);
        var5_5.mReverseTriggers.undoPrependIntoJoined(var1_1, true);
    }

    public CCTerm getCCTermRep(Term term) {
        if (this.mAnonTerms.containsKey(term)) {
            return this.mAnonTerms.get(term).getRepresentative();
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            CCTerm cCTerm = this.getFuncTerm(applicationTerm.getFunction()).getRepresentative();
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term2 = termArray[n2];
                CCTerm cCTerm2 = this.getCCTermRep(term2);
                if (cCTerm2 == null) {
                    return null;
                }
                if ((cCTerm = this.findCCAppTermRep(cCTerm, cCTerm2)) == null) {
                    return null;
                }
                ++n2;
            }
            return cCTerm;
        }
        return null;
    }

    private CCTerm findCCAppTermRep(CCTerm cCTerm, CCTerm cCTerm2) {
        CCParentInfo cCParentInfo = cCTerm.mCCPars.getInfo(0);
        if (cCParentInfo == null) {
            return null;
        }
        for (CCAppTerm.Parent parent : cCParentInfo.mCCParents) {
            if (parent.getData().getArg().getRepresentative() != cCTerm2) continue;
            return parent.getData().getRepresentative();
        }
        return null;
    }

    public boolean isEqSet(CCTerm cCTerm, CCTerm cCTerm2) {
        return cCTerm.getRepresentative() == cCTerm2.getRepresentative();
    }

    public boolean isDiseqSet(CCTerm cCTerm, CCTerm cCTerm2) {
        CCTerm cCTerm3;
        CCTerm cCTerm4 = cCTerm.getRepresentative();
        CCTermPairHash.Info info = this.mPairHash.getInfo(cCTerm4, cCTerm3 = cCTerm2.getRepresentative());
        return info != null && info.mDiseq != null;
    }

    public void insertEqualityEntry(CCTerm cCTerm, CCTerm cCTerm2, CCEquality.Entry entry) {
        while (true) {
            Object object;
            if (cCTerm.mMergeTime > cCTerm2.mMergeTime) {
                object = cCTerm;
                cCTerm = cCTerm2;
                cCTerm2 = object;
            }
            if (cCTerm.mRep == cCTerm) {
                assert (cCTerm2.mRep == cCTerm2);
                object = this.mPairHash.getInfo(cCTerm, cCTerm2);
                if (object == null) {
                    object = new CCTermPairHash.Info(cCTerm, cCTerm2);
                    this.mPairHash.add(object);
                }
                ((CCTermPairHash.Info)object).mEqlits.prependIntoJoined(entry, true);
                break;
            }
            boolean bl = cCTerm.mRep == cCTerm2;
            boolean bl2 = false;
            for (CCTermPairHash.Info.Entry entry2 : cCTerm.mPairInfos) {
                CCTermPairHash.Info info = entry2.getInfo();
                if (entry2.mOther != cCTerm2) continue;
                info.mEqlits.prependIntoJoined(entry, bl);
                bl2 = true;
                break;
            }
            if (!bl2) {
                CCTermPairHash.Info info = new CCTermPairHash.Info(cCTerm, cCTerm2);
                info.mRhsEntry.unlink();
                info.mEqlits.prependIntoJoined(entry, bl);
            }
            if (bl) break;
            cCTerm = cCTerm.mRep;
        }
    }

    public CCEquality createCCEquality(int n, CCTerm cCTerm, CCTerm cCTerm2) {
        Object object;
        assert (cCTerm != cCTerm2);
        CCEquality cCEquality = null;
        assert (cCTerm.invariant());
        assert (cCTerm2.invariant());
        if (cCTerm2.getFlatTerm().getSort().isNumericSort() && cCTerm2.getFlatTerm() instanceof ConstantTerm) {
            object = cCTerm2;
            cCTerm2 = cCTerm;
            cCTerm = object;
        }
        cCEquality = new CCEquality(n, cCTerm, cCTerm2);
        this.insertEqualityEntry(cCTerm, cCTerm2, cCEquality.getEntry());
        this.getEngine().addAtom(cCEquality);
        assert (cCTerm.invariant());
        assert (cCTerm2.invariant());
        assert (cCTerm.pairHashValid(this));
        assert (cCTerm2.pairHashValid(this));
        if (cCTerm.mRepStar == cCTerm2.mRepStar) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("CC-Prop: " + String.valueOf(cCEquality) + " repStar: " + String.valueOf(cCTerm.mRepStar));
            }
            this.mPendingLits.add(cCEquality);
            this.mRecheckOnBacktrackLits.add(cCEquality);
        } else {
            object = this.mPairHash.getInfo((CCTerm)cCTerm.mRepStar, (CCTerm)cCTerm2.mRepStar).mDiseq;
            if (object != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("CC-Prop: " + String.valueOf(cCEquality.negate()) + " diseq: " + String.valueOf(object));
                }
                cCEquality.mDiseqReason = object;
                this.mPendingLits.add(cCEquality.negate());
                this.mRecheckOnBacktrackLits.add(cCEquality.negate());
            }
        }
        return cCEquality;
    }

    public void addTerm(CCTerm cCTerm, Term term) {
        cCTerm.mFlatTerm = term;
    }

    public void addSharedTerm(CCTerm cCTerm) {
        cCTerm.share(this);
    }

    @Override
    public Clause computeConflictClause() {
        Clause clause = this.checkpoint();
        if (clause == null) {
            clause = this.checkpoint();
        }
        assert (this.mPendingCongruences.isEmpty());
        return clause;
    }

    @Override
    public Literal getPropagatedLiteral() {
        Literal literal = this.mPendingLits.poll();
        assert (literal == null || this.checkPending(literal));
        return literal;
    }

    @Override
    public Clause getUnitClause(Literal literal) {
        if (literal.getAtom() instanceof LAEquality) {
            LAEquality lAEquality = (LAEquality)literal.getAtom();
            for (CCEquality cCEquality : lAEquality.getDependentEqualities()) {
                if (cCEquality.getStackPosition() < 0 || cCEquality.getStackPosition() >= lAEquality.getStackPosition() || cCEquality.getDecideStatus().getSign() != literal.getSign()) continue;
                return new Clause(new Literal[]{cCEquality.getDecideStatus().negate(), literal}, new LeafNode(-6, EQAnnotation.EQ));
            }
            throw new AssertionError((Object)("Cannot find explanation for " + String.valueOf(lAEquality)));
        }
        if (literal instanceof CCEquality) {
            CCEquality cCEquality = (CCEquality)literal;
            return this.computeCycle(cCEquality);
        }
        CCEquality cCEquality = (CCEquality)literal.negate();
        return this.computeAntiCycle(cCEquality);
    }

    @Override
    public int checkCompleteness() {
        return 0;
    }

    void recordMerge(CCTerm cCTerm) {
        this.mUndoStack.push(new MergeUndoInfo(cCTerm));
    }

    int getMergeDepth() {
        return this.mUndoStack.size();
    }

    @Override
    public Clause setLiteral(Literal literal) {
        Object object;
        if (!(literal.getAtom() instanceof CCEquality)) {
            return null;
        }
        CCEquality cCEquality = (CCEquality)literal.getAtom();
        if (literal == cCEquality) {
            if (cCEquality.getLhs().mRepStar != cCEquality.getRhs().mRepStar && (object = cCEquality.getLhs().merge(this, cCEquality.getRhs(), cCEquality)) != null) {
                return object;
            }
        } else {
            Clause clause;
            object = cCEquality.getLhs().mRepStar;
            CCTerm cCTerm = cCEquality.getRhs().mRepStar;
            if (object == cCTerm && (clause = this.computeCycle(cCEquality)) != null) {
                return clause;
            }
            this.separate((CCTerm)object, cCTerm, cCEquality);
        }
        if ((object = cCEquality.getLASharedData()) != null) {
            assert (((List)((LAEquality)object).getDependentEqualities()).contains(cCEquality));
            if (((DPLLAtom)object).getDecideStatus() != null && ((DPLLAtom)object).getDecideStatus().getSign() != literal.getSign()) {
                return new Clause(new Literal[]{((DPLLAtom)object).getDecideStatus().negate(), literal.negate()}, new LeafNode(-6, EQAnnotation.EQ));
            }
            this.mPendingLits.add((Literal)(literal == cCEquality ? object : ((Literal)object).negate()));
        }
        return null;
    }

    @Override
    public void backtrackLiteral(Literal literal) {
    }

    void removePairHash(CCTermPairHash.Info info) {
        this.mPairHash.remove(info);
    }

    private void separate(CCTerm cCTerm, CCTerm cCTerm2, CCEquality cCEquality) {
        CCEquality cCEquality2 = cCEquality.mDiseqReason;
        if (cCEquality2 != null && cCEquality2.getDecideStatus() == cCEquality2.negate()) {
            if (cCEquality2.getLhs().getRepresentative() == cCTerm && cCEquality2.getRhs().getRepresentative() == cCTerm2) {
                return;
            }
            if (cCEquality2.getLhs().getRepresentative() == cCTerm2 && cCEquality2.getRhs().getRepresentative() == cCTerm) {
                return;
            }
        }
        CCTermPairHash.Info info = this.mPairHash.getInfo(cCTerm, cCTerm2);
        assert (info.mDiseq == null);
        this.mUndoStack.push(new SepUndoInfo(cCEquality));
        info.mDiseq = cCEquality;
        for (CCEquality.Entry entry : info.mEqlits) {
            CCEquality cCEquality3 = entry.getCCEquality();
            assert (cCEquality3.getDecideStatus() == null || cCEquality3 == cCEquality);
            if (cCEquality3.getDecideStatus() != null) continue;
            cCEquality3.mDiseqReason = cCEquality;
            this.addPending(cCEquality3.negate());
        }
    }

    private void undoSep(CCEquality cCEquality) {
        CCTermPairHash.Info info = this.mPairHash.getInfo(cCEquality.getLhs().mRepStar, cCEquality.getRhs().mRepStar);
        assert (info != null && info.mDiseq == cCEquality);
        info.mDiseq = null;
    }

    public Clause computeCycle(CCEquality cCEquality) {
        CongruencePath congruencePath = new CongruencePath(this);
        Clause clause = congruencePath.computeCycle(cCEquality, this.isProofGenerationEnabled());
        assert (clause.getSize() != 2 || clause.getLiteral(0).negate() != clause.getLiteral(1));
        return clause;
    }

    public Clause computeCycle(CCTerm cCTerm, CCTerm cCTerm2) {
        CongruencePath congruencePath = new CongruencePath(this);
        return congruencePath.computeCycle(cCTerm, cCTerm2, this.isProofGenerationEnabled());
    }

    public Clause computeAntiCycle(CCEquality cCEquality) {
        CCTerm cCTerm = cCEquality.getLhs();
        CCTerm cCTerm2 = cCEquality.getRhs();
        CCEquality cCEquality2 = cCEquality.mDiseqReason;
        assert (cCTerm.mRepStar != cCTerm2.mRepStar);
        assert (cCEquality2.getLhs().mRepStar == cCTerm.mRepStar || cCEquality2.getLhs().mRepStar == cCTerm2.mRepStar);
        assert (cCEquality2.getRhs().mRepStar == cCTerm.mRepStar || cCEquality2.getRhs().mRepStar == cCTerm2.mRepStar);
        cCTerm.invertEqualEdges(this);
        cCTerm.mEqualEdge = cCTerm2;
        cCTerm.mOldRep = cCTerm.mRepStar;
        assert (cCTerm.mOldRep.mReasonLiteral == null);
        cCTerm.mOldRep.mReasonLiteral = cCEquality;
        Clause clause = this.computeCycle(cCEquality2);
        assert (cCTerm.mEqualEdge == cCTerm2 && cCTerm.mOldRep == cCTerm.mRepStar);
        cCTerm.mOldRep.mReasonLiteral = null;
        cCTerm.mOldRep = null;
        cCTerm.mEqualEdge = null;
        return clause;
    }

    public int getDecideLevelForPath(CCTerm cCTerm, CCTerm cCTerm2) {
        CongruencePath congruencePath = new CongruencePath(this);
        return congruencePath.computeDecideLevel(cCTerm, cCTerm2);
    }

    public void addPending(Literal literal) {
        assert (this.checkPending(literal));
        this.mPendingLits.add(literal);
    }

    private boolean checkPending(Literal literal) {
        if (literal.negate() instanceof CCEquality) {
            CCEquality cCEquality = (CCEquality)literal.negate();
            CCTerm cCTerm = cCEquality.getLhs();
            CCTerm cCTerm2 = cCEquality.getRhs();
            CCEquality cCEquality2 = cCEquality.mDiseqReason;
            assert (cCTerm.mRepStar != cCTerm2.mRepStar);
            assert (cCEquality2.getLhs().mRepStar == cCTerm.mRepStar || cCEquality2.getLhs().mRepStar == cCTerm2.mRepStar);
            assert (cCEquality2.getRhs().mRepStar == cCTerm.mRepStar || cCEquality2.getRhs().mRepStar == cCTerm2.mRepStar);
            return true;
        }
        if (literal instanceof CCEquality) {
            CCEquality cCEquality = (CCEquality)literal;
            return cCEquality.getLhs().mRepStar == cCEquality.getRhs().mRepStar;
        }
        if (literal.getAtom() instanceof LAEquality) {
            LAEquality lAEquality = (LAEquality)literal.getAtom();
            for (CCEquality cCEquality : lAEquality.getDependentEqualities()) {
                if (cCEquality.getDecideStatus() == null || cCEquality.getDecideStatus().getSign() != literal.getSign()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Clause checkpoint() {
        return this.buildCongruence();
    }

    public CCEquality createEquality(CCTerm cCTerm, CCTerm cCTerm2, boolean bl) {
        CCEquality cCEquality;
        DPLLAtom dPLLAtom;
        assert (cCTerm != cCTerm2);
        EqualityProxy equalityProxy = this.mClausifier.createEqualityProxy(cCTerm.getFlatTerm(), cCTerm2.getFlatTerm(), null);
        if (equalityProxy == EqualityProxy.getFalseProxy()) {
            return null;
        }
        if (!bl && (dPLLAtom = equalityProxy.getLiteral(null)) instanceof CCEquality && ((cCEquality = (CCEquality)dPLLAtom).getLhs() == cCTerm && cCEquality.getRhs() == cCTerm2 || cCEquality.getLhs() == cCTerm2 && cCEquality.getRhs() == cCTerm)) {
            return cCEquality;
        }
        return equalityProxy.createCCEquality(cCTerm.getFlatTerm(), cCTerm2.getFlatTerm());
    }

    @Override
    public void dumpModel(LogProxy logProxy) {
        logProxy.info("Equivalence Classes:");
        for (CCTerm cCTerm : this.mAllTerms) {
            if (cCTerm != cCTerm.mRepStar || cCTerm.isFunc()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            for (CCTerm cCTerm2 : cCTerm.mMembers) {
                stringBuilder.append(string).append(cCTerm2);
                string = "=";
            }
            logProxy.info(stringBuilder.toString());
        }
    }

    private boolean checkCongruence() {
        for (CCTerm cCTerm : this.mAllTerms) {
            assert (cCTerm.invariant());
            if (!(cCTerm instanceof CCAppTerm)) continue;
            CCAppTerm cCAppTerm = (CCAppTerm)cCTerm;
            boolean bl = true;
            for (CCTerm cCTerm2 : this.mAllTerms) {
                if (bl) {
                    if (cCTerm != cCTerm2) continue;
                    bl = false;
                    continue;
                }
                if (cCTerm.getRepresentative() == cCTerm2.getRepresentative() || !(cCTerm2 instanceof CCAppTerm)) continue;
                CCAppTerm cCAppTerm2 = (CCAppTerm)cCTerm2;
                if (cCAppTerm.getFunc().getRepresentative() != cCAppTerm2.getFunc().getRepresentative() || cCAppTerm.getArg().getRepresentative() != cCAppTerm2.getArg().getRepresentative()) continue;
                this.getLogger().fatal("Should be congruent: " + String.valueOf(cCTerm) + " and " + String.valueOf(cCTerm2));
                return false;
            }
        }
        return true;
    }

    @Override
    public void printStatistics(LogProxy logProxy) {
        logProxy.info("CCTimes: iE " + this.mInvertEdgeTime + " eq " + this.mEqTime + " cc " + this.mCcTime + " setRep " + this.mSetRepTime);
        logProxy.info("Merges: " + this.mMergeCount + ", cc:" + this.mCcCount);
    }

    @Override
    public Literal getSuggestion() {
        return null;
    }

    @Override
    public void decreasedDecideLevel(int n) {
        int n2 = this.mDecideLevelToUndoStackSize.pop();
        assert (this.mDecideLevelToUndoStackSize.size() == n);
        this.backtrackStack(n2);
    }

    @Override
    public void increasedDecideLevel(int n) {
        this.mDecideLevelToUndoStackSize.push(this.mUndoStack.size());
        assert (this.mDecideLevelToUndoStackSize.size() == n);
    }

    @Override
    public void backtrackStart() {
        this.mPendingLits.clear();
        this.mPendingCongruences.clear();
    }

    @Override
    public Clause backtrackComplete() {
        CCTerm cCTerm;
        Object object;
        ArrayQueue<Literal> arrayQueue = new ArrayQueue<Literal>();
        for (Literal literal : this.mRecheckOnBacktrackLits) {
            CCEquality cCEquality = (CCEquality)literal.getAtom();
            if (cCEquality.getDecideStatus() != null) {
                arrayQueue.add(literal);
                object = cCEquality.getLASharedData();
                if (object == null || ((DPLLAtom)object).getDecideStatus() != null) continue;
                this.getLogger().debug("repropagating LAEQ: %s -> %s", cCEquality, object);
                this.mPendingLits.add((Literal)(literal == cCEquality ? object : ((Literal)object).negate()));
                continue;
            }
            object = cCEquality.getLhs().getRepresentative();
            cCTerm = cCEquality.getRhs().getRepresentative();
            boolean bl = false;
            if (literal.getSign() > 0) {
                bl = object == cCTerm;
            } else {
                CCEquality cCEquality2 = this.mPairHash.getInfo((CCTerm)object, (CCTerm)cCTerm).mDiseq;
                if (cCEquality2 != null) {
                    cCEquality.mDiseqReason = cCEquality2;
                    bl = true;
                }
            }
            if (!bl) continue;
            this.getLogger().debug("CC-ReProp: %s", literal);
            this.mPendingLits.add(literal);
            arrayQueue.add(literal);
        }
        this.mRecheckOnBacktrackLits = arrayQueue;
        ArrayQueue<SymmetricPair> arrayQueue2 = new ArrayQueue<SymmetricPair>();
        for (SymmetricPair symmetricPair : this.mRecheckOnBacktrackCongs) {
            object = (CCAppTerm)symmetricPair.getFirst();
            cCTerm = (CCAppTerm)symmetricPair.getSecond();
            if (((CCAppTerm)object).mArg.mRepStar == ((CCAppTerm)cCTerm).mArg.mRepStar && ((CCAppTerm)object).mFunc.mRepStar == ((CCAppTerm)cCTerm).mFunc.mRepStar) {
                this.getLogger().debug("Still congruent: %s and %s", object, cCTerm);
                this.addPendingCongruence((CCAppTerm)object, (CCAppTerm)cCTerm);
                arrayQueue2.add(symmetricPair);
                continue;
            }
            this.getLogger().debug("No longer congruent: %s and %s", object, cCTerm);
        }
        this.mRecheckOnBacktrackCongs = arrayQueue2;
        return this.buildCongruence();
    }

    @Override
    public void restart(int n) {
    }

    @Override
    public Clause startCheck() {
        return null;
    }

    @Override
    public void endCheck() {
    }

    void addPendingCongruence(CCAppTerm cCAppTerm, CCAppTerm cCAppTerm2) {
        assert (cCAppTerm.mLeftParInfo.inList() && cCAppTerm2.mLeftParInfo.inList());
        assert (cCAppTerm.mRightParInfo.inList() && cCAppTerm2.mRightParInfo.inList());
        this.getLogger().debug("addPendingCongruence: %s %s", cCAppTerm, cCAppTerm2);
        this.mPendingCongruences.add(new SymmetricPair<CCAppTerm>(cCAppTerm, cCAppTerm2));
    }

    private Clause buildCongruence() {
        SymmetricPair<CCAppTerm> symmetricPair;
        while ((symmetricPair = this.mPendingCongruences.poll()) != null) {
            this.getLogger().debug("PC %s", symmetricPair);
            CCAppTerm cCAppTerm = symmetricPair.getFirst();
            CCAppTerm cCAppTerm2 = symmetricPair.getSecond();
            assert (cCAppTerm.mArg.mRepStar == cCAppTerm2.mArg.mRepStar && cCAppTerm.mFunc.mRepStar == cCAppTerm2.mFunc.mRepStar) : "Unchecked buildCongruence with non-holding congruence!";
            Clause clause = cCAppTerm.merge(this, cCAppTerm2, null);
            if (clause == null) continue;
            this.getLogger().debug("buildCongruence: conflict %s", clause);
            return clause;
        }
        return null;
    }

    private void backtrackStack(int n) {
        while (this.mUndoStack.size() > n) {
            Object object;
            UndoInfo undoInfo = this.mUndoStack.pop();
            if (undoInfo instanceof MergeUndoInfo) {
                object = ((MergeUndoInfo)undoInfo).getOldRep();
                ((CCTerm)object).mRepStar.invertEqualEdges(this);
                ((CCTerm)object).undoMerge(this, ((CCTerm)object).mEqualEdge);
                continue;
            }
            object = ((SepUndoInfo)undoInfo).getDiseq();
            this.undoSep((CCEquality)object);
        }
    }

    public int getStackDepth() {
        return this.mUndoStack.size();
    }

    @Override
    public void removeAtom(DPLLAtom dPLLAtom) {
        if (dPLLAtom instanceof CCEquality) {
            CCEquality cCEquality = (CCEquality)dPLLAtom;
            this.removeCCEquality(cCEquality.getLhs(), cCEquality.getRhs(), cCEquality);
        }
    }

    private void removeCCEquality(CCTerm cCTerm, CCTerm cCTerm2, CCEquality cCEquality) {
        Object object;
        if (cCTerm.mMergeTime > cCTerm2.mMergeTime) {
            object = cCTerm;
            cCTerm = cCTerm2;
            cCTerm2 = object;
        }
        if (cCTerm.mRep == cCTerm) {
            assert (cCTerm2.mRep == cCTerm2);
            object = this.mPairHash.getInfo(cCTerm, cCTerm2);
            if (object != null) {
                ((CCTermPairHash.Info)object).mEqlits.prepareRemove(cCEquality.getEntry());
                cCEquality.getEntry().removeFromList();
                if (((CCTermPairHash.Info)object).isEmpty()) {
                    this.mPairHash.removePairInfo((CCTermPairHash.Info)object);
                }
            }
        } else {
            boolean bl = cCTerm.mRep == cCTerm2;
            boolean bl2 = false;
            for (CCTermPairHash.Info.Entry entry : cCTerm.mPairInfos) {
                CCTermPairHash.Info info = entry.getInfo();
                if (entry.mOther != cCTerm2) continue;
                info.mEqlits.prepareRemove(cCEquality.getEntry());
                bl2 = true;
                break;
            }
            assert (bl2);
            if (bl) {
                cCEquality.getEntry().removeFromList();
            } else {
                this.removeCCEquality(cCTerm.mRep, cCTerm2, cCEquality);
            }
        }
        if (cCEquality.getLASharedData() != null) {
            cCEquality.getLASharedData().removeDependentAtom(cCEquality);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void removeTerm(CCTerm var1_1) {
        if (!CClosure.$assertionsDisabled && var1_1.mRepStar != var1_1) {
            throw new AssertionError();
        }
        if (CClosure.$assertionsDisabled || this.mPendingCongruences.isEmpty()) ** GOTO lbl7
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            var2_2 = var1_1.mPairInfos.iterator().next().getInfo();
            this.mPairHash.removePairInfo((CCTermPairHash.Info)var2_2);
lbl7:
            // 2 sources

            ** while (!var1_1.mPairInfos.isEmpty())
        }
lbl8:
        // 1 sources

        if (var1_1 instanceof CCAppTerm) {
            var2_2 = (CCAppTerm)var1_1;
            var2_2.unlinkParentInfos();
        }
    }

    @Override
    public void backtrackAll() {
        assert (this.mDecideLevelToUndoStackSize.isEmpty());
        this.backtrackStack(0);
        this.mPendingLits.clear();
        this.mRecheckOnBacktrackCongs.clear();
        this.mRecheckOnBacktrackLits.clear();
        this.mPendingCongruences.clear();
    }

    @Override
    public void pop() {
        assert (this.mDecideLevelToUndoStackSize.isEmpty());
        assert (this.mUndoStack.isEmpty());
        assert (this.mRecheckOnBacktrackCongs.isEmpty());
        assert (this.mRecheckOnBacktrackLits.isEmpty());
        assert (this.mPendingCongruences.isEmpty());
        this.mNumFunctionPositions = this.mNumFunctionPositionsStack.remove(this.mNumFunctionPositionsStack.size() - 1);
        for (CCTerm cCTerm : this.mAllTerms.currentScope()) {
            this.removeTerm(cCTerm);
        }
        this.mAllTerms.endScope();
        this.mSymbolicTerms.endScope();
    }

    @Override
    public void push() {
        this.mSymbolicTerms.beginScope();
        this.mAllTerms.beginScope();
        this.mNumFunctionPositionsStack.add(this.mNumFunctionPositions);
    }

    @Override
    public Object[] getStatistics() {
        return new Object[]{":CC", new Object[][]{{"Merges", this.mMergeCount}, {"Closure", this.mCcCount}, {"Times", new Object[][]{{"Invert", this.mInvertEdgeTime}, {"Eq", this.mEqTime}, {"Closure", this.mCcTime}, {"SetRep", this.mSetRepTime}}}}};
    }

    public void fillInModel(Model model, Theory theory, SharedTermEvaluator sharedTermEvaluator, ArrayTheory arrayTheory, DataTypeTheory dataTypeTheory) {
        CCTerm cCTerm = this.mClausifier.getCCTerm((Term)theory.mTrue);
        CCTerm cCTerm2 = this.mClausifier.getCCTerm((Term)theory.mFalse);
        new ModelBuilder(this, this.mAllTerms, model, theory, sharedTermEvaluator, arrayTheory, dataTypeTheory, cCTerm, cCTerm2);
    }

    void addInvertEdgeTime(long l) {
        this.mInvertEdgeTime += l;
    }

    void addEqTime(long l) {
        this.mEqTime += l;
    }

    void addCcTime(long l) {
        this.mCcTime += l;
    }

    void addSetRepTime(long l) {
        this.mSetRepTime += l;
    }

    void incCcCount() {
        ++this.mCcCount;
    }

    void incMergeCount() {
        ++this.mMergeCount;
    }

    private static class MergeUndoInfo
    extends UndoInfo {
        final CCTerm mOldRep;

        public MergeUndoInfo(CCTerm cCTerm) {
            this.mOldRep = cCTerm;
        }

        public CCTerm getOldRep() {
            return this.mOldRep;
        }
    }

    private static class SepUndoInfo
    extends UndoInfo {
        CCEquality mDiseq;

        public SepUndoInfo(CCEquality cCEquality) {
            this.mDiseq = cCEquality;
        }

        public CCEquality getDiseq() {
            return this.mDiseq;
        }
    }

    private static class UndoInfo {
        private UndoInfo() {
        }
    }
}

