/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCAppTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CCTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.CClosure;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.cclosure.DataTypeLemma;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.SymmetricPair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class CongruencePath {
    final CClosure mClosure;
    final HashMap<SymmetricPair<CCTerm>, SubPath> mVisited;
    final ArrayDeque<SubPath> mAllPaths;
    final ArrayDeque<SymmetricPair<CCTerm>> mTodo;
    final Set<Literal> mAllLiterals;

    public CongruencePath(CClosure cClosure) {
        this.mClosure = cClosure;
        this.mVisited = new HashMap();
        this.mAllLiterals = new LinkedHashSet<Literal>();
        this.mTodo = new ArrayDeque();
        this.mAllPaths = new ArrayDeque();
    }

    private CCAnnotation createAnnotation(SymmetricPair<CCTerm> symmetricPair) {
        return new CCAnnotation(symmetricPair, this.mAllPaths, CCAnnotation.RuleKind.CONG);
    }

    private int computeDepth(CCTerm cCTerm) {
        int n = 0;
        while (cCTerm.mEqualEdge != null) {
            cCTerm = cCTerm.mEqualEdge;
            ++n;
        }
        return n;
    }

    private void computeCCPath(CCAppTerm cCAppTerm, CCAppTerm cCAppTerm2) {
        while (true) {
            this.mTodo.addFirst(new SymmetricPair<CCTerm>(cCAppTerm.mArg, cCAppTerm2.mArg));
            if (cCAppTerm.mFunc == cCAppTerm2.mFunc) break;
            cCAppTerm = (CCAppTerm)cCAppTerm.mFunc;
            cCAppTerm2 = (CCAppTerm)cCAppTerm2.mFunc;
        }
    }

    private SubPath computePathTo(CCTerm cCTerm, CCTerm cCTerm2) {
        SubPath subPath = new SubPath(cCTerm, this.mClosure.isProofGenerationEnabled());
        CCTerm cCTerm3 = cCTerm;
        while (cCTerm != cCTerm2) {
            if (cCTerm.mOldRep.mReasonLiteral != null) {
                if (cCTerm3 != cCTerm) {
                    this.computeCCPath((CCAppTerm)cCTerm3, (CCAppTerm)cCTerm);
                    subPath.addEntry(cCTerm, null);
                }
                subPath.addEntry(cCTerm.mEqualEdge, cCTerm.mOldRep.mReasonLiteral);
                this.mAllLiterals.add(cCTerm.mOldRep.mReasonLiteral);
                cCTerm3 = cCTerm.mEqualEdge;
            }
            cCTerm = cCTerm.mEqualEdge;
        }
        assert (cCTerm3 == cCTerm);
        return subPath;
    }

    SubPath computePathNonRecursive(CCTerm cCTerm, CCTerm cCTerm2) {
        if (cCTerm == cCTerm2) {
            return null;
        }
        SymmetricPair<CCTerm> symmetricPair = new SymmetricPair<CCTerm>(cCTerm, cCTerm2);
        if (this.mVisited.containsKey(symmetricPair)) {
            return this.mVisited.get(symmetricPair);
        }
        int n = this.computeDepth(cCTerm);
        int n2 = this.computeDepth(cCTerm2);
        CCTerm cCTerm3 = cCTerm;
        CCTerm cCTerm4 = cCTerm2;
        CCTerm cCTerm5 = cCTerm3;
        CCTerm cCTerm6 = cCTerm4;
        while (n > n2) {
            if (cCTerm3.mOldRep.mReasonLiteral != null) {
                cCTerm5 = cCTerm3.mEqualEdge;
            }
            cCTerm3 = cCTerm3.mEqualEdge;
            --n;
        }
        while (n2 > n) {
            if (cCTerm4.mOldRep.mReasonLiteral != null) {
                cCTerm6 = cCTerm4.mEqualEdge;
            }
            cCTerm4 = cCTerm4.mEqualEdge;
            --n2;
        }
        while (cCTerm3 != cCTerm4) {
            if (cCTerm3.mOldRep.mReasonLiteral != null) {
                cCTerm5 = cCTerm3.mEqualEdge;
            }
            if (cCTerm4.mOldRep.mReasonLiteral != null) {
                cCTerm6 = cCTerm4.mEqualEdge;
            }
            cCTerm3 = cCTerm3.mEqualEdge;
            cCTerm4 = cCTerm4.mEqualEdge;
        }
        assert (cCTerm3 != null);
        SubPath subPath = this.computePathTo(cCTerm, cCTerm5);
        if (cCTerm5 != cCTerm6) {
            this.computeCCPath((CCAppTerm)cCTerm5, (CCAppTerm)cCTerm6);
            subPath.addEntry(cCTerm6, null);
        }
        SubPath subPath2 = this.computePathTo(cCTerm2, cCTerm6);
        subPath.addSubPath(subPath2);
        this.mVisited.put(symmetricPair, subPath);
        return subPath;
    }

    public void computePath(CCTerm cCTerm, CCTerm cCTerm2) {
        HashSet<SymmetricPair<CCTerm>> hashSet = new HashSet<SymmetricPair<CCTerm>>();
        this.mTodo.add(new SymmetricPair<CCTerm>(cCTerm, cCTerm2));
        while (!this.mTodo.isEmpty()) {
            SymmetricPair<CCTerm> symmetricPair = this.mTodo.removeFirst();
            if (symmetricPair.getFirst() == symmetricPair.getSecond()) continue;
            SubPath subPath = this.mVisited.get(symmetricPair);
            if (subPath == null) {
                this.mTodo.addFirst(symmetricPair);
                this.computePathNonRecursive(symmetricPair.getFirst(), symmetricPair.getSecond());
                continue;
            }
            if (!hashSet.add(symmetricPair)) continue;
            this.mAllPaths.addFirst(subPath);
        }
    }

    public Clause computeCycle(CCEquality cCEquality, boolean bl) {
        CCTerm cCTerm = cCEquality.getLhs();
        CCTerm cCTerm2 = cCEquality.getRhs();
        this.computePath(cCEquality.getLhs(), cCEquality.getRhs());
        Literal[] literalArray = new Literal[this.mAllLiterals.size() + 1];
        int n = 0;
        literalArray[n++] = cCEquality;
        for (Literal object2 : this.mAllLiterals) {
            literalArray[n++] = object2.negate();
        }
        Clause clause = new Clause(literalArray);
        if (bl) {
            clause.setProof(new LeafNode(-3, this.createAnnotation(new SymmetricPair<CCTerm>(cCTerm, cCTerm2))));
        }
        return clause;
    }

    public Clause computeCycle(CCTerm cCTerm, CCTerm cCTerm2, boolean bl) {
        this.mClosure.getLogger().debug("computeCycle for Constants");
        this.computePath(cCTerm, cCTerm2);
        Literal[] literalArray = new Literal[this.mAllLiterals.size()];
        int n = 0;
        for (Literal object2 : this.mAllLiterals) {
            literalArray[n++] = object2.negate();
        }
        Clause clause = new Clause(literalArray);
        if (bl) {
            clause.setProof(new LeafNode(-3, this.createAnnotation(new SymmetricPair<CCTerm>(cCTerm, cCTerm2))));
        }
        return clause;
    }

    public Clause computeDTLemma(CCEquality cCEquality, DataTypeLemma dataTypeLemma, boolean bl) {
        Literal[] literalArray;
        Object object = dataTypeLemma.getReason();
        int n = ((SymmetricPair<CCTerm>[])object).length;
        int n2 = 0;
        while (n2 < n) {
            literalArray = object[n2];
            this.computePath(literalArray.getFirst(), (CCTerm)literalArray.getSecond());
            ++n2;
        }
        literalArray = new Literal[this.mAllLiterals.size() + (cCEquality != null ? 1 : 0)];
        n2 = 0;
        if (cCEquality != null) {
            literalArray[n2++] = cCEquality;
        }
        for (Literal literal : this.mAllLiterals) {
            literalArray[n2++] = literal.negate();
        }
        Clause clause = new Clause(literalArray);
        if (bl) {
            object = dataTypeLemma.getMainEquality();
            clause.setProof(new LeafNode(-8, new CCAnnotation((SymmetricPair<CCTerm>)object, this.mAllPaths, dataTypeLemma)));
        }
        return clause;
    }

    public int computeDecideLevel(CCTerm cCTerm, CCTerm cCTerm2) {
        this.computePath(cCTerm, cCTerm2);
        int n = 0;
        for (Literal literal : this.mAllLiterals) {
            n = Math.max(n, literal.getAtom().getDecideLevel());
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CongruencePath[");
        stringBuilder.append(this.mAllLiterals.toString());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static class SubPath {
        ArrayList<CCTerm> mTermsOnPath;

        public SubPath(CCTerm cCTerm) {
            this(cCTerm, true);
        }

        public SubPath(CCTerm cCTerm, boolean bl) {
            if (bl) {
                this.mTermsOnPath = new ArrayList();
                this.mTermsOnPath.add(cCTerm);
            }
        }

        public CCTerm[] getTerms() {
            return this.mTermsOnPath.toArray(new CCTerm[this.mTermsOnPath.size()]);
        }

        public void addEntry(CCTerm cCTerm, CCEquality cCEquality) {
            if (this.mTermsOnPath != null) {
                this.mTermsOnPath.add(cCTerm);
            }
        }

        public void addSubPath(SubPath subPath) {
            block5: {
                if (this.mTermsOnPath == null || subPath == null) break block5;
                if (subPath.mTermsOnPath.get(0) == this.mTermsOnPath.get(this.mTermsOnPath.size() - 1)) {
                    int n = 1;
                    while (n < subPath.mTermsOnPath.size()) {
                        this.mTermsOnPath.add(subPath.mTermsOnPath.get(n));
                        ++n;
                    }
                } else {
                    assert (subPath.mTermsOnPath.get(subPath.mTermsOnPath.size() - 1) == this.mTermsOnPath.get(this.mTermsOnPath.size() - 1));
                    int n = subPath.mTermsOnPath.size() - 2;
                    while (n >= 0) {
                        this.mTermsOnPath.add(subPath.mTermsOnPath.get(n));
                        --n;
                    }
                }
            }
        }

        public String toString() {
            return this.mTermsOnPath.toString();
        }
    }
}

