/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitesimalNumber;

public class InfinitesimalNumber
implements Comparable<InfinitesimalNumber> {
    public final Rational mReal;
    public final int mEps;
    public static final InfinitesimalNumber POSITIVE_INFINITY = new InfinitesimalNumber(Rational.POSITIVE_INFINITY, 0);
    public static final InfinitesimalNumber NEGATIVE_INFINITY = new InfinitesimalNumber(Rational.NEGATIVE_INFINITY, 0);
    public static final InfinitesimalNumber ZERO = new InfinitesimalNumber(Rational.ZERO, 0);
    public static final InfinitesimalNumber ONE = new InfinitesimalNumber(Rational.ONE, 0);
    public static final InfinitesimalNumber EPSILON = new InfinitesimalNumber(Rational.ZERO, 1);

    public InfinitesimalNumber() {
        this(Rational.ZERO, 0);
    }

    public InfinitesimalNumber(Rational rational, int n) {
        this.mReal = rational;
        this.mEps = n;
    }

    static int normEpsilon(int n) {
        return Integer.signum(n);
    }

    public InfinitesimalNumber add(InfinitesimalNumber infinitesimalNumber) {
        return new InfinitesimalNumber(this.mReal.add(infinitesimalNumber.mReal), InfinitesimalNumber.normEpsilon(this.mEps + infinitesimalNumber.mEps));
    }

    public InfinitesimalNumber sub(InfinitesimalNumber infinitesimalNumber) {
        return new InfinitesimalNumber(this.mReal.sub(infinitesimalNumber.mReal), InfinitesimalNumber.normEpsilon(this.mEps - infinitesimalNumber.mEps));
    }

    public ExactInfinitesimalNumber sub(ExactInfinitesimalNumber exactInfinitesimalNumber) {
        return new ExactInfinitesimalNumber(this.mReal.sub(exactInfinitesimalNumber.getRealValue()), Rational.valueOf((long)this.mEps, (long)1L).sub(exactInfinitesimalNumber.getEpsilon()));
    }

    public InfinitesimalNumber mul(Rational rational) {
        return new InfinitesimalNumber(this.mReal.mul(rational), this.mEps * rational.signum());
    }

    public InfinitesimalNumber div(Rational rational) {
        return new InfinitesimalNumber(this.mReal.div(rational), this.mEps * rational.signum());
    }

    public InfinitesimalNumber abs() {
        if (this.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public InfinitesimalNumber negate() {
        return new InfinitesimalNumber(this.mReal.negate(), -this.mEps);
    }

    public InfinitesimalNumber addmul(InfinitesimalNumber infinitesimalNumber, Rational rational) {
        return new InfinitesimalNumber(this.mReal.addmul(infinitesimalNumber.mReal, rational), InfinitesimalNumber.normEpsilon(this.mEps + infinitesimalNumber.mEps * rational.signum()));
    }

    public InfinitesimalNumber subdiv(InfinitesimalNumber infinitesimalNumber, Rational rational) {
        return new InfinitesimalNumber(this.mReal.subdiv(infinitesimalNumber.mReal, rational), InfinitesimalNumber.normEpsilon(this.mEps - infinitesimalNumber.mEps) * rational.signum());
    }

    @Override
    public int compareTo(InfinitesimalNumber infinitesimalNumber) {
        int n = this.mReal.compareTo(infinitesimalNumber.mReal);
        if (n == 0) {
            return this.mEps - infinitesimalNumber.mEps;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof InfinitesimalNumber) {
            InfinitesimalNumber infinitesimalNumber = (InfinitesimalNumber)object;
            return this.mReal.equals((Object)infinitesimalNumber.mReal) && this.mEps == infinitesimalNumber.mEps;
        }
        return false;
    }

    public int hashCode() {
        return this.mReal.hashCode() + 65537 * this.mEps;
    }

    public boolean less(InfinitesimalNumber infinitesimalNumber) {
        int n = this.mReal.compareTo(infinitesimalNumber.mReal);
        return n < 0 || n == 0 && this.mEps < infinitesimalNumber.mEps;
    }

    public boolean lesseq(InfinitesimalNumber infinitesimalNumber) {
        int n = this.mReal.compareTo(infinitesimalNumber.mReal);
        return n < 0 || n == 0 && this.mEps <= infinitesimalNumber.mEps;
    }

    public boolean isInfinity() {
        return this.mReal == Rational.POSITIVE_INFINITY || this.mReal == Rational.NEGATIVE_INFINITY;
    }

    public String toString() {
        if (this.mEps == 0) {
            return this.mReal.toString();
        }
        return String.valueOf(this.mReal) + (this.mEps > 0 ? "+" : "-") + "eps";
    }

    public boolean isIntegral() {
        return this.mReal.isIntegral() && this.mEps == 0;
    }

    public InfinitesimalNumber floor() {
        if (!this.mReal.isIntegral()) {
            return new InfinitesimalNumber(this.mReal.floor(), 0);
        }
        if (this.mEps >= 0) {
            return new InfinitesimalNumber(this.mReal, 0);
        }
        return new InfinitesimalNumber(this.mReal.sub(Rational.ONE), 0);
    }

    public InfinitesimalNumber ceil() {
        if (!this.mReal.isIntegral()) {
            return new InfinitesimalNumber(this.mReal.ceil(), 0);
        }
        if (this.mEps <= 0) {
            return new InfinitesimalNumber(this.mReal, 0);
        }
        return new InfinitesimalNumber(this.mReal.add(Rational.ONE), 0);
    }

    public int signum() {
        return this.mReal == Rational.ZERO ? this.mEps : this.mReal.signum();
    }

    public InfinitesimalNumber inverse() {
        return new InfinitesimalNumber(this.mReal.inverse(), -this.mEps);
    }
}

