/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;

class AstarAnnotation<E>
extends ModernAnnotations
implements Comparable<AstarAnnotation<E>> {
    private static final long serialVersionUID = 1L;
    private static int sId;
    private final int mId;
    @Visualizable
    private E mEdge;
    private AstarAnnotation<E> mPreAnnotation;
    @Visualizable
    private int mCostSoFar;
    private int mLowestExpectedCost;
    @Visualizable
    private int mExpectedCostToTarget;

    AstarAnnotation() {
        this.setExpectedCostToTarget(Integer.MAX_VALUE);
        this.setLowestExpectedCost(Integer.MAX_VALUE);
        this.mId = sId++;
    }

    void setExpectedCostToTarget(int n) {
        this.mExpectedCostToTarget = n;
        if (n < this.getLowestExpectedCost()) {
            this.setLowestExpectedCost(n);
        }
    }

    boolean isLowest() {
        return this.getLowestExpectedCost() == this.getExpectedCostToTarget();
    }

    @Override
    public int compareTo(AstarAnnotation<E> astarAnnotation) {
        return Integer.compare(this.mExpectedCostToTarget, astarAnnotation.mExpectedCostToTarget);
    }

    E getEdge() {
        return this.mEdge;
    }

    AstarAnnotation<E> getBackpointer() {
        return this.mPreAnnotation;
    }

    void setBackPointers(E e, AstarAnnotation<E> astarAnnotation) {
        this.mEdge = e;
        this.mPreAnnotation = astarAnnotation;
    }

    int getCostSoFar() {
        return this.mCostSoFar;
    }

    void setCostSoFar(int n) {
        this.mCostSoFar = n;
    }

    int getExpectedCostToTarget() {
        return this.mExpectedCostToTarget;
    }

    private int getLowestExpectedCost() {
        return this.mLowestExpectedCost;
    }

    private void setLowestExpectedCost(int n) {
        this.mLowestExpectedCost = n;
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        AstarAnnotation astarAnnotation = (AstarAnnotation)object;
        if (this.mId == astarAnnotation.mId) {
            return true;
        }
        return this.mExpectedCostToTarget == astarAnnotation.mExpectedCostToTarget;
    }
}

