/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors;

import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.rcfg.visitors.SimpleRCFGVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.RootEdge;

public class DebugRCFGVisitor
extends SimpleRCFGVisitor {
    private int mPathCount = 0;
    private int mNodeCount = 0;
    private int mEdgeCount = 0;
    private StringBuilder mStringBuilder = new StringBuilder();
    public final int mLimit;

    public DebugRCFGVisitor(ILogger iLogger, int n) {
        super(iLogger);
        this.mLimit = n;
    }

    @Override
    public void init(ModelType modelType, int n, int n2) {
        super.init(modelType, n, n2);
        this.mPathCount = 0;
        this.mNodeCount = 0;
        this.mEdgeCount = 0;
        this.mStringBuilder = new StringBuilder();
        this.mStringBuilder.append("\n--\n");
    }

    @Override
    public void finish() {
        super.finish();
        this.mStringBuilder.append("===============");
        this.mStringBuilder.append("\nPathCount: " + this.mPathCount);
        this.mStringBuilder.append("\nNodeCount: " + this.mNodeCount);
        this.mStringBuilder.append("\nEdgeCount: " + this.mEdgeCount);
        this.mStringBuilder.append("\nLimit: " + this.mLimit);
        this.mStringBuilder.append("\n===============");
        this.mLogger.debug((Object)this.mStringBuilder);
    }

    @Override
    public void pre(IcfgEdge icfgEdge) {
        ++this.mEdgeCount;
        if (icfgEdge instanceof RootEdge) {
            this.mStringBuilder.append("RootEdge");
        } else {
            this.mStringBuilder.append(((CodeBlock)icfgEdge).getPrettyPrintedStatements());
        }
    }

    @Override
    public void pre(IcfgLocation icfgLocation) {
        ++this.mNodeCount;
        this.mStringBuilder.append(" --> ");
        this.mStringBuilder.append(icfgLocation.toString());
        this.mStringBuilder.append(" --> ");
    }

    @Override
    public void endOfTrace() {
        ++this.mPathCount;
        this.mStringBuilder.replace(this.mStringBuilder.length() - 5, this.mStringBuilder.length(), "");
        this.mStringBuilder.append("\n--\n");
    }

    @Override
    public boolean abortCurrentBranch() {
        return false;
    }

    @Override
    public boolean abortAll() {
        if (this.mPathCount > this.mLimit || this.mNodeCount > this.mLimit || this.mEdgeCount > this.mLimit) {
            this.mLogger.debug((Object)"Aborting debug session because node, path or edge limit was reached");
            return true;
        }
        return false;
    }

    public boolean performedChanges() {
        return false;
    }
}

