/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.variables;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lassoranker.Lasso;
import de.uni_freiburg.informatik.ultimate.lassoranker.LassoAnalysis;
import de.uni_freiburg.informatik.ultimate.lassoranker.LinearTransition;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.InequalityConverter;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LassoBuilder {
    private final ManagedScript mMgdScript;
    private final Collection<TermVariable> mtermVariables;
    private List<LassoUnderConstruction> mLassosUC;
    private Collection<Lasso> mLassos;
    private final ReplacementVarFactory mReplacementVarFactory;
    private LassoAnalysis.PreprocessingBenchmark mPreprocessingBenchmark;
    private final ILogger mLogger;
    private final InequalityConverter.NlaHandling mNlaHandling;

    public LassoBuilder(ILogger iLogger, CfgSmtToolkit cfgSmtToolkit, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, InequalityConverter.NlaHandling nlaHandling) {
        this.mLogger = iLogger;
        this.mMgdScript = cfgSmtToolkit.getManagedScript();
        this.mNlaHandling = nlaHandling;
        this.mtermVariables = new ArrayList<TermVariable>();
        this.mReplacementVarFactory = new ReplacementVarFactory(cfgSmtToolkit, true);
        this.mLassosUC = new ArrayList<LassoUnderConstruction>();
        this.mLassosUC.add(new LassoUnderConstruction(ModifiableTransFormulaUtils.buildTransFormula((TransFormula)unmodifiableTransFormula, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mMgdScript), ModifiableTransFormulaUtils.buildTransFormula((TransFormula)unmodifiableTransFormula2, (ReplacementVarFactory)this.mReplacementVarFactory, (ManagedScript)this.mMgdScript)));
    }

    public ReplacementVarFactory getReplacementVarFactory() {
        return this.mReplacementVarFactory;
    }

    public Collection<TermVariable> getGeneratedTermVariables() {
        return Collections.unmodifiableCollection(this.mtermVariables);
    }

    public List<LassoUnderConstruction> getLassosUC() {
        return this.mLassosUC;
    }

    public void applyPreprocessor(LassoPreprocessor lassoPreprocessor) throws TermException {
        ArrayList<LassoUnderConstruction> arrayList = new ArrayList<LassoUnderConstruction>();
        for (LassoUnderConstruction lassoUnderConstruction : this.mLassosUC) {
            try {
                arrayList.addAll(lassoPreprocessor.process(lassoUnderConstruction));
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                String string = "applying " + lassoPreprocessor.getName() + " to lasso for termination ";
                toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), string));
                throw toolchainCanceledException;
            }
        }
        this.mLassosUC = arrayList;
    }

    public boolean isSane(String string) {
        boolean bl = true;
        for (LassoUnderConstruction lassoUnderConstruction : this.mLassosUC) {
            assert (bl &= lassoUnderConstruction.getStem().auxVarsDisjointFromInOutVars()) : "inconsistent lasso after " + string + ": auxVarsDisjointFromInOutVars";
            assert (bl &= lassoUnderConstruction.getStem().allAreInOutAux(lassoUnderConstruction.getStem().getFormula().getFreeVars()) == null) : "inconsistent lasso after " + string + ": allAreInOutAux";
            assert (bl &= lassoUnderConstruction.getLoop().auxVarsDisjointFromInOutVars()) : "inconsistent lasso after " + string + ": auxVarsDisjointFromInOutVars";
            assert (bl &= lassoUnderConstruction.getLoop().allAreInOutAux(lassoUnderConstruction.getLoop().getFormula().getFreeVars()) == null) : "inconsistent lasso after " + string + ": allAreInOutAux";
        }
        return bl;
    }

    public void constructPolyhedra() throws TermException {
        int n = this.mLassosUC.size();
        ArrayList<Lasso> arrayList = new ArrayList<Lasso>(n);
        int n2 = 0;
        while (n2 < n) {
            ModifiableTransFormula modifiableTransFormula = this.mLassosUC.get(n2).getStem();
            ModifiableTransFormula modifiableTransFormula2 = this.mLassosUC.get(n2).getLoop();
            LinearTransition linearTransition = LinearTransition.fromTransFormulaLR(modifiableTransFormula, this.mNlaHandling);
            LinearTransition linearTransition2 = LinearTransition.fromTransFormulaLR(modifiableTransFormula2, this.mNlaHandling);
            arrayList.add(new Lasso(linearTransition, linearTransition2));
            ++n2;
        }
        this.mLassos = arrayList;
    }

    public Collection<Lasso> getLassos() {
        return this.mLassos;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mLassos == null) {
            stringBuilder.append("Preprocessing has not been completed.\n");
            stringBuilder.append("Current lassos:\n");
            for (LassoUnderConstruction lassoUnderConstruction : this.mLassosUC) {
                stringBuilder.append(lassoUnderConstruction);
                stringBuilder.append(System.lineSeparator());
            }
        } else {
            stringBuilder.append("Lassos:\n");
            for (Lasso lasso : this.mLassos) {
                stringBuilder.append(lasso);
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public static long computeMaxDagSize(List<LassoUnderConstruction> list) {
        if (list.isEmpty()) {
            return 0L;
        }
        long[] lArray = new long[list.size()];
        int n = 0;
        while (n < list.size()) {
            lArray[n] = list.get(n).getFormulaSize();
            ++n;
        }
        Arrays.sort(lArray);
        return lArray[list.size() - 1];
    }

    public long computeMaxDagSize() {
        return LassoBuilder.computeMaxDagSize(this.mLassosUC);
    }

    public void preprocess(LassoPreprocessor[] lassoPreprocessorArray, LassoPreprocessor[] lassoPreprocessorArray2) throws TermException {
        this.mPreprocessingBenchmark = new LassoAnalysis.PreprocessingBenchmark(this.computeMaxDagSize());
        LassoPreprocessor[] lassoPreprocessorArray3 = lassoPreprocessorArray;
        int n = lassoPreprocessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            LassoPreprocessor lassoPreprocessor = lassoPreprocessorArray3[n2];
            if (lassoPreprocessor != null) {
                this.mLogger.debug((Object)lassoPreprocessor.getDescription());
                this.applyPreprocessor(lassoPreprocessor);
                this.mPreprocessingBenchmark.addPreprocessingData(lassoPreprocessor.getDescription(), this.computeMaxDagSize());
                assert (this.isSane(lassoPreprocessor.getClass().getSimpleName())) : "lasso failed sanity check";
            }
            ++n2;
        }
    }

    public LassoAnalysis.PreprocessingBenchmark getPreprocessingBenchmark() {
        return this.mPreprocessingBenchmark;
    }
}

