/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTPointerOperator;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTAttributeOwner;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;

public class CASTDeclarator
extends ASTAttributeOwner
implements IASTDeclarator,
IASTAmbiguityParent {
    private IASTInitializer initializer;
    private IASTName name;
    private IASTDeclarator nestedDeclarator;
    private IASTPointerOperator[] pointerOps;
    private int pointerOpsPos = -1;

    public CASTDeclarator() {
    }

    public CASTDeclarator(IASTName name) {
        this.setName(name);
    }

    public CASTDeclarator(IASTName name, IASTInitializer initializer) {
        this.setInitializer(initializer);
        this.setName(name);
    }

    @Override
    public CASTDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTDeclarator copy(IASTNode.CopyStyle style) {
        return this.copy(new CASTDeclarator(), style);
    }

    @Override
    protected <T extends CASTDeclarator> T copy(T copy, IASTNode.CopyStyle style) {
        copy.setName(this.name == null ? null : this.name.copy(style));
        copy.setInitializer(this.initializer == null ? null : this.initializer.copy(style));
        copy.setNestedDeclarator(this.nestedDeclarator == null ? null : this.nestedDeclarator.copy(style));
        IASTPointerOperator[] iASTPointerOperatorArray = this.getPointerOperators();
        int n = iASTPointerOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTPointerOperator pointer = iASTPointerOperatorArray[n2];
            copy.addPointerOperator(pointer == null ? null : pointer.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    @Override
    public IASTPointerOperator[] getPointerOperators() {
        if (this.pointerOps == null) {
            return IASTPointerOperator.EMPTY_ARRAY;
        }
        this.pointerOps = ArrayUtil.trimAt(IASTPointerOperator.class, this.pointerOps, this.pointerOpsPos);
        return this.pointerOps;
    }

    @Override
    public IASTDeclarator getNestedDeclarator() {
        return this.nestedDeclarator;
    }

    @Override
    public IASTName getName() {
        return this.name;
    }

    @Override
    public IASTInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public void setInitializer(IASTInitializer initializer) {
        this.assertNotFrozen();
        this.initializer = initializer;
        if (initializer != null) {
            initializer.setParent(this);
            initializer.setPropertyInParent(INITIALIZER);
        }
    }

    @Override
    public void addPointerOperator(IASTPointerOperator operator) {
        this.assertNotFrozen();
        if (operator != null) {
            operator.setParent(this);
            operator.setPropertyInParent(POINTER_OPERATOR);
            this.pointerOps = ArrayUtil.appendAt(IASTPointerOperator.class, this.pointerOps, ++this.pointerOpsPos, operator);
        }
    }

    @Override
    public void setNestedDeclarator(IASTDeclarator nested) {
        this.assertNotFrozen();
        this.nestedDeclarator = nested;
        if (nested != null) {
            nested.setParent(this);
            nested.setPropertyInParent(NESTED_DECLARATOR);
        }
    }

    @Override
    public void setName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(DECLARATOR_NAME);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitDeclarators) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        int i = 0;
        while (i <= this.pointerOpsPos) {
            if (!this.pointerOps[i].accept(action)) {
                return false;
            }
            ++i;
        }
        if (!this.acceptByAttributeSpecifiers(action)) {
            return false;
        }
        if (this.getPropertyInParent() != IASTTypeId.ABSTRACT_DECLARATOR && this.nestedDeclarator == null) {
            if (this.getParent() instanceof IASTDeclarator) {
                IASTDeclarator outermostDeclarator = (IASTDeclarator)this.getParent();
                while (outermostDeclarator.getParent() instanceof IASTDeclarator) {
                    outermostDeclarator = (IASTDeclarator)outermostDeclarator.getParent();
                }
                if (outermostDeclarator.getPropertyInParent() != IASTTypeId.ABSTRACT_DECLARATOR && this.name != null && !this.name.accept(action)) {
                    return false;
                }
            } else if (this.name != null && !this.name.accept(action)) {
                return false;
            }
        }
        if (this.nestedDeclarator != null && !this.nestedDeclarator.accept(action)) {
            return false;
        }
        if (!this.postAccept(action)) {
            return false;
        }
        return !action.shouldVisitDeclarators || action.leave(this) != 2;
    }

    protected boolean postAccept(ASTVisitor action) {
        return this.initializer == null || this.initializer.accept(action);
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            IASTNode getParent = this.getParent();
            boolean fnDtor = this instanceof IASTFunctionDeclarator;
            if (getParent instanceof IASTDeclaration) {
                if (getParent instanceof IASTFunctionDefinition) {
                    return 2;
                }
                if (getParent instanceof IASTSimpleDeclaration) {
                    IASTSimpleDeclaration sd = (IASTSimpleDeclaration)getParent;
                    int storage = sd.getDeclSpecifier().getStorageClass();
                    if (this.getInitializer() != null || storage == 1) {
                        return 2;
                    }
                    if (storage == 2 || storage == 3) {
                        return 0;
                    }
                    return fnDtor ? 0 : 2;
                }
            }
            if (getParent instanceof IASTTypeId) {
                return 1;
            }
            if (getParent instanceof IASTDeclarator) {
                IASTNode t = getParent;
                while (t instanceof IASTDeclarator) {
                    t = t.getParent();
                }
                if (t instanceof IASTDeclaration) {
                    if (getParent instanceof IASTFunctionDefinition) {
                        return 2;
                    }
                    if (getParent instanceof IASTSimpleDeclaration) {
                        if (this.getInitializer() != null) {
                            return 2;
                        }
                        IASTSimpleDeclaration sd = (IASTSimpleDeclaration)getParent;
                        int storage = sd.getDeclSpecifier().getStorageClass();
                        if (storage == 2 || storage == 3) {
                            return 0;
                        }
                    }
                    return fnDtor ? 0 : 2;
                }
                if (t instanceof IASTTypeId) {
                    return 1;
                }
            }
            if (getParent instanceof IASTParameterDeclaration) {
                return n.toCharArray().length > 0 ? 2 : 0;
            }
        }
        return 3;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.nestedDeclarator) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.nestedDeclarator = (IASTDeclarator)other;
        }
    }
}

