/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.rewrite.changegenerator;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionList;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.internal.core.dom.rewrite.ASTModification;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ASTWriterVisitor;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.ExpressionWriter;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.MacroExpansionHandler;
import org.eclipse.cdt.internal.core.dom.rewrite.astwriter.Scribe;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ASTModificationHelper;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.ModificationScopeStack;
import org.eclipse.cdt.internal.core.dom.rewrite.changegenerator.UnhandledASTModificationException;
import org.eclipse.cdt.internal.core.dom.rewrite.commenthandler.NodeCommentMap;

public class ModifiedASTExpressionWriter
extends ExpressionWriter {
    private final ASTModificationHelper modificationHelper;

    public ModifiedASTExpressionWriter(Scribe scribe, ASTWriterVisitor visitor, MacroExpansionHandler macroHandler, ModificationScopeStack stack, NodeCommentMap commentMap) {
        super(scribe, visitor, macroHandler, commentMap);
        this.modificationHelper = new ASTModificationHelper(stack);
    }

    @Override
    protected void writeExpressions(IASTExpressionList expList, IASTExpression[] expressions) {
        IASTExpression[] modifiedExpressions = (IASTExpression[])this.modificationHelper.createModifiedChildArray(expList, expressions, IASTExpression.class, this.commentMap);
        super.writeExpressions(expList, modifiedExpressions);
    }

    @Override
    protected IASTInitializer getNewInitializer(ICPPASTNewExpression newExp) {
        IASTInitializer initializer = newExp.getInitializer();
        if (initializer != null) {
            for (ASTModification childModification : this.modificationHelper.modificationsForNode(initializer)) {
                switch (childModification.getKind()) {
                    case REPLACE: {
                        if (!(childModification.getNewNode() instanceof IASTInitializer)) break;
                        return (IASTInitializer)childModification.getNewNode();
                    }
                    case INSERT_BEFORE: {
                        throw new UnhandledASTModificationException(childModification);
                    }
                    case APPEND_CHILD: {
                        throw new UnhandledASTModificationException(childModification);
                    }
                }
            }
        } else {
            for (ASTModification parentModification : this.modificationHelper.modificationsForNode(newExp)) {
                IASTNode newNode;
                if (parentModification.getKind() != ASTModification.ModificationKind.APPEND_CHILD || !((newNode = parentModification.getNewNode()) instanceof IASTInitializer)) continue;
                return (IASTInitializer)newNode;
            }
        }
        return initializer;
    }
}

