/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.chcsolver;

import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.chc.ChcSolution;
import de.uni_freiburg.informatik.ultimate.lib.chc.Derivation;
import de.uni_freiburg.informatik.ultimate.lib.chc.GolemChcScript;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornAnnot;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClauseAST;
import de.uni_freiburg.informatik.ultimate.lib.chc.IChcScript;
import de.uni_freiburg.informatik.ultimate.lib.chc.SmtChcScript;
import de.uni_freiburg.informatik.ultimate.lib.chc.eldarica.EldaricaChcScript;
import de.uni_freiburg.informatik.ultimate.lib.chc.results.ChcSatResult;
import de.uni_freiburg.informatik.ultimate.lib.chc.results.ChcUnknownResult;
import de.uni_freiburg.informatik.ultimate.lib.chc.results.ChcUnsatResult;
import de.uni_freiburg.informatik.ultimate.logic.Model;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.chcsolver.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.chcsolver.preferences.ChcSolverPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.chcsolver.preferences.ChcSolverPreferences;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.TreeAutomizerChcScript;
import java.util.Set;

public class ChcSolverObserver
extends BaseObserver {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ChcSolverPreferences mPrefs;
    private ChcSolution mSolution;

    public ChcSolverObserver(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ChcSolverPreferences chcSolverPreferences) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mPrefs = chcSolverPreferences;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (!(iElement instanceof HornClauseAST)) {
            return true;
        }
        HornAnnot hornAnnot = HornAnnot.getAnnotation((IElement)iElement);
        IChcScript iChcScript = this.getBackend(hornAnnot);
        this.configureBackend(iChcScript);
        Script.LBool lBool = iChcScript.solve(hornAnnot.getSymbolTable(), hornAnnot.getHornClauses());
        IResult iResult = this.createResult(iChcScript, lBool);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, iResult);
        if (iChcScript instanceof AutoCloseable) {
            ((AutoCloseable)iChcScript).close();
        }
        return false;
    }

    private IChcScript getBackend(HornAnnot hornAnnot) {
        return switch (this.mPrefs.getBackend()) {
            case ChcSolverPreferenceInitializer.SolverBackend.ELDARICA -> new EldaricaChcScript(this.mServices, hornAnnot.getScript().getScript());
            case ChcSolverPreferenceInitializer.SolverBackend.GOLEM -> new GolemChcScript(this.mServices, hornAnnot.getScript());
            case ChcSolverPreferenceInitializer.SolverBackend.Z3 -> new SmtChcScript(hornAnnot.getScript());
            case ChcSolverPreferenceInitializer.SolverBackend.TREEAUTOMIZER -> new TreeAutomizerChcScript(this.mServices, hornAnnot.getScript(), null);
            default -> throw new MatchException(null, null);
        };
    }

    private void configureBackend(IChcScript iChcScript) {
        if (iChcScript.supportsModelProduction()) {
            iChcScript.produceModels(this.mPrefs.produceModels());
        } else if (this.mPrefs.produceModels()) {
            this.mLogger.warn((Object)"Model production is not supported by backend");
        }
        if (iChcScript.supportsDerivationProduction()) {
            iChcScript.produceDerivations(this.mPrefs.produceDerivation());
        } else if (this.mPrefs.produceDerivation()) {
            this.mLogger.warn((Object)"Derivation production is not supported by backend");
        }
        if (iChcScript.supportsUnsatCores()) {
            iChcScript.produceUnsatCores(this.mPrefs.produceUnsatCore());
        } else if (this.mPrefs.produceUnsatCore()) {
            this.mLogger.warn((Object)"UNSAT core production is not supported by backend");
        }
    }

    private IResult createResult(IChcScript iChcScript, Script.LBool lBool) {
        return switch (lBool) {
            case Script.LBool.SAT -> this.createSatResult(iChcScript);
            case Script.LBool.UNSAT -> this.createUnSatResult(iChcScript);
            case Script.LBool.UNKNOWN -> {
                this.mSolution = ChcSolution.unknown();
                yield new ChcUnknownResult(Activator.PLUGIN_ID, "CHC solver returned UNKNOWN.");
            }
            default -> throw new MatchException(null, null);
        };
    }

    private ChcSatResult createSatResult(IChcScript iChcScript) {
        Model model = this.mPrefs.produceModels() && iChcScript.supportsModelProduction() ? (Model)iChcScript.getModel().orElse(null) : null;
        this.mSolution = ChcSolution.sat(model);
        return new ChcSatResult(Activator.PLUGIN_ID, "The given horn clause set is SAT", model);
    }

    private ChcUnsatResult createUnSatResult(IChcScript iChcScript) {
        Derivation derivation = this.mPrefs.produceDerivation() && iChcScript.supportsDerivationProduction() ? (Derivation)iChcScript.getDerivation().orElse(null) : null;
        Set set = this.mPrefs.produceUnsatCore() && iChcScript.supportsUnsatCores() ? (Set)iChcScript.getUnsatCore().orElse(null) : null;
        this.mSolution = ChcSolution.unsat((Derivation)derivation, set);
        return new ChcUnsatResult(Activator.PLUGIN_ID, "The given horn clause set is UNSAT", derivation, set);
    }

    public ChcSolution getSolution() {
        return this.mSolution;
    }
}

