/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModifiableTransFormulaUtils {
    public static boolean allVariablesAreInVars(List<Term> list, ModifiableTransFormula modifiableTransFormula) {
        return list.stream().allMatch(term -> ModifiableTransFormulaUtils.allVariablesAreInVars(term, modifiableTransFormula));
    }

    public static boolean allVariablesAreOutVars(List<Term> list, ModifiableTransFormula modifiableTransFormula) {
        return list.stream().allMatch(term -> ModifiableTransFormulaUtils.allVariablesAreOutVars(term, modifiableTransFormula));
    }

    public static boolean allVariablesAreVisible(List<Term> list, ModifiableTransFormula modifiableTransFormula) {
        return list.stream().allMatch(term -> ModifiableTransFormulaUtils.allVariablesAreVisible(term, modifiableTransFormula));
    }

    public static boolean allVariablesAreInVars(Term term, ModifiableTransFormula modifiableTransFormula) {
        return Arrays.stream(term.getFreeVars()).allMatch(termVariable -> ModifiableTransFormulaUtils.isInVar(termVariable, modifiableTransFormula));
    }

    public static boolean allVariablesAreOutVars(Term term, ModifiableTransFormula modifiableTransFormula) {
        return Arrays.stream(term.getFreeVars()).allMatch(termVariable -> ModifiableTransFormulaUtils.isOutVar(termVariable, modifiableTransFormula));
    }

    public static boolean allVariablesAreVisible(Term term, ModifiableTransFormula modifiableTransFormula) {
        return Arrays.stream(term.getFreeVars()).allMatch(termVariable -> ModifiableTransFormulaUtils.isVisible(termVariable, modifiableTransFormula));
    }

    private static boolean isVisible(TermVariable termVariable, ModifiableTransFormula modifiableTransFormula) {
        return ModifiableTransFormulaUtils.isInVar(termVariable, modifiableTransFormula) || ModifiableTransFormulaUtils.isOutVar(termVariable, modifiableTransFormula);
    }

    public static boolean isInVar(TermVariable termVariable, ModifiableTransFormula modifiableTransFormula) {
        return modifiableTransFormula.getInVarsReverseMapping().containsKey(termVariable);
    }

    public static boolean isOutVar(TermVariable termVariable, ModifiableTransFormula modifiableTransFormula) {
        return modifiableTransFormula.getOutVarsReverseMapping().containsKey(termVariable);
    }

    public static Script.LBool implies(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable) {
        Term term = ModifiableTransFormulaUtils.renameToConstants(iUltimateServiceProvider, iLogger, managedScript, iIcfgSymbolTable, modifiableTransFormula);
        Term term2 = ModifiableTransFormulaUtils.renameToConstants(iUltimateServiceProvider, iLogger, managedScript, iIcfgSymbolTable, modifiableTransFormula2);
        managedScript.getScript().push(1);
        managedScript.getScript().assertTerm(term);
        managedScript.getScript().assertTerm(SmtUtils.not((Script)managedScript.getScript(), (Term)term2));
        managedScript.getScript().assertTerm(ModifiableTransFormulaUtils.getAdditionalEqualities(Arrays.asList(modifiableTransFormula, modifiableTransFormula2), iIcfgSymbolTable, managedScript.getScript()));
        Script.LBool lBool = managedScript.getScript().checkSat();
        managedScript.getScript().pop(1);
        return lBool;
    }

    private static Term getAdditionalEqualities(List<ModifiableTransFormula> list, IIcfgSymbolTable iIcfgSymbolTable, Script script) {
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<TermVariable> hashSet2 = new HashSet<TermVariable>();
        HashSet<IProgramVar> hashSet3 = new HashSet<IProgramVar>();
        for (ModifiableTransFormula modifiableTransFormula : list) {
            for (IProgramVar iProgramVar : modifiableTransFormula.getInVars().keySet()) {
                hashSet3.add(iProgramVar);
                hashSet2.addAll(Arrays.asList(ReplacementVarUtils.getDefinition(iProgramVar).getFreeVars()));
            }
            for (IProgramVar iProgramVar : modifiableTransFormula.getOutVars().keySet()) {
                hashSet3.add(iProgramVar);
                hashSet2.addAll(Arrays.asList(ReplacementVarUtils.getDefinition(iProgramVar).getFreeVars()));
            }
        }
        for (TermVariable termVariable : hashSet2) {
            IProgramVar iProgramVar;
            iProgramVar = iIcfgSymbolTable.getProgramVar(termVariable);
            if (hashSet3.contains(iProgramVar)) continue;
            Term term = SmtUtils.binaryEquality((Script)script, (Term)iProgramVar.getDefaultConstant(), (Term)iProgramVar.getPrimedConstant());
            hashSet.add(term);
        }
        return SmtUtils.and((Script)script, hashSet);
    }

    /*
     * WARNING - void declaration
     */
    private static Term renameToConstants(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable, ModifiableTransFormula modifiableTransFormula) {
        void var6_13;
        Term term;
        HashMap<Term, Object> hashMap = new HashMap<Term, Object>();
        for (Map.Entry<IProgramVar, TermVariable> object2 : modifiableTransFormula.getInVars().entrySet()) {
            if (object2.getKey() instanceof IReplacementVarOrConst) {
                term = ReplacementVarUtils.getDefinition(object2.getKey());
                hashMap.put((Term)object2.getValue(), ModifiableTransFormulaUtils.renameVars(managedScript, iIcfgSymbolTable, term, IProgramVar::getDefaultConstant));
                continue;
            }
            hashMap.put((Term)object2.getValue(), object2.getKey().getDefaultConstant());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : modifiableTransFormula.getOutVars().entrySet()) {
            if (entry.getKey() instanceof IReplacementVarOrConst) {
                term = ReplacementVarUtils.getDefinition(entry.getKey());
                hashMap.put((Term)entry.getValue(), ModifiableTransFormulaUtils.renameVars(managedScript, iIcfgSymbolTable, term, IProgramVar::getPrimedConstant));
                continue;
            }
            hashMap.put((Term)entry.getValue(), entry.getKey().getPrimedConstant());
        }
        Term term3 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)modifiableTransFormula.getFormula());
        term3 = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term3, ModifiableTransFormulaUtils.constructEqualitiesForCoinciding(managedScript.getScript(), modifiableTransFormula)});
        if (!modifiableTransFormula.getAuxVars().isEmpty()) {
            iLogger.warn((Object)(modifiableTransFormula.getAuxVars().size() + " quantified variables"));
            TermVariable[] termVariableArray = modifiableTransFormula.getAuxVars().toArray(new TermVariable[modifiableTransFormula.getAuxVars().size()]);
            Term term4 = managedScript.getScript().quantifier(0, termVariableArray, term3, (Term[][])new Term[0][]);
        }
        assert (Arrays.asList(var6_13.getFreeVars()).isEmpty()) : "there must not be a TermVariable left";
        return var6_13;
    }

    private static Term renameVars(ManagedScript managedScript, IIcfgSymbolTable iIcfgSymbolTable, Term term, Function<IProgramVar, Term> function) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            IProgramVar iProgramVar = iIcfgSymbolTable.getProgramVar(termVariable);
            if (iProgramVar == null) {
                throw new IllegalArgumentException("term contains unknown variable");
            }
            hashMap.put(termVariable, function.apply(iProgramVar));
            ++n2;
        }
        return Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
    }

    public static Term getDefinition(ModifiableTransFormula modifiableTransFormula, TermVariable termVariable) {
        IProgramVar iProgramVar = modifiableTransFormula.getInVarsReverseMapping().get(termVariable);
        if (iProgramVar == null) {
            iProgramVar = modifiableTransFormula.getOutVarsReverseMapping().get(termVariable);
        }
        if (iProgramVar == null) {
            return null;
        }
        return ReplacementVarUtils.getDefinition(iProgramVar);
    }

    public static Term translateTermVariablesToDefinitions(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula, Term term) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            Term term2 = ModifiableTransFormulaUtils.getDefinition(modifiableTransFormula, termVariable);
            if (term2 == null) {
                throw new IllegalArgumentException(String.valueOf(termVariable) + "has no RankVar");
            }
            hashMap.put(termVariable, term2);
            ++n2;
        }
        return Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
    }

    public static List<Term> translateTermVariablesToDefinitions(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula, List<Term> list) {
        return list.stream().map(term -> ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(managedScript, modifiableTransFormula, term)).collect(Collectors.toList());
    }

    public static Term translateTermVariablesToInVars(ManagedScript managedScript, ModifiableTransFormula modifiableTransFormula, Term term, IIcfgSymbolTable iIcfgSymbolTable) {
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable = termVariableArray[n2];
            IProgramVar iProgramVar = iIcfgSymbolTable.getProgramVar(termVariable);
            Term term2 = (Term)modifiableTransFormula.getInVars().get(iProgramVar);
            assert (term2 != null) : "no inVar for " + String.valueOf(iProgramVar);
            hashMap.put(termVariable, term2);
            ++n2;
        }
        return Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
    }

    public static boolean inVarAndOutVarCoincide(IProgramVar iProgramVar, ModifiableTransFormula modifiableTransFormula) {
        return modifiableTransFormula.getInVars().get(iProgramVar) == modifiableTransFormula.getOutVars().get(iProgramVar);
    }

    private static Term constructEqualitiesForCoinciding(Script script, ModifiableTransFormula modifiableTransFormula) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (IProgramVar iProgramVar : modifiableTransFormula.getInVars().keySet()) {
            if (iProgramVar instanceof IReplacementVarOrConst || !ModifiableTransFormulaUtils.inVarAndOutVarCoincide(iProgramVar, modifiableTransFormula)) continue;
            IProgramVar iProgramVar2 = iProgramVar;
            arrayList.add(SmtUtils.binaryEquality((Script)script, (Term)iProgramVar2.getDefaultConstant(), (Term)iProgramVar2.getPrimedConstant()));
        }
        return SmtUtils.and((Script)script, arrayList);
    }

    public static ModifiableTransFormula buildTransFormula(TransFormula transFormula, ManagedScript managedScript) {
        return ModifiableTransFormulaUtils.buildTransFormulaHelper(transFormula, null, managedScript);
    }

    public static ModifiableTransFormula buildTransFormula(TransFormula transFormula, ReplacementVarFactory replacementVarFactory, ManagedScript managedScript) {
        return ModifiableTransFormulaUtils.buildTransFormulaHelper(transFormula, replacementVarFactory, managedScript);
    }

    private static ModifiableTransFormula buildTransFormulaHelper(TransFormula transFormula, ReplacementVarFactory replacementVarFactory, ManagedScript managedScript) {
        HashMap<Object, TermVariable> hashMap = new HashMap<Object, TermVariable>();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (TermVariable termVariable : transFormula.getAuxVars()) {
            TermVariable termVariable2 = managedScript.constructFreshCopy(termVariable);
            hashSet.add(termVariable2);
            hashMap.put(termVariable, termVariable2);
        }
        ModifiableTransFormula modifiableTransFormula = new ModifiableTransFormula(null);
        if (replacementVarFactory != null) {
            for (IProgramConst iProgramConst : transFormula.getNonTheoryConsts()) {
                ApplicationTerm applicationTerm = iProgramConst.getDefaultConstant();
                IReplacementVar iReplacementVar = (IReplacementVar)replacementVarFactory.getOrConstuctReplacementVar((Term)applicationTerm, true);
                modifiableTransFormula.addInVar(iReplacementVar, iReplacementVar.getTermVariable());
                modifiableTransFormula.addOutVar(iReplacementVar, iReplacementVar.getTermVariable());
                hashMap.put(applicationTerm, iReplacementVar.getTermVariable());
            }
        } else {
            modifiableTransFormula.addNonTheoryConsts(transFormula.getNonTheoryConsts());
        }
        Term term = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)transFormula.getFormula());
        modifiableTransFormula.setFormula(term);
        for (Map.Entry entry : transFormula.getInVars().entrySet()) {
            modifiableTransFormula.addInVar((IProgramVar)entry.getKey(), (TermVariable)entry.getValue());
        }
        for (Map.Entry entry : transFormula.getOutVars().entrySet()) {
            modifiableTransFormula.addOutVar((IProgramVar)entry.getKey(), (TermVariable)entry.getValue());
        }
        modifiableTransFormula.addAuxVars(hashSet);
        return modifiableTransFormula;
    }
}

