/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public final class HoareTripleCheckerStatisticsType
implements IStatisticsType {
    private static final HoareTripleCheckerStatisticsType INSTANCE = new HoareTripleCheckerStatisticsType();
    private final Map<String, Function<Object, Function<Object, Object>>> mAggrFuns = new LinkedHashMap<String, Function<Object, Function<Object, Object>>>();
    private final Map<String, Function<String, Function<Object, String>>> mPrintFuns = new LinkedHashMap<String, Function<String, Function<Object, String>>>();

    private HoareTripleCheckerStatisticsType() {
        IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions[] hoareTripleCheckerStatisticsDefinitionsArray = IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.values();
        int n = hoareTripleCheckerStatisticsDefinitionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions hoareTripleCheckerStatisticsDefinitions = hoareTripleCheckerStatisticsDefinitionsArray[n2];
            this.registerKey(hoareTripleCheckerStatisticsDefinitions.name(), object -> object2 -> hoareTripleCheckerStatisticsDefinitions.aggregate(object, object2), string -> hoareTripleCheckerStatisticsDefinitions::prettyprint);
            ++n2;
        }
    }

    public static HoareTripleCheckerStatisticsType getInstance() {
        return INSTANCE;
    }

    public Collection<String> getKeys() {
        return this.mPrintFuns.keySet();
    }

    public void registerKey(String string, Function<Object, Function<Object, Object>> function, Function<String, Function<Object, String>> function2) {
        Function<Object, Function<Object, Object>> function3 = this.mAggrFuns.put(string, function);
        if (function3 != null) {
            throw new IllegalArgumentException();
        }
        Function<String, Function<Object, String>> function4 = this.mPrintFuns.put(string, function2);
        if (function4 != null) {
            throw new IllegalArgumentException();
        }
    }

    public Object aggregate(String string, Object object, Object object2) {
        Function<Object, Function<Object, Object>> function = this.mAggrFuns.get(string);
        if (function == null) {
            throw new IllegalStateException(String.format("Key %s is unknown", string));
        }
        return function.apply(object).apply(object2);
    }

    public String prettyprintBenchmarkData(IStatisticsDataProvider iStatisticsDataProvider) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, Function<String, Function<Object, String>>>> iterator = this.mPrintFuns.entrySet().iterator();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append(" [");
        while (iterator.hasNext()) {
            Map.Entry<String, Function<String, Function<Object, String>>> entry = iterator.next();
            Object object = iStatisticsDataProvider.getValue(entry.getKey());
            stringBuilder.append(entry.getValue().apply(entry.getKey()).apply(object));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

