/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.AnnotationRemover;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.NamedTermWrapper;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.QuantifierOverapproximatingSolver;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.UnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class UltimateEliminator
extends WrapperScript {
    private static final boolean WRAP_BACKEND_SOLVER_WITH_QUANTIFIER_OVERAPPROXIMATION = true;
    private static final boolean APPLY_SIMPLE_E_SKOLEMIZATION = true;
    private static final boolean LOG_JUNIT_TEST = false;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mMgdScript;
    private Script.LBool mExpectedResult;
    private long mTreeSizeOfAssertedTerms = 0L;
    private int mNumberOfAssertedTerms = 0;

    public UltimateEliminator(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Script script) {
        super(UltimateEliminator.wrapIfNecessary(iUltimateServiceProvider, iLogger, script));
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mMgdScript = new ManagedScript(iUltimateServiceProvider, this.mScript);
    }

    private static Script wrapIfNecessary(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Script script) {
        return new QuantifierOverapproximatingSolver(iUltimateServiceProvider, iLogger, script);
    }

    public void setLogic(String string) throws UnsupportedOperationException, SMTLIBException {
        if (string.startsWith("QF_")) {
            this.mScript.setLogic(string);
        } else {
            String string2 = "QF_" + string;
            if (Logics.valueOf((String)string2) != null) {
                this.mScript.setLogic(string2);
            } else {
                throw new AssertionError((Object)"No Quantifier Free Logic found for Overapproximation");
            }
        }
    }

    public void setLogic(Logics logics) throws UnsupportedOperationException, SMTLIBException {
        if (logics.isQuantified()) {
            Logics logics2 = Logics.valueOf((String)("QF_" + logics.toString()));
            this.mScript.setLogic(logics2);
        } else {
            this.mScript.setLogic(logics);
        }
    }

    public void setInfo(String string, Object object) {
        if (string.equals(":status")) {
            String string2 = (String)object;
            this.mExpectedResult = Script.LBool.valueOf((String)string2.toUpperCase());
        } else {
            this.mScript.setInfo(string, object);
        }
    }

    public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        if (!QuantifierUtils.isQuantifierFree((Term)term)) {
            throw new UnsupportedOperationException("Cannot handle define-fun with quantified definition " + String.valueOf(term));
        }
        this.mScript.defineFun(string, termVariableArray, sort, term);
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        ++this.mNumberOfAssertedTerms;
        NamedTermWrapper namedTermWrapper = NamedTermWrapper.of(term);
        if (namedTermWrapper != null) {
            this.mTreeSizeOfAssertedTerms += new DAGSize().treesize(namedTermWrapper.getSubTerm());
            return this.mScript.assertTerm(term);
        }
        Term term2 = this.makeQuantifierFree(term);
        this.mTreeSizeOfAssertedTerms += new DAGSize().treesize(term2);
        return this.mScript.assertTerm(term2);
    }

    private Term makeQuantifierFree(Term term) {
        Term term2 = new FormulaUnLet().transform(term);
        Term term3 = new AnnotationRemover().transform(term2);
        Term term4 = new UnfTransformer(this.mMgdScript.getScript()).transform(term3);
        Term term5 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2, (Term)term4);
        if (!QuantifierUtils.isQuantifierFree((Term)term5)) {
            Term term6 = new PrenexNormalForm(this.mMgdScript).transform(term5);
            QuantifierSequence quantifierSequence = new QuantifierSequence(this.mMgdScript, term6);
            if (quantifierSequence.getNumberOfQuantifierBlocks() == 1 && ((QuantifierSequence.QuantifiedVariables)quantifierSequence.getQuantifierBlocks().get(0)).getQuantifier() == 0) {
                return this.doSimpleESkolemization(term5, quantifierSequence);
            }
            throw new AssertionError((Object)("Result of partial quantifier elimination is not quantifier-free but an " + quantifierSequence.buildQuantifierSequenceStringRepresentation() + " term."));
        }
        return term5;
    }

    private Term doSimpleESkolemization(Term term, QuantifierSequence quantifierSequence) {
        TermVariable termVariable2;
        QuantifierSequence.QuantifiedVariables quantifiedVariables = (QuantifierSequence.QuantifiedVariables)quantifierSequence.getQuantifierBlocks().get(0);
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        for (TermVariable termVariable2 : quantifiedVariables.getVariables()) {
            String string = this.generateIdentifierForESkolemization(termVariable2);
            this.mMgdScript.getScript().declareFun(string, new Sort[0], termVariable2.getSort());
            Term term2 = this.mMgdScript.getScript().term(string, new Term[0]);
            hashMap.put(termVariable2, term2);
        }
        termVariable2 = Substitution.apply((ManagedScript)this.mMgdScript, hashMap, (Term)quantifierSequence.getInnerTerm());
        return termVariable2;
    }

    private String generateIdentifierForESkolemization(TermVariable termVariable) {
        return "UltimateSkolemizationId" + this.mNumberOfAssertedTerms + "_" + termVariable.getName();
    }

    public Script.LBool checkSat() throws SMTLIBException {
        Script.LBool lBool = this.mScript.checkSat();
        if (this.mExpectedResult != null) {
            this.mLogger.info((Object)("Expected result: " + String.valueOf(lBool)));
            if (this.mExpectedResult == Script.LBool.UNKNOWN) {
                if (lBool != Script.LBool.UNKNOWN) {
                    throw new AssertionError((Object)"Congratulations! We solved a difficult benchmark");
                }
            } else if (lBool != Script.LBool.UNKNOWN && lBool != this.mExpectedResult) {
                throw new AssertionError((Object)("Result incorrect: expected " + String.valueOf(this.mExpectedResult) + " obtained " + String.valueOf(lBool) + ". Treesize of asserted terms " + this.mTreeSizeOfAssertedTerms));
            }
        }
        this.mLogger.info((Object)("Computed result: " + String.valueOf(lBool)));
        IResult iResult = this.constructResult("check-sat", String.valueOf(lBool));
        this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", iResult);
        return lBool;
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        QuantifierOverapproximatingSolver quantifierOverapproximatingSolver = (QuantifierOverapproximatingSolver)this.mScript;
        assert (quantifierOverapproximatingSolver.isInUsatCoreMode());
        Term[] termArray = this.mScript.getUnsatCore();
        HashSet<Term> hashSet = new HashSet<Term>(quantifierOverapproximatingSolver.getAdditionalUnsatCoreContent());
        hashSet.addAll(Arrays.asList(termArray));
        IResult iResult = this.constructResult("get-unsat-core", String.valueOf(hashSet));
        this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", iResult);
        return hashSet.toArray(new Term[hashSet.size()]);
    }

    public void exit() {
    }

    public Term annotate(Term term, Annotation ... annotationArray) throws SMTLIBException {
        if (Arrays.stream(annotationArray).anyMatch(annotation -> annotation.getKey().equals(":named"))) {
            Term term2 = this.makeQuantifierFree(term);
            return this.mScript.annotate(term2, annotationArray);
        }
        return this.mScript.annotate(term, annotationArray);
    }

    public Term simplify(Term term) throws SMTLIBException {
        Term term2 = new FormulaUnLet().transform(term);
        Term term3 = new AnnotationRemover().transform(term2);
        Term term4 = new UnfTransformer(this.mMgdScript.getScript()).transform(term3);
        Term term5 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2, (Term)term4);
        IResult iResult = this.constructResult("simplify", String.valueOf(term5));
        this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", iResult);
        return term5;
    }

    private IResult constructResult(String string, String string2) {
        String string3 = "Response to " + string + " command";
        String string4 = "Response to " + string + " command is: " + string2;
        IResultWithSeverity.Severity severity = IResultWithSeverity.Severity.INFO;
        GenericResult genericResult = new GenericResult("de.uni_freiburg.informatik.ultimate.core", string3, string4, severity);
        return genericResult;
    }
}

