/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.concurrent;

import de.uni_freiburg.informatik.ultimate.lib.chc.HcBodyVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.concurrent.HcGlobalVar;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.concurrent.HcLocalVar;
import de.uni_freiburg.informatik.ultimate.plugins.icfgtochc.concurrent.HcLocationVar;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class IcfgToChcConcurrent {
    private static final String FUNCTION_NAME = "Inv";
    private final ManagedScript mManagedScript;
    private final NestedMap2<String, IcfgLocation, Integer> mLocationIndices;
    private final Map<String, Integer> mNumberOfThreads;
    private final Term mBottomLocation;
    private final HcPredicateSymbol mPredicate;
    private final HcSymbolTable mHcSymbolTable;
    private final List<HcHeadVar> mDefaultHeadVars;
    private final BidirectionalMap<Integer, IHcReplacementVar> mPositions2Vars;

    public IcfgToChcConcurrent(Map<String, Integer> map, ManagedScript managedScript, CfgSmtToolkit cfgSmtToolkit, HcSymbolTable hcSymbolTable, Predicate<IProgramVar> predicate) {
        IIcfgSymbolTable iIcfgSymbolTable = cfgSmtToolkit.getSymbolTable();
        this.mHcSymbolTable = hcSymbolTable;
        this.mManagedScript = managedScript;
        List<IProgramVar> list = iIcfgSymbolTable.getGlobals().stream().filter(predicate).collect(Collectors.toList());
        this.mNumberOfThreads = new LinkedHashMap<String, Integer>(map);
        this.mLocationIndices = new NestedMap2();
        this.mBottomLocation = this.numeral(-1L);
        HashMap<String, List<IProgramVar>> hashMap = new HashMap<String, List<IProgramVar>>();
        this.mPositions2Vars = new BidirectionalMap();
        for (String object2 : this.mNumberOfThreads.keySet()) {
            hashMap.put(object2, iIcfgSymbolTable.getLocals(object2).stream().filter(predicate).collect(Collectors.toList()));
        }
        this.initializeDefaultVars(list, hashMap);
        List list2 = IntStream.range(0, this.mPositions2Vars.size()).mapToObj(n -> ((IHcReplacementVar)this.mPositions2Vars.get((Object)n)).getSort()).collect(Collectors.toList());
        this.mPredicate = hcSymbolTable.getOrConstructHornClausePredicateSymbol(FUNCTION_NAME, list2);
        this.mDefaultHeadVars = IntStream.range(0, this.mPositions2Vars.size()).mapToObj(n -> this.constructHeadVar((IHcReplacementVar)this.mPositions2Vars.get((Object)n), n)).collect(Collectors.toList());
    }

    private HcHeadVar constructHeadVar(IHcReplacementVar iHcReplacementVar, int n) {
        return this.mHcSymbolTable.getOrConstructHeadVar(this.mPredicate, n, iHcReplacementVar.getSort(), (Object)iHcReplacementVar);
    }

    private void initializeDefaultVars(Collection<IProgramVar> collection, Map<String, List<IProgramVar>> map) {
        int n = 0;
        for (IProgramVar object : collection) {
            this.mPositions2Vars.put((Object)n, (Object)new HcGlobalVar(object));
            ++n;
        }
        for (Map.Entry entry : this.mNumberOfThreads.entrySet()) {
            String string = (String)entry.getKey();
            List<IProgramVar> list = map.get(string);
            int n2 = 0;
            while (n2 < (Integer)entry.getValue()) {
                this.mPositions2Vars.put((Object)n, (Object)new HcLocationVar(string, n2, this.getIntSort()));
                ++n;
                for (IProgramVar iProgramVar : list) {
                    this.mPositions2Vars.put((Object)n, (Object)new HcLocalVar(iProgramVar, n2));
                    ++n;
                }
                ++n2;
            }
        }
    }

    private Sort getIntSort() {
        return SmtSortUtils.getIntSort((Script)this.getScript());
    }

    private List<Term> getDefaultArgs() {
        return this.mDefaultHeadVars.stream().map(HcVar::getTerm).collect(Collectors.toList());
    }

    private Term numeral(long l) {
        return this.getScript().numeral(BigInteger.valueOf(l));
    }

    private Script getScript() {
        return this.mManagedScript.getScript();
    }

    private Term getLocIndexTerm(IcfgLocation icfgLocation, String string) {
        Integer n = (Integer)this.mLocationIndices.get((Object)string, (Object)icfgLocation);
        if (n == null) {
            Map map = this.mLocationIndices.get((Object)string);
            n = map == null ? 0 : map.size();
            this.mLocationIndices.put((Object)string, (Object)icfgLocation, (Object)n);
        }
        return this.numeral(n.intValue());
    }

    public HornClause getInitialClause(Collection<IcfgLocation> collection) {
        NestedMap2 nestedMap2 = new NestedMap2();
        for (Map.Entry<String, Integer> icfgLocation : this.mNumberOfThreads.entrySet()) {
            int string = 0;
            while (string < icfgLocation.getValue()) {
                nestedMap2.put((Object)icfgLocation.getKey(), (Object)string, (Object)this.mBottomLocation);
                ++string;
            }
        }
        for (IcfgLocation icfgLocation : collection) {
            String string = icfgLocation.getProcedure();
            nestedMap2.put((Object)string, (Object)0, (Object)this.getLocIndexTerm(icfgLocation, string));
        }
        return this.constructHornClause(this.getConstraintFromLocationMap((NestedMap2<String, Integer, Term>)nestedMap2), List.of(), Set.of());
    }

    private HornClause constructHornClause(Term term, List<List<Term>> list, Set<HcVar> set) {
        return new HornClause(this.mManagedScript, this.mHcSymbolTable, term, this.mPredicate, this.mDefaultHeadVars, Collections.nCopies(list.size(), this.mPredicate), list, set);
    }

    private Term getConstraintFromLocationMap(NestedMap2<String, Integer, Term> nestedMap2) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        for (Triple triple : nestedMap2.entrySet()) {
            HcLocationVar hcLocationVar = new HcLocationVar((String)triple.getFirst(), (Integer)triple.getSecond(), this.getIntSort());
            int n = (Integer)this.mPositions2Vars.inverse().get((Object)hcLocationVar);
            Term term = this.mDefaultHeadVars.get(n).getTerm();
            arrayList.add(SmtUtils.binaryEquality((Script)this.getScript(), (Term)term, (Term)((Term)triple.getThird())));
        }
        return SmtUtils.and((Script)this.getScript(), arrayList);
    }

    public Collection<HornClause> getSafetyClauses(Collection<IcfgLocation> collection) {
        ArrayList<HornClause> arrayList = new ArrayList<HornClause>();
        HashSet<HcHeadVar> hashSet = new HashSet<HcHeadVar>(this.mDefaultHeadVars);
        List<Term> list = this.getDefaultArgs();
        for (IcfgLocation icfgLocation : collection) {
            String string = icfgLocation.getProcedure();
            int n = 0;
            while (n < this.mNumberOfThreads.get(string)) {
                NestedMap2 nestedMap2 = new NestedMap2();
                nestedMap2.put((Object)string, (Object)n, (Object)this.getLocIndexTerm(icfgLocation, string));
                Term term = this.getConstraintFromLocationMap((NestedMap2<String, Integer, Term>)nestedMap2);
                arrayList.add(new HornClause(this.mManagedScript, this.mHcSymbolTable, term, List.of(this.mPredicate), List.of(list), hashSet));
                ++n;
            }
        }
        return arrayList;
    }

    private List<Map<String, Integer>> getCartesianProductOfIndices(Collection<String> collection) {
        List<Map<String, Integer>> list = List.of(Map.of());
        for (String string : collection) {
            ArrayList<Map<String, Integer>> arrayList = new ArrayList<Map<String, Integer>>();
            int n = 0;
            while (n < this.mNumberOfThreads.get(string)) {
                for (Map<String, Integer> map : list) {
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>(map);
                    hashMap.put(string, n);
                    arrayList.add(hashMap);
                }
                ++n;
            }
            list = arrayList;
        }
        return list;
    }

    public Collection<HornClause> getInductivityClauses(List<IcfgLocation> list, IIcfgTransition<?> iIcfgTransition, List<IcfgLocation> list2) {
        ArrayList<HornClause> arrayList = new ArrayList<HornClause>();
        Set<String> set = Stream.concat(list.stream(), list2.stream()).map(IcfgLocation::getProcedure).collect(Collectors.toSet());
        for (Map<String, Integer> map : this.getCartesianProductOfIndices(set)) {
            IHcReplacementVar iHcReplacementVar;
            IProgramVar iProgramVar;
            int n;
            Object object3;
            Object object2;
            IcfgLocation icfgLocation2;
            NestedMap2 nestedMap2 = new NestedMap2();
            NestedMap2 nestedMap22 = new NestedMap2();
            for (IcfgLocation icfgLocation2 : list) {
                object2 = icfgLocation2.getProcedure();
                nestedMap2.put(object2, (Object)map.get(object2), (Object)this.getLocIndexTerm(icfgLocation2, (String)object2));
            }
            for (IcfgLocation icfgLocation2 : list2) {
                object2 = icfgLocation2.getProcedure();
                nestedMap22.put(object2, (Object)map.get(object2), (Object)this.getLocIndexTerm(icfgLocation2, (String)object2));
            }
            icfgLocation2 = iIcfgTransition.getTransformula();
            HashMap hashMap = new HashMap();
            object2 = new ArrayList();
            List<Term> list3 = this.getDefaultArgs();
            HashSet<HcVar> hashSet = new HashSet<HcVar>();
            for (Object object3 : this.mPositions2Vars.entrySet()) {
                Term term;
                String string;
                n = (Integer)object3.getKey();
                IHcReplacementVar iHcReplacementVar2 = (IHcReplacementVar)object3.getValue();
                iProgramVar = null;
                if (iHcReplacementVar2 instanceof HcLocalVar && Objects.equals(map.get(((HcLocalVar)(iHcReplacementVar = (HcLocalVar)iHcReplacementVar2)).getProcedure()), ((HcLocalVar)iHcReplacementVar).getIndex())) {
                    iProgramVar = ((HcLocalVar)iHcReplacementVar).getVariable();
                }
                if (iHcReplacementVar2 instanceof HcGlobalVar) {
                    iHcReplacementVar = (HcGlobalVar)iHcReplacementVar2;
                    iProgramVar = ((HcGlobalVar)iHcReplacementVar).getVariable();
                }
                if (iHcReplacementVar2 instanceof HcLocationVar) {
                    iHcReplacementVar = (HcLocationVar)iHcReplacementVar2;
                    string = ((HcLocationVar)iHcReplacementVar).getProcedure();
                    int n2 = ((HcLocationVar)iHcReplacementVar).getIndex();
                    term = (Term)nestedMap2.get((Object)string, (Object)n2);
                    Term term2 = (Term)nestedMap22.get((Object)string, (Object)n2);
                    if (term == null && term2 == null) continue;
                    if (term == null) {
                        term = this.mBottomLocation;
                    }
                    if (term2 == null) {
                        term2 = this.mBottomLocation;
                    }
                    object2.add(SmtUtils.binaryEquality((Script)this.getScript(), (Term)this.mDefaultHeadVars.get(n).getTerm(), (Term)term2));
                    if (!term.equals(term2)) {
                        list3.set(n, term);
                    }
                }
                if (iProgramVar == null) continue;
                iHcReplacementVar = (TermVariable)icfgLocation2.getInVars().get(iProgramVar);
                string = (TermVariable)icfgLocation2.getOutVars().get(iProgramVar);
                hashMap.put(string, this.mDefaultHeadVars.get(n).getTerm());
                if (Objects.equals(iHcReplacementVar, string)) continue;
                HcBodyVar hcBodyVar = this.mHcSymbolTable.getOrConstructBodyVar(this.mPredicate, n, (IProgramVarOrConst)iProgramVar);
                term = hcBodyVar.getTerm();
                list3.set(n, term);
                hashMap.put(iHcReplacementVar, term);
                hashSet.add((HcVar)hcBodyVar);
            }
            object3 = icfgLocation2.getFormula();
            iProgramVar = object3.getFreeVars();
            int n3 = ((TermVariable[])iProgramVar).length;
            n = 0;
            while (n < n3) {
                TermVariable termVariable = iProgramVar[n];
                if (!hashMap.containsKey(termVariable)) {
                    iHcReplacementVar = this.mHcSymbolTable.getOrConstructBodyVar(this.mPredicate, hashSet.size(), termVariable.getSort(), (Object)termVariable);
                    hashMap.put(termVariable, iHcReplacementVar.getTerm());
                    hashSet.add((HcVar)iHcReplacementVar);
                }
                ++n;
            }
            object2.add(Substitution.apply((ManagedScript)this.mManagedScript, (Map)hashMap, (Term)object3));
            arrayList.add(this.constructHornClause(SmtUtils.and((Script)this.getScript(), (Collection)object2), List.of(list3), hashSet));
        }
        return arrayList;
    }

    public Collection<HornClause> getInductivityClauses(IIcfgTransition<?> iIcfgTransition) {
        return this.getInductivityClauses(List.of(iIcfgTransition.getSource()), iIcfgTransition, List.of(iIcfgTransition.getTarget()));
    }

    public HornClause getNonInterferenceClause(IIcfgTransition<?> iIcfgTransition) {
        IProgramVar iProgramVar;
        Object object;
        int n;
        Object object22;
        String string = iIcfgTransition.getPrecedingProcedure();
        int n2 = this.mNumberOfThreads.get(string);
        ArrayList<List<Term>> arrayList = new ArrayList<List<Term>>();
        int n3 = 0;
        while (n3 <= n2) {
            arrayList.add(this.getDefaultArgs());
            ++n3;
        }
        UnmodifiableTransFormula unmodifiableTransFormula = iIcfgTransition.getTransformula();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        HashSet<HcVar> hashSet = new HashSet<HcVar>();
        for (Object object22 : this.mPositions2Vars.entrySet()) {
            HcBodyVar hcBodyVar;
            TermVariable termVariable;
            TermVariable termVariable2;
            n = (Integer)object22.getKey();
            IHcReplacementVar iHcReplacementVar = (IHcReplacementVar)object22.getValue();
            if (iHcReplacementVar instanceof HcLocalVar && ((HcLocalVar)(object = (HcLocalVar)iHcReplacementVar)).getProcedure().equals(string)) {
                iProgramVar = ((HcLocalVar)object).getVariable();
                termVariable2 = (TermVariable)unmodifiableTransFormula.getInVars().get(iProgramVar);
                termVariable = (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVar);
                if (termVariable2 != null) {
                    hcBodyVar = this.mHcSymbolTable.getOrConstructBodyVar(this.mPredicate, n, (IProgramVarOrConst)iProgramVar);
                    hashSet.add((HcVar)hcBodyVar);
                    Term term = hcBodyVar.getTerm();
                    hashMap.put(termVariable2, term);
                    int n4 = 0;
                    while (n4 < n2) {
                        int n5 = (Integer)this.mPositions2Vars.inverse().get((Object)new HcLocalVar(iProgramVar, n4));
                        ((List)arrayList.get(n4 + 1)).set(n5, term);
                        ++n4;
                    }
                }
                if (termVariable != null && !termVariable.equals(termVariable2)) {
                    hcBodyVar = this.mHcSymbolTable.getOrConstructBodyVar(this.mPredicate, n, (IProgramVarOrConst)iProgramVar);
                    hashMap.put(termVariable, hcBodyVar.getTerm());
                    hashSet.add((HcVar)hcBodyVar);
                }
            }
            if (iHcReplacementVar instanceof HcGlobalVar) {
                object = ((HcGlobalVar)iHcReplacementVar).getVariable();
                iProgramVar = (TermVariable)unmodifiableTransFormula.getInVars().get(object);
                termVariable2 = (TermVariable)unmodifiableTransFormula.getOutVars().get(object);
                hashMap.put(termVariable2, this.mDefaultHeadVars.get(n).getTerm());
                if (!Objects.equals(iProgramVar, termVariable2)) {
                    termVariable = this.mHcSymbolTable.getOrConstructBodyVar(this.mPredicate, n, (IProgramVarOrConst)object);
                    hcBodyVar = termVariable.getTerm();
                    int n6 = 0;
                    while (n6 <= n2) {
                        ((List)arrayList.get(n6)).set(n, hcBodyVar);
                        ++n6;
                    }
                    hashMap.put(iProgramVar, hcBodyVar);
                    hashSet.add((HcVar)termVariable);
                }
            }
            if (!(iHcReplacementVar instanceof HcLocationVar) || !((HcLocationVar)(object = (HcLocationVar)iHcReplacementVar)).getProcedure().equals(string)) continue;
            iProgramVar = this.getLocIndexTerm(iIcfgTransition.getSource(), string);
            int n7 = 0;
            while (n7 < n2) {
                int n8 = (Integer)this.mPositions2Vars.inverse().get((Object)new HcLocationVar(string, n7, this.getIntSort()));
                ((List)arrayList.get(n7 + 1)).set(n8, iProgramVar);
                ++n7;
            }
        }
        object22 = unmodifiableTransFormula.getFormula();
        object = object22.getFreeVars();
        int n9 = ((TermVariable[])object).length;
        n = 0;
        while (n < n9) {
            TermVariable termVariable = object[n];
            if (!hashMap.containsKey(termVariable)) {
                iProgramVar = this.mHcSymbolTable.getOrConstructBodyVar(this.mPredicate, hashSet.size(), termVariable.getSort(), (Object)termVariable);
                hashMap.put(termVariable, iProgramVar.getTerm());
                hashSet.add((HcVar)iProgramVar);
            }
            ++n;
        }
        return this.constructHornClause(Substitution.apply((ManagedScript)this.mManagedScript, hashMap, (Term)unmodifiableTransFormula.getFormula()), arrayList, hashSet);
    }

    public static interface IHcReplacementVar {
        public Sort getSort();
    }
}

