/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.benchmark;

import de.uni_freiburg.informatik.ultimate.automata.IAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.output.BoogiePrettyPrinter;
import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.util.RCFGEdgeVisitor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

public class LineCoverageCalculator<LETTER extends IIcfgTransition<?>> {
    private final IUltimateServiceProvider mServices;
    private final LineCoverageCalculator<LETTER> mRelative;
    private final ILogger mLogger;
    private final Set<Integer> mLinenumbers;

    public LineCoverageCalculator(IUltimateServiceProvider iUltimateServiceProvider, IAutomaton<LETTER, IPredicate> iAutomaton) {
        this(iUltimateServiceProvider, iAutomaton, null);
    }

    public LineCoverageCalculator(IUltimateServiceProvider iUltimateServiceProvider, IAutomaton<LETTER, IPredicate> iAutomaton, LineCoverageCalculator<LETTER> lineCoverageCalculator) {
        this.mServices = iUltimateServiceProvider;
        this.mRelative = lineCoverageCalculator;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mLinenumbers = this.calculateLineNumbers(iAutomaton);
    }

    public void reportCoverage(String string) {
        int n = this.getLineCount();
        String string2 = "Line coverage for " + string;
        if (this.mRelative == null) {
            if (n == 0) {
                return;
            }
            this.reportResult(n, n, string2);
        } else {
            int n2 = this.mRelative.getLineCount();
            if (n2 == 0) {
                return;
            }
            this.reportResult(n, n2, string2);
        }
    }

    private void reportResult(int n, int n2, String string) {
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)new StatisticsResult(Activator.PLUGIN_ID, string, (ICsvProviderProvider)new LineCoverageResult(n2, n)));
    }

    private int getLineCount() {
        return this.mLinenumbers.size();
    }

    private Set<Integer> calculateLineNumbers(IAutomaton<LETTER, IPredicate> iAutomaton) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (iAutomaton == null) {
            this.mLogger.warn((Object)"NULL automaton has no lines");
            return hashSet;
        }
        Set<LETTER> set = this.getCodeblocks(iAutomaton);
        for (IIcfgTransition iIcfgTransition : set) {
            if ("ULTIMATE.start".equals(iIcfgTransition.getPrecedingProcedure()) || !(iIcfgTransition instanceof CodeBlock)) continue;
            hashSet.addAll(this.calculateLineNumbers((CodeBlock)iIcfgTransition));
        }
        return hashSet;
    }

    private Set<Integer> calculateLineNumbers(CodeBlock codeBlock) {
        LineCoverageOfEdges lineCoverageOfEdges = new LineCoverageOfEdges(this.mLogger);
        lineCoverageOfEdges.process((IcfgEdge)codeBlock);
        return lineCoverageOfEdges.mLineNumbers;
    }

    private Set<LETTER> getCodeblocks(IAutomaton<LETTER, IPredicate> iAutomaton) {
        HashSet hashSet = new HashSet();
        if (iAutomaton instanceof INestedWordAutomaton) {
            INestedWordAutomaton iNestedWordAutomaton = (INestedWordAutomaton)iAutomaton;
            ArrayDeque<IPredicate> arrayDeque = new ArrayDeque<IPredicate>(iNestedWordAutomaton.getInitialStates());
            while (!arrayDeque.isEmpty()) {
                IPredicate iPredicate = (IPredicate)arrayDeque.removeFirst();
                this.addCodeblock(hashSet, arrayDeque, iNestedWordAutomaton.callSuccessors((Object)iPredicate));
                this.addCodeblock(hashSet, arrayDeque, iNestedWordAutomaton.internalSuccessors((Object)iPredicate));
                this.addCodeblock(hashSet, arrayDeque, iNestedWordAutomaton.returnSuccessors((Object)iPredicate));
                this.addCodeblock(hashSet, arrayDeque, iNestedWordAutomaton.summarySuccessors((Object)iPredicate));
            }
        }
        return hashSet;
    }

    private <T extends IOutgoingTransitionlet<LETTER, IPredicate>> void addCodeblock(Set<LETTER> set, Deque<IPredicate> deque, Iterable<T> iterable) {
        for (IOutgoingTransitionlet iOutgoingTransitionlet : iterable) {
            if (!set.add((IIcfgTransition)iOutgoingTransitionlet.getLetter())) continue;
            deque.addFirst((IPredicate)iOutgoingTransitionlet.getSucc());
        }
    }

    private static final class LineCoverageOfEdges
    extends RCFGEdgeVisitor {
        private final Set<Integer> mLineNumbers = new HashSet<Integer>();
        private final ILogger mLogger;

        private LineCoverageOfEdges(ILogger iLogger) {
            this.mLogger = iLogger;
        }

        private static ILocation getLocation(Statement statement) {
            if (statement instanceof AssumeStatement) {
                AssumeStatement assumeStatement = (AssumeStatement)statement;
                return assumeStatement.getFormula().getLocation();
            }
            if (statement instanceof CallStatement) {
                CallStatement callStatement = (CallStatement)statement;
                if (callStatement.getLocation().getStartLine() == callStatement.getLocation().getEndLine()) {
                    return callStatement.getLocation();
                }
                return null;
            }
            return statement.getLocation();
        }

        private void addLines(Statement statement) {
            int n;
            ILocation iLocation = LineCoverageOfEdges.getLocation(statement);
            if (iLocation == null) {
                this.mLogger.warn((Object)("Skipping empty location or multi-line location for statement " + BoogiePrettyPrinter.print((Statement)statement)));
                return;
            }
            int n2 = iLocation.getStartLine();
            if (n2 == (n = iLocation.getEndLine())) {
                this.mLineNumbers.add(n2);
            }
        }

        public void process(IcfgEdge icfgEdge) {
            this.visit(icfgEdge);
        }

        protected void visit(ParallelComposition parallelComposition) {
            for (CodeBlock codeBlock : parallelComposition.getCodeBlocks()) {
                this.visit(codeBlock);
            }
        }

        protected void visit(StatementSequence statementSequence) {
            for (Statement statement : statementSequence.getStatements()) {
                this.addLines(statement);
            }
        }

        protected void visit(Call call) {
            this.addLines((Statement)call.getCallStatement());
        }

        protected void visit(Return return_) {
            this.addLines((Statement)return_.getCallStatement());
        }
    }

    private static final class LineCoverageResult
    implements ICsvProviderProvider<String> {
        private final int mMax;
        private final int mCurrent;

        private LineCoverageResult(int n, int n2) {
            this.mMax = n;
            this.mCurrent = n2;
        }

        public ICsvProvider<String> createCsvProvider() {
            SimpleCsvProvider simpleCsvProvider = new SimpleCsvProvider(Arrays.asList("Covered lines", "Total lines", "Line coverage"));
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(String.valueOf(this.mCurrent));
            arrayList.add(String.valueOf(this.mMax));
            arrayList.add(String.valueOf(this.getCoverage()));
            simpleCsvProvider.addRow(arrayList);
            return simpleCsvProvider;
        }

        private double getCoverage() {
            return (double)this.mCurrent / (double)this.mMax * 1000.0;
        }

        public String toString() {
            return "Covered " + this.mCurrent + " Total " + this.mMax + " Coverage " + this.getCoverage();
        }
    }
}

