/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Analyze;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IEmptyStackStateFactory;
import de.uni_freiburg.informatik.ultimate.boogie.BoogieVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractInterpretationResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.ChainingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgStatementExtractor;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.builders.IInterpolantAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AbsIntTotalInterpolationAutomatonBuilder<LETTER extends IIcfgTransition<?>>
implements IInterpolantAutomatonBuilder<LETTER, IPredicate> {
    private static final long PRINT_PREDS_LIMIT = 30L;
    private static final boolean SIMPLE_HOARE_CHECK = true;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final NestedWordAutomaton<LETTER, IPredicate> mResult;
    private final CfgSmtToolkit mCsToolkit;
    private final Word<LETTER> mCurrentCounterExample;
    private final RcfgStatementExtractor mStatementExtractor;
    private final VariableCollector mVariableCollector;
    private final IIcfgSymbolTable mSymbolTable;

    public AbsIntTotalInterpolationAutomatonBuilder(IUltimateServiceProvider iUltimateServiceProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IAbstractInterpretationResult<?, LETTER, ?> iAbstractInterpretationResult, IPredicateUnifier iPredicateUnifier, CfgSmtToolkit cfgSmtToolkit, Word<LETTER> word, IIcfgSymbolTable iIcfgSymbolTable, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mCsToolkit = cfgSmtToolkit;
        this.mSymbolTable = iIcfgSymbolTable;
        this.mCurrentCounterExample = word;
        this.mVariableCollector = new VariableCollector();
        this.mStatementExtractor = new RcfgStatementExtractor();
        this.mResult = this.constructAutomaton(iNwaOutgoingLetterAndTransitionProvider, iAbstractInterpretationResult, iPredicateUnifier, iEmptyStackStateFactory);
    }

    private NestedWordAutomaton<LETTER, IPredicate> constructAutomaton(INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IAbstractInterpretationResult<?, LETTER, ?> iAbstractInterpretationResult, IPredicateUnifier iPredicateUnifier, IEmptyStackStateFactory<IPredicate> iEmptyStackStateFactory) {
        this.mLogger.info((Object)"Creating interpolant automaton from AI predicates (total)");
        NestedWordAutomaton nestedWordAutomaton = new NestedWordAutomaton(new AutomataLibraryServices(this.mServices), iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet(), iEmptyStackStateFactory);
        int n = this.mCurrentCounterExample.length();
        assert (n > 1) : "Unexpected: length of word smaller or equal to 1.";
        HashMap<IIcfgTransition, IPredicate> hashMap = new HashMap<IIcfgTransition, IPredicate>();
        IPredicate iPredicate = iPredicateUnifier.getFalsePredicate();
        HashSet<IPredicate> hashSet = new HashSet<IPredicate>();
        IPredicate iPredicate2 = iPredicateUnifier.getTruePredicate();
        hashSet.add(iPredicate2);
        nestedWordAutomaton.addState(true, false, (Object)iPredicate2);
        HashMap hashMap2 = new HashMap();
        int n2 = 0;
        while (n2 < n) {
            IPredicate iPredicate3;
            IIcfgTransition iIcfgTransition2 = (IIcfgTransition)this.mCurrentCounterExample.getSymbol(n2);
            Set set = (Set)iAbstractInterpretationResult.getLoc2States().get(iIcfgTransition2.getTarget());
            if (set == null) {
                iPredicate3 = iPredicate;
                if (this.mLogger.isDebugEnabled()) {
                    this.writeTransitionAddLog(n2, iIcfgTransition2, set, iPredicate2, iPredicate3);
                }
            } else {
                iPredicate3 = iPredicateUnifier.getOrConstructPredicateForDisjunction((Collection)set.stream().map(iAbstractState -> iAbstractState.getTerm(this.mCsToolkit.getManagedScript().getScript())).map(arg_0 -> ((IPredicateUnifier)iPredicateUnifier).getOrConstructPredicate(arg_0)).collect(Collectors.toSet()));
                if (!hashMap2.containsKey(iPredicate3)) {
                    hashMap2.put(iPredicate3, set.stream().collect(Collectors.toSet()));
                } else {
                    ((Set)hashMap2.get(iPredicate3)).addAll(set.stream().collect(Collectors.toSet()));
                }
                if (this.mLogger.isDebugEnabled()) {
                    this.writeTransitionAddLog(n2, iIcfgTransition2, set, iPredicate2, iPredicate3);
                }
            }
            if (hashSet.add(iPredicate3)) {
                nestedWordAutomaton.addState(false, iPredicate.equals(iPredicate3), (Object)iPredicate3);
            }
            if (iIcfgTransition2 instanceof IIcfgCallTransition) {
                nestedWordAutomaton.addCallTransition((Object)iPredicate2, (Object)iIcfgTransition2, (Object)iPredicate3);
                hashMap.put(iIcfgTransition2, iPredicate2);
            } else if (iIcfgTransition2 instanceof IIcfgReturnTransition) {
                IIcfgReturnTransition iIcfgReturnTransition = (IIcfgReturnTransition)iIcfgTransition2;
                IPredicate iPredicate4 = (IPredicate)hashMap.get(iIcfgReturnTransition.getCorrespondingCall());
                assert (iPredicate4 != null) : "Return does not have a corresponding call.";
                nestedWordAutomaton.addReturnTransition((Object)iPredicate2, (Object)iPredicate4, (Object)iIcfgTransition2, (Object)iPredicate3);
            } else {
                nestedWordAutomaton.addInternalTransition((Object)iPredicate2, (Object)iIcfgTransition2, (Object)iPredicate3);
            }
            iPredicate2 = iPredicate3;
            ++n2;
        }
        for (IPredicate iPredicate5 : nestedWordAutomaton.getFinalStates()) {
            iNwaOutgoingLetterAndTransitionProvider.getAlphabet().forEach(iIcfgTransition -> nestedWordAutomaton.addInternalTransition((Object)iPredicate5, iIcfgTransition, (Object)iPredicate5));
        }
        if (30L < (long)hashSet.size()) {
            this.mLogger.info((Object)("Using " + hashSet.size() + " predicates from AI: " + String.join((CharSequence)",", hashSet.stream().limit(30L).map(Object::toString).collect(Collectors.toList())) + "..."));
        } else {
            this.mLogger.info((Object)("Using " + hashSet.size() + " predicates from AI: " + String.join((CharSequence)",", hashSet.stream().map(Object::toString).collect(Collectors.toList()))));
        }
        this.enhanceResult(iNwaOutgoingLetterAndTransitionProvider, iAbstractInterpretationResult, nestedWordAutomaton, hashMap2, iPredicateUnifier);
        return nestedWordAutomaton;
    }

    private void enhanceResult(INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, IAbstractInterpretationResult<?, LETTER, ?> iAbstractInterpretationResult, NestedWordAutomaton<LETTER, IPredicate> nestedWordAutomaton, Map<IPredicate, Set<IAbstractState<?>>> map, IPredicateUnifier iPredicateUnifier) {
        Analyze analyze;
        this.mLogger.info((Object)"Enhancing interpolant automaton by introducing valid transitions between predicates.");
        int n = -1;
        if (this.mLogger.isDebugEnabled()) {
            analyze = new Analyze(new AutomataLibraryServices(this.mServices), nestedWordAutomaton);
            n = analyze.getNumberOfTransitions(Analyze.SymbolType.TOTAL);
        }
        analyze = map.keySet();
        IAbstractPostOperator iAbstractPostOperator = iAbstractInterpretationResult.getUsedDomain().getPostOperator();
        ChainingHoareTripleChecker chainingHoareTripleChecker = HoareTripleCheckerUtils.constructSdHoareTripleChecker((ILogger)this.mLogger, (CfgSmtToolkit)this.mCsToolkit, (IPredicateUnifier)iPredicateUnifier);
        for (IIcfgTransition iIcfgTransition : iNwaOutgoingLetterAndTransitionProvider.getAlphabet()) {
            IInternalAction iInternalAction = (IInternalAction)iIcfgTransition;
            if (iIcfgTransition instanceof IIcfgCallTransition || iIcfgTransition instanceof IIcfgReturnTransition) continue;
            Set<IProgramVarOrConst> set = this.mVariableCollector.collectVariableNames((CodeBlock)iIcfgTransition, this.mStatementExtractor, this.mSymbolTable);
            for (IPredicate iPredicate : analyze) {
                Set<IAbstractState<?>> set2 = map.get(iPredicate);
                for (IPredicate iPredicate2 : analyze) {
                    IncrementalPlicationChecker.Validity validity;
                    if (iInternalAction != null && (validity = chainingHoareTripleChecker.checkInternal(iPredicate, iInternalAction, iPredicate2)) != IncrementalPlicationChecker.Validity.UNKNOWN) {
                        if (validity == IncrementalPlicationChecker.Validity.VALID) {
                            nestedWordAutomaton.addInternalTransition((Object)iPredicate, (Object)iIcfgTransition, (Object)iPredicate2);
                        }
                        if (validity != IncrementalPlicationChecker.Validity.NOT_CHECKED) continue;
                        throw new UnsupportedOperationException("Validity result is NOT_CHECKED which should not happen.");
                    }
                    validity = map.get(iPredicate2);
                    boolean bl = true;
                    boolean bl2 = false;
                    for (IAbstractState<?> iAbstractState : set2) {
                        if (!AbsIntTotalInterpolationAutomatonBuilder.areCompatible(iAbstractState, set)) continue;
                        bl = false;
                        Collection<IAbstractState> collection = this.applyPostInternally(iAbstractState, iAbstractPostOperator, iIcfgTransition);
                        boolean bl3 = false;
                        block4: for (IAbstractState iAbstractState2 : validity) {
                            for (IAbstractState iAbstractState3 : collection) {
                                if (!AbsIntTotalInterpolationAutomatonBuilder.isSubsetInternally(iAbstractState3, iAbstractState2)) continue;
                                bl3 = true;
                                break block4;
                            }
                        }
                        if (bl3) continue;
                        bl2 = true;
                        break;
                    }
                    if (bl || bl2) continue;
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug((Object)("Adding new transition: [" + iPredicate.hashCode() + "] -> " + String.valueOf(iIcfgTransition) + " [" + iPredicate2.hashCode() + "]"));
                    }
                    nestedWordAutomaton.addInternalTransition((Object)iPredicate, (Object)iIcfgTransition, (Object)iPredicate2);
                }
            }
        }
        if (this.mLogger.isDebugEnabled()) {
            IIcfgTransition iIcfgTransition;
            iIcfgTransition = new Analyze(new AutomataLibraryServices(this.mServices), nestedWordAutomaton);
            int n2 = iIcfgTransition.getNumberOfTransitions(Analyze.SymbolType.TOTAL);
            this.mLogger.debug((Object)("Enhancement added " + (n2 - n) + " transitions."));
            this.mLogger.debug((Object)("# Transitions before: " + n));
            this.mLogger.debug((Object)("# Transitions after : " + n2));
        }
    }

    private void writeTransitionAddLog(int n, LETTER LETTER, Set<IAbstractState<?>> set, IPredicate iPredicate, IPredicate iPredicate2) {
        if (n == 0) {
            this.mLogger.debug((Object)"------------------------------------------------");
        }
        this.mLogger.debug((Object)("Transition: " + String.valueOf(LETTER)));
        this.mLogger.debug((Object)("Original Target States: " + String.valueOf(set == null ? "NONE" : set)));
        this.mLogger.debug((Object)("Source Term: " + String.valueOf(iPredicate)));
        this.mLogger.debug((Object)("Target Term: " + String.valueOf(iPredicate2)));
        this.mLogger.debug((Object)"------------------------------------------------");
    }

    @Override
    public NestedWordAutomaton<LETTER, IPredicate> getResult() {
        return this.mResult;
    }

    private Collection<IAbstractState> applyPostInternally(IAbstractState<?> iAbstractState, IAbstractPostOperator iAbstractPostOperator, LETTER LETTER) {
        return iAbstractPostOperator.apply(iAbstractState, LETTER);
    }

    private static boolean isSubsetInternally(IAbstractState iAbstractState, IAbstractState iAbstractState2) {
        if (iAbstractState.getVariables().size() != iAbstractState2.getVariables().size()) {
            return false;
        }
        if (!iAbstractState.getVariables().stream().allMatch(arg_0 -> ((ImmutableSet)iAbstractState2.getVariables()).contains(arg_0))) {
            return false;
        }
        IAbstractState.SubsetResult subsetResult = iAbstractState.isSubsetOf(iAbstractState2);
        return subsetResult != IAbstractState.SubsetResult.NONE;
    }

    private static boolean areCompatible(IAbstractState iAbstractState, Set<IProgramVarOrConst> set) {
        assert (iAbstractState != null);
        assert (set != null);
        if (set.isEmpty()) {
            return true;
        }
        if (iAbstractState.getVariables().isEmpty()) {
            return false;
        }
        ImmutableSet immutableSet = iAbstractState.getVariables();
        for (IProgramVarOrConst iProgramVarOrConst : set) {
            if (immutableSet.contains(iProgramVarOrConst)) continue;
            return false;
        }
        return true;
    }

    private static final class VariableCollector
    extends BoogieVisitor {
        private Set<IProgramVarOrConst> mVariables;
        private Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;

        private VariableCollector() {
        }

        private Set<IProgramVarOrConst> collectVariableNames(CodeBlock codeBlock, RcfgStatementExtractor rcfgStatementExtractor, IIcfgSymbolTable iIcfgSymbolTable) {
            this.mVariables = new HashSet<IProgramVarOrConst>();
            this.mBoogie2SmtSymbolTable = (Boogie2SmtSymbolTable)iIcfgSymbolTable;
            for (Statement statement : rcfgStatementExtractor.process((IcfgEdge)codeBlock)) {
                this.processStatement(statement);
            }
            return this.mVariables;
        }

        protected void visit(IdentifierExpression identifierExpression) {
            this.mVariables.add((IProgramVarOrConst)this.mBoogie2SmtSymbolTable.getBoogieVar(identifierExpression.getIdentifier(), identifierExpression.getDeclarationInformation(), false));
        }

        protected void visit(VariableLHS variableLHS) {
            this.mVariables.add((IProgramVarOrConst)this.mBoogie2SmtSymbolTable.getBoogieVar(variableLHS.getIdentifier(), variableLHS.getDeclarationInformation(), false));
        }
    }
}

