/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph;

import de.uni_freiburg.informatik.ultimate.automata.tree.TreeRun;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HornClause;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HCSSABuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.treeautomizer.graph.HcSsaTreeFlattener;
import java.util.HashSet;
import java.util.Map;

public class TreeChecker {
    private final TreeRun<HornClause, IPredicate> mTree;
    private final ManagedScript mBackendSmtSolverScript;
    private final HCPredicate mPostCondition;
    private final HCPredicate mPreCondition;
    private final HCSSABuilder mSSABuilder;
    private final ILogger mLogger;
    private final PredicateUnifier mPredicateUnifier;

    public TreeChecker(TreeRun<HornClause, IPredicate> treeRun, ManagedScript managedScript, HCPredicate hCPredicate, HCPredicate hCPredicate2, ILogger iLogger, PredicateUnifier predicateUnifier, HcSymbolTable hcSymbolTable) {
        this.mTree = treeRun;
        this.mBackendSmtSolverScript = managedScript;
        this.mPostCondition = hCPredicate2;
        this.mPreCondition = hCPredicate;
        this.mPredicateUnifier = predicateUnifier;
        this.mSSABuilder = new HCSSABuilder(this.mTree, (IPredicate)this.mPreCondition, (IPredicate)this.mPostCondition, this.mBackendSmtSolverScript, this.mPredicateUnifier, hcSymbolTable);
        this.mLogger = iLogger;
    }

    public TreeRun<HornClause, IPredicate> annotateTreeRunWithInterpolants(Map<TreeRun<HornClause, IPredicate>, Term> map) {
        return this.mSSABuilder.buildTreeRunWithBackVersionedInterpolants(map);
    }

    protected HcSsaTreeFlattener getSSA() {
        return this.mSSABuilder.getSSA();
    }

    protected Script.LBool checkTrace(Object object) {
        Term term;
        HcSsaTreeFlattener hcSsaTreeFlattener = this.getSSA();
        Term[] termArray = hcSsaTreeFlattener.getFlattenedTermList();
        HashSet<String> hashSet = new HashSet<String>();
        Term[] termArray2 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term = termArray2[n2];
            Annotation annotation = new Annotation(":named", (Object)hcSsaTreeFlattener.getName(term));
            if (!hashSet.contains(hcSsaTreeFlattener.getName(term))) {
                this.mLogger.debug((Object)("assert: " + hcSsaTreeFlattener.getName(term) + " :: " + term.toString()));
                hashSet.add(hcSsaTreeFlattener.getName(term));
                Term term2 = this.mBackendSmtSolverScript.annotate(object, term, new Annotation[]{annotation});
                this.mBackendSmtSolverScript.assertTerm(object, term2);
            }
            ++n2;
        }
        term = this.mBackendSmtSolverScript.checkSat(object);
        return term;
    }
}

