/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.UnaryExpression;

public class LTLPrettyPrinter
extends ACSLVisitor {
    private static final char BLANK = ' ';
    private static final char PARENTHESIS_CLOSE = ')';
    private static final char PARENTHESIS_OPEN = '(';
    protected StringBuilder mBuilder;

    public String print(ACSLNode aCSLNode) {
        this.mBuilder = new StringBuilder();
        aCSLNode.accept(this);
        return this.mBuilder.toString();
    }

    @Override
    public boolean visit(BinaryExpression binaryExpression) {
        this.mBuilder.append('(');
        binaryExpression.getLeft().accept(this);
        this.mBuilder.append(' ').append(ACSLPrettyPrinter.binaryOperatorToString(binaryExpression.getOperator())).append(' ');
        binaryExpression.getRight().accept(this);
        this.mBuilder.append(')');
        return false;
    }

    @Override
    public boolean visit(UnaryExpression unaryExpression) {
        this.mBuilder.append(ACSLPrettyPrinter.unaryOperatorToString(unaryExpression.getOperator())).append('(');
        unaryExpression.getExpr().accept(this);
        this.mBuilder.append(')');
        return false;
    }

    @Override
    public boolean visit(BooleanLiteral booleanLiteral) {
        this.mBuilder.append(booleanLiteral.getValue());
        return super.visit(booleanLiteral);
    }

    @Override
    public boolean visit(IdentifierExpression identifierExpression) {
        this.mBuilder.append(identifierExpression.getIdentifier());
        return super.visit(identifierExpression);
    }

    @Override
    public boolean visit(IntegerLiteral integerLiteral) {
        this.mBuilder.append(integerLiteral.getValue());
        return super.visit(integerLiteral);
    }

    @Override
    public boolean visit(RealLiteral realLiteral) {
        this.mBuilder.append(realLiteral.getValue());
        return super.visit(realLiteral);
    }
}

