/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeAnnot;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.CodeStatement;
import java.util.List;
import java.util.function.Predicate;

public final class CodeAnnotStmt
extends CodeAnnot {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(CodeAnnotStmt.class);
    CodeStatement codeStmt;

    public CodeAnnotStmt(CodeStatement codeStatement) {
        this.codeStmt = codeStatement;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid CodeAnnotStmt: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CodeAnnotStmt").append('[');
        stringBuffer.append(this.codeStmt);
        return stringBuffer.append(']').toString();
    }

    public CodeStatement getCodeStmt() {
        return this.codeStmt;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        list.add(this.codeStmt);
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((CodeAnnot)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.codeStmt != null) {
            this.codeStmt.accept(aCSLVisitor);
        }
    }

    @Override
    public CodeAnnot accept(ACSLTransformer aCSLTransformer) {
        CodeAnnot codeAnnot = aCSLTransformer.transform(this);
        if (codeAnnot != this) {
            return codeAnnot;
        }
        CodeStatement codeStatement = null;
        if (this.codeStmt != null) {
            codeStatement = this.codeStmt.accept(aCSLTransformer);
        }
        if (this.codeStmt != codeStatement) {
            return new CodeAnnotStmt(codeStatement);
        }
        return this;
    }
}

