/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Word<LETTER>
implements Iterable<LETTER> {
    private static final String QUOTE_SPACE = "\" ";
    private static final char QUOTE = '\"';
    protected final LETTER[] mWord;

    @SafeVarargs
    public Word(LETTER ... LETTERArray) {
        this.mWord = LETTERArray;
    }

    public int length() {
        return this.mWord.length;
    }

    public List<LETTER> asList() {
        return Arrays.asList(this.mWord);
    }

    public Set<LETTER> asSet() {
        return new HashSet<LETTER>(Arrays.asList(this.mWord));
    }

    public LETTER getSymbol(int n) {
        if (n < 0 || n >= this.length()) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.mWord[n];
    }

    public Word<LETTER> concatenate(Word<LETTER> word) {
        return new Word<Object>(CoreUtil.concatAll((Object[])this.mWord, (Object[][])new Object[][]{word.mWord}));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n = 0;
        while (n < this.length()) {
            stringBuilder.append('\"');
            stringBuilder.append(this.getSymbol(n));
            stringBuilder.append(QUOTE_SPACE);
            ++n;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<LETTER> iterator() {
        return this.asList().iterator();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.deepHashCode(this.mWord);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Word word = (Word)object;
        return Arrays.deepEquals(this.mWord, word.mWord);
    }
}

