/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.counting.Counter;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.FinalCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.Guard;
import de.uni_freiburg.informatik.ultimate.automata.counting.InitialCondition;
import de.uni_freiburg.informatik.ultimate.automata.counting.TermType;
import de.uni_freiburg.informatik.ultimate.automata.counting.Transition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class Complement<LETTER, STATE, CRSF extends IStateFactory<STATE>>
implements IOperation<LETTER, STATE, CRSF> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final CountingAutomaton<LETTER, STATE> mOperand;
    private final CountingAutomaton<LETTER, STATE> mResult;
    private final IIntersectionStateFactory<STATE> mStateFactory;

    public Complement(AutomataLibraryServices automataLibraryServices, IIntersectionStateFactory<STATE> iIntersectionStateFactory, CountingAutomaton<LETTER, STATE> countingAutomaton) throws AutomataLibraryException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(this.getClass());
        this.mOperand = countingAutomaton;
        this.mStateFactory = iIntersectionStateFactory;
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.computeResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private CountingAutomaton<LETTER, STATE> computeResult() {
        Object object2;
        ArrayList<Counter> arrayList = new ArrayList<Counter>();
        for (Counter object22 : this.mOperand.getCounter()) {
            arrayList.add(object22.copyCounter());
        }
        HashMap<STATE, InitialCondition> hashMap = new HashMap<STATE, InitialCondition>();
        HashMap hashMap2 = new HashMap();
        HashMap hashMap3 = new HashMap();
        for (Object object2 : this.mOperand.getStates()) {
            ArrayList<Guard> arrayList2;
            Object object32;
            Iterator<Object> iterator;
            Object object42;
            hashMap.put(object2, this.mOperand.getInitialConditions().get(object2).copyInitialCondition());
            ArrayList<Transition<LETTER, STATE>> arrayList3 = new ArrayList<Transition<LETTER, STATE>>();
            for (Transition<LETTER, STATE> transition : this.mOperand.getTransitions().get(object2)) {
                arrayList3.add(transition.copyTransition());
            }
            hashMap3.put(object2, arrayList3);
            ArrayList<ArrayList<Guard>> arrayList4 = this.mOperand.getFinalConditions().get(object2).copyFinalCondition().getCondition();
            for (Object object42 : arrayList4) {
                iterator = ((ArrayList)object42).iterator();
                while (iterator.hasNext()) {
                    object32 = (Guard)iterator.next();
                    if (((Guard)object32).getTermType() == TermType.TRUE) {
                        ((Guard)object32).changeTermType(TermType.FALSE);
                        continue;
                    }
                    if (((Guard)object32).getTermType() == TermType.FALSE) {
                        ((Guard)object32).changeTermType(TermType.TRUE);
                        continue;
                    }
                    switch (((Guard)object32).getRelationSymbol()) {
                        case EQ: {
                            ((Guard)object32).changeRelationType(RelationSymbol.DISTINCT);
                            break;
                        }
                        case DISTINCT: {
                            ((Guard)object32).changeRelationType(RelationSymbol.EQ);
                            break;
                        }
                        case LESS: {
                            ((Guard)object32).changeRelationType(RelationSymbol.GEQ);
                            break;
                        }
                        case GREATER: {
                            ((Guard)object32).changeRelationType(RelationSymbol.LEQ);
                            break;
                        }
                        case LEQ: {
                            ((Guard)object32).changeRelationType(RelationSymbol.GREATER);
                            break;
                        }
                        case GEQ: {
                            ((Guard)object32).changeRelationType(RelationSymbol.LESS);
                        }
                    }
                }
            }
            if (arrayList4.size() == 1) {
                for (Object object42 : arrayList4.get(0)) {
                    object32 = new ArrayList();
                    ((ArrayList)object32).add(((Guard)object42).copyGuard());
                    arrayList4.add((ArrayList<Guard>)object32);
                }
                arrayList4.remove(0);
                hashMap2.put(object2, new FinalCondition(arrayList4));
                continue;
            }
            object42 = new ArrayList();
            ArrayList arrayList5 = new ArrayList();
            for (Object object32 : arrayList4.get(0)) {
                for (Object object5 : arrayList4.get(1)) {
                    arrayList2 = new ArrayList<Guard>();
                    arrayList2.add(((Guard)object32).copyGuard());
                    arrayList2.add(((Guard)object5).copyGuard());
                    arrayList5.add(arrayList2);
                }
            }
            arrayList4.remove(0);
            arrayList4.remove(0);
            while (arrayList4.size() > 0) {
                for (Object object32 : arrayList4.get(0)) {
                    Iterator<Guard> iterator2 = arrayList5.iterator();
                    while (iterator2.hasNext()) {
                        Object object5;
                        object5 = (ArrayList)((Object)iterator2.next());
                        arrayList2 = new ArrayList();
                        Iterator iterator3 = ((ArrayList)object5).iterator();
                        while (iterator3.hasNext()) {
                            Guard guard = (Guard)iterator3.next();
                            arrayList2.add(guard.copyGuard());
                        }
                        arrayList2.add(((Guard)object32).copyGuard());
                        ((ArrayList)object42).add(arrayList2);
                    }
                }
                arrayList5.clear();
                iterator = ((ArrayList)object42).iterator();
                while (iterator.hasNext()) {
                    object32 = (ArrayList)iterator.next();
                    arrayList5.add(new ArrayList(object32));
                }
                arrayList4.remove(0);
                ((ArrayList)object42).clear();
            }
            hashMap2.put(object2, new FinalCondition(arrayList5));
        }
        object2 = new CountingAutomaton<LETTER, STATE>(this.mServices, this.mOperand.getAlphabet(), this.mOperand.getStates(), arrayList, hashMap, hashMap2, hashMap3);
        return object2;
    }

    @Override
    public CountingAutomaton<LETTER, STATE> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        return true;
    }
}

