/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.SetOfStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.VpAlphabet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IRelabelStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.util.ConstructionCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.TransformIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class RelabelNwa<LETTER, STATE>
implements INwaOutgoingTransitionProvider<LETTER, STATE> {
    private final IRelabelStateFactory<STATE> mStateFactory;
    private final INwaOutgoingTransitionProvider<LETTER, STATE> mOperand;
    private final ConstructionCache<STATE, STATE> mNewStateCache;
    private final Map<STATE, STATE> mNewState2OldState;
    private final SetOfStates<STATE> mSetOfStates;
    private final Function<OutgoingInternalTransition<LETTER, STATE>, OutgoingInternalTransition<LETTER, STATE>> mInternalTransitionTransformer;
    private final Function<OutgoingCallTransition<LETTER, STATE>, OutgoingCallTransition<LETTER, STATE>> mCallTransitionTransformer;
    private final Function<OutgoingReturnTransition<LETTER, STATE>, OutgoingReturnTransition<LETTER, STATE>> mReturnTransitionTransformer;

    public RelabelNwa(final IRelabelStateFactory<STATE> iRelabelStateFactory, INwaOutgoingTransitionProvider<LETTER, STATE> iNwaOutgoingTransitionProvider) {
        this.mStateFactory = iRelabelStateFactory;
        this.mOperand = iNwaOutgoingTransitionProvider;
        this.mNewState2OldState = new HashMap<STATE, STATE>();
        ConstructionCache.IValueConstruction iValueConstruction = new ConstructionCache.IValueConstruction<STATE, STATE>(){
            int mStateCounter = 0;

            public STATE constructValue(STATE STATE) {
                Object STATE2 = iRelabelStateFactory.relabel(STATE, this.mStateCounter);
                ++this.mStateCounter;
                Object STATE3 = RelabelNwa.this.mNewState2OldState.put(STATE2, STATE);
                if (STATE3 != null) {
                    throw new AssertionError((Object)("double state " + String.valueOf(STATE3)));
                }
                boolean bl = RelabelNwa.this.mOperand.isInitial(STATE);
                boolean bl2 = RelabelNwa.this.mOperand.isFinal(STATE);
                RelabelNwa.this.mSetOfStates.addState(bl, bl2, STATE2);
                return STATE2;
            }
        };
        this.mNewStateCache = new ConstructionCache(iValueConstruction);
        this.mInternalTransitionTransformer = outgoingInternalTransition -> new OutgoingInternalTransition(outgoingInternalTransition.getLetter(), this.mNewStateCache.getOrConstruct(outgoingInternalTransition.getSucc()));
        this.mCallTransitionTransformer = outgoingCallTransition -> new OutgoingCallTransition(outgoingCallTransition.getLetter(), this.mNewStateCache.getOrConstruct(outgoingCallTransition.getSucc()));
        this.mReturnTransitionTransformer = outgoingReturnTransition -> new OutgoingReturnTransition(this.mNewStateCache.getOrConstruct(outgoingReturnTransition.getHierPred()), outgoingReturnTransition.getLetter(), this.mNewStateCache.getOrConstruct(outgoingReturnTransition.getSucc()));
        Object STATE = iRelabelStateFactory.createEmptyStackState();
        this.mSetOfStates = new SetOfStates(STATE);
        for (Object STATE2 : this.mOperand.getInitialStates()) {
            this.mNewStateCache.getOrConstruct(STATE2);
        }
    }

    @Override
    public Set<LETTER> getAlphabet() {
        return this.mOperand.getAlphabet();
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public int size() {
        return this.mOperand.size();
    }

    @Override
    public String sizeInformation() {
        return this.mOperand.sizeInformation();
    }

    @Override
    public VpAlphabet<LETTER> getVpAlphabet() {
        return this.mOperand.getVpAlphabet();
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mSetOfStates.getEmptyStackState();
    }

    @Override
    public Iterable<STATE> getInitialStates() {
        return this.mSetOfStates.getInitialStates();
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mSetOfStates.isInitial(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return this.mSetOfStates.isAccepting(STATE);
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE) {
        STATE STATE2 = this.mNewState2OldState.get(STATE);
        return () -> new TransformIterator(this.mOperand.internalSuccessors(STATE2).iterator(), this.mInternalTransitionTransformer);
    }

    @Override
    public Iterable<OutgoingCallTransition<LETTER, STATE>> callSuccessors(STATE STATE) {
        STATE STATE2 = this.mNewState2OldState.get(STATE);
        return () -> new TransformIterator(this.mOperand.callSuccessors(STATE2).iterator(), this.mCallTransitionTransformer);
    }

    @Override
    public Iterable<OutgoingReturnTransition<LETTER, STATE>> returnSuccessorsGivenHier(STATE STATE, STATE STATE2) {
        STATE STATE3 = this.mNewState2OldState.get(STATE);
        STATE STATE4 = this.mNewState2OldState.get(STATE2);
        return () -> new TransformIterator(this.mOperand.returnSuccessorsGivenHier(STATE3, STATE4).iterator(), this.mReturnTransitionTransformer);
    }
}

