/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateXsimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IIncomingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.ITransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

public class NwaApproximateBisimulation<LETTER, STATE>
extends NwaApproximateXsimulation<LETTER, STATE, Collection<Set<STATE>>> {
    private final Set<Set<STATE>> mPartition;

    public NwaApproximateBisimulation(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, NwaApproximateXsimulation.SimulationType simulationType) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNestedWordAutomaton, simulationType, true);
    }

    public NwaApproximateBisimulation(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, NwaApproximateXsimulation.SimulationType simulationType, boolean bl) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNestedWordAutomaton, simulationType, NwaApproximateBisimulation.createSingleBlockPartition(iNestedWordAutomaton.getStates()), bl);
    }

    public NwaApproximateBisimulation(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, NwaApproximateXsimulation.SimulationType simulationType, Collection<Set<STATE>> collection, boolean bl) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iNestedWordAutomaton);
        this.mPartition = collection instanceof Set ? (Set<Object>)collection : new HashSet<Set<STATE>>(collection);
        this.run(simulationType, bl);
        if (this.mLogger.isInfoEnabled()) {
            long l = this.countNumberOfNonreflexivePairs();
            this.mLogger.info((Object)("Approximate bisimulation contains " + l + " pairs (excluding reflexive pairs)."));
        }
    }

    public PartitionBackedSetOfPairs<STATE> getResult() {
        return new PartitionBackedSetOfPairs(this.mPartition);
    }

    @Override
    protected void initializeAllNonreflexivePairs() throws AutomataOperationCanceledException {
    }

    @Override
    protected void initializeAllNonreflexivePairsRespectingAcceptance() throws AutomataOperationCanceledException {
        ArrayList<ImmutableSet> arrayList = new ArrayList<ImmutableSet>();
        Iterator<Set<STATE>> iterator = this.mPartition.iterator();
        while (iterator.hasNext()) {
            Set<STATE> set = iterator.next();
            assert (!set.isEmpty()) : "The input sets should not be empty.";
            HashSet<STATE> hashSet = new HashSet<STATE>(set.size());
            HashSet<STATE> hashSet2 = new HashSet<STATE>(set.size());
            for (STATE STATE : set) {
                if (this.mOperand.isFinal(STATE)) {
                    hashSet.add(STATE);
                    continue;
                }
                hashSet2.add(STATE);
            }
            if (hashSet.isEmpty() || hashSet2.isEmpty()) continue;
            arrayList.add(ImmutableSet.of(hashSet));
            arrayList.add(ImmutableSet.of(hashSet2));
            iterator.remove();
        }
        this.mPartition.addAll(arrayList);
    }

    @Override
    protected void separateByDifferentSymbols() throws AutomataOperationCanceledException {
        LinkedList<Set<STATE>> linkedList = new LinkedList<Set<STATE>>(this.mPartition);
        boolean bl = !this.mOperand.getVpAlphabet().getCallAlphabet().isEmpty();
        while (!linkedList.isEmpty()) {
            Set set = (Set)linkedList.poll();
            if (set.size() == 1) continue;
            boolean bl2 = this.splitBySymbols(set, linkedList, this.mOperand::lettersInternal);
            if (!bl || bl2) continue;
            this.splitBySymbols(set, linkedList, this.mOperand::lettersCall);
        }
    }

    private boolean splitBySymbols(Set<STATE> set, Queue<Set<STATE>> queue, Function<STATE, Set<LETTER>> function) {
        ImmutableSet immutableSet;
        HashMap<ImmutableSet, HashSet<STATE>> hashMap = new HashMap<ImmutableSet, HashSet<STATE>>();
        for (Object object : set) {
            immutableSet = function.apply(object);
            HashSet<STATE> hashSet = (HashSet<STATE>)hashMap.get(immutableSet);
            if (hashSet == null) {
                hashSet = new HashSet<STATE>();
                hashMap.put(immutableSet, hashSet);
            }
            hashSet.add(object);
        }
        if (hashMap.size() == 1) {
            return false;
        }
        this.mPartition.remove(set);
        for (Object object : hashMap.values()) {
            immutableSet = ImmutableSet.of(object);
            this.mPartition.add((Set<STATE>)immutableSet);
            queue.add((Set<STATE>)immutableSet);
        }
        return true;
    }

    @Override
    protected void separateByTransitionConstraints() throws AutomataOperationCanceledException {
        LinkedList<Set<STATE>> linkedList = new LinkedList<Set<STATE>>();
        HashMap<STATE, Set<STATE>> hashMap = new HashMap<STATE, Set<STATE>>();
        for (Set<STATE> set : this.mPartition) {
            linkedList.add(set);
            for (STATE STATE : set) {
                hashMap.put(STATE, set);
            }
        }
        while (!linkedList.isEmpty()) {
            Set set = (Set)linkedList.poll();
            this.splitByPredecessors(set, hashMap, linkedList, this.mOperand::internalPredecessors, this.mOperand::internalPredecessors);
            this.splitByPredecessors(set, hashMap, linkedList, this.mOperand::callPredecessors, this.mOperand::callPredecessors);
        }
    }

    private void splitByPredecessors(Set<STATE> set, Map<STATE, Set<STATE>> map, Queue<Set<STATE>> queue, Function<STATE, Iterable<? extends ITransitionlet<LETTER, STATE>>> function, BiFunction<STATE, LETTER, Iterable<? extends IIncomingTransitionlet<LETTER, STATE>>> biFunction) {
        Set<LETTER> set2 = this.getAllTransitionLetters(set, function);
        HashSet<STATE> hashSet = new HashSet<STATE>();
        for (LETTER LETTER : set2) {
            for (STATE STATE : set) {
                for (IIncomingTransitionlet<LETTER, STATE> iIncomingTransitionlet : biFunction.apply(STATE, LETTER)) {
                    hashSet.add(iIncomingTransitionlet.getPred());
                }
            }
            this.split(hashSet, map, queue);
        }
    }

    private Set<LETTER> getAllTransitionLetters(Set<STATE> set, Function<STATE, Iterable<? extends ITransitionlet<LETTER, STATE>>> function) {
        HashSet<LETTER> hashSet = new HashSet<LETTER>();
        for (STATE STATE : set) {
            for (ITransitionlet<LETTER, STATE> iTransitionlet : function.apply(STATE)) {
                hashSet.add(iTransitionlet.getLetter());
            }
        }
        return hashSet;
    }

    private void split(Set<STATE> set, Map<STATE, Set<STATE>> map, Queue<Set<STATE>> queue) {
        while (!set.isEmpty()) {
            Iterator<STATE> iterator = set.iterator();
            STATE STATE = iterator.next();
            iterator.remove();
            this.splitBlock(STATE, set, map, queue);
        }
    }

    private void splitBlock(STATE STATE, Set<STATE> set, Map<STATE, Set<STATE>> map, Queue<Set<STATE>> queue) {
        Object object2;
        Set<STATE> set2 = map.get(STATE);
        HashSet<STATE> hashSet = new HashSet<STATE>();
        hashSet.add(STATE);
        HashSet<STATE> hashSet2 = new HashSet<STATE>();
        for (Object object2 : set2) {
            if (set.contains(object2)) {
                set.remove(object2);
                hashSet.add(object2);
                continue;
            }
            if (object2 == STATE) continue;
            hashSet2.add(object2);
        }
        if (hashSet2.isEmpty()) {
            return;
        }
        this.mPartition.remove(set2);
        object2 = ImmutableSet.of(hashSet);
        this.updatePartitionAndMap(map, (ImmutableSet<STATE>)object2);
        ImmutableSet immutableSet = ImmutableSet.of(hashSet2);
        this.updatePartitionAndMap(map, ImmutableSet.of((Set)immutableSet));
        if (object2.size() < immutableSet.size()) {
            queue.add((Set<STATE>)object2);
        } else {
            queue.add((Set<STATE>)immutableSet);
        }
    }

    private void updatePartitionAndMap(Map<STATE, Set<STATE>> map, ImmutableSet<STATE> immutableSet) {
        this.mPartition.add((Set<STATE>)immutableSet);
        for (Object e : immutableSet) {
            map.put((STATE)e, (Set<STATE>)immutableSet);
        }
    }

    private static <STATE> Collection<Set<STATE>> createSingleBlockPartition(Set<STATE> set) {
        HashSet<Set<STATE>> hashSet = new HashSet<Set<STATE>>();
        hashSet.add((Set<STATE>)ImmutableSet.of(set));
        return hashSet;
    }

    private long countNumberOfNonreflexivePairs() {
        long l = 0L;
        for (Set<STATE> set : this.mPartition) {
            long l2 = set.size();
            l += l2 * l2 - l2;
        }
        return l;
    }
}

