/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateXsimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IIncomingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IOutgoingTransitionlet;
import de.uni_freiburg.informatik.ultimate.automata.util.MapBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class NwaApproximateSimulation<LETTER, STATE>
extends NwaApproximateXsimulation<LETTER, STATE, Map<STATE, Set<STATE>>> {
    private final Map<STATE, Set<STATE>> mMayBeSimulatedBy = new HashMap<STATE, Set<STATE>>();
    private final HashRelation<STATE, STATE> mIsNotSimulatedBy = new HashRelation();

    public NwaApproximateSimulation(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, NwaApproximateXsimulation.SimulationType simulationType) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iNestedWordAutomaton, simulationType, true);
    }

    public NwaApproximateSimulation(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, NwaApproximateXsimulation.SimulationType simulationType, boolean bl) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iNestedWordAutomaton);
        this.run(simulationType, bl);
        if (this.mLogger.isInfoEnabled()) {
            long l = this.countNumberOfPairs();
            this.mLogger.info((Object)("Approximate simulation contains " + l + " pairs (excluding reflexive pairs)."));
        }
    }

    public MapBackedSetOfPairs<STATE> getResult() {
        return new ReflexiveMapBackedSetOfPairs<STATE>(this.mMayBeSimulatedBy, this.mOperand.getStates());
    }

    @Override
    protected void initializeAllNonreflexivePairs() throws AutomataOperationCanceledException {
        ArrayList arrayList = new ArrayList(this.mOperand.getStates());
        int n = 0;
        while (n < arrayList.size()) {
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            HashSet hashSet = new HashSet();
            int n2 = 0;
            while (n2 < arrayList.size()) {
                if (n != n2) {
                    hashSet.add(arrayList.get(n2));
                }
                ++n2;
            }
            this.mMayBeSimulatedBy.put(arrayList.get(n), hashSet);
            ++n;
        }
    }

    @Override
    protected void initializeAllNonreflexivePairsRespectingAcceptance() throws AutomataOperationCanceledException {
        ArrayList arrayList = new ArrayList(this.mOperand.getStates());
        int n = 0;
        while (n < arrayList.size()) {
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            HashSet hashSet = new HashSet();
            Object STATE = arrayList.get(n);
            if (!this.mOperand.isFinal(STATE)) {
                hashSet.addAll(arrayList);
            } else {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    if (n != n2) {
                        Object STATE2 = arrayList.get(n2);
                        if (this.mOperand.isFinal(STATE2)) {
                            hashSet.add(STATE2);
                        } else {
                            this.mIsNotSimulatedBy.addPair(STATE, STATE2);
                        }
                    }
                    ++n2;
                }
            }
            this.mMayBeSimulatedBy.put(STATE, hashSet);
            ++n;
        }
    }

    @Override
    protected void separateByDifferentSymbols() throws AutomataOperationCanceledException {
        ArrayList<STATE> arrayList = new ArrayList<STATE>();
        for (Map.Entry<STATE, Set<STATE>> object : this.mMayBeSimulatedBy.entrySet()) {
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            STATE STATE = object.getKey();
            Set set = this.mOperand.lettersInternal(STATE);
            Set set2 = this.mOperand.lettersCall(STATE);
            Set<STATE> set3 = object.getValue();
            ArrayList<STATE> arrayList2 = new ArrayList<STATE>(set3.size());
            for (Object object2 : set3) {
                if (this.mOperand.lettersInternal(object2).containsAll(set) && this.mOperand.lettersCall(object2).containsAll(set2)) continue;
                arrayList2.add(object2);
            }
            if (arrayList2.isEmpty()) continue;
            for (Object object2 : arrayList2) {
                set3.remove(object2);
                this.mIsNotSimulatedBy.addPair(STATE, object2);
            }
            if (!set3.isEmpty()) continue;
            arrayList.add(STATE);
        }
        for (Object object : arrayList) {
            this.mMayBeSimulatedBy.remove(object);
        }
    }

    @Override
    protected void separateByTransitionConstraints() throws AutomataOperationCanceledException {
        while (!this.mIsNotSimulatedBy.isEmpty()) {
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            Map.Entry entry = (Map.Entry)this.mIsNotSimulatedBy.iterator().next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            this.mIsNotSimulatedBy.removePair(k, v);
            for (Object LETTER : this.getCommonIncomingLetters(k, v, this.mOperand::lettersInternalIncoming)) {
                this.separatePredecessors(k, v, object2 -> this.mOperand.internalPredecessors(object2, LETTER), object2 -> this.mOperand.internalSuccessors(object2, LETTER));
            }
            for (Iterator iterator : this.getCommonIncomingLetters(k, v, this.mOperand::lettersCallIncoming)) {
                this.separatePredecessors(k, v, object2 -> this.mOperand.callPredecessors(object2, iterator), object2 -> this.mOperand.callSuccessors(object2, iterator));
            }
        }
    }

    private void separatePredecessors(STATE STATE, STATE STATE2, Function<STATE, Iterable<? extends IIncomingTransitionlet<LETTER, STATE>>> function, Function<STATE, Iterable<? extends IOutgoingTransitionlet<LETTER, STATE>>> function2) throws AutomataOperationCanceledException {
        Set<Object> set = this.mMayBeSimulatedBy.get(STATE);
        if (set == null) {
            set = Collections.emptySet();
        }
        for (IIncomingTransitionlet<LETTER, STATE> iIncomingTransitionlet : function.apply(STATE2)) {
            if (!this.mServices.getProgressAwareTimer().continueProcessing()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
            STATE STATE3 = iIncomingTransitionlet.getPred();
            boolean bl = false;
            for (IOutgoingTransitionlet<LETTER, STATE> iOutgoingTransitionlet : function2.apply(STATE3)) {
                STATE STATE4 = iOutgoingTransitionlet.getSucc();
                if (!STATE.equals(STATE4) && !set.contains(STATE4)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            for (IIncomingTransitionlet iIncomingTransitionlet2 : function.apply(STATE)) {
                this.separateStates(iIncomingTransitionlet2.getPred(), STATE3);
            }
        }
    }

    private void separateStates(STATE STATE, STATE STATE2) {
        Set<STATE> set = this.mMayBeSimulatedBy.get(STATE);
        if (set != null && set.contains(STATE2)) {
            set.remove(STATE2);
            if (set.isEmpty()) {
                this.mMayBeSimulatedBy.remove(STATE);
            }
            this.mIsNotSimulatedBy.addPair(STATE, STATE2);
        }
    }

    private long countNumberOfPairs() {
        long l = 0L;
        for (Set<STATE> set : this.mMayBeSimulatedBy.values()) {
            l += (long)set.size();
        }
        return l;
    }

    private static class ReflexiveMapBackedSetOfPairs<STATE>
    extends MapBackedSetOfPairs<STATE> {
        private final Set<STATE> mStates;

        public ReflexiveMapBackedSetOfPairs(Map<STATE, Set<STATE>> map, Set<STATE> set) {
            super(map);
            this.mStates = set;
        }

        @Override
        public boolean containsPair(STATE STATE, STATE STATE2) {
            return STATE.equals(STATE2) || super.containsPair(STATE, STATE2);
        }

        @Override
        public Iterator<Pair<STATE, STATE>> iterator() {
            final Iterator iterator = super.iterator();
            final Iterator<STATE> iterator2 = this.mStates.iterator();
            return new Iterator<Pair<STATE, STATE>>(){
                private boolean reflexiveMode = true;

                @Override
                public boolean hasNext() {
                    if (this.reflexiveMode) {
                        if (iterator2.hasNext()) {
                            return true;
                        }
                        this.reflexiveMode = false;
                    }
                    return iterator.hasNext();
                }

                @Override
                public Pair<STATE, STATE> next() {
                    if (this.reflexiveMode) {
                        if (!$assertionsDisabled && !iterator2.hasNext()) {
                            throw new AssertionError();
                        }
                        Object e = iterator2.next();
                        return new Pair(e, e);
                    }
                    if (!$assertionsDisabled && !iterator.hasNext()) {
                        throw new AssertionError();
                    }
                    return (Pair)iterator.next();
                }
            };
        }

        @Override
        public Map<STATE, Set<STATE>> getRelation() {
            throw new UnsupportedOperationException("The map is not reflexive, hence we do not provide it.");
        }
    }
}

