/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.simulation.performance;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class PlotCsvUtils {
    public static final String CSV_SEPARATOR = "\t";
    public static final File DESKTOP = new File(System.getProperty("user.home"), "Desktop");

    private PlotCsvUtils() {
    }

    public static void appendColumnToCsv(File file, List<String> list) throws IOException {
        List<String> list2 = PlotCsvUtils.getFileContent(file);
        if (list2.size() != list.size()) {
            System.err.println("Error: Size of CSV must be equal to the size of the column to add.");
        }
        Iterator<String> iterator = list.iterator();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : list2) {
            String string2 = iterator.next();
            String object = string + CSV_SEPARATOR + string2;
            linkedList.add(object);
        }
        PlotCsvUtils.writeFile(file, linkedList);
    }

    public static List<String> getColumnContent(List<String> list, int n) {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string : list) {
            String[] stringArray = string.split(CSV_SEPARATOR);
            linkedList.add(stringArray[n]);
        }
        return linkedList;
    }

    public static List<String> getFileContent(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
            ArrayList<String> arrayList = new ArrayList<String>();
            String string = bufferedReader.readLine();
            while (string != null) {
                arrayList.add(string);
                string = bufferedReader.readLine();
            }
            return arrayList;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void main(String[] stringArray) throws IOException {
        System.out.println("Starting...");
        File file = new File(DESKTOP, "plotData_direct.csv");
        File file2 = new File(DESKTOP, "plotData_delayed.csv");
        File file3 = new File(DESKTOP, "plotData_combined.csv");
        List<String> list = PlotCsvUtils.getFileContent(file);
        List<String> list2 = PlotCsvUtils.getFileContent(file2);
        List<String> list3 = PlotCsvUtils.getColumnContent(list2, 13);
        List<String> list4 = PlotCsvUtils.getColumnContent(list2, 14);
        PlotCsvUtils.writeFile(file3, list);
        PlotCsvUtils.renameColumnHeader(file3, 13, "SIZE_OUTPUT_DIRECT");
        PlotCsvUtils.renameColumnHeader(file3, 14, "OVERALL_TIME_DIRECT");
        PlotCsvUtils.appendColumnToCsv(file3, list3);
        PlotCsvUtils.appendColumnToCsv(file3, list4);
        PlotCsvUtils.renameColumnHeader(file3, 15, "SIZE_OUTPUT_DELAYED");
        PlotCsvUtils.renameColumnHeader(file3, 16, "OVERALL_TIME_DELAYED");
        System.out.println("Finished.");
    }

    public static void renameColumnHeader(File file, int n, String string) throws IOException {
        List<String> list = PlotCsvUtils.getFileContent(file);
        Iterator<String> iterator = list.iterator();
        String string2 = iterator.next();
        CharSequence[] charSequenceArray = string2.split(CSV_SEPARATOR);
        charSequenceArray[n] = string;
        String string3 = String.join((CharSequence)CSV_SEPARATOR, charSequenceArray);
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add(string3);
        while (iterator.hasNext()) {
            linkedList.add(iterator.next());
        }
        PlotCsvUtils.writeFile(file, linkedList);
    }

    public static void writeFile(File file, List<String> list) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(file, false));
        for (String string : list) {
            printWriter.println(string);
        }
        printWriter.close();
    }
}

