/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Label;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.AffineExpression;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.BoolValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.IfExpressionTree;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.IntervalProjection;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctDomainState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctInterval;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctPostOperator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.util.typeutils.TypeUtils;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;

public class OctStatementProcessor {
    private final OctPostOperator mPostOp;
    private final IntervalProjection mIntervalProjection;

    public OctStatementProcessor(OctPostOperator octPostOperator) {
        this.mPostOp = octPostOperator;
        this.mIntervalProjection = new IntervalProjection(this.mPostOp.getBoogie2SmtSymbolTable());
    }

    public List<OctDomainState> processStatement(Statement statement, List<OctDomainState> list) {
        if (statement instanceof AssignmentStatement) {
            return this.processAssignmentStatement((AssignmentStatement)statement, list);
        }
        if (statement instanceof AssumeStatement) {
            Expression expression = ((AssumeStatement)statement).getFormula();
            return this.mPostOp.getAssumeProcessor().assume(expression, list);
        }
        if (statement instanceof HavocStatement) {
            return this.processHavocStatement((HavocStatement)statement, list);
        }
        if (statement instanceof Label) {
            return list;
        }
        throw new UnsupportedOperationException("Unsupported type of statement: " + String.valueOf(statement));
    }

    private List<OctDomainState> processAssignmentStatement(AssignmentStatement assignmentStatement, List<OctDomainState> list) {
        LeftHandSide[] leftHandSideArray = assignmentStatement.getLhs();
        Expression[] expressionArray = assignmentStatement.getRhs();
        assert (leftHandSideArray.length == expressionArray.length) : "Unbalanced assignment: " + String.valueOf(assignmentStatement);
        int n = leftHandSideArray.length;
        if (n == 1) {
            LeftHandSide leftHandSide = leftHandSideArray[0];
            if (leftHandSide instanceof VariableLHS) {
                return this.processSingleAssignment((IProgramVarOrConst)this.mPostOp.getBoogieVar((VariableLHS)leftHandSide), expressionArray[0], list);
            }
            return list;
        }
        HashMap<CallSite, IProgramVar> hashMap = new HashMap<CallSite, IProgramVar>();
        ArrayList<Pair> arrayList = new ArrayList<Pair>(n);
        ArrayList<Pair> arrayList2 = new ArrayList<Pair>(n);
        int n2 = 0;
        while (n2 < n) {
            LeftHandSide object2 = leftHandSideArray[n2];
            if (object2 instanceof VariableLHS) {
                VariableLHS variableLHS = (VariableLHS)object2;
                IProgramVar iProgramVar = this.mPostOp.getBoogieVar(variableLHS);
                String string = "octTmp(" + String.valueOf(iProgramVar) + ")";
                IProgramVar iProgramVar2 = AbsIntUtil.createTemporaryIBoogieVar(string, variableLHS.getType());
                hashMap.put((CallSite)((Object)string), iProgramVar2);
                arrayList.add(new Pair((Object)iProgramVar2, (Object)expressionArray[n2]));
                arrayList2.add(new Pair((Object)iProgramVar, (Object)iProgramVar2));
            }
            ++n2;
        }
        List<OctDomainState> list2 = new ArrayList<OctDomainState>(list.size());
        for (OctDomainState octDomainState2 : list) {
            list2.add((OctDomainState)octDomainState2.addVariables(hashMap.values()));
        }
        for (Pair pair : arrayList) {
            list2 = this.processSingleAssignment((IProgramVarOrConst)pair.getFirst(), (Expression)pair.getSecond(), list2);
        }
        list2 = OctPostOperator.removeBottomStates(list2);
        list2.forEach(octDomainState -> octDomainState.copyVars(arrayList2));
        ArrayList<OctDomainState> arrayList3 = new ArrayList<OctDomainState>(list.size());
        list2.forEach(octDomainState -> {
            boolean bl = arrayList3.add((OctDomainState)octDomainState.removeVariables(hashMap.values()));
        });
        return arrayList3;
    }

    public List<OctDomainState> processSingleAssignment(IProgramVarOrConst iProgramVarOrConst, Expression expression, List<OctDomainState> list) {
        IBoogieType iBoogieType = expression.getType();
        if (TypeUtils.isBoolean(iBoogieType)) {
            return this.processBooleanAssign(iProgramVarOrConst, expression, list);
        }
        if (TypeUtils.isNumeric(iBoogieType)) {
            return this.processNumericAssign(iProgramVarOrConst, expression, list);
        }
        return list;
    }

    private List<OctDomainState> processBooleanAssign(IProgramVarOrConst iProgramVarOrConst, Expression expression, List<OctDomainState> list2) {
        if (expression instanceof BooleanLiteral) {
            BoolValue boolValue = BoolValue.get(((BooleanLiteral)expression).getValue());
            list2 = OctPostOperator.removeBottomStates(list2);
            list2.forEach(octDomainState -> octDomainState.assignBooleanVar(iProgramVarOrConst, boolValue));
            return list2;
        }
        if (expression instanceof IdentifierExpression) {
            IdentifierExpression identifierExpression = (IdentifierExpression)expression;
            list2 = OctPostOperator.removeBottomStates(list2);
            if (AbsIntUtil.isVariable(identifierExpression)) {
                IProgramVarOrConst iProgramVarOrConst2 = this.mPostOp.getBoogieVar(identifierExpression);
                list2.forEach(octDomainState -> octDomainState.copyVar(iProgramVarOrConst, iProgramVarOrConst2));
            } else {
                list2.forEach(octDomainState -> octDomainState.havocVar(iProgramVarOrConst));
            }
            return list2;
        }
        Expression expression2 = this.mPostOp.getExprTransformer().logicNegCached(expression);
        return this.mPostOp.splitF(list2, list -> {
            list = this.mPostOp.getAssumeProcessor().assume(expression, (List<OctDomainState>)list);
            list = OctPostOperator.removeBottomStates(list);
            list.forEach(octDomainState -> octDomainState.assignBooleanVar(iProgramVarOrConst, BoolValue.TRUE));
            return list;
        }, list -> {
            list = this.mPostOp.getAssumeProcessor().assume(expression2, (List<OctDomainState>)list);
            list = OctPostOperator.removeBottomStates(list);
            list.forEach(octDomainState -> octDomainState.assignBooleanVar(iProgramVarOrConst, BoolValue.FALSE));
            return list;
        });
    }

    private List<OctDomainState> processNumericAssign(IProgramVarOrConst iProgramVarOrConst, Expression expression, List<OctDomainState> list) {
        ArrayList<OctDomainState> arrayList = new ArrayList<OctDomainState>();
        IfExpressionTree ifExpressionTree = this.mPostOp.getExprTransformer().removeIfExprsCached(expression);
        for (Pair<Expression, List<OctDomainState>> pair : ifExpressionTree.assumeLeafs(this.mPostOp, list)) {
            List<OctDomainState> list2 = (List<OctDomainState>)pair.getSecond();
            list2 = OctPostOperator.removeBottomStates(list2);
            arrayList.addAll(this.processNumericAssignWithoutIfs(iProgramVarOrConst, (Expression)pair.getFirst(), list2));
        }
        return this.mPostOp.joinDownToMax(arrayList);
    }

    private List<OctDomainState> processNumericAssignWithoutIfs(IProgramVarOrConst iProgramVarOrConst, Expression expression, List<OctDomainState> list) {
        AffineExpression affineExpression = this.mPostOp.getExprTransformer().affineExprCached(expression);
        if (affineExpression != null) {
            if (affineExpression.isConstant()) {
                OctValue octValue = new OctValue(affineExpression.getConstant());
                list.forEach(octDomainState -> octDomainState.assignNumericVarConstant(iProgramVarOrConst, octValue));
                return list;
            }
            AffineExpression.OneVarForm oneVarForm = affineExpression.getOneVarForm();
            if (oneVarForm != null) {
                Consumer<OctDomainState> consumer = octDomainState -> octDomainState.copyVar(iProgramVarOrConst, oneVarForm.var);
                if (oneVarForm.negVar) {
                    consumer = consumer.andThen(octDomainState -> octDomainState.negateNumericVar(iProgramVarOrConst));
                }
                if (oneVarForm.constant.signum() != 0) {
                    consumer = consumer.andThen(octDomainState -> octDomainState.incrementNumericVar(iProgramVarOrConst, oneVarForm.constant));
                }
                list.forEach(consumer);
                return list;
            }
            AffineExpression.TwoVarForm twoVarForm = affineExpression.getTwoVarForm();
            if (twoVarForm != null) {
                for (OctDomainState octDomainState2 : list) {
                    OctInterval octInterval = octDomainState2.projectToInterval(twoVarForm);
                    octDomainState2.assignNumericVarInterval(iProgramVarOrConst, octInterval);
                }
                return list;
            }
            if (this.mPostOp.isFallbackAssignIntervalProjectionEnabled()) {
                return this.mIntervalProjection.assignNumericVarAffine(iProgramVarOrConst, affineExpression, list);
            }
        } else if (this.mPostOp.isFallbackAssignIntervalProjectionEnabled()) {
            return this.mIntervalProjection.assignNumericVarWithoutIfs(iProgramVarOrConst, expression, list);
        }
        list.forEach(octDomainState -> octDomainState.havocVar(iProgramVarOrConst));
        return list;
    }

    private List<OctDomainState> processHavocStatement(HavocStatement havocStatement, List<OctDomainState> list) {
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        VariableLHS[] variableLHSArray = havocStatement.getIdentifiers();
        int n = variableLHSArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLHS variableLHS = variableLHSArray[n2];
            arrayList.add(this.mPostOp.getBoogieVar(variableLHS));
            ++n2;
        }
        list = OctPostOperator.removeBottomStates(list);
        list.forEach(octDomainState -> octDomainState.havocVars(arrayList));
        return list;
    }
}

