/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.tool.initializer;

import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.PreprocessorAnnotation;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTable;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractDomain;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.FixpointEngineParameters;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ILoopDetector;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.IcfgAbstractStateStorageProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgDebugHelper;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.rcfg.RcfgVariableProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.array.ArrayDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.compound.CompoundDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.empty.EmptyDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.congruence.CongruenceDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.explicit.ExplicitValueDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.sign.SignDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.relational.octagon.OctagonDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.Boogie2SmtSymbolTableTmpVars;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.transformula.poorman.PoormanAbstractDomain;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.BoogieIcfgContainer;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class FixpointEngineParameterFactory {
    private final BoogieSymbolTable mSymbolTable;
    private final IIcfg<?> mRoot;
    private final BoogieIcfgContainer mBoogieIcfg;
    private final IUltimateServiceProvider mServices;
    private final OctagonDomain.LiteralCollectorFactory mLiteralCollector;
    private final IBoogieSymbolTableVariableProvider mVariableProvider;

    public FixpointEngineParameterFactory(IIcfg<?> iIcfg, OctagonDomain.LiteralCollectorFactory literalCollectorFactory, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mRoot = iIcfg;
        this.mBoogieIcfg = AbsIntUtil.getBoogieIcfgContainer(this.mRoot);
        this.mServices = iUltimateServiceProvider;
        PreprocessorAnnotation preprocessorAnnotation = PreprocessorAnnotation.getAnnotation(iIcfg);
        if (preprocessorAnnotation == null || preprocessorAnnotation.getSymbolTable() == null) {
            throw new IllegalArgumentException("Could not get BoogieSymbolTable");
        }
        this.mSymbolTable = preprocessorAnnotation.getSymbolTable();
        this.mLiteralCollector = literalCollectorFactory;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        boolean bl = iPreferenceProvider.getBoolean("Use the RCFG-of-the-future interface");
        boolean bl2 = iPreferenceProvider.getString("Abstract domain for RCFG-of-the-future").equals(PoormanAbstractDomain.class.getSimpleName());
        boolean bl3 = iPreferenceProvider.getString("Abstract domain").equals(ArrayDomain.class.getSimpleName());
        this.mVariableProvider = bl && bl2 || bl3 ? new Boogie2SmtSymbolTableTmpVars(this.mBoogieIcfg.getBoogie2SMT().getBoogie2SmtSymbolTable()) : this.mBoogieIcfg.getBoogie2SMT().getBoogie2SmtSymbolTable();
    }

    public <STATE extends IAbstractState<STATE>> FixpointEngineParameters<STATE, IcfgEdge, IProgramVarOrConst, IcfgLocation> createParams(IProgressAwareTimer iProgressAwareTimer, ITransitionProvider<IcfgEdge, IcfgLocation> iTransitionProvider, ILoopDetector<IcfgEdge> iLoopDetector) {
        IAbstractDomain<?, IcfgEdge> iAbstractDomain = this.selectDomain();
        IcfgAbstractStateStorageProvider icfgAbstractStateStorageProvider = new IcfgAbstractStateStorageProvider(this.mServices, iTransitionProvider);
        RcfgVariableProvider rcfgVariableProvider = new RcfgVariableProvider(this.mRoot.getCfgSmtToolkit(), this.mServices);
        RcfgDebugHelper rcfgDebugHelper = new RcfgDebugHelper(this.mRoot.getCfgSmtToolkit(), this.mServices, this.mRoot.getCfgSmtToolkit().getSymbolTable());
        return new FixpointEngineParameters(this.mServices, IProgramVarOrConst.class).setDomain(iAbstractDomain).setLoopDetector(iLoopDetector).setStorage(icfgAbstractStateStorageProvider).setTransitionProvider(iTransitionProvider).setVariableProvider(rcfgVariableProvider).setDebugHelper(rcfgDebugHelper).setTimer(iProgressAwareTimer);
    }

    private IAbstractDomain<?, IcfgEdge> selectDomain() {
        ILogger iLogger;
        IPreferenceProvider iPreferenceProvider = this.mServices.getPreferenceProvider(Activator.PLUGIN_ID);
        String string = iPreferenceProvider.getString("Abstract domain");
        IAbstractDomain<?, IcfgEdge> iAbstractDomain = this.getFlatDomainOrNull(string, iLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID));
        if (iAbstractDomain != null) {
            return iAbstractDomain;
        }
        if (ArrayDomain.class.getSimpleName().equals(string)) {
            String string2 = iPreferenceProvider.getString("Underlying domain");
            IAbstractDomain<?, IcfgEdge> iAbstractDomain2 = CompoundDomain.class.getSimpleName().equals(string2) ? this.createCompoundDomain(iPreferenceProvider, iLogger) : this.getFlatDomainOrFail(string2, iLogger);
            return new ArrayDomain(iAbstractDomain2, (IIcfg<?>)this.mBoogieIcfg, this.mServices, iLogger, this.mSymbolTable, this.mVariableProvider);
        }
        if (CompoundDomain.class.getSimpleName().equals(string)) {
            return this.createCompoundDomain(iPreferenceProvider, iLogger);
        }
        throw new UnsupportedOperationException(FixpointEngineParameterFactory.getFailureString(string));
    }

    private IAbstractDomain<?, IcfgEdge> createCompoundDomain(IPreferenceProvider iPreferenceProvider, ILogger iLogger) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (iPreferenceProvider.getBoolean("Empty Domain")) {
            arrayList.add(EmptyDomain.class.getSimpleName());
        }
        if (iPreferenceProvider.getBoolean("Sign Domain")) {
            arrayList.add(SignDomain.class.getSimpleName());
        }
        if (iPreferenceProvider.getBoolean("Congruence Domain")) {
            arrayList.add(CongruenceDomain.class.getSimpleName());
        }
        if (iPreferenceProvider.getBoolean("Interval Domain")) {
            arrayList.add(IntervalDomain.class.getSimpleName());
        }
        if (iPreferenceProvider.getBoolean("Octagon Domain")) {
            arrayList.add(OctagonDomain.class.getSimpleName());
        }
        if (iPreferenceProvider.getBoolean("Explicit value domain")) {
            arrayList.add(ExplicitValueDomain.class.getSimpleName());
        }
        return new CompoundDomain(this.mServices, arrayList.stream().map(string -> this.getFlatDomainOrFail((String)string, iLogger)).collect(Collectors.toList()), this.mBoogieIcfg);
    }

    private IAbstractDomain<?, IcfgEdge> getFlatDomainOrNull(String string, ILogger iLogger) {
        if (EmptyDomain.class.getSimpleName().equals(string)) {
            return new EmptyDomain<IcfgEdge>();
        }
        if (SignDomain.class.getSimpleName().equals(string)) {
            return new SignDomain(this.mServices, (IIcfg<?>)this.mBoogieIcfg, this.mSymbolTable, this.mVariableProvider);
        }
        if (IntervalDomain.class.getSimpleName().equals(string)) {
            return new IntervalDomain(iLogger, this.mSymbolTable, this.mLiteralCollector.create().getLiteralCollection(), this.mServices, this.mBoogieIcfg, this.mVariableProvider);
        }
        if (OctagonDomain.class.getSimpleName().equals(string)) {
            return new OctagonDomain(iLogger, this.mSymbolTable, this.mLiteralCollector, this.mServices, this.mBoogieIcfg, this.mVariableProvider);
        }
        if (CongruenceDomain.class.getSimpleName().equals(string)) {
            return new CongruenceDomain(iLogger, this.mServices, this.mSymbolTable, this.mBoogieIcfg, this.mVariableProvider);
        }
        if (ExplicitValueDomain.class.getSimpleName().equals(string)) {
            return new ExplicitValueDomain(iLogger, this.mSymbolTable, this.mLiteralCollector.create().getLiteralCollection(), this.mServices, this.mBoogieIcfg, this.mVariableProvider);
        }
        return null;
    }

    private IAbstractDomain<?, IcfgEdge> getFlatDomainOrFail(String string, ILogger iLogger) {
        IAbstractDomain<?, IcfgEdge> iAbstractDomain = this.getFlatDomainOrNull(string, iLogger);
        if (iAbstractDomain == null) {
            throw new UnsupportedOperationException(FixpointEngineParameterFactory.getFailureString(string));
        }
        return iAbstractDomain;
    }

    public IBoogieSymbolTableVariableProvider getSymbolTableVariableProvider() {
        return this.mVariableProvider;
    }

    private static String getFailureString(String string) {
        return "The value \"" + string + "\" of preference \"Abstract domain\" was not considered before! ";
    }
}

