/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.List;
import java.util.function.Predicate;

public final class BooleanLiteral
extends Expression {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(BooleanLiteral.class);
    boolean value;

    public BooleanLiteral(ILocation iLocation, boolean bl) {
        super(iLocation);
        this.value = bl;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BooleanLiteral: " + String.valueOf((Object)this);
    }

    public BooleanLiteral(ILocation iLocation, IBoogieType iBoogieType, boolean bl) {
        super(iLocation, iBoogieType);
        this.value = bl;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid BooleanLiteral: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BooleanLiteral").append('[');
        stringBuffer.append(this.value);
        return stringBuffer.append(']').toString();
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Expression)this)) {
            return;
        }
        generatedBoogieAstVisitor.visit(this);
    }

    @Override
    public Expression accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Expression expression = generatedBoogieAstTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        return this;
    }
}

