/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.QuadraticMatrix;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.jordan.RationalMatrix;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;

public class JordanDecomposition {
    private final JordanDecompositionStatus mStatus;
    private final QuadraticMatrix mJnf;
    private final RationalMatrix mModal;
    private final RationalMatrix mInverseModal;
    private final NestedMap2<Integer, Integer, Integer> mJordanBlockSizes;

    public JordanDecomposition(JordanDecompositionStatus jordanDecompositionStatus, QuadraticMatrix quadraticMatrix, RationalMatrix rationalMatrix, RationalMatrix rationalMatrix2, NestedMap2<Integer, Integer, Integer> nestedMap2) {
        assert (jordanDecompositionStatus == JordanDecompositionStatus.SUCCESS ^ quadraticMatrix == null) : "provide JNF iff success";
        assert (quadraticMatrix == null == (nestedMap2 == null)) : "all or nothing";
        if (nestedMap2 != null) assert (nestedMap2.keySet().stream().allMatch(n -> n == -1 || n == 0 || n == 1)) : "only supported eigenvalues as keys";
        this.mStatus = jordanDecompositionStatus;
        this.mJnf = quadraticMatrix;
        this.mModal = rationalMatrix;
        this.mInverseModal = rationalMatrix2;
        this.mJordanBlockSizes = nestedMap2;
    }

    public JordanDecompositionStatus getStatus() {
        return this.mStatus;
    }

    public QuadraticMatrix getJnf() {
        return this.mJnf;
    }

    public RationalMatrix getModal() {
        return this.mModal;
    }

    public RationalMatrix getInverseModal() {
        return this.mInverseModal;
    }

    public NestedMap2<Integer, Integer, Integer> getJordanBlockSizes() {
        return this.mJordanBlockSizes;
    }

    public static enum JordanDecompositionStatus {
        SUCCESS,
        UNSUPPORTED_EIGENVALUES;

    }
}

