/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class TimeTracker {
    private long mStartTime = -1L;
    private long mElapsedTimeNs;
    private long mLastDeltaNs = -1L;

    public TimeTracker() {
        this.reset();
    }

    public <T> T measure(Supplier<T> supplier) {
        this.start();
        T t = supplier.get();
        this.stop();
        return t;
    }

    public void start() {
        assert (this.mStartTime == -1L) : "TimeTracker already running";
        this.mStartTime = System.nanoTime();
    }

    public void stop() {
        assert (this.mStartTime != -1L) : "TimeTracker was not running";
        this.mLastDeltaNs = System.nanoTime() - this.mStartTime;
        this.mElapsedTimeNs += this.mLastDeltaNs;
        this.mStartTime = -1L;
    }

    public void reset() {
        this.mStartTime = -1L;
        this.mElapsedTimeNs = 0L;
        this.mLastDeltaNs = -1L;
    }

    public String toString() {
        if (this.mStartTime == -1L) {
            return "N/A";
        }
        return CoreUtil.humanReadableTime(this.mElapsedTimeNs, TimeUnit.NANOSECONDS, 2);
    }

    public long lastDelta(TimeUnit timeUnit) {
        assert (this.mStartTime == -1L) : "TimeTracker currently running";
        if (this.mLastDeltaNs == -1L) {
            throw new IllegalStateException("Clock was not started");
        }
        return timeUnit.convert(this.mLastDeltaNs, TimeUnit.NANOSECONDS);
    }

    public long elapsedTime(TimeUnit timeUnit) {
        assert (this.mStartTime == -1L) : "TimeTracker currently running";
        return timeUnit.convert(this.mElapsedTimeNs, TimeUnit.NANOSECONDS);
    }
}

