/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.RcpProgressMonitorWrapper;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.ParserInitializationException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.toolchain.BasicToolchainJob;
import de.uni_freiburg.informatik.ultimate.core.lib.results.ExceptionOrErrorResult;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.IController;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchain;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class DefaultToolchainJob
extends BasicToolchainJob {
    protected File[] mInputFiles;
    protected IToolchain<RunDefinition> mToolchain;

    public DefaultToolchainJob(String string, ICore<RunDefinition> iCore, IController<RunDefinition> iController, ILogger iLogger, File[] fileArray) {
        super(string, iCore, iController, iLogger);
        this.setUser(true);
        this.setSystem(false);
        if (fileArray == null || fileArray.length == 0) {
            throw new IllegalArgumentException("No input files given");
        }
        this.mInputFiles = fileArray;
    }

    public DefaultToolchainJob(String string, ICore<RunDefinition> iCore, IController<RunDefinition> iController, ILogger iLogger, IToolchain<RunDefinition> iToolchain) {
        super(string, iCore, iController, iLogger);
        this.setUser(true);
        this.setSystem(false);
        this.setToolchain(iToolchain);
    }

    protected void setToolchain(IToolchain<RunDefinition> iToolchain) {
        assert (iToolchain != null);
        this.mToolchain = iToolchain;
    }

    protected void releaseToolchain() {
        this.mCore.releaseToolchain(this.mToolchain);
    }

    @Override
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        IToolchainProgressMonitor iToolchainProgressMonitor = RcpProgressMonitorWrapper.create(iProgressMonitor);
        iToolchainProgressMonitor.beginTask(this.getName(), -1);
        try {
            this.setToolchain((IToolchain<RunDefinition>)this.mCore.requestToolchain(this.mInputFiles));
            iToolchainProgressMonitor.worked(1);
            this.mToolchain.init(iToolchainProgressMonitor);
            iToolchainProgressMonitor.worked(1);
            if (!this.mToolchain.initializeParsers()) {
                throw new ParserInitializationException();
            }
            iToolchainProgressMonitor.worked(1);
            IToolchainData iToolchainData = this.mToolchain.makeToolSelection(iToolchainProgressMonitor);
            if (iToolchainData == null) {
                this.mLogger.fatal((Object)"Toolchain selection failed, aborting...");
                Status status = new Status(8, "de.uni_freiburg.informatik.ultimate.core", 8, "Toolchain selection canceled", null);
                return status;
            }
            this.setServices(iToolchainData.getServices());
            iToolchainProgressMonitor.worked(1);
            this.mToolchain.runParsers();
            iToolchainProgressMonitor.worked(1);
            IStatus iStatus = this.convert(this.mToolchain.processToolchain(iToolchainProgressMonitor));
            return iStatus;
        }
        catch (Throwable throwable) {
            IStatus iStatus = this.handleException(throwable);
            return iStatus;
        }
        finally {
            iToolchainProgressMonitor.done();
            this.releaseToolchain();
        }
    }

    protected IStatus handleException(Throwable throwable) {
        if (throwable == null) {
            this.mLogger.fatal((Object)"The toolchain wants to handle an exception, but provided nothing");
        } else if (this.mLogger.isDebugEnabled()) {
            this.mLogger.fatal((Object)"The toolchain threw an exception", throwable);
        } else {
            this.mLogger.fatal((Object)String.format("The toolchain threw an exception: %s: %s", throwable.getClass(), throwable.getMessage()));
        }
        this.mController.displayException(this.mToolchain, "The toolchain threw an exception", throwable);
        if (this.mServices != null) {
            this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", (IResult)new ExceptionOrErrorResult("de.uni_freiburg.informatik.ultimate.core", throwable));
        }
        return new Status(4, "de.uni_freiburg.informatik.ultimate.core", 4, "Toolchain threw an exception", null);
    }
}

