/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.toolchain;

import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ObjectFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.ToolchainListType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public class ToolchainFileValidator {
    private static final String TOOLCHAIN_PACKAGE = "de.uni_freiburg.informatik.ultimate.core.lib.toolchain";
    private static final String TOOLCHAIN_URI = "/de/uni_freiburg/informatik/ultimate/core/lib/toolchain/toolchain.xsd";

    public RunDefinition createEmptyToolchain() {
        ObjectFactory objectFactory = new ObjectFactory();
        RunDefinition runDefinition = objectFactory.createRunDefinition();
        runDefinition.setName("Unknown");
        runDefinition.setToolchain(objectFactory.createToolchainListType());
        return runDefinition;
    }

    public RunDefinition loadValidatedToolchain(String string) throws JAXBException, FileNotFoundException, SAXException {
        JAXBContext jAXBContext = ToolchainFileValidator.createJAXBContext();
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        URL uRL = this.getClass().getResource(TOOLCHAIN_URI);
        unmarshaller.setSchema(SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(uRL));
        JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal((InputStream)new FileInputStream(string));
        return (RunDefinition)jAXBElement.getValue();
    }

    public void saveToolchain(String string, String string2, ToolchainListType toolchainListType) throws JAXBException, FileNotFoundException {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        ObjectFactory objectFactory = new ObjectFactory();
        JAXBContext jAXBContext = ToolchainFileValidator.createJAXBContext();
        RunDefinition runDefinition = objectFactory.createRunDefinition();
        runDefinition.setToolchain(toolchainListType);
        runDefinition.setName(string2);
        JAXBElement<RunDefinition> jAXBElement = objectFactory.createRundefinition(runDefinition);
        Marshaller marshaller = jAXBContext.createMarshaller();
        marshaller.marshal(jAXBElement, (OutputStream)new FileOutputStream(string));
    }

    private static JAXBContext createJAXBContext() throws JAXBException {
        return JAXBContext.newInstance((String)TOOLCHAIN_PACKAGE, (ClassLoader)ObjectFactory.class.getClassLoader());
    }
}

