/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.syntaxchecker;

import de.uni_freiburg.informatik.ultimate.cdt.decorator.ASTDecorator;
import de.uni_freiburg.informatik.ultimate.core.lib.models.WrapperNode;
import de.uni_freiburg.informatik.ultimate.core.lib.observers.BaseObserver;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;

public class FilenameExtractionObserver
extends BaseObserver {
    private String mFilename;
    private final ILogger mLogger;

    public FilenameExtractionObserver(ILogger iLogger) {
        this.mLogger = iLogger;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (!(iElement instanceof WrapperNode)) {
            this.mLogger.warn((Object)("Seen unsupported model: " + iElement.getClass().getCanonicalName()));
            return false;
        }
        WrapperNode wrapperNode = (WrapperNode)iElement;
        ASTDecorator aSTDecorator = (ASTDecorator)wrapperNode.getBacking();
        if (aSTDecorator.getUnits().size() != 1) {
            throw new UnsupportedOperationException("SyntaxChecker does not support multiple files");
        }
        String string = aSTDecorator.getUnit(0).getSourceTranslationUnit().getFileLocation().getFileName();
        if (this.mFilename != null) {
            throw new IllegalStateException("mFilename already set");
        }
        this.mFilename = string;
        return false;
    }

    public String getFilename() {
        return this.mFilename;
    }
}

