/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils;

import de.uni_freiburg.informatik.ultimate.automata.Word;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Counterexample<L> {
    public static final String MISSING_CONTROL_CONFIGURATION_MESSAGE = "Counterexample with control configurations is required, but this counterexample does not have control configurations.";
    private final NestedWord<L> mWord;
    private final List<Object> mControlConfigurations;

    public Counterexample(Word<L> word) {
        this.mWord = NestedWord.nestedWord(word);
        this.mControlConfigurations = null;
        if (word.length() == 0) {
            throw new IllegalArgumentException("Counterexample must be non-empty");
        }
    }

    public Counterexample(Word<L> word, List<?> list) {
        this.mWord = NestedWord.nestedWord(Objects.requireNonNull(word));
        this.mControlConfigurations = List.copyOf((Collection)Objects.requireNonNull(list));
        if (word.length() == 0) {
            throw new IllegalArgumentException("Counterexample must be non-empty");
        }
        if (list.size() != this.mWord.length() + 1) {
            throw new IllegalArgumentException("Number of control configurations does not match word length");
        }
    }

    public NestedWord<L> getWord() {
        return this.mWord;
    }

    public int length() {
        return this.mWord.length();
    }

    public boolean hasControlConfigurations() {
        return this.mControlConfigurations != null;
    }

    public void requireControlConfigurations() {
        if (this.mControlConfigurations == null) {
            throw new IllegalStateException(MISSING_CONTROL_CONFIGURATION_MESSAGE);
        }
    }

    public List<Object> getControlConfigurations() {
        this.requireControlConfigurations();
        return Collections.unmodifiableList(this.mControlConfigurations);
    }
}

