/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.AssertOrderUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.assertorders.IAssertOrder;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AssertOrderSmallConstantsFirst<L extends IAction>
implements IAssertOrder<L> {
    private static final int CONSTANT_SIZE = 10;

    private static boolean termHasConstantGreaterThan(Term term, int n) {
        if (term instanceof ApplicationTerm) {
            Term[] termArray;
            Term[] termArray2 = termArray = ((ApplicationTerm)term).getParameters();
            int n2 = termArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Term term2 = termArray2[n3];
                if (AssertOrderSmallConstantsFirst.termHasConstantGreaterThan(term2, n)) {
                    return true;
                }
                ++n3;
            }
        } else if (term instanceof ConstantTerm) {
            Object object = ((ConstantTerm)term).getValue();
            if (object instanceof BigInteger) {
                return ((BigInteger)object).compareTo(BigInteger.valueOf(n)) > 0;
            }
            if (object instanceof BigDecimal) {
                return ((BigDecimal)object).compareTo(BigDecimal.valueOf(n)) > 0;
            }
            if (object instanceof Rational) {
                return ((Rational)object).compareTo(Rational.valueOf((long)n, (long)1L)) > 0;
            }
            throw new UnsupportedOperationException("ConstantTerm is neither BigInter nor BigDecimal, therefore comparison is not possible!");
        }
        return false;
    }

    private Set<Integer> partitionStmtsAccordingToConstantSize(NestedWord<L> nestedWord, int n) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        int n2 = 0;
        while (n2 < nestedWord.length()) {
            Term term = ((IAction)nestedWord.getSymbol(n2)).getTransformula().getFormula();
            if (!AssertOrderSmallConstantsFirst.termHasConstantGreaterThan(term, n)) {
                hashSet.add(n2);
            }
            ++n2;
        }
        return hashSet;
    }

    @Override
    public List<Set<Integer>> partition(Counterexample<L> counterexample) {
        NestedWord<L> nestedWord = counterexample.getWord();
        Set<Integer> set = this.partitionStmtsAccordingToConstantSize(nestedWord, 10);
        return List.of(set, AssertOrderUtils.getTraceDifference(nestedWord, set));
    }
}

