/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class StateContainerFieldMap<LETTER, STATE> {
    private static final int ONE = 1;
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final int FOUR = 4;
    private final STATE mState;
    private Object mOut1;
    private Object mOut2;
    private Object mOut3;
    private Object mOut4;

    public StateContainerFieldMap(STATE STATE) {
        this.mState = STATE;
    }

    public STATE getState() {
        return this.mState;
    }

    private boolean inOutMapMode() {
        return this.mOut1 instanceof Map || this.mOut2 instanceof Map || this.mOut3 instanceof Map || this.mOut4 instanceof Map;
    }

    private void addOutgoingInternal(LETTER LETTER, STATE STATE) {
        OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition = new OutgoingInternalTransition<LETTER, STATE>(LETTER, STATE);
        if (this.inOutMapMode()) {
            this.addInternalTransitionMap((Map)this.mOut1, LETTER, STATE);
        } else if (this.mOut1 == null) {
            this.mOut1 = outgoingInternalTransition;
        } else if (this.mOut2 == null) {
            this.mOut2 = outgoingInternalTransition;
        } else if (this.mOut3 == null) {
            this.mOut3 = outgoingInternalTransition;
        } else {
            this.switchOutMode();
            this.addInternalTransitionMap((Map)this.mOut1, LETTER, STATE);
        }
    }

    private void switchOutMode() {
        assert (this.mOut1 != null && !(this.mOut1 instanceof Map));
        assert (this.mOut2 != null && !(this.mOut2 instanceof Map));
        assert (this.mOut3 != null && !(this.mOut3 instanceof Map));
        Object[] objectArray = new Object[]{this.mOut1, this.mOut2, this.mOut3};
        this.mOut1 = new HashMap();
        this.mOut2 = new HashMap();
        this.mOut3 = new HashMap();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (!(object instanceof OutgoingInternalTransition)) {
                throw new AssertionError();
            }
            OutgoingInternalTransition outgoingInternalTransition = (OutgoingInternalTransition)object;
            this.addInternalTransitionMap((Map)this.mOut1, outgoingInternalTransition.getLetter(), outgoingInternalTransition.getSucc());
            ++n2;
        }
    }

    protected Object getOut1() {
        return this.mOut1;
    }

    protected Object getOut2() {
        return this.mOut2;
    }

    protected Object getOut3() {
        return this.mOut3;
    }

    private void addInternalTransitionMap(Map<LETTER, Set<STATE>> map, LETTER LETTER, STATE STATE) {
        Set<STATE> set = map.get(LETTER);
        if (set == null) {
            set = new HashSet<STATE>();
            map.put(LETTER, set);
        }
        set.add(STATE);
    }

    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessorsField() {
        return () -> new FieldIterator();
    }

    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessorsMap(Map<LETTER, Set<STATE>> map, LETTER LETTER) {
        return () -> new MapLetterIterator(map, LETTER);
    }

    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessorsMap(Map<LETTER, Set<STATE>> map) {
        return () -> new MapNoLetterIterator(map);
    }

    private final class FieldIterator
    implements Iterator<OutgoingInternalTransition<LETTER, STATE>> {
        private int mPosition;

        public FieldIterator() {
            this.updatePosition();
        }

        private void updatePosition() {
            ++this.mPosition;
        }

        @Override
        public boolean hasNext() {
            return this.mPosition < 4;
        }

        @Override
        public OutgoingInternalTransition<LETTER, STATE> next() {
            Object object = switch (this.mPosition) {
                case 1 -> StateContainerFieldMap.this.getOut1();
                case 2 -> StateContainerFieldMap.this.getOut2();
                case 3 -> StateContainerFieldMap.this.getOut3();
                default -> throw new NoSuchElementException();
            };
            if (!(object instanceof OutgoingInternalTransition)) {
                throw new AssertionError();
            }
            this.updatePosition();
            return (OutgoingInternalTransition)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class MapLetterIterator
    implements Iterator<OutgoingInternalTransition<LETTER, STATE>> {
        private final LETTER mLetter;
        private Iterator<STATE> mIterator;

        protected MapLetterIterator(Map<LETTER, Set<STATE>> map, LETTER LETTER) {
            this.mLetter = LETTER;
            this.mIterator = map != null ? (map.get(LETTER) != null ? map.get(LETTER).iterator() : null) : null;
        }

        @Override
        public boolean hasNext() {
            return this.mIterator == null || this.mIterator.hasNext();
        }

        @Override
        public OutgoingInternalTransition<LETTER, STATE> next() {
            if (this.mIterator == null) {
                throw new NoSuchElementException();
            }
            Object STATE = this.mIterator.next();
            return new OutgoingInternalTransition(this.mLetter, STATE);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class MapNoLetterIterator
    implements Iterator<OutgoingInternalTransition<LETTER, STATE>> {
        private final Map<LETTER, Set<STATE>> mLetter2succ;
        private final Iterator<LETTER> mLetterIterator;
        private LETTER mCurrentLetter;
        private Iterator<OutgoingInternalTransition<LETTER, STATE>> mCurrentIterator;

        protected MapNoLetterIterator(Map<LETTER, Set<STATE>> map) {
            this.mLetter2succ = map;
            this.mLetterIterator = map.keySet().iterator();
            this.nextLetter();
        }

        private void nextLetter() {
            if (this.mLetterIterator.hasNext()) {
                do {
                    this.mCurrentLetter = this.mLetterIterator.next();
                    this.mCurrentIterator = StateContainerFieldMap.this.internalSuccessorsMap(this.mLetter2succ, this.mCurrentLetter).iterator();
                } while (!this.mCurrentIterator.hasNext() && this.mLetterIterator.hasNext());
                if (!this.mCurrentIterator.hasNext()) {
                    this.mCurrentLetter = null;
                    this.mCurrentIterator = null;
                }
            } else {
                this.mCurrentLetter = null;
                this.mCurrentIterator = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.mCurrentLetter != null;
        }

        @Override
        public OutgoingInternalTransition<LETTER, STATE> next() {
            if (this.mCurrentLetter == null) {
                throw new NoSuchElementException();
            }
            OutgoingInternalTransition outgoingInternalTransition = this.mCurrentIterator.next();
            if (!this.mCurrentIterator.hasNext()) {
                this.nextLetter();
            }
            return outgoingInternalTransition;
        }
    }
}

