/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoWord;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class GetRandomNestedWord<LETTER, STATE>
implements IOperation<LETTER, STATE, IStateFactory<STATE>> {
    private static final int TEMPORARY_PENDING_CALL = -7;
    private final Random mRandom;
    private final List<LETTER> mInternalAlphabet;
    private final List<LETTER> mCallAlphabet;
    private final List<LETTER> mReturnAlphabet;
    private final NestedWord<LETTER> mResult;

    public GetRandomNestedWord(AutomataLibraryServices automataLibraryServices, INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider, int n, long l) {
        this.mInternalAlphabet = new ArrayList(iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getInternalAlphabet());
        this.mCallAlphabet = new ArrayList(iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getCallAlphabet());
        this.mReturnAlphabet = new ArrayList(iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getReturnAlphabet());
        this.mRandom = new Random(l);
        int n2 = this.mInternalAlphabet.size() + this.mCallAlphabet.size() + this.mReturnAlphabet.size();
        double d = (double)this.mCallAlphabet.size() / (double)n2;
        double d2 = (double)this.mReturnAlphabet.size() / (double)n2;
        this.mResult = this.generateNestedWord(n, d, d2);
    }

    @Override
    public String startMessage() {
        return MessageFormat.format("Start {0}. Internal alphabet has {1} letters, call alphabet has {2} letters, return alphabet has {3} letters", this.getOperationName(), this.mInternalAlphabet.size(), this.mCallAlphabet.size(), this.mReturnAlphabet.size());
    }

    @Override
    public NestedWord<LETTER> getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        return true;
    }

    private NestedWord<LETTER> generateNestedWord(int n, double d, double d2) {
        GetRandomNestedWord.checkInput(d, d2, "probability for call and return both have to between 0 and 1 also the sum has to be between 0 and 1");
        LETTER[] LETTERArray = this.getLetterArray(n);
        int[] nArray = new int[n];
        ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            double d3 = this.mRandom.nextDouble();
            if (d3 < d) {
                LETTERArray[n3] = this.getRandomLetter(this.mCallAlphabet);
                nArray[n3] = -7;
                arrayDeque.push(n3);
                ++n2;
            } else if (n2 > 0 && d3 < d + d2) {
                int n4;
                LETTERArray[n3] = this.getRandomLetter(this.mReturnAlphabet);
                nArray[n3] = n4 = ((Integer)arrayDeque.pop()).intValue();
                nArray[n4] = n3;
                --n2;
            } else if (this.mInternalAlphabet.isEmpty()) {
                LETTERArray[n3] = this.getRandomLetter(this.mCallAlphabet);
                nArray[n3] = -7;
                arrayDeque.push(n3);
                ++n2;
            } else {
                LETTERArray[n3] = this.getRandomLetter(this.mInternalAlphabet);
                nArray[n3] = -2;
            }
            ++n3;
        }
        while (!arrayDeque.isEmpty()) {
            n3 = (Integer)arrayDeque.pop();
            nArray[n3] = Integer.MAX_VALUE;
        }
        return new NestedWord<LETTER>(LETTERArray, nArray);
    }

    private LETTER[] getLetterArray(int n) {
        return new Object[n];
    }

    private static void checkInput(double d, double d2, String string) {
        if (d < 0.0) {
            throw new IllegalArgumentException(string);
        }
        if (d > 1.0) {
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            throw new IllegalArgumentException(string);
        }
        if (d2 > 1.0) {
            throw new IllegalArgumentException(string);
        }
        if (d + d2 > 1.0) {
            throw new IllegalArgumentException(string);
        }
    }

    private NestedWord<LETTER> internalSingleton() {
        LETTER LETTER = this.getRandomLetter(this.mInternalAlphabet);
        return new NestedWord<LETTER>(LETTER, -2);
    }

    private NestedWord<LETTER> pendingCallSingleton() {
        LETTER LETTER = this.getRandomLetter(this.mCallAlphabet);
        return new NestedWord<LETTER>(LETTER, Integer.MAX_VALUE);
    }

    private NestedWord<LETTER> pendingReturnSingleton() {
        LETTER LETTER = this.getRandomLetter(this.mReturnAlphabet);
        return new NestedWord<LETTER>(LETTER, Integer.MIN_VALUE);
    }

    private LETTER getRandomLetter(List<LETTER> list) {
        int n = list.size();
        assert (n > 0);
        return list.get(this.mRandom.nextInt(n));
    }

    public NestedLassoWord<LETTER> generateNestedLassoWord(int n, int n2, double d, double d2) {
        NestedWord<LETTER> nestedWord = this.generateNestedWord(n, d, d2);
        NestedWord<LETTER> nestedWord2 = this.generateNestedWord(n2, d, d2);
        NestedLassoWord<LETTER> nestedLassoWord = new NestedLassoWord<LETTER>(nestedWord, nestedWord2);
        return nestedLassoWord;
    }

    public NestedLassoWord<LETTER> generateNestedLassoWord(int n, double d, double d2) {
        int n2 = this.mRandom.nextInt(n);
        int n3 = n - n2 + 1;
        NestedWord<LETTER> nestedWord = this.generateNestedWord(n2, d, d2);
        NestedWord<LETTER> nestedWord2 = this.generateNestedWord(n3, d, d2);
        NestedLassoWord<LETTER> nestedLassoWord = new NestedLassoWord<LETTER>(nestedWord, nestedWord2);
        return nestedLassoWord;
    }
}

