/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationStatistics;
import de.uni_freiburg.informatik.ultimate.automata.StatisticsType;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWordAutomataUtils;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.IAutomatonStatePartition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.IBlock;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.io.BufferedWriter;
import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;

public class ShrinkNwa<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    public static final int SUGGESTED_RANDOM_SPLIT_SIZE = 200;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG2 = false;
    private static final boolean DEBUG3 = false;
    private static final boolean DEBUG4 = false;
    private static final boolean STATISTICS = false;
    private static final boolean STAT_RETURN_SIZE = false;
    private static final int HIER_PRED_MAX_SIZE = 150;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private IDoubleDeckerAutomaton<LETTER, STATE> mDoubleDecker;
    private Partition mPartition;
    private int mEquivalenceClassIds;
    private WorkListIntCall mWorkListIntCall;
    private WorkListRet mWorkListRet;
    private WorkListRetHier mWorkListRetHier;
    private final HashSet<EquivalenceClass> mNegativeSet;
    private final EquivalenceClass mNegativeClass;
    private final Matrix mSingletonMatrix;
    private final DummyMap mDownStateMap;
    private List<EquivalenceClass> mSplitEcsReturn;
    private final boolean mSplitOutgoing;
    private final OutgoingHelperInternal mOutInternal;
    private final OutgoingHelperCall mOutCall;
    private final boolean mNondeterministicTransitions;
    private boolean mRandomReturnSplit;
    private final int mTreshold;
    private boolean mFirstReturnSplit;
    private HashMap<EquivalenceClass, HashSet<STATE>> mFirstReturnLin2Hiers;
    private boolean mFirstReturnSplitAlternative;
    private boolean mFirstReturnSplitHierAlternative;
    private boolean mSplitAllCallPreds;
    private boolean mReturnSplitNaive;
    private HashSet<EquivalenceClass> mReturnSplitCorrectnessEcs;
    private int mSplitsWithChange;
    private int mSplitsWithoutChange;
    private int mIncomingTransitions;
    private int mNoIncomingTransitions;
    private int mIgnoredReturnSingletons1x1;
    private long mReturnTime;
    private long mMatrixTime;
    private long mWholeTime;
    private long mReturnSeparateTime;
    private long mReturnFirstTime;
    private long mReturnFirstTimeAlternative;
    private long mReturnFirstTimeHierAlternative;
    private final BufferedWriter mWriter1;
    private final BufferedWriter mWriter2;
    private final int mInitialPartitionSize;
    private int mLargestBlockInitialPartition;
    private final boolean mInitialPartitionSeparatesFinalsAndNonfinals;

    public ShrinkNwa(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, false, 0, false, 0, false, false);
    }

    public ShrinkNwa(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, boolean bl, int n, boolean bl2, int n2, boolean bl3, boolean bl4) throws AutomataOperationCanceledException {
        this(automataLibraryServices, iMinimizationStateFactory, iNestedWordAutomaton, null, false, false, bl, n, bl2, n2, bl3, bl4, true, false);
    }

    public ShrinkNwa(AutomataLibraryServices automataLibraryServices, IMinimizationStateFactory<STATE> iMinimizationStateFactory, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4, int n2, boolean bl5, boolean bl6, boolean bl7, boolean bl8) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iMinimizationStateFactory);
        this.mOperand = iNestedWordAutomaton;
        this.printStartMessage();
        this.mWriter1 = null;
        this.mWriter2 = null;
        if (iNestedWordAutomaton instanceof IDoubleDeckerAutomaton) {
            this.mDoubleDecker = (IDoubleDeckerAutomaton)iNestedWordAutomaton;
        } else {
            if (!this.isFiniteAutomaton()) {
                throw new IllegalArgumentException("The input must either be a finite automaton or an IDoubleDeckerAutomaton.");
            }
            this.mDoubleDecker = null;
        }
        this.mInitialPartitionSeparatesFinalsAndNonfinals = bl8;
        this.mPartition = new Partition();
        this.mEquivalenceClassIds = 0;
        this.mWorkListIntCall = new WorkListIntCall();
        this.mWorkListRet = new WorkListRet();
        this.mSplitEcsReturn = new LinkedList<EquivalenceClass>();
        this.mNegativeSet = new HashSet();
        this.mNegativeClass = new EquivalenceClass();
        this.mNegativeSet.add(this.mNegativeClass);
        this.mSingletonMatrix = new Matrix();
        this.mDownStateMap = new DummyMap();
        this.mInitialPartitionSize = partitionBackedSetOfPairs == null ? 0 : partitionBackedSetOfPairs.getRelation().size();
        this.mSplitOutgoing = bl3;
        if (this.mSplitOutgoing) {
            this.mOutInternal = new OutgoingHelperInternal();
            this.mOutCall = new OutgoingHelperCall();
        } else {
            this.mOutInternal = null;
            this.mOutCall = null;
        }
        this.mTreshold = n;
        this.mRandomReturnSplit = n > 0;
        this.mFirstReturnSplit = bl4;
        this.mFirstReturnLin2Hiers = this.mFirstReturnSplit ? new HashMap(2) : null;
        switch (n2) {
            case 0: {
                this.mFirstReturnSplitAlternative = false;
                this.mFirstReturnSplitHierAlternative = false;
                break;
            }
            case 1: {
                this.mFirstReturnSplitAlternative = true;
                this.mFirstReturnSplitHierAlternative = false;
                break;
            }
            case 2: {
                this.mFirstReturnSplitAlternative = true;
                this.mFirstReturnSplitHierAlternative = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("firstReturnSplitAlternative must be one of 0, 1, 2.");
            }
        }
        if (this.mFirstReturnSplitAlternative) {
            this.mWorkListRetHier = new WorkListRetHier();
        }
        this.mSplitAllCallPreds = bl5;
        this.mReturnSplitNaive = bl6;
        if (this.mReturnSplitNaive) {
            this.mReturnSplitCorrectnessEcs = new HashSet();
        }
        this.mNondeterministicTransitions = bl7;
        this.minimize(bl2, partitionBackedSetOfPairs, bl);
        this.constructAutomaton(bl);
        this.printExitMessage();
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public AutomataOperationStatistics getAutomataOperationStatistics() {
        AutomataOperationStatistics automataOperationStatistics = super.getAutomataOperationStatistics();
        if (this.mLargestBlockInitialPartition != 0) {
            automataOperationStatistics.addKeyValuePair(StatisticsType.SIZE_MAXIMAL_INITIAL_BLOCK, this.mLargestBlockInitialPartition);
        }
        return automataOperationStatistics;
    }

    private void minimize(boolean bl, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl2) throws AutomataOperationCanceledException {
        this.initialize(partitionBackedSetOfPairs);
        InternalTransitionIterator internalTransitionIterator = new InternalTransitionIterator();
        if (bl) {
            while (this.mWorkListIntCall.hasNext()) {
                this.checkTimeOut();
                EquivalenceClass equivalenceClass = this.mWorkListIntCall.next();
                this.splitInternalOrCallPredecessors(equivalenceClass, internalTransitionIterator, true);
            }
        } else {
            CallTransitionIterator callTransitionIterator = new CallTransitionIterator();
            block1: while (true) {
                EquivalenceClass equivalenceClass2;
                Object object;
                this.checkTimeOut();
                while (this.mWorkListIntCall.hasNext()) {
                    object = this.mWorkListIntCall.next();
                    if (((EquivalenceClass)object).mIncomingInt == IncomingStatus.IN_WORKLIST) {
                        ((EquivalenceClass)object).mIncomingInt = IncomingStatus.UNKNOWN;
                        this.splitInternalOrCallPredecessors((EquivalenceClass)object, internalTransitionIterator, true);
                    }
                    if (((EquivalenceClass)object).mIncomingCall != IncomingStatus.IN_WORKLIST) continue;
                    ((EquivalenceClass)object).mIncomingCall = IncomingStatus.UNKNOWN;
                    if (this.mSplitAllCallPreds) continue;
                    this.splitInternalOrCallPredecessors((EquivalenceClass)object, callTransitionIterator, false);
                }
                this.checkTimeOut();
                if (this.mWorkListRet.hasNext()) {
                    if (this.mRandomReturnSplit) {
                        this.mRandomReturnSplit = false;
                        object = new LinkedList();
                        for (EquivalenceClass equivalenceClass2 : this.mPartition.mEquivalenceClasses) {
                            if (equivalenceClass2.mStates.size() <= this.mTreshold) continue;
                            ((LinkedList)object).add(equivalenceClass2);
                        }
                        Iterator<EquivalenceClass> iterator = ((AbstractSequentialList)object).iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block1;
                            equivalenceClass2 = iterator.next();
                            this.splitRandom(equivalenceClass2);
                        }
                    }
                    if (this.mFirstReturnSplit) {
                        this.splitReturnPredecessorsFirstTime();
                        continue;
                    }
                    if (this.mFirstReturnSplitAlternative) {
                        this.mReturnFirstTimeAlternative -= new GregorianCalendar().getTimeInMillis();
                        this.splitReturnLinearAlt();
                        this.mReturnFirstTimeAlternative += new GregorianCalendar().getTimeInMillis();
                        continue;
                    }
                    if (this.mReturnSplitNaive) {
                        this.splitReturnNaiveHierarchicalStates(this.mWorkListRet.next());
                        continue;
                    }
                    this.splitReturnPredecessors();
                    continue;
                }
                if (this.mFirstReturnSplitAlternative) {
                    if (this.mFirstReturnSplitHierAlternative) {
                        if (this.mWorkListRetHier.hasNext()) {
                            this.mReturnFirstTimeHierAlternative -= new GregorianCalendar().getTimeInMillis();
                            this.splitReturnHierAlt();
                            this.mReturnFirstTimeHierAlternative += new GregorianCalendar().getTimeInMillis();
                            continue;
                        }
                        break;
                    }
                    this.mFirstReturnSplitAlternative = false;
                    this.mWorkListRet.fillWithAll();
                    continue;
                }
                if (this.mReturnSplitCorrectnessEcs == null || this.mReturnSplitCorrectnessEcs.isEmpty()) break;
                object = this.mReturnSplitCorrectnessEcs.iterator();
                assert (object.hasNext());
                equivalenceClass2 = (EquivalenceClass)object.next();
                object.remove();
                this.splitReturnCorrectness(equivalenceClass2);
            }
        }
    }

    private void checkTimeOut() throws AutomataOperationCanceledException {
        if (this.isCancellationRequested()) {
            String string = NestedWordAutomataUtils.generateGenericMinimizationRunningTaskDescription(this.getOperationName(), this.mOperand, this.mInitialPartitionSize, this.mLargestBlockInitialPartition);
            throw new AutomataOperationCanceledException(new RunningTaskInfo(this.getClass(), string));
        }
    }

    private void splitReturnNaiveHierarchicalEcs(EquivalenceClass equivalenceClass) {
        HashMap hashMap = new HashMap();
        for (Object object : equivalenceClass.mStates) {
            for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : this.mOperand.returnPredecessors(object)) {
                EquivalenceClass equivalenceClass2;
                HashSet hashSet;
                LETTER LETTER = incomingReturnTransition.getLetter();
                HashMap hashMap2 = (HashMap)hashMap.get(LETTER);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    hashMap.put(LETTER, hashMap2);
                }
                if ((hashSet = (HashSet)hashMap2.get(equivalenceClass2 = this.mPartition.mState2EquivalenceClass.get(incomingReturnTransition.getHierPred()))) == null) {
                    hashSet = new HashSet();
                    hashMap2.put(equivalenceClass2, hashSet);
                }
                hashSet.add(incomingReturnTransition.getLinPred());
            }
        }
        if (hashMap.isEmpty()) {
            equivalenceClass.mIncomingRet = IncomingStatus.NONE;
        } else {
            for (Object object : hashMap.values()) {
                for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : ((HashMap)object).values()) {
                    assert (!((HashSet)((Object)incomingReturnTransition)).isEmpty());
                    this.mPartition.splitEquivalenceClasses(incomingReturnTransition);
                }
            }
        }
    }

    private void splitReturnNaiveHierarchicalStates(EquivalenceClass equivalenceClass) {
        HashMap hashMap = new HashMap();
        for (Object object : equivalenceClass.mStates) {
            for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : this.mOperand.returnPredecessors(object)) {
                Object STATE;
                HashSet hashSet;
                LETTER LETTER = incomingReturnTransition.getLetter();
                HashMap hashMap2 = (HashMap)hashMap.get(LETTER);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap();
                    hashMap.put(LETTER, hashMap2);
                }
                if ((hashSet = (HashSet)hashMap2.get(STATE = incomingReturnTransition.getHierPred())) == null) {
                    hashSet = new HashSet();
                    hashMap2.put(STATE, hashSet);
                }
                hashSet.add(incomingReturnTransition.getLinPred());
            }
        }
        if (hashMap.isEmpty()) {
            equivalenceClass.mIncomingRet = IncomingStatus.NONE;
        } else {
            for (Object object : hashMap.values()) {
                for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : ((HashMap)object).values()) {
                    assert (!((HashSet)((Object)incomingReturnTransition)).isEmpty());
                    this.mPartition.splitEquivalenceClasses(incomingReturnTransition);
                }
            }
        }
    }

    private void splitReturnNaive(EquivalenceClass equivalenceClass) {
        HashMap<LETTER, HashSet<STATE>> hashMap = new HashMap<LETTER, HashSet<STATE>>();
        for (Object object : equivalenceClass.mStates) {
            for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : this.mOperand.returnPredecessors(object)) {
                LETTER LETTER = incomingReturnTransition.getLetter();
                HashSet<STATE> hashSet = (HashSet<STATE>)hashMap.get(LETTER);
                if (hashSet == null) {
                    hashSet = new HashSet<STATE>();
                    hashMap.put(LETTER, hashSet);
                }
                hashSet.add(incomingReturnTransition.getLinPred());
            }
        }
        if (hashMap.isEmpty()) {
            equivalenceClass.mIncomingRet = IncomingStatus.NONE;
        } else {
            for (Object object : hashMap.values()) {
                assert (!((HashSet)object).isEmpty());
                this.mPartition.splitEquivalenceClasses(object);
            }
        }
    }

    private void splitReturnCorrectness(EquivalenceClass equivalenceClass) {
        HashMap<EquivalenceClass, HashSet<EquivalenceClass>> hashMap3;
        HashMap hashMap2 = new HashMap();
        for (HashMap<EquivalenceClass, HashSet<EquivalenceClass>> hashMap3 : equivalenceClass.mStates) {
            HashSet<HashMap<EquivalenceClass, HashSet<EquivalenceClass>>> hashSet = new HashSet<HashMap<EquivalenceClass, HashSet<EquivalenceClass>>>();
            Iterator<OutgoingReturnTransition<LETTER, HashMap<EquivalenceClass, HashSet<EquivalenceClass>>>> iterator = this.mOperand.returnSuccessors(hashMap3).iterator();
            if (!iterator.hasNext()) continue;
            do {
                hashSet.add(iterator.next().getHierPred());
            } while (iterator.hasNext());
            hashMap2.put(hashMap3, hashSet);
        }
        hashMap3 = this.splitReturnEcTranslation(hashMap2);
        this.splitReturnForwardsAnalysis(hashMap3, true);
        while (!this.mSplitEcsReturn.isEmpty()) {
            assert (this.assertSetProperty(this.mSplitEcsReturn));
            this.splitReturnExecute(this.mSplitEcsReturn);
            hashMap3 = this.splitReturnEcTranslation(hashMap2);
            this.mSplitEcsReturn = new LinkedList<EquivalenceClass>();
            this.splitReturnForwardsAnalysis(hashMap3, true);
        }
        this.splitReturnForwardsAnalysis(hashMap3, false);
        if (!this.mSplitEcsReturn.isEmpty()) {
            assert (this.assertSetProperty(this.mSplitEcsReturn));
            this.splitReturnExecute(this.mSplitEcsReturn);
            this.mSplitEcsReturn = new LinkedList<EquivalenceClass>();
        }
    }

    private void splitReturnCorrectnessNoHier(EquivalenceClass equivalenceClass) {
        HashMap<EquivalenceClass, HashSet<EquivalenceClass>> hashMap3;
        HashMap hashMap2 = new HashMap();
        for (HashMap<EquivalenceClass, HashSet<EquivalenceClass>> hashMap3 : equivalenceClass.mStates) {
            HashSet<HashMap<EquivalenceClass, HashSet<EquivalenceClass>>> hashSet = new HashSet<HashMap<EquivalenceClass, HashSet<EquivalenceClass>>>();
            Iterator<OutgoingReturnTransition<LETTER, HashMap<EquivalenceClass, HashSet<EquivalenceClass>>>> iterator = this.mOperand.returnSuccessors(hashMap3).iterator();
            if (!iterator.hasNext()) continue;
            do {
                hashSet.add(iterator.next().getHierPred());
            } while (iterator.hasNext());
            hashMap2.put(hashMap3, hashSet);
        }
        hashMap3 = this.splitReturnEcTranslation(hashMap2);
        this.splitReturnForwardsAnalysis(hashMap3, false);
        if (!this.mSplitEcsReturn.isEmpty()) {
            assert (this.assertSetProperty(this.mSplitEcsReturn));
            this.splitReturnExecute(this.mSplitEcsReturn);
            this.mSplitEcsReturn = new LinkedList<EquivalenceClass>();
        }
    }

    private void splitReturnCorrectnessNoMatrix(EquivalenceClass equivalenceClass) {
        HashSet<EquivalenceClass> hashSet = new HashSet<EquivalenceClass>();
        for (Object object : equivalenceClass.mStates) {
            Iterator<IncomingReturnTransition<LETTER, STATE>> iterator = this.mOperand.returnPredecessors(object).iterator();
            while (iterator.hasNext()) {
                hashSet.add(this.mPartition.mState2EquivalenceClass.get(iterator.next().getHierPred()));
            }
        }
        for (EquivalenceClass equivalenceClass2 : hashSet) {
            for (Iterator<IncomingReturnTransition<LETTER, STATE>> iterator : equivalenceClass2.mStates) {
                Collection collection;
                HashMap hashMap = new HashMap();
                for (Object object : equivalenceClass.mStates) {
                    HashSet hashSet2;
                    if (!this.mDoubleDecker.isDoubleDecker((Iterator<IncomingReturnTransition<LETTER, STATE>>)object, iterator)) continue;
                    collection = this.mOperand.returnSuccessorsGivenHier((Iterator<IncomingReturnTransition<LETTER, STATE>>)object, iterator).iterator();
                    HashMap<EquivalenceClass, HashSet<Object>> hashMap2 = new HashMap<EquivalenceClass, HashSet<Object>>();
                    if (collection.hasNext()) {
                        do {
                            EquivalenceClass equivalenceClass3;
                            HashSet<Object> hashSet3;
                            if ((hashSet3 = (HashSet<Object>)hashMap2.get(equivalenceClass3 = this.mPartition.mState2EquivalenceClass.get(((OutgoingReturnTransition)((Object)(hashSet2 = (OutgoingReturnTransition)collection.next()))).getSucc()))) == null) {
                                hashSet3 = new HashSet<Object>();
                                hashMap2.put(equivalenceClass3, hashSet3);
                            }
                            hashSet3.add(object);
                        } while (collection.hasNext());
                        continue;
                    }
                    hashSet2 = (HashSet)hashMap2.get(this.mNegativeClass);
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet();
                        hashMap2.put(this.mNegativeClass, hashSet2);
                    }
                    hashSet2.add(object);
                }
                for (Object object : hashMap.values()) {
                    collection = ((HashMap)object).values();
                    if (collection.size() <= 1) continue;
                    equivalenceClass2.markSplit(collection);
                }
                if (this.mSplitEcsReturn.isEmpty()) continue;
                this.splitReturnExecute(this.mSplitEcsReturn);
                this.mSplitEcsReturn = new LinkedList<EquivalenceClass>();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initialize(PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs) {
        if (partitionBackedSetOfPairs == null) {
            HashSet iterable = new HashSet();
            HashSet hashSet = new HashSet();
            for (HashSet hashSet2 : this.mOperand.getStates()) {
                if (this.mSplitAllCallPreds && this.mOperand.callSuccessors(hashSet2).iterator().hasNext()) {
                    this.mPartition.addEcInitialization(Collections.singleton(hashSet2));
                    continue;
                }
                if (this.mOperand.isFinal(hashSet2)) {
                    iterable.add(hashSet2);
                    continue;
                }
                hashSet.add(hashSet2);
            }
            if (this.mSplitOutgoing) {
                this.splitOutgoing(iterable, hashSet);
            } else {
                if (!iterable.isEmpty()) {
                    this.mPartition.addEcInitialization(iterable);
                }
                if (!hashSet.isEmpty()) {
                    this.mPartition.addEcInitialization(hashSet);
                }
            }
        } else {
            Object object = partitionBackedSetOfPairs.getRelation();
            if (this.mInitialPartitionSeparatesFinalsAndNonfinals) {
                assert (this.assertStatesSeparation((Iterable<Set<STATE>>)object)) : "The states in the initial modules are not separated with respect to their final status.";
                hashSet2 = object.iterator();
                while (hashSet2.hasNext()) {
                    Set set = (Set)hashSet2.next();
                    this.mPartition.addEcInitialization(set);
                    this.mLargestBlockInitialPartition = Math.max(this.mLargestBlockInitialPartition, set.size());
                }
            } else {
                HashSet hashSet = new HashSet();
                hashSet2 = new HashSet();
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    void var3_10;
                    Set set = (Set)iterator.next();
                    for (Object e : set) {
                        if (this.mOperand.isFinal(e)) {
                            var3_10.add(e);
                            continue;
                        }
                        hashSet2.add(e);
                    }
                    if (!var3_10.isEmpty()) {
                        this.mPartition.addEcInitialization(var3_10);
                        this.mLargestBlockInitialPartition = Math.max(this.mLargestBlockInitialPartition, var3_10.size());
                        HashSet hashSet3 = new HashSet();
                    }
                    if (hashSet2.isEmpty()) continue;
                    this.mPartition.addEcInitialization(hashSet2);
                    this.mLargestBlockInitialPartition = Math.max(this.mLargestBlockInitialPartition, hashSet2.size());
                    hashSet2 = new HashSet();
                }
            }
        }
        if (this.mSplitAllCallPreds) {
            for (EquivalenceClass equivalenceClass : this.mPartition.mEquivalenceClasses) {
                equivalenceClass.mIncomingCall = IncomingStatus.NONE;
            }
        }
        if (this.mReturnSplitCorrectnessEcs != null) {
            this.mReturnSplitCorrectnessEcs.addAll(this.mPartition.mEquivalenceClasses);
        }
    }

    private void splitInternalOrCallPredecessors(EquivalenceClass equivalenceClass, ITransitionIterator<LETTER, STATE> iTransitionIterator, boolean bl) {
        assert (bl && iTransitionIterator instanceof InternalTransitionIterator && equivalenceClass.mIncomingInt != IncomingStatus.IN_WORKLIST || !bl && iTransitionIterator instanceof CallTransitionIterator && equivalenceClass.mIncomingCall != IncomingStatus.IN_WORKLIST);
        HashMap<LETTER, HashSet<STATE>> hashMap = new HashMap<LETTER, HashSet<STATE>>();
        for (Object object : equivalenceClass.mStates) {
            iTransitionIterator.nextState(object);
            while (iTransitionIterator.hasNext()) {
                LETTER LETTER = iTransitionIterator.nextAndLetter();
                HashSet<STATE> hashSet = (HashSet<STATE>)hashMap.get(LETTER);
                if (hashSet == null) {
                    hashSet = new HashSet<STATE>();
                    hashMap.put(LETTER, hashSet);
                }
                hashSet.add(iTransitionIterator.getPred());
            }
        }
        if (hashMap.isEmpty()) {
            if (bl) {
                equivalenceClass.mIncomingInt = IncomingStatus.NONE;
            } else {
                equivalenceClass.mIncomingCall = IncomingStatus.NONE;
            }
        } else {
            for (Object object : hashMap.values()) {
                assert (!((HashSet)object).isEmpty());
                this.mPartition.splitEquivalenceClasses(object);
            }
        }
    }

    private void splitReturnPredecessors() {
        HashMap<STATE, HashSet<STATE>> hashMap = this.splitReturnBackwardsAnalysis();
        HashMap<EquivalenceClass, HashSet<EquivalenceClass>> hashMap2 = this.splitReturnEcTranslation(hashMap);
        this.splitReturnForwardsAnalysis(hashMap2, true);
        while (!this.mSplitEcsReturn.isEmpty()) {
            assert (this.assertSetProperty(this.mSplitEcsReturn));
            this.splitReturnExecute(this.mSplitEcsReturn);
            hashMap2 = this.splitReturnEcTranslation(hashMap);
            this.mSplitEcsReturn = new LinkedList<EquivalenceClass>();
            this.splitReturnForwardsAnalysis(hashMap2, true);
        }
        this.splitReturnForwardsAnalysis(hashMap2, false);
        if (!this.mSplitEcsReturn.isEmpty()) {
            assert (this.assertSetProperty(this.mSplitEcsReturn));
            this.splitReturnExecute(this.mSplitEcsReturn);
            this.mSplitEcsReturn = new LinkedList<EquivalenceClass>();
        }
    }

    private HashMap<STATE, HashSet<STATE>> splitReturnBackwardsAnalysis() {
        HashMap<STATE, HashSet<STATE>> hashMap = new HashMap<STATE, HashSet<STATE>>(ShrinkNwa.computeHashCap(this.mPartition.mEquivalenceClasses.size()));
        while (this.mWorkListRet.hasNext()) {
            EquivalenceClass equivalenceClass = this.mWorkListRet.next();
            boolean bl = false;
            for (Object STATE : equivalenceClass.mStates) {
                Iterator<IncomingReturnTransition<LETTER, STATE>> iterator = this.mOperand.returnPredecessors(STATE).iterator();
                if (!iterator.hasNext()) continue;
                bl = true;
                do {
                    IncomingReturnTransition<LETTER, STATE> incomingReturnTransition;
                    STATE STATE2;
                    HashSet<STATE> hashSet;
                    if ((hashSet = (HashSet<STATE>)hashMap.get(STATE2 = (incomingReturnTransition = iterator.next()).getLinPred())) == null) {
                        hashSet = new HashSet<STATE>();
                        hashMap.put(STATE2, hashSet);
                    }
                    hashSet.add(incomingReturnTransition.getHierPred());
                } while (iterator.hasNext());
            }
            if (bl) continue;
            equivalenceClass.mIncomingRet = IncomingStatus.NONE;
        }
        return hashMap;
    }

    private HashMap<EquivalenceClass, HashSet<EquivalenceClass>> splitReturnEcTranslation(HashMap<STATE, HashSet<STATE>> hashMap) {
        HashMap<EquivalenceClass, HashSet<EquivalenceClass>> hashMap2 = new HashMap<EquivalenceClass, HashSet<EquivalenceClass>>(ShrinkNwa.computeHashCap(hashMap.size()));
        for (Map.Entry<STATE, HashSet<STATE>> entry : hashMap.entrySet()) {
            EquivalenceClass equivalenceClass = this.mPartition.mState2EquivalenceClass.get(entry.getKey());
            HashSet<EquivalenceClass> hashSet = hashMap2.get(equivalenceClass);
            if (hashSet == null) {
                hashSet = new HashSet();
                hashMap2.put(equivalenceClass, hashSet);
            }
            for (STATE STATE : entry.getValue()) {
                hashSet.add(this.mPartition.mState2EquivalenceClass.get(STATE));
            }
        }
        return hashMap2;
    }

    private void splitReturnForwardsAnalysis(HashMap<EquivalenceClass, HashSet<EquivalenceClass>> hashMap, boolean bl) {
        for (Map.Entry<EquivalenceClass, HashSet<EquivalenceClass>> entry : hashMap.entrySet()) {
            EquivalenceClass equivalenceClass = entry.getKey();
            boolean bl2 = equivalenceClass.mStates.size() == 1;
            HashSet<EquivalenceClass> hashSet = entry.getValue();
            Matrix matrix = equivalenceClass.mMatrix;
            if (matrix == null) {
                equivalenceClass.initializeMatrix(hashSet);
                matrix = equivalenceClass.mMatrix;
            }
            if (matrix == this.mSingletonMatrix) continue;
            HashMap hashMap2 = matrix.mHier2lin2letter2succ;
            for (EquivalenceClass equivalenceClass2 : hashSet) {
                if (bl2 && equivalenceClass2.mStates.size() == 1) continue;
                ArrayList<MatrixRow> arrayList = new ArrayList<MatrixRow>(equivalenceClass2.mStates.size());
                for (Object STATE : equivalenceClass2.mStates) {
                    HashMap hashMap3 = hashMap2.get(STATE);
                    if (hashMap3 == null || hashMap3.isEmpty()) continue;
                    arrayList.add(new MatrixRow(STATE, hashMap3));
                }
                if (bl) {
                    if (bl2) continue;
                    this.splitReturnAnalyzeLinear(hashMap2, equivalenceClass, arrayList);
                    continue;
                }
                if (arrayList.size() <= 1) continue;
                this.splitReturnAnalyzeHierarchical(hashMap2, equivalenceClass2, arrayList);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void splitReturnAnalyzeLinear(HashMap<STATE, HashMap<STATE, HashMap<LETTER, HashSet<STATE>>>> hashMap, EquivalenceClass equivalenceClass, ArrayList<MatrixRow> arrayList) {
        for (MatrixRow matrixRow : arrayList) {
            HashMap hashMap2 = matrixRow.mLin2letter2succ;
            if (hashMap2.size() == 1) continue;
            int n = ShrinkNwa.computeHashCap(hashMap2.size());
            HashMap hashMap3 = new HashMap(n);
            HashSet hashSet = new HashSet(n);
            for (Map.Entry entry : hashMap2.entrySet()) {
                void hashSet22;
                Object STATE = entry.getKey();
                assert (equivalenceClass.mStates.contains(STATE));
                HashMap hashMap4 = entry.getValue();
                if (hashMap4 == this.mDownStateMap) {
                    hashSet.add(STATE);
                    continue;
                }
                HashMap hashMap5 = new HashMap(ShrinkNwa.computeHashCap(hashMap4.size()));
                for (Map.Entry entry2 : hashMap4.entrySet()) {
                    Object LETTER = entry2.getKey();
                    HashSet hashSet2 = entry2.getValue();
                    HashSet<EquivalenceClass> hashSet3 = new HashSet<EquivalenceClass>(ShrinkNwa.computeHashCap(hashSet2.size()));
                    for (Object STATE2 : hashSet2) {
                        hashSet3.add(this.mPartition.mState2EquivalenceClass.get(STATE2));
                    }
                    hashMap5.put(LETTER, hashSet3);
                }
                HashSet hashSet4 = (HashSet)hashMap3.get(hashMap5);
                if (hashSet4 == null) {
                    HashSet hashSet5 = new HashSet();
                    hashMap3.put(hashMap5, hashSet5);
                }
                hashSet22.add(STATE);
            }
            if (!hashSet.isEmpty()) {
                hashMap3.put(null, hashSet);
            }
            if (hashMap3.size() <= 1) continue;
            equivalenceClass.markSplit(hashMap3.values());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void splitReturnAnalyzeHierarchical(HashMap<STATE, HashMap<STATE, HashMap<LETTER, HashSet<STATE>>>> hashMap, EquivalenceClass equivalenceClass, ArrayList<MatrixRow> arrayList) {
        int n = arrayList.size();
        if (n <= 1) {
            return;
        }
        int n2 = ShrinkNwa.computeHashCap(n);
        HashMap hashMap2 = new HashMap(n2);
        HashSet hashSet = new HashSet(n2);
        int n3 = ShrinkNwa.computeHashCap(equivalenceClass.mStates.size());
        int n4 = 0;
        while (n4 < n) {
            MatrixRow matrixRow = arrayList.get(n4);
            Object STATE = matrixRow.mHier;
            HashMap hashMap3 = matrixRow.mLin2letter2succ.values().iterator().next();
            if (hashMap3 == this.mDownStateMap) {
                hashSet.add(STATE);
            } else {
                void hashSet22;
                HashMap hashMap4 = new HashMap(ShrinkNwa.computeHashCap(hashMap3.size()));
                for (Map.Entry entry : hashMap3.entrySet()) {
                    Object LETTER = entry.getKey();
                    HashSet hashSet2 = entry.getValue();
                    HashSet<EquivalenceClass> hashSet3 = new HashSet<EquivalenceClass>(ShrinkNwa.computeHashCap(hashSet2.size()));
                    for (Object STATE2 : hashSet2) {
                        hashSet3.add(this.mPartition.mState2EquivalenceClass.get(STATE2));
                    }
                    hashMap4.put(LETTER, hashSet3);
                }
                HashSet hashSet4 = (HashSet)hashMap2.get(hashMap4);
                if (hashSet4 == null) {
                    HashSet hashSet5 = new HashSet(n3);
                    hashMap2.put(hashMap4, hashSet5);
                }
                hashSet22.add(STATE);
            }
            ++n4;
        }
        if (!hashSet.isEmpty()) {
            hashMap2.put(null, hashSet);
        }
        if (hashMap2.size() > 1) {
            equivalenceClass.markSplit(hashMap2.values());
        }
    }

    private void splitReturnExecute(Collection<EquivalenceClass> collection) {
        for (EquivalenceClass equivalenceClass : collection) {
            int n;
            HashMap hashMap = equivalenceClass.mState2SeparatedSet;
            assert (hashMap != null);
            int n2 = equivalenceClass.mStates.size();
            ArrayList<ColorSet> arrayList = new ArrayList<ColorSet>(n2);
            block1: for (Map.Entry entry : hashMap.entrySet()) {
                Object STATE = entry.getKey();
                HashSet hashSet = entry.getValue();
                assert (equivalenceClass.mStates.contains(STATE) && hashSet != null);
                for (ColorSet colorSet : arrayList) {
                    if (colorSet.mBlocked.contains(STATE)) continue;
                    colorSet.mContent.add(STATE);
                    colorSet.mBlocked.addAll(hashSet);
                    --n2;
                    continue block1;
                }
                arrayList.add(new ColorSet(n2, STATE, hashSet));
                --n2;
            }
            assert (n2 >= 0);
            int n3 = 0;
            if (n2 == 0) {
                n = ((ColorSet)arrayList.get((int)0)).mContent.size();
                var9_12 = arrayList.size() - 1;
                while (var9_12 > 0) {
                    int n4 = ((ColorSet)arrayList.get((int)var9_12)).mContent.size();
                    if (n4 > n) {
                        n = n4;
                        n3 = var9_12;
                    }
                    --var9_12;
                }
            } else {
                n = ((ColorSet)arrayList.get((int)0)).mContent.size();
                var9_12 = arrayList.size() - 1;
                while (var9_12 > 0) {
                    int n5 = ((ColorSet)arrayList.get((int)var9_12)).mContent.size();
                    if (n5 < n) {
                        n = n5;
                        n3 = var9_12;
                    }
                    --var9_12;
                }
            }
            n = arrayList.size();
            while (true) {
                if (--n == n3) {
                    --n;
                }
                if (n < 0) break;
                EquivalenceClass equivalenceClass2 = this.mPartition.addEcReturn(((ColorSet)arrayList.get((int)n)).mContent, equivalenceClass);
            }
            equivalenceClass.mState2SeparatedSet = null;
        }
    }

    private void splitReturnLinearAlt() {
        EquivalenceClass equivalenceClass = this.mWorkListRet.next();
        HashMap<EquivalenceClass, HashSet<IncomingReturnTransition<LETTER, STATE>>> hashMap = this.splitReturnFindTransitionsAlt(equivalenceClass);
        if (hashMap.isEmpty()) {
            equivalenceClass.mIncomingRet = IncomingStatus.NONE;
            return;
        }
        for (Map.Entry<EquivalenceClass, HashSet<IncomingReturnTransition<LETTER, STATE>>> entry : hashMap.entrySet()) {
            this.splitReturnLinearAltHelper(entry.getKey(), (Collection)entry.getValue());
        }
    }

    private HashMap<EquivalenceClass, HashSet<IncomingReturnTransition<LETTER, STATE>>> splitReturnFindTransitionsAlt(EquivalenceClass equivalenceClass) {
        HashMap<EquivalenceClass, HashSet<IncomingReturnTransition<LETTER, STATE>>> hashMap = new HashMap<EquivalenceClass, HashSet<IncomingReturnTransition<LETTER, STATE>>>();
        HashMap hashMap2 = this.mPartition.mState2EquivalenceClass;
        for (Object STATE : equivalenceClass.mStates) {
            for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : this.mOperand.returnPredecessors(STATE)) {
                EquivalenceClass equivalenceClass2 = hashMap2.get(incomingReturnTransition.getLinPred());
                HashSet<IncomingReturnTransition<LETTER, STATE>> hashSet = hashMap.get(equivalenceClass2);
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashMap.put(equivalenceClass2, hashSet);
                }
                hashSet.add(incomingReturnTransition);
            }
        }
        return hashMap;
    }

    private void splitReturnLinearAltHelper(EquivalenceClass equivalenceClass, Collection<IncomingReturnTransition<LETTER, STATE>> collection) {
        Object object;
        HashSet<Object> hashSet;
        HashMap<Object, HashSet<Object>> hashMap;
        IncomingReturnTransition<LETTER, STATE> incomingReturnTransition2;
        Set set = equivalenceClass.mStates;
        int n = set.size();
        if (n == 1) {
            return;
        }
        HashSet hashSet2 = new HashSet(ShrinkNwa.computeHashCap(n));
        HashMap hashMap2 = new HashMap(ShrinkNwa.computeHashCap(collection.size()));
        equivalenceClass.mState2SeparatedSet = new HashMap(ShrinkNwa.computeHashCap(n));
        for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition2 : collection) {
            Object LETTER;
            Object object2 = incomingReturnTransition2.getHierPred();
            hashMap = (HashMap)hashMap2.get(object2);
            if (hashMap == null) {
                hashMap = new HashMap();
                hashMap2.put(object2, hashMap);
            }
            if ((hashSet = (HashSet<Object>)hashMap.get(LETTER = incomingReturnTransition2.getLetter())) == null) {
                hashSet = new HashSet<Object>();
                hashMap.put(LETTER, hashSet);
            }
            object = incomingReturnTransition2.getLinPred();
            hashSet.add(object);
            hashSet2.add(object);
        }
        incomingReturnTransition2 = new ArrayList(n - hashSet2.size());
        for (Object e : set) {
            if (hashSet2.contains(e)) continue;
            ((ArrayList)((Object)incomingReturnTransition2)).add(e);
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            hashMap = entry.getKey();
            int n2 = ShrinkNwa.computeHashCap(n - hashSet2.size());
            hashSet = new HashSet(n2);
            object = new HashSet(n2);
            Iterator<Object> iterator = ((ArrayList)((Object)incomingReturnTransition2)).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.mDoubleDecker.isDoubleDecker(e, hashMap)) {
                    ((HashSet)object).add(e);
                    for (HashSet hashSet3 : hashSet2) {
                        equivalenceClass.markPair(e, hashSet3);
                    }
                    continue;
                }
                hashSet.add(e);
            }
            for (Map.Entry entry2 : ((HashMap)entry.getValue()).entrySet()) {
                HashSet hashSet3;
                hashSet3 = (HashSet)entry2.getValue();
                if (hashSet3.size() == hashSet2.size()) continue;
                for (Iterator iterator2 : hashSet2) {
                    if (hashSet3.contains(iterator2) || !this.mDoubleDecker.isDoubleDecker(iterator2, hashMap)) continue;
                    for (Object e : hashSet3) {
                        equivalenceClass.markPair(iterator2, e);
                    }
                }
            }
        }
        if (equivalenceClass.mState2SeparatedSet.size() > 0) {
            this.mSplitEcsReturn.add(equivalenceClass);
            this.splitReturnExecute(this.mSplitEcsReturn);
            this.mSplitEcsReturn = new LinkedList<EquivalenceClass>();
        }
        equivalenceClass.mState2SeparatedSet = null;
    }

    private void splitReturnHierAlt() {
        EquivalenceClass equivalenceClass;
        block3: {
            do {
                equivalenceClass = this.mWorkListRetHier.next();
                if (equivalenceClass.mIncomingRet != IncomingStatus.NONE) break block3;
            } while (this.mWorkListRetHier.hasNext());
            return;
        }
        HashMap<EquivalenceClass, HashSet<EquivalenceClass>> hashMap = this.splitReturnFindOutgoingTransitions(equivalenceClass);
        if (hashMap.isEmpty()) {
            equivalenceClass.mIncomingRet = IncomingStatus.NONE;
            return;
        }
        for (Map.Entry<EquivalenceClass, HashSet<EquivalenceClass>> entry : hashMap.entrySet()) {
            this.splitReturnHierAltHelper(entry.getKey(), entry.getValue());
        }
    }

    private HashMap<EquivalenceClass, HashSet<EquivalenceClass>> splitReturnFindOutgoingTransitions(EquivalenceClass equivalenceClass) {
        HashMap<EquivalenceClass, HashSet<EquivalenceClass>> hashMap = new HashMap<EquivalenceClass, HashSet<EquivalenceClass>>();
        HashMap hashMap2 = this.mPartition.mState2EquivalenceClass;
        for (Object STATE : equivalenceClass.mStates) {
            for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : this.mOperand.returnPredecessors(STATE)) {
                EquivalenceClass equivalenceClass2 = hashMap2.get(incomingReturnTransition.getHierPred());
                HashSet<EquivalenceClass> hashSet = hashMap.get(equivalenceClass2);
                if (hashSet == null) {
                    hashSet = new HashSet();
                    hashMap.put(equivalenceClass2, hashSet);
                }
                hashSet.add(hashMap2.get(incomingReturnTransition.getLinPred()));
            }
        }
        return hashMap;
    }

    private void splitReturnHierAltHelper(EquivalenceClass equivalenceClass, HashSet<EquivalenceClass> hashSet) {
        Set set = equivalenceClass.mStates;
        int n = set.size();
        if (n == 1) {
            return;
        }
        equivalenceClass.mState2SeparatedSet = new HashMap(ShrinkNwa.computeHashCap(n));
        HashMap hashMap = this.mPartition.mState2EquivalenceClass;
        for (EquivalenceClass equivalenceClass2 : hashSet) {
            HashMap hashMap2 = new HashMap();
            for (Object STATE : set) {
                Object object2;
                HashMap hashMap3 = new HashMap(ShrinkNwa.computeHashCap(n));
                for (Object object2 : equivalenceClass2.mStates) {
                    if (!this.mDoubleDecker.isDoubleDecker(object2, STATE)) continue;
                    Iterator iterator = this.mOperand.returnSuccessorsGivenHier(object2, STATE).iterator();
                    if (iterator.hasNext()) {
                        do {
                            OutgoingReturnTransition outgoingReturnTransition;
                            EquivalenceClass equivalenceClass3;
                            HashSet hashSet2;
                            if ((hashSet2 = (HashSet)hashMap3.get(equivalenceClass3 = hashMap.get((outgoingReturnTransition = iterator.next()).getSucc()))) == null) {
                                hashSet2 = new HashSet();
                                hashMap3.put(equivalenceClass3, hashSet2);
                            }
                            hashSet2.add(outgoingReturnTransition.getLetter());
                        } while (iterator.hasNext());
                        break;
                    }
                    hashMap3.put(this.mNegativeClass, null);
                    break;
                }
                assert (!hashMap3.isEmpty());
                object2 = (HashSet)hashMap2.get(hashMap3);
                if (object2 == null) {
                    object2 = new HashSet();
                    hashMap2.put(hashMap3, object2);
                }
                ((HashSet)object2).add(STATE);
            }
            if (hashMap2.size() <= 1) continue;
            equivalenceClass.markSplit(hashMap2.values());
        }
        if (equivalenceClass.mState2SeparatedSet.size() > 0) {
            this.mSplitEcsReturn.add(equivalenceClass);
            this.splitReturnExecute(this.mSplitEcsReturn);
            this.mSplitEcsReturn = new LinkedList<EquivalenceClass>();
        }
        equivalenceClass.mState2SeparatedSet = null;
    }

    private void splitReturnPredecessorsFirstTime() {
        Set<Map.Entry<EquivalenceClass, HashSet<STATE>>> set = this.mFirstReturnLin2Hiers.entrySet();
        block0: while (true) {
            HashSet<Object> hashSet;
            EquivalenceClass equivalenceClass;
            if (!set.isEmpty()) {
                assert (set.size() == 1);
                Map.Entry<EquivalenceClass, HashSet<STATE>> entry = set.iterator().next();
                equivalenceClass = entry.getKey();
                hashSet = entry.getValue();
            } else {
                if (!this.mWorkListRet.hasNext()) break;
                equivalenceClass = this.mWorkListRet.next();
            }
            if (equivalenceClass.mStates.size() == 1) continue;
            hashSet = this.splitReturnPredecessorsFirstTimeRepeat(equivalenceClass, new HashSet());
            while (true) {
                if (hashSet == null || hashSet.isEmpty()) continue block0;
                if (this.mWorkListIntCall.hasNext()) {
                    this.mFirstReturnLin2Hiers = new HashMap(2);
                    this.mFirstReturnLin2Hiers.put(equivalenceClass, hashSet);
                    continue block0;
                }
                if (equivalenceClass.mStates.size() == 1) continue;
                hashSet = this.splitReturnPredecessorsFirstTimeRepeat(equivalenceClass, hashSet);
            }
            break;
        }
        this.mFirstReturnSplit = false;
        this.mWorkListRet.fillWithAll();
    }

    private HashSet<STATE> splitReturnPredecessorsFirstTimeRepeat(EquivalenceClass equivalenceClass, HashSet<STATE> hashSet) {
        hashSet = this.splitReturnPredecessorsFirstTimeAnalyze(equivalenceClass, hashSet);
        if (this.mSplitEcsReturn.size() == 1) {
            assert (this.mSplitEcsReturn.get(0) == equivalenceClass);
            this.splitReturnExecute(this.mSplitEcsReturn);
            this.mSplitEcsReturn.clear();
        } else assert (this.mSplitEcsReturn.isEmpty());
        return hashSet;
    }

    private HashSet<STATE> splitReturnPredecessorsFirstTimeAnalyze(EquivalenceClass equivalenceClass, HashSet<STATE> hashSet) {
        Object object;
        Set set = equivalenceClass.mStates;
        HashSet<Object> hashSet2 = new HashSet<Object>();
        boolean bl = hashSet.isEmpty();
        block0: for (Object STATE : set) {
            for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mOperand.returnSuccessors(STATE)) {
                object = outgoingReturnTransition.getHierPred();
                if (!hashSet.add(object)) continue;
                hashSet2.add(object);
                if (hashSet2.size() != 150) continue;
                bl = true;
                break block0;
            }
        }
        if (!bl) {
            hashSet = null;
        }
        int n = ShrinkNwa.computeHashCap(set.size());
        for (Object e : hashSet2) {
            HashMap hashMap = new HashMap(n);
            object = new HashSet(n);
            for (Object STATE : set) {
                if (!this.mDoubleDecker.isDoubleDecker(STATE, e)) continue;
                Iterator iterator = this.mOperand.returnSuccessorsGivenHier(STATE, e).iterator();
                if (iterator.hasNext()) {
                    HashSet hashSet3;
                    HashMap hashMap2 = new HashMap();
                    do {
                        Object LETTER;
                        HashSet hashSet4;
                        if ((hashSet4 = (HashSet)hashMap2.get(LETTER = ((OutgoingReturnTransition)((Object)(hashSet3 = iterator.next()))).getLetter())) == null) {
                            hashSet4 = new HashSet();
                            hashMap2.put(LETTER, hashSet4);
                        }
                        hashSet4.add(((OutgoingReturnTransition)((Object)hashSet3)).getSucc());
                    } while (iterator.hasNext());
                    hashSet3 = (HashSet)hashMap.get(hashMap2);
                    if (hashSet3 == null) {
                        hashSet3 = new HashSet();
                        hashMap.put(hashMap2, hashSet3);
                    }
                    hashSet3.add(STATE);
                    continue;
                }
                ((HashSet)object).add(STATE);
            }
            if (!((HashSet)object).isEmpty()) {
                hashMap.put(null, object);
            }
            if (hashMap.size() <= 1) continue;
            equivalenceClass.markSplit(hashMap.values());
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    private void splitReturnExecuteOld(Collection<EquivalenceClass> collection) {
        for (EquivalenceClass equivalenceClass : collection) {
            void n4;
            void var10_13;
            Iterable<Object> iterable;
            Object object;
            HashMap hashMap = equivalenceClass.mState2SeparatedSet;
            assert (hashMap != null);
            HashMap<Object, Integer> hashMap2 = new HashMap<Object, Integer>(ShrinkNwa.computeHashCap(equivalenceClass.mStates.size()));
            int n = 0;
            block1: for (Map.Entry entry : hashMap.entrySet()) {
                object = entry.getKey();
                iterable = entry.getValue();
                assert (equivalenceClass.mStates.contains(object) && iterable != null);
                if (n == 0) {
                    hashMap2.put(object, 0);
                    ++n;
                    continue;
                }
                HashSet<Integer> hashSet = new HashSet<Integer>(ShrinkNwa.computeHashCap(n));
                for (Object STATE : iterable) {
                    Integer n2 = (Integer)hashMap2.get(STATE);
                    if (n2 == null) continue;
                    hashSet.add(n2);
                    if (hashSet.size() == n) break;
                }
                if (hashSet.size() == n) {
                    hashMap2.put(object, n);
                    ++n;
                    continue;
                }
                assert (hashSet.size() < n);
                int n3 = 0;
                while (true) {
                    assert (n3 <= n);
                    if (!hashSet.contains(n3)) {
                        hashMap2.put(object, n3);
                        continue block1;
                    }
                    ++n3;
                }
            }
            assert (n > 1);
            HashSet[] hashSetArray2 = new HashSet[n];
            int n5 = n - 1;
            while (var10_13 > 0) {
                hashSetArray2[var10_13] = new HashSet();
                --var10_13;
            }
            for (Map.Entry entry : hashMap2.entrySet()) {
                int n6 = (Integer)entry.getValue();
                if (n6 <= 0) continue;
                hashSetArray2[n6].add(entry.getKey());
            }
            int n7 = hashSetArray2.length - 1;
            while (n4 > 0) {
                object = hashSetArray2[n4];
                iterable = this.mPartition.addEcReturn(object, equivalenceClass);
                --n4;
            }
            equivalenceClass.mState2SeparatedSet = null;
        }
    }

    private void splitRandom(EquivalenceClass equivalenceClass) {
        if (this.mOperand.callSuccessors(equivalenceClass.mStates.iterator().next()).iterator().hasNext()) {
            this.splitRandomEqual(equivalenceClass);
        } else {
            this.splitRandomReturns(equivalenceClass);
        }
    }

    private void splitRandomEqual(EquivalenceClass equivalenceClass) {
        Set set = equivalenceClass.mStates;
        int n = ShrinkNwa.computeHashCap(this.mTreshold);
        block0: while (set.size() > this.mTreshold) {
            HashSet hashSet = new HashSet(n);
            int n2 = this.mTreshold;
            for (Object STATE : set) {
                hashSet.add(STATE);
                if (--n2 != 0) continue;
                this.mPartition.addEcReturn(hashSet, equivalenceClass);
                continue block0;
            }
        }
    }

    private void splitRandomReturns(EquivalenceClass equivalenceClass) {
        Set set = equivalenceClass.mStates;
        int n = ShrinkNwa.computeHashCap(this.mTreshold);
        LinkedList linkedList = new LinkedList();
        HashSet hashSet = new HashSet(n);
        for (Object STATE : set) {
            if (!this.mOperand.returnSuccessors(STATE).iterator().hasNext()) continue;
            hashSet.add(STATE);
            if (hashSet.size() != this.mTreshold) continue;
            linkedList.add(hashSet);
            hashSet = new HashSet(n);
        }
        if (!hashSet.isEmpty()) {
            linkedList.add(hashSet);
        } else if (linkedList.isEmpty()) {
            return;
        }
        int n2 = set.size();
        for (HashSet hashSet2 : linkedList) {
            assert (!hashSet2.isEmpty());
            if ((n2 -= hashSet2.size()) == 0) break;
            this.mPartition.addEcReturn(hashSet2, equivalenceClass);
        }
    }

    private void constructAutomaton(boolean bl) {
        this.mPartition.markInitials();
        this.constructResultFromPartition(this.mPartition, bl);
        this.mPartition = null;
        this.mWorkListIntCall = null;
        this.mWorkListRet = null;
    }

    private boolean assertStatesSeparation(Iterable<Set<STATE>> iterable) {
        for (Set<STATE> set : iterable) {
            Iterator<STATE> iterator = set.iterator();
            assert (iterator.hasNext()) : "Empty equivalence classes should be avoided.";
            boolean bl = this.mOperand.isFinal(iterator.next());
            while (iterator.hasNext()) {
                if (bl == this.mOperand.isFinal(iterator.next())) continue;
                return false;
            }
        }
        return true;
    }

    private <T> boolean assertSetProperty(List<T> list) {
        HashSet<T> hashSet = new HashSet<T>(ShrinkNwa.computeHashCap(list.size()));
        hashSet.addAll(list);
        return hashSet.size() == list.size();
    }

    private void splitOutgoing(HashSet<STATE> hashSet, HashSet<STATE> hashSet2) {
        HashSet<STATE> hashSet3 = hashSet;
        int n = 0;
        while (n < 2) {
            if (!hashSet3.isEmpty()) {
                HashMap<Collection<LETTER>, Collection<STATE>> hashMap = this.splitOutgoingHelper(hashSet3, this.mOutCall);
                for (Collection<STATE> collection : hashMap.values()) {
                    HashMap<Collection<LETTER>, Collection<STATE>> hashMap2 = this.splitOutgoingHelper(collection, this.mOutInternal);
                    for (Collection<STATE> collection2 : hashMap2.values()) {
                        assert (!collection2.isEmpty() && collection2 instanceof HashSet);
                        this.mPartition.addEcInitialization((HashSet)collection2);
                    }
                }
                hashSet3 = hashSet2;
            }
            ++n;
        }
    }

    private HashMap<Collection<LETTER>, Collection<STATE>> splitOutgoingHelper(Collection<STATE> collection, IOutgoingHelper<LETTER, STATE> iOutgoingHelper) {
        HashMap<Collection<LETTER>, Collection<STATE>> hashMap = new HashMap<Collection<LETTER>, Collection<STATE>>(ShrinkNwa.computeHashCap(iOutgoingHelper.size()));
        for (STATE STATE : collection) {
            Set<LETTER> set = iOutgoingHelper.letters(STATE);
            Collection<STATE> collection2 = hashMap.get(set);
            if (collection2 == null) {
                collection2 = iOutgoingHelper.newCollection();
                hashMap.put(set, collection2);
            }
            collection2.add(STATE);
        }
        return hashMap;
    }

    @Override
    protected Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        return this.checkLanguageEquivalence(iMinimizationCheckResultStateFactory);
    }

    private abstract class AWorkList
    implements Iterator<EquivalenceClass> {
        protected final PriorityQueue<EquivalenceClass> mQueue;

        public AWorkList() {
            this.mQueue = new PriorityQueue(Math.max(ShrinkNwa.this.mOperand.size(), 1), (equivalenceClass, equivalenceClass2) -> equivalenceClass.mStates.size() - equivalenceClass2.mStates.size());
        }

        public void add(EquivalenceClass equivalenceClass) {
            assert (!this.mQueue.contains(equivalenceClass));
            this.mQueue.add(equivalenceClass);
        }

        @Override
        public boolean hasNext() {
            return !this.mQueue.isEmpty();
        }

        @Override
        public abstract EquivalenceClass next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing is not supported.");
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            this.toStringHelper(stringBuilder);
            stringBuilder.append(">>");
            return stringBuilder.toString();
        }

        protected void toStringHelper(StringBuilder stringBuilder) {
            stringBuilder.append("<<");
            String string = "";
            for (EquivalenceClass equivalenceClass : this.mQueue) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(equivalenceClass);
            }
        }
    }

    private class CallTransitionIterator
    implements ITransitionIterator<LETTER, STATE> {
        private Iterator<IncomingCallTransition<LETTER, STATE>> mIterator;
        private IncomingCallTransition<LETTER, STATE> mTransition;

        private CallTransitionIterator() {
        }

        @Override
        public void nextState(STATE STATE) {
            this.mIterator = ShrinkNwa.this.mOperand.callPredecessors(STATE).iterator();
        }

        @Override
        public LETTER nextAndLetter() {
            this.mTransition = this.mIterator.next();
            return this.mTransition.getLetter();
        }

        @Override
        public STATE getPred() {
            return this.mTransition.getPred();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }
    }

    private class ColorSet {
        protected final HashSet<STATE> mContent;
        protected final HashSet<STATE> mBlocked;

        public ColorSet(int n, STATE STATE, HashSet<STATE> hashSet) {
            this.mContent = new HashSet(ShrinkNwa.computeHashCap(n));
            this.mContent.add(STATE);
            this.mBlocked = hashSet;
        }
    }

    private class DummyMap
    extends HashMap<LETTER, HashSet<STATE>> {
        private static final long serialVersionUID = 1L;

        private DummyMap() {
        }

        @Override
        public HashSet<STATE> get(Object object) {
            return null;
        }

        @Override
        public String toString() {
            return "{dummy map}";
        }
    }

    private class EquivalenceClass
    implements IBlock<STATE> {
        private final int mId;
        private Set<STATE> mStates;
        private Set<STATE> mIntersection;
        private IncomingStatus mIncomingInt;
        private IncomingStatus mIncomingCall;
        private IncomingStatus mIncomingRet;
        private HashMap<STATE, HashSet<STATE>> mState2SeparatedSet;
        private Matrix mMatrix;
        private IncomingStatus mOutgoingRet;
        private boolean mIsInitial;

        private EquivalenceClass(Set<STATE> set, boolean bl) {
            assert (!set.isEmpty());
            ++ShrinkNwa.this.mEquivalenceClassIds;
            this.mId = ShrinkNwa.this.mEquivalenceClassIds;
            this.mStates = set;
            this.reset();
        }

        private EquivalenceClass() {
            this.mId = 0;
            this.mStates = null;
            this.mIntersection = null;
        }

        public EquivalenceClass(Set<STATE> set) {
            this(set, false);
            this.mIncomingInt = IncomingStatus.IN_WORKLIST;
            this.mIncomingCall = IncomingStatus.IN_WORKLIST;
            shrinkNwa.mWorkListIntCall.add(this);
            this.mIncomingRet = IncomingStatus.IN_WORKLIST;
            shrinkNwa.mWorkListRet.add(this);
            if (shrinkNwa.mFirstReturnSplitAlternative) {
                this.mOutgoingRet = IncomingStatus.IN_WORKLIST;
                shrinkNwa.mWorkListRetHier.add(this);
            }
            this.mMatrix = null;
        }

        public EquivalenceClass(Set<STATE> set, EquivalenceClass equivalenceClass) {
            this(set, true);
            switch (equivalenceClass.mIncomingInt) {
                case UNKNOWN: 
                case IN_WORKLIST: {
                    this.mIncomingInt = IncomingStatus.IN_WORKLIST;
                    shrinkNwa.mWorkListIntCall.add(this);
                    break;
                }
                case NONE: {
                    this.mIncomingInt = IncomingStatus.NONE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (equivalenceClass.mIncomingCall) {
                case UNKNOWN: 
                case IN_WORKLIST: {
                    this.mIncomingCall = IncomingStatus.IN_WORKLIST;
                    if (this.mIncomingInt == IncomingStatus.IN_WORKLIST) break;
                    shrinkNwa.mWorkListIntCall.add(this);
                    break;
                }
                case NONE: {
                    this.mIncomingCall = IncomingStatus.NONE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            switch (equivalenceClass.mIncomingRet) {
                case UNKNOWN: 
                case IN_WORKLIST: {
                    this.mIncomingRet = IncomingStatus.IN_WORKLIST;
                    shrinkNwa.mWorkListRet.add(this);
                    break;
                }
                case NONE: {
                    this.mIncomingRet = IncomingStatus.NONE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            if (shrinkNwa.mFirstReturnSplitAlternative) {
                switch (equivalenceClass.mOutgoingRet) {
                    case UNKNOWN: 
                    case IN_WORKLIST: {
                        this.mOutgoingRet = IncomingStatus.IN_WORKLIST;
                        shrinkNwa.mWorkListRetHier.add(this);
                        break;
                    }
                    case NONE: {
                        this.mOutgoingRet = IncomingStatus.NONE;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            if (shrinkNwa.mNondeterministicTransitions) {
                if (equivalenceClass.mIncomingInt == IncomingStatus.UNKNOWN) {
                    equivalenceClass.mIncomingInt = IncomingStatus.IN_WORKLIST;
                    shrinkNwa.mWorkListIntCall.add(equivalenceClass);
                }
                if (equivalenceClass.mIncomingCall == IncomingStatus.UNKNOWN) {
                    equivalenceClass.mIncomingCall = IncomingStatus.IN_WORKLIST;
                    if (equivalenceClass.mIncomingInt != IncomingStatus.IN_WORKLIST) {
                        shrinkNwa.mWorkListIntCall.add(equivalenceClass);
                    }
                }
                if (equivalenceClass.mIncomingRet == IncomingStatus.UNKNOWN) {
                    equivalenceClass.mIncomingRet = IncomingStatus.IN_WORKLIST;
                    shrinkNwa.mWorkListRet.add(equivalenceClass);
                }
            }
            if (shrinkNwa.mReturnSplitCorrectnessEcs != null) {
                for (Object STATE : this.mStates) {
                    for (IncomingReturnTransition incomingReturnTransition : shrinkNwa.mOperand.returnPredecessors(STATE)) {
                        shrinkNwa.mReturnSplitCorrectnessEcs.add(shrinkNwa.mPartition.mState2EquivalenceClass.get(incomingReturnTransition.getLinPred()));
                    }
                }
                for (Object STATE : equivalenceClass.mStates) {
                    for (IncomingReturnTransition incomingReturnTransition : shrinkNwa.mOperand.returnPredecessors(STATE)) {
                        shrinkNwa.mReturnSplitCorrectnessEcs.add(shrinkNwa.mPartition.mState2EquivalenceClass.get(incomingReturnTransition.getLinPred()));
                    }
                }
                if (shrinkNwa.mReturnSplitCorrectnessEcs.contains(equivalenceClass)) {
                    shrinkNwa.mReturnSplitCorrectnessEcs.add(this);
                }
            }
            this.resetMatrix(equivalenceClass);
        }

        void markAsInitial() {
            this.mIsInitial = true;
        }

        public int hashCode() {
            return this.mId;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            assert (this.getClass() == object.getClass());
            EquivalenceClass equivalenceClass = (EquivalenceClass)object;
            return this.mId == equivalenceClass.mId;
        }

        public void initializeMatrix(HashSet<EquivalenceClass> hashSet) {
            AbstractCollection abstractCollection;
            if (this.mStates.size() == 1) {
                abstractCollection = new ArrayList(hashSet.size());
                for (EquivalenceClass equivalenceClass : hashSet) {
                    if (equivalenceClass.mStates.size() <= 1) continue;
                    abstractCollection.add((EquivalenceClass)equivalenceClass);
                }
            } else {
                abstractCollection = hashSet;
            }
            int n = abstractCollection.size();
            if (n == 0) {
                this.mMatrix = ShrinkNwa.this.mSingletonMatrix;
                return;
            }
            this.mMatrix = new Matrix(n);
            HashMap hashMap = this.mMatrix.mHier2lin2letter2succ;
            int n2 = ShrinkNwa.computeHashCap(this.mStates.size());
            for (EquivalenceClass equivalenceClass : abstractCollection) {
                for (Object STATE : equivalenceClass.mStates) {
                    HashMap hashMap2 = new HashMap(n2);
                    for (Object STATE2 : this.mStates) {
                        if (!ShrinkNwa.this.mDoubleDecker.isDoubleDecker(STATE2, STATE)) continue;
                        Iterator iterator = ShrinkNwa.this.mOperand.returnSuccessorsGivenHier(STATE2, STATE).iterator();
                        if (iterator.hasNext()) {
                            HashMap hashMap3 = new HashMap();
                            hashMap2.put(STATE2, hashMap3);
                            do {
                                OutgoingReturnTransition outgoingReturnTransition;
                                Object LETTER;
                                HashSet hashSet2;
                                if ((hashSet2 = (HashSet)hashMap3.get(LETTER = (outgoingReturnTransition = iterator.next()).getLetter())) == null) {
                                    hashSet2 = new HashSet();
                                    hashMap3.put(LETTER, hashSet2);
                                }
                                hashSet2.add(outgoingReturnTransition.getSucc());
                            } while (iterator.hasNext());
                            continue;
                        }
                        hashMap2.put(STATE2, ShrinkNwa.this.mDownStateMap);
                    }
                    if (hashMap2.size() <= 0) continue;
                    hashMap.put(STATE, hashMap2);
                }
                assert (hashMap.size() > 0);
            }
        }

        private void resetMatrix(EquivalenceClass equivalenceClass) {
            Matrix matrix = equivalenceClass.mMatrix;
            if (matrix == null || matrix == ShrinkNwa.this.mSingletonMatrix) {
                return;
            }
            HashMap hashMap = matrix.mHier2lin2letter2succ;
            LinkedList linkedList = new LinkedList();
            Set set = this.mStates;
            this.mMatrix = new Matrix(hashMap.size());
            HashMap hashMap2 = this.mMatrix.mHier2lin2letter2succ;
            for (Map.Entry object : hashMap.entrySet()) {
                HashMap hashMap3 = object.getValue();
                Iterator iterator = hashMap3.entrySet().iterator();
                LinkedList linkedList2 = new LinkedList();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Iterator<Object> iterator2 = entry.getKey();
                    if (!set.contains(iterator2)) continue;
                    HashMap hashMap4 = new HashMap(ShrinkNwa.computeHashCap(hashMap3.size()));
                    hashMap4.put(iterator2, entry.getValue());
                    linkedList2.add(iterator2);
                    while (iterator.hasNext()) {
                        Map.Entry entry2 = iterator.next();
                        iterator2 = entry2.getKey();
                        if (!set.contains(iterator2)) continue;
                        hashMap4.put(iterator2, entry2.getValue());
                        linkedList2.add(iterator2);
                    }
                    Object STATE = object.getKey();
                    hashMap2.put(STATE, hashMap4);
                    if (hashMap3.size() != 0) break;
                    linkedList.add(STATE);
                    break;
                }
                for (Object object2 : linkedList2) {
                    hashMap3.remove(object2);
                    if (hashMap.size() != 0) continue;
                    linkedList.add(object.getKey());
                }
            }
            for (Object object : linkedList) {
                hashMap.remove(object);
            }
            if (hashMap.size() <= 1) {
                if (hashMap.size() == 0) {
                    equivalenceClass.mMatrix = null;
                } else if (equivalenceClass.mStates.size() - this.mStates.size() == 1) {
                    equivalenceClass.mMatrix = ShrinkNwa.this.mSingletonMatrix;
                }
            }
            if (hashMap2.size() <= 1) {
                if (hashMap2.size() == 0) {
                    this.mMatrix = null;
                } else if (this.mStates.size() == 1) {
                    this.mMatrix = ShrinkNwa.this.mSingletonMatrix;
                }
            }
        }

        public void markSplit(Collection<HashSet<STATE>> collection) {
            assert (collection.size() > 1) : "Splits with " + collection.size() + " set are not sensible and should be caught beforehand.";
            if (this.mState2SeparatedSet == null) {
                this.mState2SeparatedSet = new HashMap(ShrinkNwa.computeHashCap(this.mStates.size()));
                ShrinkNwa.this.mSplitEcsReturn.add(this);
            } else assert (ShrinkNwa.this.mSplitEcsReturn.contains(this));
            HashSet<Iterable> hashSet = new HashSet<Iterable>();
            for (Iterable iterable : collection) {
                for (Iterable iterable2 : hashSet) {
                    for (Object t : iterable2) {
                        for (Object t2 : iterable) {
                            this.markPair(t, t2);
                        }
                    }
                }
                hashSet.add(iterable);
            }
        }

        private void markPair(STATE STATE, STATE STATE2) {
            assert (STATE != STATE2 && this.mStates.contains(STATE) && this.mStates.contains(STATE2));
            HashSet<Object> hashSet = this.mState2SeparatedSet.get(STATE);
            if (hashSet == null) {
                hashSet = new HashSet();
                this.mState2SeparatedSet.put(STATE, hashSet);
            }
            hashSet.add(STATE2);
            hashSet = this.mState2SeparatedSet.get(STATE2);
            if (hashSet == null) {
                hashSet = new HashSet();
                this.mState2SeparatedSet.put(STATE2, hashSet);
            }
            hashSet.add(STATE);
        }

        private void reset() {
            this.mIntersection = new HashSet(ShrinkNwa.computeHashCap(this.mStates.size()));
            this.mState2SeparatedSet = null;
        }

        public String toString() {
            if (this.mStates == null) {
                return "negative equivalence class";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            stringBuilder.append("<[");
            stringBuilder.append((Object)this.mIncomingInt);
            stringBuilder.append(",");
            stringBuilder.append((Object)this.mIncomingCall);
            stringBuilder.append(",");
            stringBuilder.append((Object)this.mIncomingRet);
            if (ShrinkNwa.this.mFirstReturnSplitAlternative) {
                stringBuilder.append(",");
                stringBuilder.append((Object)this.mOutgoingRet);
            }
            stringBuilder.append("], [");
            for (Object STATE : this.mStates) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(STATE);
            }
            stringBuilder.append("], [");
            string = "";
            for (Object STATE : this.mIntersection) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(STATE);
            }
            stringBuilder.append("]>");
            return stringBuilder.toString();
        }

        public String toStringShort() {
            if (this.mStates == null) {
                return "negative equivalence class";
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            stringBuilder.append("<");
            for (Object STATE : this.mStates) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(STATE);
            }
            stringBuilder.append(">");
            return stringBuilder.toString();
        }

        @Override
        public boolean isInitial() {
            return this.mIsInitial;
        }

        @Override
        public boolean isFinal() {
            return ShrinkNwa.this.mOperand.isFinal(this.mStates.iterator().next());
        }

        @Override
        public STATE minimize(IMergeStateFactory<STATE> iMergeStateFactory) {
            return iMergeStateFactory.merge(this.mStates);
        }

        @Override
        public Iterator<STATE> iterator() {
            return this.mStates.iterator();
        }

        @Override
        public boolean isRepresentativeIndependentInternalsCalls() {
            return true;
        }

        static /* synthetic */ Set access$0(EquivalenceClass equivalenceClass) {
            return equivalenceClass.mStates;
        }
    }

    private static interface IOutgoingHelper<LETTER, STATE> {
        public int size();

        public Set<LETTER> letters(STATE var1);

        public Collection<STATE> newCollection();

        public boolean assertLetters(STATE var1);
    }

    private static interface ITransitionIterator<LETTER, STATE> {
        public void nextState(STATE var1);

        public LETTER nextAndLetter();

        public boolean hasNext();

        public STATE getPred();
    }

    private static enum IncomingStatus {
        UNKNOWN,
        IN_WORKLIST,
        NONE;

    }

    private class InternalTransitionIterator
    implements ITransitionIterator<LETTER, STATE> {
        private Iterator<IncomingInternalTransition<LETTER, STATE>> mIterator;
        private IncomingInternalTransition<LETTER, STATE> mTransition;

        private InternalTransitionIterator() {
        }

        @Override
        public void nextState(STATE STATE) {
            this.mIterator = ShrinkNwa.this.mOperand.internalPredecessors(STATE).iterator();
        }

        @Override
        public STATE getPred() {
            return this.mTransition.getPred();
        }

        @Override
        public LETTER nextAndLetter() {
            this.mTransition = this.mIterator.next();
            return this.mTransition.getLetter();
        }

        @Override
        public boolean hasNext() {
            return this.mIterator.hasNext();
        }
    }

    private class Matrix {
        private final HashMap<STATE, HashMap<STATE, HashMap<LETTER, HashSet<STATE>>>> mHier2lin2letter2succ;

        public Matrix(int n) {
            this.mHier2lin2letter2succ = new HashMap(ShrinkNwa.computeHashCap(n));
        }

        private Matrix() {
            this.mHier2lin2letter2succ = null;
        }

        public String toString() {
            return this.mHier2lin2letter2succ == null ? "{1x1-matrix}" : this.mHier2lin2letter2succ.toString();
        }
    }

    private class MatrixRow {
        private final STATE mHier;
        private final HashMap<STATE, HashMap<LETTER, HashSet<STATE>>> mLin2letter2succ;

        public MatrixRow(STATE STATE, HashMap<STATE, HashMap<LETTER, HashSet<STATE>>> hashMap) {
            this.mHier = STATE;
            assert (!hashMap.isEmpty());
            this.mLin2letter2succ = hashMap;
        }

        public String toString() {
            return String.valueOf(this.mHier) + " -> " + String.valueOf(this.mLin2letter2succ);
        }
    }

    private class OutgoingHelperCall
    implements IOutgoingHelper<LETTER, STATE> {
        private OutgoingHelperCall() {
        }

        @Override
        public int size() {
            return ShrinkNwa.this.mOperand.getVpAlphabet().getCallAlphabet().size();
        }

        @Override
        public Set<LETTER> letters(STATE STATE) {
            assert (this.assertLetters(STATE));
            return ShrinkNwa.this.mOperand.lettersCall(STATE);
        }

        @Override
        public Collection<STATE> newCollection() {
            return new LinkedList();
        }

        @Override
        public boolean assertLetters(STATE STATE) {
            Set set = ShrinkNwa.this.mOperand.lettersCall(STATE);
            HashSet hashSet = new HashSet(ShrinkNwa.computeHashCap(set.size()));
            Iterator iterator = ShrinkNwa.this.mOperand.callSuccessors(STATE).iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next().getLetter());
            }
            if (hashSet.size() != set.size()) {
                return false;
            }
            for (Object e : set) {
                if (hashSet.contains(e)) continue;
                return false;
            }
            return true;
        }
    }

    private class OutgoingHelperInternal
    implements IOutgoingHelper<LETTER, STATE> {
        private OutgoingHelperInternal() {
        }

        @Override
        public int size() {
            return ShrinkNwa.this.mOperand.getVpAlphabet().getInternalAlphabet().size();
        }

        @Override
        public Set<LETTER> letters(STATE STATE) {
            assert (this.assertLetters(STATE));
            return ShrinkNwa.this.mOperand.lettersInternal(STATE);
        }

        @Override
        public Collection<STATE> newCollection() {
            return new HashSet();
        }

        @Override
        public boolean assertLetters(STATE STATE) {
            Set set = ShrinkNwa.this.mOperand.lettersInternal(STATE);
            HashSet hashSet = new HashSet(ShrinkNwa.computeHashCap(set.size()));
            Iterator iterator = ShrinkNwa.this.mOperand.internalSuccessors(STATE).iterator();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next().getLetter());
            }
            if (hashSet.size() != set.size()) {
                return false;
            }
            for (Object e : set) {
                if (hashSet.contains(e)) continue;
                return false;
            }
            return true;
        }
    }

    public class Partition
    implements IAutomatonStatePartition<STATE> {
        private final Collection<EquivalenceClass> mEquivalenceClasses = new LinkedList<EquivalenceClass>();
        private final HashMap<STATE, EquivalenceClass> mState2EquivalenceClass;

        public Partition() {
            this.mState2EquivalenceClass = new HashMap(ShrinkNwa.computeHashCap(ShrinkNwa.this.mOperand.size()));
        }

        public void markInitials() {
            for (Object e : ShrinkNwa.this.mOperand.getInitialStates()) {
                EquivalenceClass equivalenceClass = this.mState2EquivalenceClass.get(e);
                equivalenceClass.markAsInitial();
            }
        }

        private void addEcInitialization(Set<STATE> set) {
            EquivalenceClass equivalenceClass = new EquivalenceClass(set);
            this.mEquivalenceClasses.add(equivalenceClass);
            for (Object STATE : set) {
                this.mState2EquivalenceClass.put(STATE, equivalenceClass);
            }
        }

        private EquivalenceClass addEcIntCall(EquivalenceClass equivalenceClass) {
            Set set = equivalenceClass.mIntersection;
            if (set.size() > equivalenceClass.mStates.size()) {
                set = equivalenceClass.mStates;
                equivalenceClass.mStates = equivalenceClass.mIntersection;
            }
            EquivalenceClass equivalenceClass2 = new EquivalenceClass(set, equivalenceClass);
            this.mEquivalenceClasses.add(equivalenceClass2);
            for (Object STATE : equivalenceClass2.mStates) {
                this.mState2EquivalenceClass.put(STATE, equivalenceClass2);
            }
            return equivalenceClass2;
        }

        private EquivalenceClass addEcReturn(Set<STATE> set, EquivalenceClass equivalenceClass) {
            EquivalenceClass equivalenceClass2 = new EquivalenceClass(set, equivalenceClass);
            this.mEquivalenceClasses.add(equivalenceClass2);
            for (Object STATE : set) {
                assert (equivalenceClass.mStates.contains(STATE) && this.mState2EquivalenceClass.get(STATE) == equivalenceClass);
                equivalenceClass.mStates.remove(STATE);
                this.mState2EquivalenceClass.put(STATE, equivalenceClass2);
            }
            return equivalenceClass2;
        }

        private void splitState(STATE STATE, LinkedList<EquivalenceClass> linkedList) {
            EquivalenceClass equivalenceClass = this.mState2EquivalenceClass.get(STATE);
            if (equivalenceClass.mIntersection.isEmpty()) {
                assert (!linkedList.contains(equivalenceClass));
                linkedList.add(equivalenceClass);
            } else assert (linkedList.contains(equivalenceClass));
            equivalenceClass.mIntersection.add(STATE);
            equivalenceClass.mStates.remove(STATE);
        }

        public boolean splitEquivalenceClasses(Iterable<STATE> iterable) {
            boolean bl = false;
            LinkedList<EquivalenceClass> linkedList = new LinkedList<EquivalenceClass>();
            for (Object object : iterable) {
                this.splitState(object, linkedList);
            }
            for (EquivalenceClass equivalenceClass : linkedList) {
                if (equivalenceClass.mStates.isEmpty()) {
                    equivalenceClass.mStates = equivalenceClass.mIntersection;
                    ++ShrinkNwa.this.mSplitsWithoutChange;
                } else {
                    ++ShrinkNwa.this.mSplitsWithChange;
                    bl = true;
                    this.addEcIntCall(equivalenceClass);
                }
                equivalenceClass.reset();
            }
            return bl;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            String string = "";
            for (EquivalenceClass equivalenceClass : this.mEquivalenceClasses) {
                stringBuilder.append(string);
                string = ", ";
                stringBuilder.append(equivalenceClass);
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public IBlock<STATE> getBlock(STATE STATE) {
            return this.mState2EquivalenceClass.get(STATE);
        }

        public Set<STATE> getContainingSet(STATE STATE) {
            return this.mState2EquivalenceClass.get(STATE).mStates;
        }

        public int size() {
            return this.mEquivalenceClasses.size();
        }

        @Override
        public Iterator<IBlock<STATE>> blocksIterator() {
            return new Iterator<IBlock<STATE>>(){
                private final Iterator<EquivalenceClass> mIt;
                {
                    this.mIt = Partition.this.mEquivalenceClasses.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mIt.hasNext();
                }

                @Override
                public IBlock<STATE> next() {
                    return this.mIt.next();
                }
            };
        }

        public Iterator<Set<STATE>> iterator() {
            return new Iterator<Set<STATE>>(){
                private final Iterator<EquivalenceClass> mIt;
                {
                    this.mIt = Partition.this.mEquivalenceClasses.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.mIt.hasNext();
                }

                @Override
                public Set<STATE> next() {
                    return this.mIt.next().mStates;
                }
            };
        }
    }

    private class WorkListIntCall
    extends AWorkList {
        private WorkListIntCall() {
        }

        @Override
        public EquivalenceClass next() {
            EquivalenceClass equivalenceClass = (EquivalenceClass)this.mQueue.poll();
            return equivalenceClass;
        }

        @Override
        public void add(EquivalenceClass equivalenceClass) {
            assert (equivalenceClass.mIncomingInt == IncomingStatus.IN_WORKLIST || equivalenceClass.mIncomingCall == IncomingStatus.IN_WORKLIST);
            super.add(equivalenceClass);
        }
    }

    private class WorkListRet
    extends AWorkList {
        private WorkListRet() {
        }

        @Override
        public EquivalenceClass next() {
            EquivalenceClass equivalenceClass = (EquivalenceClass)this.mQueue.poll();
            equivalenceClass.mIncomingRet = IncomingStatus.UNKNOWN;
            return equivalenceClass;
        }

        @Override
        public void add(EquivalenceClass equivalenceClass) {
            assert (equivalenceClass.mIncomingRet == IncomingStatus.IN_WORKLIST);
            super.add(equivalenceClass);
        }

        public void fillWithAll() {
            for (EquivalenceClass equivalenceClass : ShrinkNwa.this.mPartition.mEquivalenceClasses) {
                if (equivalenceClass.mIncomingRet == IncomingStatus.NONE) continue;
                equivalenceClass.mIncomingRet = IncomingStatus.IN_WORKLIST;
                this.mQueue.add(equivalenceClass);
            }
        }
    }

    private class WorkListRetHier
    extends AWorkList {
        private WorkListRetHier() {
        }

        @Override
        public EquivalenceClass next() {
            EquivalenceClass equivalenceClass = (EquivalenceClass)this.mQueue.poll();
            equivalenceClass.mOutgoingRet = IncomingStatus.UNKNOWN;
            return equivalenceClass;
        }

        @Override
        public void add(EquivalenceClass equivalenceClass) {
            assert (equivalenceClass.mOutgoingRet == IncomingStatus.IN_WORKLIST);
            super.add(equivalenceClass);
        }
    }
}

