/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.AbstractMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.Clause;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.VariableStatus;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class GeneralMaxSatSolver<V>
extends AbstractMaxSatSolver<V> {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private final SolverStack mStack = new SolverStack();
    private int mNumberOfNonHornClauses;
    private int mMaxNonHornClauses;
    private final boolean mShowExpensiveDebugLogs = false;

    public GeneralMaxSatSolver(AutomataLibraryServices automataLibraryServices) {
        super(automataLibraryServices);
        this.synchronizeStack();
    }

    @Override
    public void addHornClause(V[] VArray, V v) {
        Object[] objectArray = v == null ? EMPTY_ARRAY : new Object[]{v};
        this.addClause(VArray, objectArray);
    }

    @Override
    public void addClause(V[] VArray, V[] VArray2) {
        if (this.mDecisions > 0) {
            throw new UnsupportedOperationException("only legal before decisions were made");
        }
        assert (this.mPropagatees.isEmpty());
        Clause<V> clause = new Clause<V>(this, VArray2, VArray);
        if (clause.isEquivalentToTrue()) {
            ++this.mClauses;
            ++this.mTrivialClauses;
        } else {
            Object object;
            ++this.mClauses;
            ++this.mCurrentLiveClauses;
            this.mMaxLiveClauses = Math.max(this.mMaxLiveClauses, this.mCurrentLiveClauses);
            if (clause.isEquivalentToFalse()) {
                this.mConjunctionEquivalentToFalse = true;
                throw new UnsupportedOperationException("clause set is equivalent to false");
            }
            V[] VArray3 = clause.getNegativeAtoms();
            int n = VArray3.length;
            int n2 = 0;
            while (n2 < n) {
                object = VArray3[n2];
                this.mOccursNegative.addPair(object, clause);
                ++n2;
            }
            VArray3 = clause.getPositiveAtoms();
            n = VArray3.length;
            n2 = 0;
            while (n2 < n) {
                object = VArray3[n2];
                this.mOccursPositive.addPair(object, clause);
                ++n2;
            }
            if (clause.isPseudoUnit()) {
                object = clause.getPropagatee();
                this.mPropagatees.put(object.getFirst(), (Boolean)object.getSecond());
                this.propagateAll();
            } else if (!clause.isHorn()) {
                this.incrementNumberOfNonHornClauses();
            }
        }
    }

    @Override
    protected Boolean getPersistentAssignment(V v) {
        Boolean bl = (Boolean)this.mVariablesIrrevocablySet.get(v);
        assert (bl == null || !this.mStack.getVarTempSet().containsKey(v)) : "Unsynchronized assignment data structures.";
        return bl;
    }

    @Override
    protected VariableStatus getTemporaryAssignment(V v) {
        Iterator iterator = this.mStack.iterator();
        while (iterator.hasNext()) {
            Map map = iterator.next();
            Boolean bl = map.get(v);
            if (bl == null) continue;
            assert (!this.mVariablesIrrevocablySet.containsKey(v)) : "Unsynchronized assignment data structures.";
            return bl != false ? VariableStatus.TRUE : VariableStatus.FALSE;
        }
        return VariableStatus.UNSET;
    }

    @Override
    protected void decideOne() {
        Object v = this.getUnsetVariable();
        this.pushStack(v);
        ++this.mDecisions;
        this.setVariable(v, true);
        this.propagateAll();
        if (this.mConjunctionEquivalentToFalse) {
            this.backtrack(v);
            if (this.mConjunctionEquivalentToFalse) {
                this.backtrackFurther(v);
            }
        }
        if (!this.mConjunctionEquivalentToFalse) {
            this.makeModificationsPersistentIfAllowed();
        }
    }

    @Override
    protected void setVariable(V v, boolean bl) {
        assert (this.mVariables.contains(v)) : "unknown variable";
        assert (!this.mVariablesIrrevocablySet.containsKey(v)) : "variable already set";
        Boolean bl2 = this.mStack.getVarTempSet().put((Boolean)v, bl);
        if (bl2 != null) {
            throw new IllegalArgumentException("variable already set " + String.valueOf(v));
        }
        this.mPropagatees.remove(v);
        this.reEvaluateStatusOfAllClauses(v);
    }

    @Override
    protected void makeAssignmentPersistent() {
        boolean bl;
        this.mLogger.debug((Object)"making current solver state persistent");
        do {
            for (Map.Entry entry : this.mStack.getVarTempSet().entrySet()) {
                Object v = entry.getKey();
                this.mVariablesIrrevocablySet.put(v, entry.getValue());
                this.mUnsetVariables.remove(v);
            }
            this.removeMarkedClauses();
        } while (!(bl = this.popStack()));
    }

    @Override
    protected void backtrack(V v) {
        this.mLogger.debug((Object)"backtracking");
        ++this.mWrongDecisions;
        Set set = this.mStack.getVarTempSet().keySet();
        this.popStack();
        this.mPropagatees = new HashMap();
        this.mConjunctionEquivalentToFalse = false;
        this.reEvaluateStatusOfAllClauses(set, v);
        this.setVariable(v, false);
        this.propagateAll();
    }

    @Override
    protected void undoAssignment(V v) {
        super.undoAssignment(v);
        this.mUnsetVariables.add(v);
    }

    @Override
    protected void incrementNumberOfNonHornClauses() {
        ++this.mNumberOfNonHornClauses;
        this.mLogger.debug((Object)("NumberOfNonHornClauses: " + this.mNumberOfNonHornClauses));
    }

    @Override
    protected void decrementNumberOfNonHornClauses() {
        --this.mNumberOfNonHornClauses;
        this.mLogger.debug((Object)("NumberOfNonHornClauses: " + this.mNumberOfNonHornClauses));
        assert (this.mNumberOfNonHornClauses >= 0) : "Number of non-Horn clauses became negative.";
    }

    @Override
    protected void firstDecisionOrStop() {
        this.mMaxNonHornClauses = this.mNumberOfNonHornClauses;
    }

    @Override
    protected void log() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Clauses: ").append(this.mClauses);
        stringBuilder.append(" (thereof " + this.mTrivialClauses + " trivial clauses");
        stringBuilder.append(" and " + this.mMaxNonHornClauses + " Non-Horn clauses)");
        stringBuilder.append(" MaxLiveClauses: ").append(this.mMaxLiveClauses);
        stringBuilder.append(" Decisions : ").append(this.mDecisions);
        stringBuilder.append(" (thereof " + this.mWrongDecisions + " wrong decisions)");
        this.mLogger.info((Object)stringBuilder.toString());
    }

    private void makeModificationsPersistentIfAllowed() {
        boolean bl;
        boolean bl2 = bl = this.mStack.isLowestStackLevel() || this.hasOnlyHornClauses();
        if (bl) {
            this.makeAssignmentPersistent();
        } else {
            for (Map.Entry entry : this.mStack.getVarTempSet().entrySet()) {
                this.mUnsetVariables.remove(entry.getKey());
            }
        }
    }

    private void backtrackFurther(V v) {
        assert (this.mNumberOfNonHornClauses > 0) : "For Horn clauses backtracking should not be necessary for more than one level.";
        assert (v != null);
        V v2 = v;
        do {
            boolean bl = this.mUnsetVariables.add(v2);
            assert (bl) : "The variable should have been set before backtracking.";
            v2 = this.mStack.getDecision();
            assert (v2 != null);
            this.backtrack(v2);
        } while (this.mConjunctionEquivalentToFalse && !this.mStack.isLowestStackLevel());
    }

    private boolean hasOnlyHornClauses() {
        return this.mNumberOfNonHornClauses == 0;
    }

    private void synchronizeStack() {
        this.mClausesMarkedForRemoval = this.mStack.getMarkedClauses();
    }

    private void pushStack(V v) {
        this.mStack.push(v);
        this.synchronizeStack();
    }

    private boolean popStack() {
        boolean bl = this.mStack.pop();
        this.synchronizeStack();
        return bl;
    }

    private class SolverStack {
        private final ArrayDeque<de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent> mStackInner = new ArrayDeque();
        private de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent mLowestLevel = new StackContent();
        private boolean mIsLowestLevel = true;

        public boolean pop() {
            if (!this.mStackInner.isEmpty()) {
                this.mStackInner.pop();
                this.mIsLowestLevel = this.mStackInner.isEmpty();
                return false;
            }
            this.mLowestLevel = new StackContent();
            return true;
        }

        public void push(V v) {
            this.mStackInner.push((de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent)new StackContent(v));
            this.mIsLowestLevel = false;
        }

        public boolean isLowestStackLevel() {
            assert (this.mIsLowestLevel == this.mStackInner.isEmpty());
            return this.mIsLowestLevel;
        }

        public Map<V, Boolean> getVarTempSet() {
            return this.getCurrentLevel().getVariablesTemporarilySet();
        }

        public V getDecision() {
            return this.getCurrentLevel().getVariableDecision();
        }

        public Set<Clause<V>> getMarkedClauses() {
            return this.getCurrentLevel().getClausesMarkedForRemoval();
        }

        public Iterator<Map<V, Boolean>> iterator() {
            return new StackIterator(this, this.mStackInner.iterator(), (StackContent)this.mLowestLevel);
        }

        private de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent getCurrentLevel() {
            de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent stackContent = this.mIsLowestLevel ? this.mLowestLevel : (StackContent)this.mStackInner.peek();
            return stackContent;
        }

        private class StackContent {
            private final V mVariableDecision;
            private final Map<V, Boolean> mVariablesTemporarilySet;
            private final Set<Clause<V>> mClausesMarkedForRemoval;

            public StackContent() {
                this(null, false);
            }

            public StackContent(V v) {
                this(v, false);
                assert (v != null) : "Do not set the variable to null!";
            }

            private StackContent(V v, boolean bl) {
                this.mVariableDecision = v;
                this.mVariablesTemporarilySet = new HashMap();
                this.mClausesMarkedForRemoval = new LinkedHashSet();
            }

            public V getVariableDecision() {
                return this.mVariableDecision;
            }

            public Map<V, Boolean> getVariablesTemporarilySet() {
                return this.mVariablesTemporarilySet;
            }

            public Set<Clause<V>> getClausesMarkedForRemoval() {
                return this.mClausesMarkedForRemoval;
            }

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<");
                if (this.mVariableDecision == null) {
                    stringBuilder.append("lowest level, ");
                } else {
                    stringBuilder.append(this.mVariableDecision);
                    stringBuilder.append(" = current decision, ");
                }
                stringBuilder.append(this.mVariablesTemporarilySet.size());
                stringBuilder.append(" variables temporarily assigned, ");
                stringBuilder.append(this.mClausesMarkedForRemoval.size());
                stringBuilder.append(" clauses temporarily satisfied>");
                return stringBuilder.toString();
            }
        }

        private static class StackIterator
        implements Iterator<Map<V, Boolean>> {
            private final Iterator<de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent> mIt;
            private boolean mIsAtBottom;
            private final de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent mLowestLevelStack;
            final /* synthetic */ SolverStack this$1;

            public StackIterator(Iterator<de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent> iterator, de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent stackContent) {
                this.this$1 = var1_1;
                this.mIt = iterator;
                this.mLowestLevelStack = stackContent;
            }

            @Override
            public boolean hasNext() {
                boolean bl = this.mIt.hasNext();
                if (bl) {
                    return true;
                }
                if (this.mIsAtBottom) {
                    return false;
                }
                this.mIsAtBottom = true;
                return true;
            }

            @Override
            public Map<V, Boolean> next() {
                de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.GeneralMaxSatSolver$SolverStack.StackContent stackContent = this.mIsAtBottom ? this.mLowestLevelStack : (StackContent)this.mIt.next();
                return stackContent.getVariablesTemporarilySet();
            }
        }
    }
}

