/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.IGeneralizedNwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.NestedLassoRun;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.Options;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.AbstractGeneralizedAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.GeneralizedNestedWordAutomatonReachableStates;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.LassoConstructor;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.StateContainer;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

public class GeneralizedNestedWordAutomatonReachableStates<LETTER, STATE>
extends AbstractGeneralizedAutomatonReachableStates<LETTER, STATE> {
    private final IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> mOperand;
    protected final IStateFactory<STATE> mStateFactory;
    private final Map<STATE, StateContainer<LETTER, STATE>> mStates = new HashMap<STATE, StateContainer<LETTER, STATE>>();
    private final ReachableStatesComputationTarjan mReach;

    public GeneralizedNestedWordAutomatonReachableStates(AutomataLibraryServices automataLibraryServices, IGeneralizedNwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iGeneralizedNwaOutgoingLetterAndTransitionProvider) throws AutomataOperationCanceledException {
        super(automataLibraryServices, iGeneralizedNwaOutgoingLetterAndTransitionProvider.getVpAlphabet());
        this.mOperand = iGeneralizedNwaOutgoingLetterAndTransitionProvider;
        this.mStateFactory = iGeneralizedNwaOutgoingLetterAndTransitionProvider.getStateFactory();
        this.mDownStates.add(iGeneralizedNwaOutgoingLetterAndTransitionProvider.getEmptyStackState());
        try {
            this.mReach = new ReachableStatesComputationTarjan();
            this.mFinalStates.clear();
        }
        catch (ToolchainCanceledException toolchainCanceledException) {
            throw toolchainCanceledException;
        }
        catch (Error | RuntimeException throwable) {
            throw throwable;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.stateContainerInformation());
        }
    }

    @Override
    protected StateContainer<LETTER, STATE> getStateContainer(STATE STATE) {
        return this.mStates.get(STATE);
    }

    private String stateContainerInformation() {
        return this.mStates.size() + " states";
    }

    private StateContainer<LETTER, STATE> getOrAddState(STATE STATE) {
        StateContainer<LETTER, STATE> stateContainer = this.mStates.get(STATE);
        if (stateContainer == null) {
            stateContainer = new StateContainer(STATE);
            this.mStates.put(STATE, stateContainer);
            if (this.mOperand.isFinal(STATE)) {
                this.mFinalStates.add(STATE);
            }
        }
        return stateContainer;
    }

    @Override
    public Boolean isEmpty() {
        return this.mReach.isEmpty();
    }

    @Override
    public NestedLassoRun<LETTER, STATE> getNestedLassoRun() throws AutomataOperationCanceledException {
        if (this.mReach.isEmpty().booleanValue()) {
            return null;
        }
        if (this.mLasso == null) {
            for (List list : this.mReach.getLoopList()) {
                LassoConstructor lassoConstructor = new LassoConstructor(this.mServices, this, list);
                NestedLassoRun nestedLassoRun = lassoConstructor.getNestedLassoRun();
                if (this.mLasso != null && this.mLasso.getStem().getLength() + this.mLasso.getLoop().getLength() <= nestedLassoRun.getStem().getLength() + nestedLassoRun.getLoop().getLength()) continue;
                this.mLasso = nestedLassoRun;
            }
        }
        return this.mLasso;
    }

    @Override
    protected void removeStates(STATE STATE) {
        this.mStates.remove(STATE);
        this.mInitialStates.remove(STATE);
        this.mFinalStates.remove(STATE);
    }

    private AutomataLibraryServices getServices() {
        return this.mServices;
    }

    private RunningTaskInfo constructRunningTaskInfo() {
        String string = GeneralizedNestedWordAutomatonReachableStates.constructRunningTaskInfoMessage(this.mNumberOfConstructedStates, this.mOperand.getClass());
        RunningTaskInfo runningTaskInfo = new RunningTaskInfo(this.getClass(), string);
        return runningTaskInfo;
    }

    @Override
    public Set<STATE> getStates() {
        return this.mStates.keySet();
    }

    @Override
    public Set<LETTER> lettersInternalIncoming(STATE STATE) {
        return this.mStates.get(STATE).lettersInternalIncoming();
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).internalPredecessors(LETTER);
    }

    @Override
    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(STATE STATE) {
        return this.mStates.get(STATE).internalPredecessors();
    }

    @Override
    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(STATE STATE, LETTER LETTER) {
        return this.mStates.get(STATE).internalSuccessors(LETTER);
    }

    @Override
    public IStateFactory<STATE> getStateFactory() {
        return this.mStateFactory;
    }

    @Override
    public int size() {
        return this.mStates.size();
    }

    @Override
    public String sizeInformation() {
        return this.size() + " states";
    }

    @Override
    public STATE getEmptyStackState() {
        return this.mOperand.getEmptyStackState();
    }

    @Override
    public boolean isInitial(STATE STATE) {
        return this.mOperand.isInitial(STATE);
    }

    @Override
    public int getAcceptanceSize() {
        return this.mOperand.getAcceptanceSize();
    }

    @Override
    public boolean isFinal(STATE STATE, int n) {
        return this.mOperand.isFinal(STATE, n);
    }

    @Override
    public Set<Integer> getAcceptanceLabels(STATE STATE) {
        return this.mOperand.getAcceptanceLabels(STATE);
    }

    @Override
    public boolean isFinal(STATE STATE) {
        return !this.getAcceptanceLabels(STATE).isEmpty();
    }

    class ReachableStatesComputationTarjan {
        private final de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.GeneralizedNestedWordAutomatonReachableStates$ReachableStatesComputationTarjan.Tarjan mTarjan = null;
        private final de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.GeneralizedNestedWordAutomatonReachableStates$ReachableStatesComputationTarjan.Ascc mAscc;

        public ReachableStatesComputationTarjan() throws AutomataOperationCanceledException {
            GeneralizedNestedWordAutomatonReachableStates.this.mNumberOfConstructedStates = 0;
            this.mAscc = new Ascc();
        }

        public Boolean isEmpty() {
            if (this.mTarjan == null) {
                return this.mAscc.mIsEmpty;
            }
            return this.mTarjan.mIsEmpty;
        }

        public List<List<STATE>> getLoopList() {
            if (this.mTarjan == null) {
                return this.mAscc.mSccList;
            }
            return this.mTarjan.mSCC;
        }

        private class Ascc {
            private int mCnt = 0;
            private final Stack<de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.GeneralizedNestedWordAutomatonReachableStates$ReachableStatesComputationTarjan.AsccElem> mSCCs = new Stack();
            private final Stack<STATE> mAct = new Stack();
            private final TObjectIntMap<STATE> mDfsNum = new TObjectIntHashMap();
            private final Set<STATE> mQPrime;
            private final Set<STATE> mEmp;
            private final List<List<STATE>> mSccList = new ArrayList();
            private Boolean mIsEmpty = null;

            private void asccClear() {
                this.mDfsNum.clear();
                this.mQPrime.clear();
                this.mEmp.clear();
            }

            public Ascc() throws AutomataOperationCanceledException {
                Object object2;
                this.mQPrime = new HashSet();
                this.mEmp = new HashSet();
                boolean bl = false;
                for (Object object2 : ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mOperand.getInitialStates()) {
                    ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mInitialStates.add(object2);
                    if (this.mDfsNum.containsKey(object2)) continue;
                    boolean bl2 = this.construct(object2);
                    boolean bl3 = bl = bl2 || bl;
                }
                this.mIsEmpty = !bl;
                object2 = new HashSet(((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mStates.keySet());
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Iterator<Object> iterator2 = iterator.next();
                    if (this.mQPrime.contains(iterator2)) {
                        assert (!this.mEmp.contains(iterator2)) : "Wrong state in mEmp";
                        continue;
                    }
                    if (this.mEmp.contains(iterator2)) {
                        assert (!this.mQPrime.contains(iterator2)) : "Wrong state in QPrime";
                        StateContainer stateContainer = ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mStates.get(iterator2);
                        HashSet hashSet = new HashSet();
                        for (IncomingInternalTransition incomingInternalTransition : stateContainer.internalPredecessors()) {
                            Object object3;
                            if (!((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mServices.getProgressAwareTimer().continueProcessing()) {
                                object3 = GeneralizedNestedWordAutomatonReachableStates.this.constructRunningTaskInfo();
                                throw new AutomataOperationCanceledException((RunningTaskInfo)object3);
                            }
                            object3 = ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mStates.get(incomingInternalTransition.getPred());
                            if (object3 != null) {
                                ((StateContainer)object3).removeSuccessor(iterator2);
                            }
                            hashSet.add(incomingInternalTransition.getPred());
                        }
                        stateContainer.removePredecessors(hashSet);
                    } else assert (false) : "You should never be here";
                    ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mStates.remove(iterator2);
                    ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mInitialStates.remove(iterator2);
                    ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mFinalStates.remove(iterator2);
                }
                this.asccClear();
            }

            boolean construct(STATE STATE) throws AutomataOperationCanceledException {
                Object object;
                ++this.mCnt;
                this.mDfsNum.put(STATE, this.mCnt);
                this.mSCCs.push((de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.GeneralizedNestedWordAutomatonReachableStates$ReachableStatesComputationTarjan.AsccElem)new AsccElem(STATE, ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mOperand.getAcceptanceLabels(STATE)));
                this.mAct.push(STATE);
                ++((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mNumberOfConstructedStates;
                boolean bl = false;
                StateContainer stateContainer = GeneralizedNestedWordAutomatonReachableStates.this.getOrAddState(STATE);
                for (OutgoingInternalTransition object2 : ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mOperand.internalSuccessors(STATE)) {
                    Object STATE2;
                    if (!GeneralizedNestedWordAutomatonReachableStates.this.getServices().getProgressAwareTimer().continueProcessing()) {
                        object = GeneralizedNestedWordAutomatonReachableStates.this.constructRunningTaskInfo();
                        throw new AutomataOperationCanceledException((RunningTaskInfo)object);
                    }
                    object = object2.getSucc();
                    stateContainer.addInternalOutgoing(object2);
                    StateContainer stateContainer2 = GeneralizedNestedWordAutomatonReachableStates.this.getOrAddState(object);
                    stateContainer2.addInternalIncoming(new IncomingInternalTransition(STATE, object2.getLetter()));
                    if (this.mQPrime.contains(object)) {
                        bl = true;
                        continue;
                    }
                    if (this.mEmp.contains(object)) continue;
                    if (!this.mAct.contains(object)) {
                        boolean hashSet = this.construct(object);
                        bl = hashSet || bl;
                        continue;
                    }
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    do {
                        AsccElem asccElem = (AsccElem)this.mSCCs.pop();
                        STATE2 = asccElem.mState;
                        hashSet.addAll(asccElem.mLabels);
                        if (hashSet.size() != GeneralizedNestedWordAutomatonReachableStates.this.getAcceptanceSize()) continue;
                        bl = true;
                    } while (this.mDfsNum.get(STATE2) > this.mDfsNum.get(object));
                    this.mSCCs.push((de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion.GeneralizedNestedWordAutomatonReachableStates$ReachableStatesComputationTarjan.AsccElem)new AsccElem(STATE2, hashSet));
                }
                if (((AsccElem)this.mSCCs.peek()).mState.equals(STATE)) {
                    Set<Integer> set = ((AsccElem)this.mSCCs.peek()).mLabels;
                    ArrayList arrayList = new ArrayList();
                    this.mSCCs.pop();
                    do {
                        assert (!this.mAct.isEmpty()) : "mAct is empty";
                        object = this.mAct.pop();
                        if (bl) {
                            this.mQPrime.add(object);
                        } else {
                            this.mEmp.add(object);
                        }
                        arrayList.add(object);
                    } while (!object.equals(STATE));
                    if (set.size() == GeneralizedNestedWordAutomatonReachableStates.this.getAcceptanceSize() && (arrayList.size() > 1 || stateContainer.hashSelfloop())) {
                        this.mSccList.add(arrayList);
                    }
                }
                return bl;
            }
        }

        private class AsccElem {
            STATE mState;
            Set<Integer> mLabels;

            AsccElem(STATE STATE, Set<Integer> set) {
                this.mState = STATE;
                this.mLabels = set;
            }

            public String toString() {
                return "(" + String.valueOf(this.mState) + "," + String.valueOf(this.mLabels) + ")";
            }
        }

        private class Tarjan {
            private int mIndex = 0;
            private final Stack<STATE> mStack = new Stack();
            private final TObjectIntMap<STATE> mIndexMap = new TObjectIntHashMap();
            private final TObjectIntMap<STATE> mLowlinkMap = new TObjectIntHashMap();
            private final List<List<STATE>> mSCC = new ArrayList();
            private Boolean mIsEmpty = null;

            public Tarjan() throws AutomataOperationCanceledException {
                for (Object STATE : ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mOperand.getInitialStates()) {
                    ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mInitialStates.add(STATE);
                    if (this.mIndexMap.containsKey(STATE)) continue;
                    this.strongConnect(STATE);
                }
                if (this.mIsEmpty == null) {
                    this.mIsEmpty = true;
                }
            }

            void strongConnect(STATE STATE) throws AutomataOperationCanceledException {
                Object bl;
                this.mStack.push(STATE);
                this.mIndexMap.put(STATE, this.mIndex);
                this.mLowlinkMap.put(STATE, this.mIndex);
                ++this.mIndex;
                ++((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mNumberOfConstructedStates;
                StateContainer stateContainer = GeneralizedNestedWordAutomatonReachableStates.this.getOrAddState(STATE);
                for (OutgoingInternalTransition object2 : ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mOperand.internalSuccessors(STATE)) {
                    if (!GeneralizedNestedWordAutomatonReachableStates.this.getServices().getProgressAwareTimer().continueProcessing()) {
                        bl = GeneralizedNestedWordAutomatonReachableStates.this.constructRunningTaskInfo();
                        throw new AutomataOperationCanceledException((RunningTaskInfo)bl);
                    }
                    bl = object2.getSucc();
                    if (!this.mIndexMap.containsKey(bl)) {
                        this.strongConnect(bl);
                        this.mLowlinkMap.put(STATE, Math.min(this.mLowlinkMap.get(STATE), this.mLowlinkMap.get(bl)));
                    } else if (this.mStack.contains(bl)) {
                        this.mLowlinkMap.put(STATE, Math.min(this.mLowlinkMap.get(STATE), this.mIndexMap.get(bl)));
                    }
                    stateContainer.addInternalOutgoing(object2);
                    StateContainer stateContainer2 = GeneralizedNestedWordAutomatonReachableStates.this.getOrAddState(bl);
                    stateContainer2.addInternalIncoming(new IncomingInternalTransition(STATE, object2.getLetter()));
                }
                if (this.mLowlinkMap.get(STATE) == this.mIndexMap.get(STATE)) {
                    boolean bl2;
                    HashSet<Integer> hashSet = new HashSet<Integer>();
                    ArrayList arrayList = new ArrayList();
                    while (!this.mStack.empty()) {
                        bl = this.mStack.pop();
                        hashSet.addAll(((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mOperand.getAcceptanceLabels(bl));
                        arrayList.add(bl);
                        if (bl.equals(STATE)) break;
                    }
                    boolean bl3 = bl2 = ((ReachableStatesComputationTarjan)ReachableStatesComputationTarjan.this).GeneralizedNestedWordAutomatonReachableStates.this.mOperand.getAcceptanceSize() == hashSet.size();
                    if (arrayList.size() == 1 && bl2 && !stateContainer.hashSelfloop()) {
                        bl2 = false;
                    }
                    if (bl2) {
                        this.mIsEmpty = false;
                        this.mSCC.add(arrayList);
                        if (Options.verbose) {
                            System.out.println("Loop: " + String.valueOf(arrayList));
                        }
                    }
                }
            }
        }
    }
}

